<?php
/*------------------------------------------------------------------------
# plg_zhosmmap_article_overview - Zh OpenStreetMap Plugin - Article Overview Map
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Content\ContentPrepareEvent;

use ZhukDL\Component\ZhOSMMap\Site\Helper\MapDataHelper;


class plgContentPlgZhOSMMap_article_overview extends CMSPlugin implements SubscriberInterface
{    
    
    var $scripthead;
    var $scripttext;
    var $scriptinitialize;    
    var $scriptfulltext;

    var $MapXsuffix = "ZhOMPLG_ARTICLE_OVERVIEW";    

    var $markercluster;
    var $markerclusterlist;
    var $markermanager;
    var $infobubble;
    var $featureMarkerWithLabel;
    var $main_lang;
    var $use_object_manager;
    var $urlProtocol;
    
    
    
    var $compatiblemode;
    var $httpsprotocol;
    var $mapapiversion;
    var $placemarktitletag;
    
    var $geotag_link;
    var $geotag_css;
    var $geotag_hide_marker;
    var $licenseinfo;
	
	var $loadtype;
	var $loadjquery;
	var $load_delay;
	var $current_custom_js_path;
	
	var $useObjectStructure;    
    
	public static function getSubscribedEvents(): array
	{
		return [
		  'onContentPrepare' => 'onContentPrepare',  
		];
	} 
  
    public function onContentPrepare(ContentPrepareEvent $event)
    {
		$context = $event->getContext();
		$article = $event->getItem(); 
		$params = $event->getParams();
		$page = $event->getPage();
		
        $parameterDefaultLine = ';;;;;;;;;;;;;;;;;;;;';

        $app = Factory::getApplication();

        $comparams = ComponentHelper::getParams( 'com_zhosmmap' );

        $this->compatiblemode = $comparams->get( 'map_compatiblemode');
        $this->httpsprotocol = $comparams->get('httpsprotocol');
        $this->loadtype = $comparams->get('loadtype');
        $this->mapapiversion = $comparams->get('map_api_version');
        
        $this->geotag_link = $comparams->get('geotag_link');
        $this->geotag_css = $comparams->get('geotag_css');
        $this->geotag_hide_marker = $comparams->get('geotag_hide_marker');

        $this->licenseinfo = $comparams->get('licenseinfo');
        $this->placemarktitletag = $comparams->get('placemarktitletag');
        
        $this->urlProtocol = "http";
        if ($this->httpsprotocol != "")
        {
            if ((int)$this->httpsprotocol == 0)
            {
                $this->urlProtocol = 'https';
            }
        }        
        
        $this->load_delay = $comparams->get( 'load_delay');
        
        $document    = Factory::getDocument();

        // Load default language
        $this->loadLanguage();
        
        $this->current_custom_js_path = URI::root() .'components/com_zhosmmap/assets/js/';
        $current_custom_js_path = $this->current_custom_js_path;    
        
        $this->useObjectStructure = 1;

        require_once JPATH_SITE . '/plugins/content/plgzhosmmap/helpers/placemarks.php';

                
        $regexOverview        = '/({zhosmmap-overview:\s*)(.*?)(})/is';
        $matchesOverview         = array();
        $count_matches_Overview    = preg_match_all($regexOverview, $article->text, $matchesOverview, PREG_PATTERN_ORDER | PREG_OFFSET_CAPTURE);

        $regexCategory        = '/({zhosmmap-overview-category:\s*)(.*?)(})/is';
        $matchesCategory         = array();
        $count_matches_Category    = preg_match_all($regexCategory, $article->text, $matchesCategory, PREG_PATTERN_ORDER | PREG_OFFSET_CAPTURE);

        $regexArticleList        = '/({zhosmmap-overview-articlelist:\s*)(.*?)(})/is';
        $matchesArticleList         = array();
        $count_matches_ArticleList    = preg_match_all($regexArticleList, $article->text, $matchesArticleList, PREG_PATTERN_ORDER | PREG_OFFSET_CAPTURE);
        

        $this->markercluster = 0;
        $this->markerclusterlist = 0;
        $this->markermanager = 0;
        $this->main_lang = "";
        $this->infobubble = 0;
        $this->featureMarkerWithLabel = 0;
        $this->use_object_manager = 0;
        
        // 11.03.2016 to fix a few articles or modules on page
        $this->scriptfulltext = "";
        $this->scriptinitialize = "";
        

        // Local variables - part 1 - begin
        // set it in any time
        $compatiblemode = $this->compatiblemode;
        $loadtype = $this->loadtype;
		$loadjquery = $this->loadjquery;
        $mapapiversion = $this->mapapiversion;
        $licenseinfo = $this->licenseinfo;
        $placemarkTitleTag = $this->placemarktitletag;
        $urlProtocol = $this->urlProtocol;
        
        $main_lang = $this->main_lang;

        $current_custom_js_path = $this->current_custom_js_path;

		$imgpathIcons = URI::root() .'components/com_zhosmmap/assets/icons/';
		$imgpathUtils = URI::root() .'components/com_zhosmmap/assets/utils/';
		$directoryIcons = 'components/com_zhosmmap/assets/icons/';
	   
        // Local variables - part 1 - end


        if (($count_matches_Overview > 0) ||
            ($count_matches_ArticleList > 0) ||
            ($count_matches_Category > 0)
            )
        {

            // Begin loop for OverviewMap
            for($i = 0; $i < $count_matches_Overview; $i++) 
            {
              //$article->text .= "\n" .'<br />-1-'. $matches[0][$i][0];
               //$article->text .= "\n" .'<br />-2-'. $matches[1][$i][0];
              //$article->text .= "\n" .'<br />-3-'. $matches[2][$i][0];
              //$article->text .= "\n" .'<br />-4-'. $matches[3][$i][0];
                if (property_exists($article, "id"))
                {
                    $cur_article_id = $article->id;
                }
                else
                {
                    $cur_article_id ="";
                }
                
                $cur_article_id = str_replace(array("{", "}"), '_', $cur_article_id);
                $contextFormatted =  str_replace(array("{", "}"), '_', $context);
                $compoundID = str_replace('#','_', str_replace('.', '_', $contextFormatted.'#'.$cur_article_id .'#'.$i));
                $pars = explode(";", $matchesOverview[2][$i][0].$parameterDefaultLine);
                $basicID = $pars[0];
                $compoundID .= '_'.$basicID.'_'.'map';                              
                // 12.11.2018 fix -extrafields from K2
                $compoundID = str_replace('-','_', $compoundID);

                if ($this->getMap($compoundID, $cur_article_id, $matchesOverview[2][$i][0], "0", "0", "0", "0", "0", "0", "0"))
                {
                    $patternsOverview = '/'.$matchesOverview[0][$i][0].'/';
                    $replacementsOverview = $this->scripthead ; //'call='.$i ;
                    $this->scriptfulltext .= "\n" . $this->scripttext;
                    $article->text = preg_replace($patternsOverview, $replacementsOverview, $article->text, 1);
                }
            }
            // End loop for OverviewMap
   

            // Begin loop for Category
            for($i = 0; $i < $count_matches_Category; $i++) 
            {
                if (property_exists($article, "id"))
                {
                    $cur_article_id = $article->id;
                }
                else
                {
                    $cur_article_id ="";
                }
                
                $cur_article_id = str_replace(array("{", "}"), '_', $cur_article_id);
                $contextFormatted =  str_replace(array("{", "}"), '_', $context);
                $compoundID = str_replace('#','_', str_replace('.', '_', $contextFormatted.'#'.$cur_article_id .'#'.$i));
                $pars = explode(";", $matchesCategory[2][$i][0].$parameterDefaultLine);
                $basicID = 0; // $pars[0]; - this is list now
                $compoundID .= '_'.$basicID.'_'.'cat';
                // 12.11.2018 fix -extrafields from K2
                $compoundID = str_replace('-','_', $compoundID);

                if ($this->getMap($compoundID, $cur_article_id, "0", "0", $matchesCategory[2][$i][0], "0", "0", "0", "0", "0"))
                {
                    $patternsCategory = '/'.$matchesCategory[0][$i][0].'/';
                    $replacementsCategory = $this->scripthead ; 
                    $this->scriptfulltext .= "\n" . $this->scripttext;
                    $article->text = preg_replace($patternsCategory, $replacementsCategory, $article->text, 1);
                }
            }
            // End loop for Category

            // Begin loop for ArticleList
            for($i = 0; $i < $count_matches_ArticleList; $i++) 
            {
                if (property_exists($article, "id"))
                {
                    $cur_article_id = $article->id;
                }
                else
                {
                    $cur_article_id ="";
                }
                
                $cur_article_id = str_replace(array("{", "}"), '_', $cur_article_id);
                $contextFormatted =  str_replace(array("{", "}"), '_', $context);
                $compoundID = str_replace('#','_', str_replace('.', '_', $contextFormatted.'#'.$cur_article_id .'#'.$i));
                $pars = explode(";", $matchesArticleList[2][$i][0].$parameterDefaultLine);
                $basicID = 0; // $pars[0] - this is a placemark list;
                $compoundID .= '_'.$basicID.'_'.'articlelist';
                // 12.11.2018 fix -extrafields from K2
                $compoundID = str_replace('-','_', $compoundID);

                 if ($this->getMap($compoundID, $cur_article_id, "0", $matchesArticleList[2][$i][0], "0", "0", "0", "0", "0", "0"))
                {
                    $patternsArticleList = '/'.$matchesArticleList[0][$i][0].'/';
                    $replacementsArticleList = $this->scripthead ; 
                    $this->scriptfulltext .= "\n" . $this->scripttext;
                    $article->text = preg_replace($patternsArticleList, $replacementsArticleList, $article->text, 1);
                }
                
            }
            // End loop for ArticleList
            
            $article->text .= '<script type="text/javascript" >/*<![CDATA[*/' ."\n";
            $article->text .= $this->scriptfulltext ."\n";

            if ($this->loadtype == "1")
            {
                $article->text .= 'function initialize'.$this->MapXsuffix . $cur_article_id .'() {' ."\n";
                $article->text .= $this->scriptinitialize;
                $article->text .= '};' ."\n";
                
                $article->text .= ' window.addEvent(\'domready\', initialize'.$this->MapXsuffix . $cur_article_id .');' ."\n";
            }
            else if ($this->loadtype == "2")
            {
                $article->text .= 'function initialize'.$this->MapXsuffix . $cur_article_id .'() {' ."\n";
                $article->text .= $this->scriptinitialize;
                $article->text .= '};' ."\n";
                
                $article->text .= 'var tmpJQ'.$this->MapXsuffix . $cur_article_id.' = jQuery.noConflict();'."\n";
                $article->text .= ' tmpJQ'.$this->MapXsuffix . $cur_article_id.'(document).ready(function() {initialize'.$this->MapXsuffix . $cur_article_id .'();});' ."\n";
            }            
            else
            {
                $article->text .= ' function addLoadEvent(func) {' ."\n";
                $article->text .= '  var oldonload = window.onload;' ."\n";
                $article->text .= '  if (typeof window.onload != \'function\') {' ."\n";
                $article->text .= '    window.onload = func;' ."\n";
                $article->text .= '  } else {' ."\n";
                $article->text .= '    window.onload = function() {' ."\n";
                $article->text .= '      if (oldonload) {' ."\n";
                $article->text .= '        oldonload();' ."\n";
                $article->text .= '      }' ."\n";
                $article->text .= '      func();' ."\n";
                $article->text .= '    }' ."\n";
                $article->text .= '  }' ."\n";
                $article->text .= '}    ' ."\n";    

                
                $article->text .= 'function initialize'.$this->MapXsuffix . $cur_article_id .'() {' ."\n";
                $article->text .= $this->scriptinitialize;
                $article->text .= '};' ."\n";


                $article->text .= 'addLoadEvent(initialize'.$this->MapXsuffix . $cur_article_id .');' ."\n";
            }

            //$article->text .= 'window.onload = initialize;' ."\n";
            $article->text .= '/*]]>*/</script>' ."\n";

            // add local variables for common script
            //   because module doesn't use object model
            
            $featureMarkerWithLabel = $this->featureMarkerWithLabel;
            $markercluster = $this->markercluster;
            $markerclusterlist = $this->markerclusterlist;
            $markermanager = $this->markermanager;


            $infobubble = $this->infobubble;
            $use_object_manager = $this->use_object_manager;

            // do it for each article, because it can be different scripts to load
            require (JPATH_SITE . '/components/com_zhosmmap/tmpl/map/display_script.php');            
        
        }

            
        return true;

    }
    
    function getMap($currentArticleId, $article_id, $mapOverviewWithPars, $articleListWithPars, $categoryListWithPars, $p6, $p7, $p8, $p9, $p10)
    {      
        $parameterDefaultLine = ';;;;;;;;;;;;;;;;;;;;';
        
       
        // Center Value in (placemark, map)
        $currentCenter = "map";
        $currentPlacemarkCenter = "do not change";
        $currentPlacemarkAction = "do not change";
        $currentPlacemarkActionID = "do not change";
        
        // Zoom Value in (1.., do not change)
        $currentZoom = "do not change";
    
        // Map Type Value
        $currentMapType ="do not change";

        // Size Value 
        $currentMapWidth ="do not change";
        $currentMapHeight ="do not change";
        
                        
        // get plugin parameters
        $param_mapid = $this->params->get('mapid', '');
        $param_dflt_icontype = $this->params->get('dflt_icontype', '');
        $param_dflt_iconofsetx = $this->params->get('dflt_iconofsetx', '');
        $param_dflt_iconofsety = $this->params->get('dflt_iconofsety', '');
        $param_coordinategroup = $this->params->get('coordinategroup', '');
        $param_latitude = $this->params->get('latitude', '');
        $param_longitude = $this->params->get('longitude', '');

        $param_markercontent = $this->params->get('markercontent', '');
        $param_actionbyclick = $this->params->get('actionbyclick', '');
        $param_baloon = $this->params->get('baloon', '');
        $param_showgps = $this->params->get('showgps', '');
        $param_toolbararticle = $this->params->get('toolbararticle', '');

        $param_icontype = $this->params->get('icontype', '');
        $param_iconofsetx = $this->params->get('iconofsetx', '');
        $param_iconofsety = $this->params->get('iconofsety', '');

         
    if (($mapOverviewWithPars == "0") &&
        ($articleListWithPars == "0") &&
        ($categoryListWithPars == "0")
        ) 
    {
        return false;
    }

    $db = Factory::getDBO();

    if ($mapOverviewWithPars != "0")
    {

        $pars = explode(";", $mapOverviewWithPars.$parameterDefaultLine);
        $mapId = $pars[0];
        $placemarkCenter = $pars[1];
        $placemarkZoom = $pars[2];
        $placemarkMapType = $pars[3];
        $placemarkMapWidth = $pars[4];
        $placemarkMapHeight = $pars[5];
        $placemarkAction = $pars[6];
		$mapObjects = $pars[7];
		
		
		if ($mapObjects != "" && $mapObjects != "do not change")
		{
			switch ($mapObjects)
            {
                case "ALL":
				    $fix_id = 100000000000;
					$curr_add_map_params = true;
				break;
				
				default:
					$fix_id = 1;
					$curr_add_map_params = false;
                break;
			}
		}
		else
		{
			$fix_id = 1;
			$curr_add_map_params = false;
		}
		
        $placemarkId =  $fix_id * (int)$article_id;


        if ($mapId == "do not change" || $mapId == "")
        {
            $mapId = $param_mapid;
        }

        if ($placemarkZoom != "")
        {
              $currentZoom = plgZhOSMMapPlacemarksHelper::parseZoom($placemarkZoom);
        }

        if ($placemarkMapType != "")
        {
          $currentMapType = plgZhOSMMapPlacemarksHelper::parseMapType($placemarkMapType);
        }

        if ($placemarkMapWidth != "")
        {
            $currentMapWidth = $placemarkMapWidth;
        }

        if ($placemarkMapHeight != "")
        {
            $currentMapHeight = $placemarkMapHeight;
        }

        if ($placemarkCenter != "")
        {
            switch ($placemarkCenter)
            {
                case "map":

                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;    

                break;
                case "placemark":

                    $currentPlacemarkCenter = (int)$placemarkId;
                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;  
                    $currentPlacemarkCenterType = "coordinates";

                break;
                default:

                break;
            }



        }


        if ((int)$article_id == 0)
        {
            return false;
        }
        else
        {
            $map = MapDataHelper::getMap((int)$mapId);

            if (isset($map) && (int)$map->id != 0)
            {

                $placemarklistid = "";
                $explacemarklistid = "";
                $grouplistid = "";
                $categorylistid = "";
                $taglistid = "";

                $routelistid = "";
                $exroutelistid = "";
                $routegrouplistid = "";
                $routecategorylistid = "";     

                $pathlistid = "";
                $expathlistid = "";
                $pathgrouplistid = "";
                $pathcategorylistid = "";
                $pathtaglistid = "";

                // it will be recalculated later -- begin
                $centerplacemarkid = "";
                $centerplacemarkaction = "";
                $centerplacemarkactionid = "";
                // it will be recalculated later -- end
                $externalmarkerlink = "";


                // 13.11.2014 - disable placemark list
                $map->markerlistpos = 0;
                // 12.08.2015 - disable group management
                $map->markergroupcontrol = 0;

                $usermarkersfilter = "";

                // disable ajax loading map objects and its content
                $map->useajax = 0;
                $map->useajaxobject = 0;


																	   

                $markers_article = MapDataHelper::getArticleMarkers(
                        $fix_id,
                        (int)$article_id,
                        (int)$map->id,
                        $param_dflt_icontype,
                        $param_dflt_iconofsetx,
                        $param_dflt_iconofsety,
                        $param_icontype,
                        $param_iconofsetx,
                        $param_iconofsety,
                        "",
                        $param_coordinategroup,
                        $param_latitude,
                        $param_longitude,
                        $param_markercontent,
                        $param_actionbyclick,
                        $param_baloon,
                        $param_showgps,
                        $param_toolbararticle
                );
				
				
                // addition parameters
                $maptypes = MapDataHelper::getMapTypes();

				if ($curr_add_map_params)
				{
					$markers = MapDataHelper::getMarkers($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
														   $map->usermarkers, $usermarkersfilter, $map->usercontact, $map->markerorder);
					
					$paths = MapDataHelper::getPaths($map->id, $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);
					
					$routers = MapDataHelper::getRouters($map->id, $routelistid, $exroutelistid, $routegrouplistid, $routecategorylistid);

					$markergroups = MapDataHelper::getMarkerGroups($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
																	 $map->markergrouporder);
					$mgrgrouplist = MapDataHelper::getMarkerGroupsManage($map->id, 
																		   $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
																		   $map->markergrouporder, $map->markergroupshowicon,
																		   $map->markergroupctlmarker, $map->markergroupctlpath, 
																		   $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);	
				
			
					$markers_result = array_merge($markers, $markers_article);
				
				}
				else
				{
					unset($markers);

					unset($paths);
					unset($routers);

					unset($markergroups);
					unset($mgrgrouplist);
					
					$markers_result = $markers_article;
				}
				

                

                foreach ($markers_result as $key => $currentmarker) 
                {
                    $currentPlacemarkCenterCoordinates = 'L.latLng('.$currentmarker->latitude.', ' .$currentmarker->longitude.')';
                }
				
				$markers = $markers_result;


            }
            else
            {
                return false;
            }





        }
    } 
    else if ($articleListWithPars !="0")
    {
        $pars = explode(";", $articleListWithPars.$parameterDefaultLine);
        $placemarkListIds = $pars[0];
        $mapId = $pars[1];
        $placemarkCenter = $pars[2];
        $placemarkZoom = $pars[3];
        $placemarkMapType = $pars[4];
        $placemarkMapWidth = $pars[5];
        $placemarkMapHeight = $pars[6];
        $placemarkAction = $pars[7];

        $fix_id = 100000000000;

        $placemarkId = $fix_id * (int)$article_id;


        if ($mapId == "do not change" || $mapId == "")
        {
            $mapId = $param_mapid;
        }

        if ($placemarkZoom != "")
        {
              $currentZoom = plgZhOSMMapPlacemarksHelper::parseZoom($placemarkZoom);
        }

        if ($placemarkMapType != "")
        {
          $currentMapType = plgZhOSMMapPlacemarksHelper::parseMapType($placemarkMapType);
        }

        if ($placemarkMapWidth != "")
        {
            $currentMapWidth = $placemarkMapWidth;
        }

        if ($placemarkMapHeight != "")
        {
            $currentMapHeight = $placemarkMapHeight;
        }

        if ($placemarkCenter != "")
        {
            switch ($placemarkCenter)
            {
                case "map":

                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;    

                break;
                case "placemark":

                    $currentPlacemarkCenter = (int)$placemarkId;
                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;  
                    $currentPlacemarkCenterType = "coordinates";

                break;
                default:

                break;
            }



        }

        if ((int)$article_id == 0)
        {
            return false;
        }
        else
        {
            $map = MapDataHelper::getMap((int)$mapId);

            if (isset($map) && (int)$map->id != 0)
            {

                $placemarklistid = "";
                $explacemarklistid = "";
                $grouplistid = "";
                $categorylistid = "";
                $taglistid = "";

                $routelistid = "";
                $exroutelistid = "";
                $routegrouplistid = "";
                $routecategorylistid = "";     

                $pathlistid = "";
                $expathlistid = "";
                $pathgrouplistid = "";
                $pathcategorylistid = "";
                $pathtaglistid = "";

                // it will be recalculated later -- begin
                $centerplacemarkid = "";
                $centerplacemarkaction = "";
                $centerplacemarkactionid = "";
                // it will be recalculated later -- end
                $externalmarkerlink = "";


                // 13.11.2014 - disable placemark list
                $map->markerlistpos = 0;
                // 12.08.2015 - disable group management
                $map->markergroupcontrol = 0;

                $usermarkersfilter = "";

                // disable ajax loading map objects and its content
                $map->useajax = 0;
                $map->useajaxobject = 0;

                // addition parameters
                $markers = MapDataHelper::getMarkers($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                       $map->usermarkers, $usermarkersfilter, $map->usercontact, $map->markerorder);
                
                $paths = MapDataHelper::getPaths($map->id, $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);
                
                $routers = MapDataHelper::getRouters($map->id, $routelistid, $exroutelistid, $routegrouplistid, $routecategorylistid);
                $maptypes = MapDataHelper::getMapTypes();

                $markergroups = MapDataHelper::getMarkerGroups($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                                 $map->markergrouporder);
                $mgrgrouplist = MapDataHelper::getMarkerGroupsManage($map->id, 
                                                                       $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                                       $map->markergrouporder, $map->markergroupshowicon,
                                                                       $map->markergroupctlmarker, $map->markergroupctlpath, 
                                                                       $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);

                $markers_article = MapDataHelper::getArticleMarkers(
                        $fix_id,
                        $placemarkListIds,
                        (int)$map->id,
                        $param_dflt_icontype,
                        $param_dflt_iconofsetx,
                        $param_dflt_iconofsety,
                        $param_icontype,
                        $param_iconofsetx,
                        $param_iconofsety,
                        "",
                        $param_coordinategroup,
                        $param_latitude,
                        $param_longitude,
                        $param_markercontent,
                        $param_actionbyclick,
                        $param_baloon,
                        $param_showgps,
                        $param_toolbararticle
                );

                $markers_result = array_merge($markers, $markers_article);
                
                foreach ($markers_result as $key => $currentmarker) 
                {
                    $currentPlacemarkCenterCoordinates = 'L.latLng('.$currentmarker->latitude.', ' .$currentmarker->longitude.')';
                }
                
                $markers = $markers_result;

            }
            else
            {
                return false;
            }





        }        
    }
    else if ($categoryListWithPars !="0")
    {
        
        $pars = explode(";", $categoryListWithPars.$parameterDefaultLine);
        $categoryListIds = $pars[0];
        $mapId = $pars[1];
        $placemarkCenter = $pars[2];
        $placemarkZoom = $pars[3];
        $placemarkMapType = $pars[4];
        $placemarkMapWidth = $pars[5];
        $placemarkMapHeight = $pars[6];
        $placemarkAction = $pars[7];

        $fix_id = 100000000000;

        $placemarkId = $fix_id * (int)$article_id;


        if ($mapId == "do not change" || $mapId == "")
        {
            $mapId = $param_mapid;
        }

        if ($placemarkZoom != "")
        {
              $currentZoom = plgZhOSMMapPlacemarksHelper::parseZoom($placemarkZoom);
        }

        if ($placemarkMapType != "")
        {
          $currentMapType = plgZhOSMMapPlacemarksHelper::parseMapType($placemarkMapType);
        }

        if ($placemarkMapWidth != "")
        {
            $currentMapWidth = $placemarkMapWidth;
        }

        if ($placemarkMapHeight != "")
        {
            $currentMapHeight = $placemarkMapHeight;
        }

        if ($placemarkCenter != "")
        {
            switch ($placemarkCenter)
            {
                case "map":

                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;    

                break;
                case "placemark":

                    $currentPlacemarkCenter = (int)$placemarkId;
                    $currentPlacemarkActionID = (int)$placemarkId;
                    $currentPlacemarkAction = $placemarkAction;  
                    $currentPlacemarkCenterType = "coordinates";

                break;
                default:

                break;
            }



        }

        if ((int)$article_id == 0)
        {
            return false;
        }
        else
        {
            $map = MapDataHelper::getMap((int)$mapId);

            if (isset($map) && (int)$map->id != 0)
            {

                $placemarklistid = "";
                $explacemarklistid = "";
                $grouplistid = "";
                $categorylistid = "";
                $taglistid = "";

                $routelistid = "";
                $exroutelistid = "";
                $routegrouplistid = "";
                $routecategorylistid = "";     

                $pathlistid = "";
                $expathlistid = "";
                $pathgrouplistid = "";
                $pathcategorylistid = "";
                $pathtaglistid = "";

                // it will be recalculated later -- begin
                $centerplacemarkid = "";
                $centerplacemarkaction = "";
                $centerplacemarkactionid = "";
                // it will be recalculated later -- end
                $externalmarkerlink = "";


                // 13.11.2014 - disable placemark list
                $map->markerlistpos = 0;
                // 12.08.2015 - disable group management
                $map->markergroupcontrol = 0;

                $usermarkersfilter = "";

                // disable ajax loading map objects and its content
                $map->useajax = 0;
                $map->useajaxobject = 0;

                // addition parameters
                $markers = MapDataHelper::getMarkers($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                       $map->usermarkers, $usermarkersfilter, $map->usercontact, $map->markerorder);
                
                $paths = MapDataHelper::getPaths($map->id, $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);
                
                $routers = MapDataHelper::getRouters($map->id, $routelistid, $exroutelistid, $routegrouplistid, $routecategorylistid);
                $maptypes = MapDataHelper::getMapTypes();

                $markergroups = MapDataHelper::getMarkerGroups($map->id, $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                                 $map->markergrouporder);
                $mgrgrouplist = MapDataHelper::getMarkerGroupsManage($map->id, 
                                                                       $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                                       $map->markergrouporder, $map->markergroupshowicon,
                                                                       $map->markergroupctlmarker, $map->markergroupctlpath, 
                                                                       $pathlistid, $expathlistid, $pathgrouplistid, $pathcategorylistid, $pathtaglistid);

                $markers_article = MapDataHelper::getArticleMarkers(
                        $fix_id,
                        "",
                        (int)$map->id,
                        $param_dflt_icontype,
                        $param_dflt_iconofsetx,
                        $param_dflt_iconofsety,
                        $param_icontype,
                        $param_iconofsetx,
                        $param_iconofsety,
                        $categoryListIds,
                        $param_coordinategroup,
                        $param_latitude,
                        $param_longitude,
                        $param_markercontent,
                        $param_actionbyclick,
                        $param_baloon,
                        $param_showgps,
                        $param_toolbararticle
                );

                $markers_result = array_merge($markers, $markers_article);
                
                foreach ($markers_result as $key => $currentmarker) 
                {
                    $currentPlacemarkCenterCoordinates = 'L.latLng('.$currentmarker->latitude.', ' .$currentmarker->longitude.')';
                }
                
                $markers = $markers_result;


            }
            else
            {
                return false;
            }





        }        
    }        
    
    // Change translation language and load translation
    if (isset($map->lang) && $map->lang != "")
    {
		$currentLanguage = Factory::getLanguage();
		$lang = $map->lang;
		$currentLanguage->load('plgzhosmmap_article_overview', JPATH_PLUGINS, $lang, true);    
		$currentLanguage->load('plgzhosmmap_article_overview', JPATH_SITE . '/plugins/content/plgzhosmmap_article_overview' , $lang, true);    
    } else {
		$currentLanguage = Factory::getLanguage();
		$currentLangTag = $currentLanguage->getTag();
		$currentLanguage->load('plgzhosmmap_article_overview', JPATH_PLUGINS, $currentLangTag, true);        
		$currentLanguage->load('plgzhosmmap_article_overview', JPATH_SITE . '/plugins/content/plgzhosmmap_article_overview' , $currentLangTag, true);    	

	}

    $MapXArticleId = $currentArticleId;
    $MapXdoLoad = 0;
    $MapXsuffix = $this->MapXsuffix;
    
    $useObjectStructure = $this->useObjectStructure;
    
    $compatiblemode = $this->compatiblemode;
    $loadtype = $this->loadtype;
    $mapapiversion = $this->mapapiversion;
	$loadjquery = $this->loadjquery;
    
    $main_lang = $this->main_lang;
        
    $licenseinfo = $this->licenseinfo;
    $placemarkTitleTag = $this->placemarktitletag;

    $urlProtocol = $this->urlProtocol;
    
    $load_delay = $this->load_delay;
    
    if (($currentPlacemarkCenter != "") && ($currentPlacemarkCenter != "do not change"))
    {
        $centerplacemarkid = $currentPlacemarkCenter;
    }
    else
    {
        $centerplacemarkid = "";
    }

    if (($currentPlacemarkAction != "") && ($currentPlacemarkAction != "do not change"))
    {
        $centerplacemarkaction = $currentPlacemarkAction;
    }
    else
    {
        $centerplacemarkaction = "";
    }

    if (($currentPlacemarkActionID != "") && ($currentPlacemarkActionID != "do not change"))
    {
        $centerplacemarkactionid = $currentPlacemarkActionID;
    }
    else
    {
        $centerplacemarkaction = "";
    }
    
    if (($currentZoom != "") && ($currentZoom != "do not change"))
    {
        $mapzoom = $currentZoom;
    }
    else
    {
        $mapzoom = "";
    }

    
    if (($currentMapWidth != "") && ($currentMapWidth != "do not change"))
    {
        $mapMapWidth = $currentMapWidth;
    }
    else
    {
        $mapMapWidth = "";
    }

    if (($currentMapHeight != "") && ($currentMapHeight != "do not change"))
    {
        $mapMapHeight = $currentMapHeight;
    }
    else
    {
        $mapMapHeight = "";
    }
        
    $current_custom_js_path = $this->current_custom_js_path;

    // -- -- extending ------------------------------------------
    // class suffix, for example for module use
    $cssClassSuffix = "";
    


    
/*
// ***** Settings Begin *************************************

// ***** Settings End ***************************************
*/

    
    require (JPATH_SITE . '/components/com_zhosmmap/tmpl/map/display_map_data.php');

    return true;
    }


}
