<?php
/*------------------------------------------------------------------------
# mod_zhosmmap_article_overview - Zh OpenStreetMap Module - Article Overview Map
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use ZhukDL\Component\ZhOSMMap\Site\Helper\MapDataHelper;

$document    = Factory::getDocument();

// ***** Init Section Begin ***********************************

        $MapXsuffix = "ZhOMMOD_ARTICLE_OVERVIEW";

        $markercluster = 0;
        $markerclusterlist = 0;
        $markermanager = 0;
        $main_lang = "";
        $infobubble = 0;
        $featureMarkerWithLabel = 0;
        $use_object_manager = 0;

        $current_custom_js_path = URI::root() .'components/com_zhosmmap/assets/js/';

		// was 0 and unfefinite, now like module
        $useObjectStructure = 2;
        $MapXdoLoad = 0;
		$MapXArticleId = $module->id;
        
// ***** Init Section End *************************************


$id = $params->get('mapid', '');
$param_dflt_icontype = $params->get('dflt_icontype', '');
$param_dflt_iconofsetx = $params->get('dflt_iconofsetx', '');
$param_dflt_iconofsety = $params->get('dflt_iconofsety', '');
$param_articlelistid = $params->get('articlelistid', '');
$param_categorylistid = $params->get('categorylistid', '');
$param_coordinategroup = $params->get('coordinategroup', '');
$param_latitude = $params->get('latitude', '');
$param_longitude = $params->get('longitude', '');

$param_markercontent = $params->get('markercontent', '');
$param_actionbyclick = $params->get('actionbyclick', '');
$param_baloon = $params->get('baloon', '');
$param_showgps = $params->get('showgps', '');
$param_toolbararticle = $params->get('toolbararticle', '');

$param_icontype = $params->get('icontype', '');
$param_iconofsetx = $params->get('iconofsetx', '');
$param_iconofsety = $params->get('iconofsety', '');

$map = MapDataHelper::getMap((int)$id);

// Change translation language and load translation
$currentLanguage = Factory::getLanguage();
$currentLangTag = $currentLanguage->getTag();
if (isset($map->lang) && $map->lang != "")
{

    $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $map->lang, true);    

    $currentLanguage->load('mod_zhosmmap_article_overview', JPATH_SITE, $map->lang, true);    

}
else
{

    $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $currentLangTag, true);    

    $currentLanguage->load('mod_zhosmmap_article_overview', JPATH_SITE, $currentLangTag, true);    
    
}

if (isset($map) && (int)$map->id != 0)
{

// ***** Settings Begin *************************************
    
$centerplacemarkid = "";
$centerplacemarkaction = "";
$centerplacemarkactionid = "";
$externalmarkerlink = "";

$placemarklistid = "";
$explacemarklistid = "";
$grouplistid = "";
$categorylistid = "";
$taglistid = "";

// Pass it but not use there (only in query)
$routelistid = "";
$exroutelistid = "";
$routegrouplistid = "";
$routecategorylistid = "";

// Pass, used in query
$pathlistid = "";
$expathlistid = "";
$pathgrouplistid = "";
$pathcategorylistid = "";
$pathtaglistid = "";
//

$usermarkersfilter = "";

unset($markers);
unset($paths);

unset($routers);
unset($maptypes);
unset($markergroups);
unset($mgrgrouplist);


$markers = MapDataHelper::getArticleMarkers(
                    0,
                    $param_articlelistid,
                    (int)$map->id,
                    $param_dflt_icontype,
                    $param_dflt_iconofsetx,
                    $param_dflt_iconofsety,
                    $param_icontype,
                    $param_iconofsetx,
                    $param_iconofsety,
                    $param_categorylistid,
                    $param_coordinategroup,
                    $param_latitude,
                    $param_longitude,
                    $param_markercontent,
                    $param_actionbyclick,
                    $param_baloon,
                    $param_showgps,
                    $param_toolbararticle
            );

// disable ajax loading map objects and its content
$map->useajax = 0;
$map->useajaxobject = 0;
                                                            
$mapzoom = "";


$mapMapWidth = "";
$mapMapHeight = "";


// -- -- extending ------------------------------------------
// class suffix, for example for module use

$cssClassSuffix = $params->get('moduleclass_sfx', '');
$defaultIconType = $params->get('icontype', '');
$defaultIconTypeX = $params->get('iconofsetx', '');
$defaultIconTypeY = $params->get('iconofsety', '');


// -- -- -- component options - begin -----------------------

$compatiblemode = MapDataHelper::getCompatibleMode();

$licenseinfo = MapDataHelper::getMapLicenseInfo();

$loadtype = MapDataHelper::getLoadType();
$mapapiversion = MapDataHelper::getMapAPIVersion();
$loadjquery = MapDataHelper::getLoadJQuery();

$httpsprotocol = MapDataHelper::getHttpsProtocol();

$urlProtocol = 'http';
if ($httpsprotocol != "")
{
    if ((int)$httpsprotocol == 0)
    {
        $urlProtocol = 'https';
    }
}

$placemarkTitleTag = MapDataHelper::getPlacemarkTitleTag();
$load_delay = MapDataHelper::getDelay();

// -- -- -- component options - end -------------------------

// ***** Settings End ***************************************




require_once (JPATH_SITE . '/components/com_zhosmmap/tmpl/map/display_map_data.php');

require_once (JPATH_SITE . '/components/com_zhosmmap/tmpl/map/display_script.php');

}
else
{
  echo Text::_( 'MOD_ZHOSMMAP_ARTICLE_MAP_NOTFIND_ID' ).' '. $id;
}
