<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use ZhukDL\Component\ZhOSMMap\Site\Helper\MapPathsHelper;

$returnText = '';

if (isset($currentpath->objecttype))
{
        $current_path_path = str_replace(array("\r", "\r\n", "\n"), '', $currentpath->path);

        if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
        {
                if (isset($map->useajax) && (int)$map->useajax != 0)
                {
                        // do not create content string, create by loop only in the end
                }
                else
                {                                          
                        if ($currentpath->hoverhtml != "")
                        {
                                $returnText .= 'var hoverStringPath'. $currentpath->id.' = '.
                                        MapPathsHelper::get_path_hover_string(
                                                $currentpath);                                    
                        }                                         
                }
        }    

        if ($current_path_path != "")
        {
                $scripttextPathStart = "";
                $scripttextPathEnd = "";
            
                if (isset($currentpath->labelpublished) && (int)$currentpath->labelpublished != 0 )
                {
                    $ofsX = (int)$currentpath->labelanchorx;
                    $ofsY = (int)$currentpath->labelanchory;

                    $scripttextPathContent = $currentpath->labelcontent;
                    
                    if (isset($currentpath->labelstyle) && $currentpath->labelstyle != "")
                    {
                        $scripttextPathContent = '<div class="pathLabel" style="'.str_replace(array("\r", "\r\n", "\n"), '', $currentpath->labelstyle).'">'.$scripttextPathContent."</div>";
                    }
                    $scripttextPathStart = 'L.divIcon({ ';
                    $scripttextPathStart .= ' html: \''; 
                    if ((int)$currentpath->labelpublished == 1)
                    {
                        $scripttextPathStart .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $scripttextPathContent));
                    }
                    $scripttextPathStart .= '\''."\n"; 

                    $scripttextPathEnd = "";
                    if ($currentpath->labelclass != "")
                    {
                            $scripttextPathEnd .= ', className: "'. $currentpath->labelclass .'"'."\n";
                    }        
                    else
                    {
                        // remove default little white rectangle
                        $scripttextPathEnd .= ', className: "zhom-path-label-default"'."\n";
                    }
                    if ($ofsX != 0 || $ofsY != 0)
                    {
                        $scripttextPathEnd .= ', iconAnchor: ['.$ofsX.','.$ofsY.']';
                    }
                    $scripttextPathEnd .= '}) ' ."\n";

                }
                
                switch ((int)$currentpath->objecttype) 
                {                           
                        case 0: // LINE

                                $returnText .= ' var allCoordinates'. $currentpath->id.' = [ '."\n";
                                $returnText .=' ['.str_replace(";","], [", $current_path_path).'] '."\n";
                                $returnText .= ' ]; '."\n";
                                $returnText .= ' var plPath'. $currentpath->id.' = L.polyline(allCoordinates'. $currentpath->id.', {'."\n";

                                if (isset($currentpath->geodesic) && (int)$currentpath->geodesic == 1) 
                                {
                                        $returnText .= ' geodesic: true '."\n";
                                }
                                else
                                {
                                        $returnText .= ' geodesic: false '."\n";
                                }
                                $returnText .= ',color: "'.$currentpath->color.'"'."\n";
                                $returnText .= ',opacity: '.$currentpath->opacity."\n";
                                $returnText .= ',weight: '.$currentpath->weight."\n";
                                if (isset($currentpath->linecap)) 
                                {
                                    if ((int)$currentpath->linecap == 0)
                                    {
                                        $returnText .= ',lineCap: \'round\''."\n";
                                    }
                                    elseif ((int)$currentpath->linecap == 1) 
                                    {
                                        $returnText .= ',lineCap: \'butt\''."\n";
                                    }
                                    elseif ((int)$currentpath->linecap == 2) 
                                    {
                                        $returnText .= ',lineCap: \'square\''."\n";
                                    }
                                    else
                                    {
                                        $returnText .= ',lineCap: \'round\''."\n";
                                    }                                       
                                }
                                if (isset($currentpath->linejoin)) 
                                {
                                    if ((int)$currentpath->linejoin == 0)
                                    {
                                        $returnText .= ',lineJoin: \'round\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 1) 
                                    {
                                        $returnText .= ',lineJoin: \'arcs\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 2) 
                                    {
                                        $returnText .= ',lineJoin: \'bevel\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 3) 
                                    {
                                        $returnText .= ',lineJoin: \'miter\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 4) 
                                    {
                                        $returnText .= ',lineJoin: \'miter-clip\''."\n";
                                    }
                                    else
                                    {
                                        $returnText .= ',lineJoin: \'round\''."\n";
                                    }                                       
                                }
                                if (isset($currentpath->dasharray) && $currentpath->dasharray != "") 
                                {
                                    $returnText .= ',dashArray: \'' . $currentpath->dasharray .'\''."\n";
                                }
                                if (isset($currentpath->dashoffset) && $currentpath->dashoffset != "") 
                                {
                                    $returnText .= ',dashOffset: \'' . $currentpath->dashoffset .'\''."\n";
                                }
                                $returnText .= ' });'."\n";

                                
                                if (isset($currentpath->labelpublished) && (int)$currentpath->labelpublished != 0
                                    && $scripttextPathStart != "" && $scripttextPathEnd != "")
                                {
                                    $returnText .= 'plPath'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                    $returnText .= ' var plPathLabel'. $currentpath->id.' = L.marker(plPath'. $currentpath->id.'.getCenter(), {interactive: false, icon: '.$scripttextPathStart.$scripttextPathEnd.'});'."\n";
                                    if ((int)$currentpath->labelpublished == 2)
                                    {
                                        $returnText .= ' plPathLabel'. $currentpath->id.'.bindTooltip("'.$currentpath->labelcontent.'", {permanent: true});'."\n";
                                    }
                                    $returnText .= 'plPath'. $currentpath->id.'.removeFrom(map'.$mapDivSuffix.');'."\n";
                                }
                                // 28.01.2015 - Added GroupManagement
                                if (((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
                                      || (isset($map->markermanager) && (int)$map->markermanager == 1))
                                  &&(isset($map->markergroupctlpath) 
                                  && (((int)$map->markergroupctlpath == 2) || ((int)$map->markergroupctlpath == 3))))
                                {
                                        if ($zhomObjectManager != 0)
                                        {
                                            $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPath'. $currentpath->id.');'."\n";
                                            if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                            {
                                                $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPathLabel'. $currentpath->id.');'."\n";
                                            }
                                        }
                                }
                                else
                                {
                                        $returnText .= 'plPath'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                        if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                        {
                                            $returnText .= 'plPathLabel'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                        }                                  
                                }


                                $returnText .= '  plPath'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
                                $returnText .= '  plPath'. $currentpath->id.'.zhomObjectType = '. $currentpath->objecttype.';' ."\n";
                                $returnText .= '  plPath'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
                                $returnText .= '  plPath'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    

                                if ($currentpath->hover_color != "")
                                {
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomHoverChangeColor = 1;' ."\n";
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomStrokeColor = "'. $currentpath->color.'";' ."\n";
                                }
                                else
                                {
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomHoverChangeColor = 0;' ."\n";
                                }

                                // Mouse hover - begin
                                if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
                                {
                                        if ($currentpath->hoverhtml != "")
                                        {
                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                            {
                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                            }
                                            else
                                            {
                                                if ((int)$map->hovermarker != 0)
                                                {
                                                        $returnText .= '  plPath'. $currentpath->id.'.bindTooltip(hoverStringPath'. $currentpath->id.$fv_hover_marker_options.');'."\n";
														$returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                                $returnText .= '       color: "'.$currentpath->hover_color.'"'."\n";
                                                                $returnText .= '      });' ."\n";

                                                                $returnText .= '    plPath'. $currentpath->id.'.openTooltip();' ."\n";

                                                        }

                                                        $returnText .= '  });' ."\n";


                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                                $returnText .= '       color: "'.$currentpath->color.'"'."\n";
                                                                $returnText .= '      });' ."\n";

                                                                $returnText .= '    plPath'. $currentpath->id.'.closeTooltip();' ."\n";
                                                        }

                                                        $returnText .= '  });' ."\n";
														
                                                }

                                            }

                                        }
                                        else
                                        {
                                                if ($currentpath->hover_color != "")
                                                {
                                                    if (isset($map->useajax) && (int)$map->useajax != 0)
                                                    {
                                                            $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                                    }
                                                    else
                                                    {
                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                        $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                        $returnText .= '       color: "'.$currentpath->hover_color.'"'."\n";
                                                        $returnText .= '      });' ."\n";
                                                        $returnText .= '  });' ."\n";
                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                        $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                        $returnText .= '       color: "'.$currentpath->color.'"'."\n";
                                                        $returnText .= '      });' ."\n";
                                                        $returnText .= '  });' ."\n";
                                                    }
                                                }                                                    
                                        }
                                }
                                else
                                {
                                        if ($currentpath->hover_color != "")
                                        {
                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                            {
                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                            }
                                            else
                                            {
                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                $returnText .= '       color: "'.$currentpath->hover_color.'"'."\n";
                                                $returnText .= '      });' ."\n";
                                                $returnText .= '  });' ."\n";
                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                $returnText .= '       color: "'.$currentpath->color.'"'."\n";
                                                $returnText .= '      });' ."\n";
                                                $returnText .= '  });' ."\n";
                                            }
                                        }                            
                                }                            
                                // Mouse hover - end


                                if (isset($map->useajax) && (int)$map->useajax != 0)
                                {
                                        // do not create listeners, create by loop only in the end
                                        $returnText .= '  ajaxpaths'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                }
                                else
                                {                                                       
                                    // Action By Click Path - Begin                            
                                    switch ((int)$currentpath->actionbyclick)
                                    {
                                            // None
                                            case 0:
                                            break;
                                            // Info
                                            case 1:
                                                if ($managePanelInfowin == 1)
                                                {
                                                    // do not bind popup for panel
                                                }
                                                else
                                                {
                                                    if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                                                    {
                                                        $returnText .= '  plPath'.$currentpath->id.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(plPath'. $currentpath->id.'.zhomInfowinContent));'."\n";
                                                    }
                                                    else
                                                    {
                                                       $returnText .= '  plPath'. $currentpath->id.'.bindPopup(plPath'. $currentpath->id.'.zhomInfowinContent);'."\n"; 
                                                    }
                                                }
                                                
                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";


                                                // Open infowin
                                                if ((int)$map->markerlistpos != 0)
                                                {
                                                        $returnText .= '  Map_Animate_Marker_Hide_Force(map'.$mapDivSuffix.');'."\n";
                                                }

                                                if ($managePanelInfowin == 1)
                                                {
                                                        $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.panelShowPathContent(this.zhomInfowinContent);' ."\n";
                                                }    
                                                else
                                                {
                                                    $returnText .= ' this.openPopup();' ."\n";
                                                }                                                                 

                                                $returnText .= '  });' ."\n";
                                            break;
                                            // Link
                                            case 2:
                                                    if ($currentpath->hrefsite != "")
                                                    {
                                                            $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                            $returnText .= '  window.open("'.$currentpath->hrefsite.'");' ."\n";
                                                            $returnText .= '  });' ."\n";                                            
                                                    }
                                            break;
                                            // Link in self
                                            case 3:
                                                    if ($currentpath->hrefsite != "")
                                                    {
                                                            $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                            $returnText .= '  window.location = "'.$currentpath->hrefsite.'";' ."\n";
                                                            $returnText .= '  });' ."\n";
                                                    }
                                            break;
                                            default:
                                                    $returnText .= '' ."\n";
                                            break;
                                    }
                                    // Action By Click Path - End
                                }
                        break;
                        case 1: //POLYGON
                                $returnText .= ' var allCoordinates'. $currentpath->id.' = [ '."\n";
                                $returnText .=' ['.str_replace(";","], [", $current_path_path).'] '."\n";
                                $returnText .= ' ]; '."\n";
                                $returnText .= ' var plPath'. $currentpath->id.' = L.polygon(allCoordinates'. $currentpath->id.', {'."\n";

                                if (isset($currentpath->geodesic) && (int)$currentpath->geodesic == 1) 
                                {
                                        $returnText .= ' geodesic: true, '."\n";
                                }
                                else
                                {
                                        $returnText .= ' geodesic: false, '."\n";
                                }
                                $returnText .= ' color: "'.$currentpath->color.'"'."\n";
                                $returnText .= ',opacity: '.$currentpath->opacity."\n";
                                $returnText .= ',weight: '.$currentpath->weight."\n";
                                if ($currentpath->fillcolor != "")
                                {
                                        $returnText .= ',fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                }
                                if ($currentpath->fillopacity != "")
                                {
                                        $returnText .= ',fillOpacity: '.$currentpath->fillopacity."\n";
                                }
                                if (isset($currentpath->linejoin)) 
                                {
                                    if ((int)$currentpath->linejoin == 0)
                                    {
                                        $returnText .= ',lineJoin: \'round\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 1) 
                                    {
                                        $returnText .= ',lineJoin: \'arcs\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 2) 
                                    {
                                        $returnText .= ',lineJoin: \'bevel\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 3) 
                                    {
                                        $returnText .= ',lineJoin: \'miter\''."\n";
                                    }
                                    elseif ((int)$currentpath->linejoin == 4) 
                                    {
                                        $returnText .= ',lineJoin: \'miter-clip\''."\n";
                                    }
                                    else
                                    {
                                        $returnText .= ',lineJoin: \'round\''."\n";
                                    }                                       
                                }
                                if (isset($currentpath->dasharray) && $currentpath->dasharray != "") 
                                {
                                    $returnText .= ',dashArray: \'' . $currentpath->dasharray .'\''."\n";
                                }
                                if (isset($currentpath->dashoffset) && $currentpath->dashoffset != "") 
                                {
                                    $returnText .= ',dashOffset: \'' . $currentpath->dashoffset .'\''."\n";
                                }
                                $returnText .= ' });'."\n";

                                if (isset($currentpath->labelpublished) && (int)$currentpath->labelpublished != 0
                                    && $scripttextPathStart != "" && $scripttextPathEnd != "")
                                {
                                    $returnText .= 'plPath'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                    $returnText .= ' var plPathLabel'. $currentpath->id.' = L.marker(plPath'. $currentpath->id.'.getCenter(), {interactive: false, icon: '.$scripttextPathStart.$scripttextPathEnd.'});'."\n";
                                    if ((int)$currentpath->labelpublished == 2)
                                    {
                                        $returnText .= ' plPathLabel'. $currentpath->id.'.bindTooltip("'.$currentpath->labelcontent.'", {permanent: true});'."\n";
                                    }
                                    $returnText .= 'plPath'. $currentpath->id.'.removeFrom(map'.$mapDivSuffix.');'."\n";
                                }
                                
                                // 28.01.2015 - Added GroupManagement
                                if (((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
                                        || (isset($map->markermanager) && (int)$map->markermanager == 1))
                                  &&(isset($map->markergroupctlpath) 
                                  && (((int)$map->markergroupctlpath == 2) || ((int)$map->markergroupctlpath == 3))))
                                {
                                        if ($zhomObjectManager != 0)
                                        {
                                                $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPath'. $currentpath->id.');'."\n";
                                        }
                                        if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                        {
                                            $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPathLabel'. $currentpath->id.');'."\n";
                                        }
                                }
                                else
                                {
                                        $returnText .= 'plPath'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                        if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                        {
                                            $returnText .= 'plPathLabel'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                        } 
                                }


                                $returnText .= '  plPath'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
                                $returnText .= '  plPath'. $currentpath->id.'.zhomObjectType = '. $currentpath->objecttype.';' ."\n";
                                $returnText .= '  plPath'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
                                $returnText .= '  plPath'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    

                                if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                {
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomHoverChangeColor = 1;' ."\n";
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomStrokeColor = "'. $currentpath->color.'";' ."\n";
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomFillColor = "'. $currentpath->fillcolor.'";' ."\n";
                                }
                                else
                                {
                                    $returnText .= '  plPath'. $currentpath->id.'.zhomHoverChangeColor = 0;' ."\n";
                                }                                                

                                // Mouse hover - begin
                                if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
                                {
                                        if ($currentpath->hoverhtml != "")
                                        {
                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                            {
                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                            }
                                            else
                                            {                                                                
                                                if ((int)$map->hovermarker != 0)
                                                {
                                                        $returnText .= '  plPath'. $currentpath->id.'.bindTooltip(hoverStringPath'. $currentpath->id.$fv_hover_marker_options.');'."\n";

                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                        {
                                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                                }                                            
                                                                if ($currentpath->hover_fillcolor != "")
                                                                {
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '    ,';
                                                                        }                    
                                                                        else
                                                                        {
                                                                                $returnText .= '     ';
                                                                        }
                                                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                                }    
                                                                $returnText .= '      });' ."\n";
                                                        }
                                                        $returnText .= '    plPath'. $currentpath->id.'.openTooltip();' ."\n";

                                                        $returnText .= '  });' ."\n";

                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                        {
                                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                                }                                
                                                                if ($currentpath->hover_fillcolor != "")
                                                                {
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '    ,';
                                                                        }                    
                                                                        else
                                                                        {
                                                                                $returnText .= '     ';
                                                                        }                                    
                                                                        $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                                }
                                                                $returnText .= '      });' ."\n";
                                                        }

                                                        $returnText .= '    plPath'. $currentpath->id.'.closeTooltip();' ."\n";

                                                        $returnText .= '  });' ."\n";
                                                }

                                            }    

                                        }
                                        else
                                        {
                                                if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                {
                                                    if (isset($map->useajax) && (int)$map->useajax != 0)
                                                    {
                                                            $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                                    }
                                                    else
                                                    {
                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                        $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                        }                                            
                                                        if ($currentpath->hover_fillcolor != "")
                                                        {
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '    ,';
                                                                }                    
                                                                else
                                                                {
                                                                        $returnText .= '     ';
                                                                }
                                                                $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                        }                                        
                                                        $returnText .= '      });' ."\n";
                                                        $returnText .= '  });' ."\n";
                                                        $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                        $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                        }                                
                                                        if ($currentpath->hover_fillcolor != "")
                                                        {
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '    ,';
                                                                }                    
                                                                else
                                                                {
                                                                        $returnText .= '     ';
                                                                }                                    
                                                                $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                        }
                                                        $returnText .= '      });' ."\n";
                                                        $returnText .= '  });' ."\n";
                                                    }
                                                }                                                    
                                        }
                                }
                                else
                                {
                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                        {
                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                            {
                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                            }
                                            else
                                            {
                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                if ($currentpath->hover_color != "")
                                                {
                                                        $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                }                                            
                                                if ($currentpath->hover_fillcolor != "")
                                                {
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    ,';
                                                        }                    
                                                        else
                                                        {
                                                                $returnText .= '     ';
                                                        }
                                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                }
                                                $returnText .= '      });' ."\n";
                                                $returnText .= '  });' ."\n";
                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                $returnText .= '    plPath'. $currentpath->id.'.setStyle({' ."\n";    
                                                if ($currentpath->hover_color != "")
                                                {
                                                        $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                }                                
                                                if ($currentpath->hover_fillcolor != "")
                                                {
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    ,';
                                                        }                    
                                                        else
                                                        {
                                                                $returnText .= '     ';
                                                        }                                    
                                                        $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                }
                                                $returnText .= '      });' ."\n";
                                                $returnText .= '  });' ."\n";
                                            }
                                        }                            
                                }                            
                                // Mouse hover - end


                                if (isset($map->useajax) && (int)$map->useajax != 0)
                                {
                                        // do not create listeners, create by loop only in the end
                                        $returnText .= '  ajaxpaths'.$mapDivSuffix.'.push(plPath'. $currentpath->id.');'."\n";
                                }
                                else
                                {
                                    // Action By Click Path - Begin                            
                                    switch ((int)$currentpath->actionbyclick)
                                    {
                                            // None
                                            case 0:
                                            break;
                                            // Info
                                            case 1:
                                                if ($managePanelInfowin == 1)
                                                {
                                                    // do not bind popup for panel
                                                }
                                                else
                                                {
                                                    if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                                                    {
                                                        $returnText .= '  plPath'.$currentpath->id.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(plPath'. $currentpath->id.'.zhomInfowinContent));'."\n";
                                                    }
                                                    else
                                                    {
                                                        $returnText .= '  plPath'. $currentpath->id.'.bindPopup(plPath'. $currentpath->id.'.zhomInfowinContent);'."\n";
                                                    }
                                                }

                                                $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";

                                                if ((int)$map->markerlistpos != 0)
                                                {
                                                        $returnText .= '  Map_Animate_Marker_Hide_Force(map'.$mapDivSuffix.');'."\n";
                                                }

                                                if ($managePanelInfowin == 1)
                                                {
                                                    $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.panelShowPathContent(this.zhomInfowinContent);' ."\n";
                                                }    
                                                else
                                                {                                            
                                                    $returnText .= ' this.openPopup();' ."\n";
                                                }


                                                $returnText .= '  });' ."\n";
                                            break;
                                            // Link
                                            case 2:
                                                    if ($currentpath->hrefsite != "")
                                                    {
                                                            $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                            $returnText .= '  window.open("'.$currentpath->hrefsite.'");' ."\n";
                                                            $returnText .= '  });' ."\n";                                            
                                                    }
                                            break;
                                            // Link in self
                                            case 3:
                                                    if ($currentpath->hrefsite != "")
                                                    {
                                                            $returnText .= '  plPath'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                            $returnText .= '  window.location = "'.$currentpath->hrefsite.'";' ."\n";
                                                            $returnText .= '  });' ."\n";
                                                    }
                                            break;
                                            default:
                                                    $returnText .= '' ."\n";
                                            break;
                                    }
                                    // Action By Click Path - End

                                }
                        break;
                        case 2: //CIRCLE
                            if ($currentpath->radius != "")
                                {
                                        $arrayPathCoords = explode(';', $current_path_path);
                                        $arrayPathIndex = 0;
                                        foreach ($arrayPathCoords as $currentpathcoordinates) 
                                        {
                                                $arrayPathIndex += 1;

                                                $returnText .= ' var plPath'.$arrayPathIndex.'_'. $currentpath->id.' = L.circle(['.$currentpathcoordinates.'], {'."\n";
                                                $returnText .= ' radius: '.$currentpath->radius."\n";
                                                $returnText .= ',color: "'.$currentpath->color.'"'."\n";
                                                $returnText .= ',opacity: '.$currentpath->opacity."\n";
                                                $returnText .= ',weight: '.$currentpath->weight."\n";
                                                if ($currentpath->fillcolor != "")
                                                {
                                                        $returnText .= ',fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                }
                                                if ($currentpath->fillopacity != "")
                                                {
                                                        $returnText .= ',fillOpacity: '.$currentpath->fillopacity."\n";
                                                }
                                                if (isset($currentpath->dasharray) && $currentpath->dasharray != "") 
                                                {
                                                    $returnText .= ',dashArray: \'' . $currentpath->dasharray .'\''."\n";
                                                }
                                                if (isset($currentpath->dashoffset) && $currentpath->dashoffset != "") 
                                                {
                                                    $returnText .= ',dashOffset: \'' . $currentpath->dashoffset .'\''."\n";
                                                }
                                                $returnText .= '  });' ."\n";
                                                
                                                if (isset($currentpath->labelpublished) && (int)$currentpath->labelpublished != 0
                                                    && $scripttextPathStart != "" && $scripttextPathEnd != "")
                                                {
                                                    $returnText .= ' var plPathLabel'. $arrayPathIndex.'_'. $currentpath->id.' = L.marker(['.$currentpathcoordinates.'], {interactive: false, icon: '.$scripttextPathStart.$scripttextPathEnd.'});'."\n";                                           
                                                    if ((int)$currentpath->labelpublished == 2)
                                                    {
                                                        $returnText .= ' plPathLabel'. $arrayPathIndex.'_'.$currentpath->id.'.bindTooltip("'.$currentpath->labelcontent.'", {permanent: true});'."\n";
                                                    }
                                                }


                                                // 28.01.2015 - Added GroupManagement
                                                if (((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
                                                        || (isset($map->markermanager) && (int)$map->markermanager == 1))
                                                  &&(isset($map->markergroupctlpath) 
                                                  && (((int)$map->markergroupctlpath == 2) || ((int)$map->markergroupctlpath == 3))))
                                                {
                                                        if ($zhomObjectManager != 0)
                                                        {
                                                                $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPath'.$arrayPathIndex.'_'. $currentpath->id.');'."\n";
                                                                if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                                                {
                                                                    $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathXAdd('.$currentpath->markergroup.', plPathLabel'.$arrayPathIndex.'_'.$currentpath->id.');'."\n";
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        $returnText .= 'plPath'.$arrayPathIndex.'_'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";                                                
                                                        if ($scripttextPathStart != "" && $scripttextPathEnd != "")
                                                        {
                                                            $returnText .= 'plPathLabel'.$arrayPathIndex.'_'.$currentpath->id.'.addTo(map'.$mapDivSuffix.');'."\n";
                                                        }
                                                }


                                                $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
                                                $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomObjectType = '. $currentpath->objecttype.';' ."\n";
                                                $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
                                                $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    

                                                if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                {
                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomHoverChangeColor = 1;' ."\n";
                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomStrokeColor = "'. $currentpath->color.'";' ."\n";
                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomFillColor = "'. $currentpath->fillcolor.'";' ."\n";
                                                }
                                                else
                                                {
                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomHoverChangeColor = 0;' ."\n";
                                                }    

                                                // Mouse hover - begin
                                                if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
                                                {
                                                        if ($currentpath->hoverhtml != "")
                                                        {
                                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                                            {
                                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'.$arrayPathIndex.'_'. $currentpath->id.');'."\n";
                                                            }
                                                            else
                                                            {                                                                                
                                                                if ((int)$map->hovermarker != 0)
                                                                {
                                                                        $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.bindTooltip(hoverStringPath'. $currentpath->id.$fv_hover_marker_options.');'."\n";
                                                                        $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                                        {
                                                                                $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                                if ($currentpath->hover_color != "")
                                                                                {
                                                                                        $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                                                }                                            
                                                                                if ($currentpath->hover_fillcolor != "")
                                                                                {
                                                                                        if ($currentpath->hover_color != "")
                                                                                        {
                                                                                                $returnText .= '    ,';
                                                                                        }                    
                                                                                        else
                                                                                        {
                                                                                                $returnText .= '     ';
                                                                                        }
                                                                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                                                }    
                                                                                $returnText .= '      });' ."\n";
                                                                        }
                                                                        $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.openTooltip();' ."\n";

                                                                        $returnText .= '  });' ."\n";

                                                                        $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                                        {
                                                                                $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                                if ($currentpath->hover_color != "")
                                                                                {
                                                                                        $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                                                }                                
                                                                                if ($currentpath->hover_fillcolor != "")
                                                                                {
                                                                                        if ($currentpath->hover_color != "")
                                                                                        {
                                                                                                $returnText .= '    ,';
                                                                                        }                    
                                                                                        else
                                                                                        {
                                                                                                $returnText .= '     ';
                                                                                        }                                    
                                                                                        $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                                                }
                                                                                $returnText .= '      });' ."\n";
                                                                        }
                                                                        $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.closeTooltip();' ."\n";

                                                                        $returnText .= '  });' ."\n";
                                                                }

                                                            }

                                                        }
                                                        else
                                                        {
                                                                if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                                {
                                                                    if (isset($map->useajax) && (int)$map->useajax != 0)
                                                                    {
                                                                            $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'.$arrayPathIndex.'_'. $currentpath->id.');'."\n";
                                                                    }
                                                                    else
                                                                    {
                                                                        $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                                        $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                                        }                                            
                                                                        if ($currentpath->hover_fillcolor != "")
                                                                        {
                                                                                if ($currentpath->hover_color != "")
                                                                                {
                                                                                        $returnText .= '    ,';
                                                                                }                    
                                                                                else
                                                                                {
                                                                                        $returnText .= '     ';
                                                                                }
                                                                                $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                                        }                                        
                                                                        $returnText .= '      });' ."\n";
                                                                        $returnText .= '  });' ."\n";
                                                                        $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                                        $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                                        }                                
                                                                        if ($currentpath->hover_fillcolor != "")
                                                                        {
                                                                                if ($currentpath->hover_color != "")
                                                                                {
                                                                                        $returnText .= '    ,';
                                                                                }                    
                                                                                else
                                                                                {
                                                                                        $returnText .= '     ';
                                                                                }                                    
                                                                                $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                                        }
                                                                        $returnText .= '      });' ."\n";
                                                                        $returnText .= '  });' ."\n";
                                                                    }
                                                                }                                                    
                                                        }
                                                }
                                                else
                                                {
                                                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                                        {
                                                            if (isset($map->useajax) && (int)$map->useajax != 0)
                                                            {
                                                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(plPath'.$arrayPathIndex.'_'. $currentpath->id.');'."\n";
                                                            }
                                                            else
                                                            {
                                                                $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                                                $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                                                }                                            
                                                                if ($currentpath->hover_fillcolor != "")
                                                                {
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '    ,';
                                                                        }                    
                                                                        else
                                                                        {
                                                                                $returnText .= '     ';
                                                                        }
                                                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                                }
                                                                $returnText .= '      });' ."\n";
                                                                $returnText .= '  });' ."\n";
                                                                $returnText .= '  plPath'. $arrayPathIndex.'_'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                                                $returnText .= '    plPath'. $arrayPathIndex.'_'. $currentpath->id.'.setStyle({' ."\n";    
                                                                if ($currentpath->hover_color != "")
                                                                {
                                                                        $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                                                }                                
                                                                if ($currentpath->hover_fillcolor != "")
                                                                {
                                                                        if ($currentpath->hover_color != "")
                                                                        {
                                                                                $returnText .= '    ,';
                                                                        }                    
                                                                        else
                                                                        {
                                                                                $returnText .= '     ';
                                                                        }                                    
                                                                        $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                                }
                                                                $returnText .= '      });' ."\n";
                                                                $returnText .= '  });' ."\n";
                                                            }
                                                        }                            
                                                }                                                                
                                                // Mouse hover - end


                                                if (isset($map->useajax) && (int)$map->useajax != 0)
                                                {
                                                        // do not create listeners, create by loop only in the end
                                                        $returnText .= '  ajaxpaths'.$mapDivSuffix.'.push(plPath'. $arrayPathIndex.'_'. $currentpath->id.');'."\n";
                                                }
                                                else
                                                { 
                                                    // Action By Click Path - Begin                            
                                                    switch ((int)$currentpath->actionbyclick)
                                                    {
                                                        // None
                                                        case 0:
                                                        break;
                                                        // Info
                                                        case 1:
                                                            if ($managePanelInfowin == 1)
                                                            {
                                                                // do not bind popup for panel
                                                            }
                                                            else
                                                            {
                                                                if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                                                                {
                                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'.$currentpath->id.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomInfowinContent));'."\n";
                                                                }
                                                                else
                                                                {
                                                                    $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.bindPopup(plPath'.$arrayPathIndex.'_'. $currentpath->id.'.zhomInfowinContent);'."\n";
                                                                }
                                                            }

                                                            $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";

                                                            if ((int)$map->markerlistpos != 0)
                                                            {
                                                                    $returnText .= '  Map_Animate_Marker_Hide_Force(map'.$mapDivSuffix.');'."\n";
                                                            }

                                                            if ($managePanelInfowin == 1)
                                                            {
                                                                    $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.panelShowPathContent(this.zhomInfowinContent);' ."\n";
                                                            }    
                                                            else
                                                            {
                                                                    $returnText .= ' this.openPopup();' ."\n";    
                                                            }                                            


                                                            $returnText .= '  });' ."\n";
                                                        break;
                                                        // Link
                                                        case 2:
                                                                if ($currentpath->hrefsite != "")
                                                                {
                                                                        $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                                        $returnText .= '  window.open("'.$currentpath->hrefsite.'");' ."\n";
                                                                        $returnText .= '  });' ."\n";                                            
                                                                }
                                                        break;
                                                        // Link in self
                                                        case 3:
                                                                if ($currentpath->hrefsite != "")
                                                                {
                                                                        $returnText .= '  plPath'.$arrayPathIndex.'_'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                                        $returnText .= '  window.location = "'.$currentpath->hrefsite.'";' ."\n";
                                                                        $returnText .= '  });' ."\n";
                                                                }
                                                        break;
                                                        default:
                                                                $returnText .= '' ."\n";
                                                        break;
                                                    }
                                                    // Action By Click Path - End

                                                }

                                        }
                                }
                        break;
                }

        }
}

