<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\Exception\ExecutionFailureException;
use Joomla\CMS\HTML\HTMLHelper;

use ZhukDL\Component\ZhOSMMap\Site\Helper\MapDivsHelper;
use ZhukDL\Component\ZhOSMMap\Site\Helper\MapPlacemarksHelper;
use ZhukDL\Component\ZhOSMMap\Site\Helper\MapGroupsHelper;
use ZhukDL\Component\ZhOSMMap\Site\Helper\MapPathsHelper;

/*
use Joomla\CMS\Application\ApplicationHelper;
use Joomla\Input\Cookie;
*/

$document    = Factory::getDocument();

$wa  = $document->getWebAssetManager();

$allowUserMarker = 0;
$scripttext = '';
$scripttextBegin = '';
$scripttextEnd = '';

$divmapheader ="";
$divmapfooter ="";
$currentUserInfo ="";
$currentUserID = 0;

$scripthead ="";

$currentUser = Factory::getUser();


// Change translation language and load translation
$currentLanguage = Factory::getLanguage();
$currentLangTag = $currentLanguage->getTag();

$main_lang_little = "";

// backup for visualization
if (isset($map->useajax) && (int)$map->useajax != 0) 
{
    $backup_useajax = (int)$map->useajax;                                                              
}
else
{
    $backup_useajax = 0;
}
if (isset($map->useajaxobject) && (int)$map->useajaxobject != 0) 
{
    $backup_useajaxobject = (int)$map->useajaxobject;                                                              
}
else
{
    $backup_useajaxobject = 0;
}
                                                            
if (isset($map->lang) && $map->lang != "")
{
        $main_lang = $map->lang;
        $main_lang_little = substr($main_lang,0, strpos($main_lang, '-'));

      
    $currentLanguage->load('com_zhosmmap', JPATH_SITE, $map->lang, true);    
    $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $map->lang, true);    
    
    // fix translation problem on plugin call
    $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $map->lang, true);    

    if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
    {
        $this->main_lang = $main_lang;
                
    }

    
}
else
{
    $currentLanguage->load('com_zhosmmap', JPATH_SITE, $currentLangTag, true);    
    $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $currentLangTag, true);        
    $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $currentLangTag, true);    
    
}


if (isset($MapXdoLoad) && ((int)$MapXdoLoad == 0))
{
    // all OK
    if ((int)$MapXdoLoad == 0)
    {   // ***** Plugin call *****
        //   hide loading call
        //   but passing composite ID
        if (isset($MapXArticleId) && ($MapXArticleId != ""))
        {
            $mapInitTag = $MapXArticleId;
            // Map DIV suffix
            $mapDivSuffix = '_'.$MapXArticleId;
        }
        else
        {
            if (isset($MapXsuffix) && ($MapXsuffix != ""))
            {
                $mapInitTag = $MapXsuffix;
                $mapDivSuffix = "";
            }
            else
            {
                $mapInitTag = "";
                $mapDivSuffix = "";
            }
        }
    }
    else
    {
        if (isset($MapXsuffix) && ($MapXsuffix != ""))
        {
            $mapInitTag = $MapXsuffix;
            $mapDivSuffix = "";
        }
        else
        {
            $mapInitTag = "";
            $mapDivSuffix = "";
        }
    }

}
else
{
    $MapXdoLoad = 1;

    if (isset($MapXsuffix) && ($MapXsuffix != ""))
    {
        $mapInitTag = $MapXsuffix;
        $mapDivSuffix = "";
    }
    else
    {
        $mapInitTag = "";
        $mapDivSuffix = "";
    }
}




if (isset($map->usermarkers) 
  && ((int)$map->usermarkers == 1
      ||(int)$map->usermarkers == 2)) 
{

    if ($currentUser->id == 0)
    {
        if ((int)$map->usermarkers == 1)
        {
            $currentUserInfo .= '<div id="OMapsLogin'.$mapDivSuffix.'" class="zhom-login">';
            $currentUserInfo .= Text::_( 'COM_ZHOSMMAP_MAP_USER_NOTLOGIN' );
            $currentUserInfo .= '</div>';
        }
        $allowUserMarker = 0;
        $currentUserID = 0;
    }
    else
    {
        if ((int)$map->usermarkers == 1)
        {
            $currentUserInfo .= '<div id="OMapsLogin'.$mapDivSuffix.'" class="zhom-login">';
            $currentUserInfo .= Text::_( 'COM_ZHOSMMAP_MAP_USER_LOGIN' ) .' '. $currentUser->name;
            $currentUserInfo .= '</div>';
        }
        $allowUserMarker = 1;
        $currentUserID = $currentUser->id;
    }
    
} 
else
{
    $allowUserMarker = 0;
    $currentUserID = 0;
}

// if post data to load
if ($allowUserMarker == 1
 && isset($_POST['marker_action']))
{        
    $scripttext .= '<script type="text/javascript">';
    
    $db = Factory::getDBO();

    if (isset($_POST['marker_action']) && 
        ($_POST['marker_action'] == "insert") ||
        ($_POST['marker_action'] == "update") 
        )
    {

        $title = substr($_POST["markername"], 0, 249);
        if ($title == "")
        {
            $title = 'Placemark';
        }

        $markericon = substr($_POST["markerimage"], 0, 249);
        if ($markericon == "")
        {
            $markericon ='default#';
        }
        
        $description = $_POST["markerdescription"];
        $latitude = substr($_POST["markerlat"], 0, 100);
        $longitude = substr($_POST["markerlng"], 0, 100);
        $group = substr($_POST["markergroup"], 0, 100);
        $markercatid = substr($_POST["markercatid"], 0, 100);
        //$markerbaloon = substr($_POST["markerbaloon"], 0, 100);
        $markermarkercontent = substr($_POST["markermarkercontent"], 0, 100);
        if (isset($_POST['markerid']))
        {
            $markerid = (int)substr($_POST["markerid"], 0, 100);
        }
        else
        {
            $markerid = '';
        }
        $markerhrefimage = substr($_POST["markerhrefimage"], 0, 500);
        
        if (isset($map->usercontact) && (int)$map->usercontact == 1) 
        {
            $contactid = substr($_POST["contactid"], 0, 100);
        }
        else
        {
            $contactid = '';
        }
        
        $contactDoInsert = 0;
        
        if (isset($map->usercontact) && (int)$map->usercontact == 1) 
        {
            $contact_name = substr($_POST["contactname"], 0, 250);
            $contact_position = substr($_POST["contactposition"], 0, 250);
            $contact_phone = substr($_POST["contactphone"], 0, 250);
            $contact_mobile = substr($_POST["contactmobile"], 0, 250);
            $contact_fax = substr($_POST["contactfax"], 0, 250);
            $contact_address = substr($_POST["contactaddress"], 0, 250);
            $contact_email = substr($_POST["contactemail"], 0, 250);
            
            if (($contact_name != "") 
              ||($contact_position != "")
              ||($contact_phone != "")
              ||($contact_mobile != "")
              ||($contact_fax != "")
              ||($contact_email != "")
              ||($contact_address != "")
                )
            {
                $contactDoInsert = 1;
            }
        }

        $newRow = new \stdClass();
        
        if ($_POST['marker_action'] == "insert")
        {
            $newRow->id = NULL;
            $newRow->userprotection = 0;
            $newRow->openbaloon = 0;
            $newRow->actionbyclick = 1;
            $newRow->access = 1;
            
            if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
             &&($contactDoInsert == 1))
            {                
                $newRow->showcontact = 2;
            }
            else
            {                
                $newRow->showcontact = 0;
            }
        }
        else
        {
            $newRow->id = $markerid;

            if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
             &&($contactDoInsert == 1) && ((int)$contactid == 0))
            {                
                $newRow->showcontact = 2;
            }
            
        }
        
        // Data for Contacts - begin
        if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
          &&($contactDoInsert == 1))
        {
            $newContactRow = new \stdClass();
            
            if ($_POST['marker_action'] == "insert")
            {
                $newContactRow->id = NULL;
                $newContactRow->published = (int)$map->usercontactpublished;
                $newContactRow->language = '*';
                $newContactRow->access = 1;
            }
            else
            {
                if ((int)$contactid == 0)
                {
                    $newContactRow->id = NULL;
                    $newContactRow->published = (int)$map->usercontactpublished;
                    $newContactRow->language = '*';
                    $newContactRow->access = 1;
                }
                else
                {
                    $newContactRow->id = $contactid;
                }
            }
            
        }            
        // Data for Contacts - end
        
        // because it (quotes) escaped
        $newRow->title = str_replace('\\','', htmlspecialchars($title, ENT_NOQUOTES, 'UTF-8'));
        $newRow->description = str_replace('\\','', htmlspecialchars($description, ENT_NOQUOTES, 'UTF-8'));
        // because it escaped
        $newRow->latitude = htmlspecialchars($latitude, ENT_QUOTES, 'UTF-8');
        $newRow->longitude = htmlspecialchars($longitude, ENT_QUOTES, 'UTF-8');
        $newRow->mapid = $map->id;
        $newRow->icontype = htmlspecialchars($markericon, ENT_QUOTES, 'UTF-8');
                
		if ($_POST['marker_action'] == "insert") {
			$newRow->published = (int)$map->usermarkerspublished;
			$newRow->createdbyuser = $currentUserID;
		} else {
			// do not change state
		}

        $newRow->markergroup = htmlspecialchars($group, ENT_QUOTES, 'UTF-8');
		if ($newRow->markergroup == '') {
			$newRow->markergroup = 0;
		}
        $newRow->catid = htmlspecialchars($markercatid, ENT_QUOTES, 'UTF-8');
		if ($newRow->catid == '') {
			$newRow->catid = 0;
		}

        $newRow->baloon = 3; //htmlspecialchars($markerbaloon, ENT_QUOTES, 'UTF-8');
        $newRow->markercontent = htmlspecialchars($markermarkercontent, ENT_QUOTES, 'UTF-8');
        $newRow->hrefimage = htmlspecialchars($markerhrefimage, ENT_QUOTES, 'UTF-8');
        

        if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
          &&($contactDoInsert == 1))
        {
            $newContactRow->name = str_replace('\\','', htmlspecialchars($contact_name, ENT_NOQUOTES, 'UTF-8'));
            if ($newContactRow->name == "")
            {
                $newContactRow->name = $newRow->title;
            }
            $newContactRow->con_position = str_replace('\\','', htmlspecialchars($contact_position, ENT_NOQUOTES, 'UTF-8'));
            $newContactRow->telephone = str_replace('\\','', htmlspecialchars($contact_phone, ENT_NOQUOTES, 'UTF-8'));
            $newContactRow->mobile = str_replace('\\','', htmlspecialchars($contact_mobile, ENT_NOQUOTES, 'UTF-8'));
            $newContactRow->fax = str_replace('\\','', htmlspecialchars($contact_fax, ENT_NOQUOTES, 'UTF-8'));
            $newContactRow->email_to = str_replace('\\','', htmlspecialchars($contact_email, ENT_NOQUOTES, 'UTF-8'));
            $newContactRow->address = str_replace('\\','', htmlspecialchars($contact_address, ENT_NOQUOTES, 'UTF-8'));
        }
        
        if ($_POST['marker_action'] == "insert")
        {
            if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
              &&($contactDoInsert == 1))
            {
                $dml_contact_result = $db->insertObject( '#__contact_details', $newContactRow, 'id' );
                
                $newRow->contactid = $newContactRow->id;
            }

            // 9.03.2015 set creation date
            $newRow->createddate = Factory::getDate()->toSQL();
            
            $dml_result = $db->insertObject( '#__zhosmmaps_markers', $newRow, 'id' );
        }
        else
        {
            if ((isset($map->usercontact) && (int)$map->usercontact == 1) 
              &&($contactDoInsert == 1))
            {
                if (isset($newContactRow->id))
                {
                    $dml_contact_result = $db->updateObject( '#__contact_details', $newContactRow, 'id' );
                }
                else
                {
                    $dml_contact_result = $db->insertObject( '#__contact_details', $newContactRow, 'id' );
                    $newRow->contactid = $newContactRow->id;
                }
            }

            $dml_result = $db->updateObject( '#__zhosmmaps_markers', $newRow, 'id' );
            //$scripttext .= 'alert("Updated");'."\n";
        }
        
        if ((!$dml_result) || 
            (isset($map->usercontact) && (int)$map->usercontact == 1 && ($contactDoInsert == 1) && (!$dml_result))
            )
        {
            //$this->setError($db->getErrorMsg());
            $scripttext .= 'alert("Error (Insert New Marker or Update): " + "' . $db->escape($db->getErrorMsg()).'");';
        }
        else
        {
            //$scripttext .= 'alert("Complete, redirect");'."\n";
            $scripttext .= 'window.location = "'.URI::current().'";'."\n";
            
            $new_id = $newRow->id;

        }
    }
    else if (isset($_POST['marker_action']) && $_POST['marker_action'] == "delete") 
    {

        $contactid = substr($_POST["contactid"], 0, 100);
        $markerid = substr($_POST["markerid"], 0, 100);
    
        if (isset($map->usercontact) && (int)$map->usercontact == 1) 
        {
        
            if ((int)$contactid != 0)
            {
                $query = $db->getQuery(true);

                $db->setQuery( 'DELETE FROM `#__contact_details` '.
                'WHERE `id`='.(int)$contactid);
                
                try {
					$db->execute();
				} catch (ExecutionFailureException $e) {
					throw new \Exception("Error (Delete Exist Marker Contact): " . $e->getMessage(), 500);
				}  
            }
        }


        $query = $db->getQuery(true);

        $db->setQuery( 'DELETE FROM `#__zhosmmaps_markers` '.
        'WHERE `createdbyuser`='.$currentUserID.
        ' and `id`='.(int)$markerid);

		try {
			$db->execute();
			$scripttext .= 'window.location = "'.URI::current().'";'."\n";
		} catch (ExecutionFailureException $e) {
			throw new \Exception("Error (Delete Exist Marker): " . $e->getMessage(), 500);
		} 
		
    }
$scripttext .= '</script>';


    echo $scripttext;

}
else
{
// main part where not post data


// Process API version for map controls
//
//if ($apiversion != "")
//{    
//}
//else
//{
    $feature4control = 2;
//}    

$credits ='';

if ($licenseinfo == "")
{
  $licenseinfo = 115;
}

if ($compatiblemode == "")
{
  $compatiblemode = 0;
}


if (isset($placemarkTitleTag) && $placemarkTitleTag != "")
{
    if ($placemarkTitleTag == "h2"
     || $placemarkTitleTag == "h3")
    {
        // it's OK. Do not change it
        //$placemarkTitleTag = $placemarkTitleTag;
    }
    else
    {
        $placemarkTitleTag ='h2';
    }
}
else
{
    $placemarkTitleTag ='h2';
}


$imgpathIcons = URI::root() .'components/com_zhosmmap/assets/icons/';
$imgpathUtils = URI::root() .'components/com_zhosmmap/assets/utils/';
$imgpathGPX = URI::root() .'components/com_zhosmmap/assets/gpx/';
$directoryIcons = 'components/com_zhosmmap/assets/icons/';

$imgpath4size = JPATH_SITE .'/components/com_zhosmmap/assets/icons/';



$currentPlacemarkCenter = "do not change";
$currentPlacemarkAction = "do not change";
$currentPlacemarkActionID = "do not change";

if (!isset($currentPlacemarkCenterType))
{
    $currentPlacemarkCenterType = "placemark";
}
if (!isset($currentPlacemarkCenterCoordinates))
{
    $currentPlacemarkCenterCoordinates = "";
}

if ($centerplacemarkid != "")
{
    $currentPlacemarkCenter = $centerplacemarkid;
        
}

if ($centerplacemarkactionid != "")
{
    $currentPlacemarkActionID = $centerplacemarkactionid;
}

if ($centerplacemarkaction != "")
{
    $currentPlacemarkAction = str_replace(',', ';', $centerplacemarkaction);
}

if (isset($loadjquery))
{
	if ((int)$loadjquery == 1) {
		$wa->useScript('jquery');
	}
}


$wa->registerAndUseStyle('zhosmmaps.common',URI::root() .'components/com_zhosmmap/assets/css/common.css');

if (isset($map->css2load) && ($map->css2load != ""))
{
    $loadCSSList = explode(';', str_replace(array("\r", "\r\n", "\n"), ';', $map->css2load));


    for($i = 0; $i < count($loadCSSList); $i++) 
    {
        $currCSS = trim($loadCSSList[$i]);
        if ($currCSS != "")
        {
            $wa->registerAndUseStyle('zhosmmaps.css2load_' . $i,$currCSS);
        }
    }
}

if (isset($map->js2load) && ($map->js2load != ""))
{
    $loadJSList = explode(';', str_replace(array("\r", "\r\n", "\n"), ';', $map->js2load));


    for($i = 0; $i < count($loadJSList); $i++) 
    {
        $currJS = trim($loadJSList[$i]);
        if ($currJS != "")
        {
            $wa->registerAndUseScript('zhosmmaps.js2load_' . $i,$currJS);
        }
    }
}


// super override - init
$fv_override_load_delay = "";

// Overrides - begin
if (isset($map->override_id) && (int)$map->override_id != 0) 
{
    $fv_override = MapPlacemarksHelper::get_MapOverride($map->override_id);
    if (isset($fv_override) && (int)$fv_override->published == 1)
    {
        if ((isset($fv_override->placemark_list_title) && $fv_override->placemark_list_title != ""))
        {
            $fv_override_placemark_title = $fv_override->placemark_list_title;
        }
        else
        {
            $fv_override_placemark_title = Text::_( 'COM_ZHOSMMAP_MARKERLIST_SEARCH_FIELD');
        }
        if ((isset($fv_override->placemark_list_button_title) && $fv_override->placemark_list_button_title != ""))
        {
            $fv_override_placemark_button_title = $fv_override->placemark_list_button_title;
        }
        else
        {
            $fv_override_placemark_button_title = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
        }
        if ((isset($fv_override->placemark_list_button_hint) && $fv_override->placemark_list_button_hint != ""))
        {
            $fv_override_placemark_button_tooltip = $fv_override->placemark_list_button_hint;
        }
        else
        {
            $fv_override_placemark_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
        }
        
        // panel
        if ((isset($fv_override->panelcontrol_hint) && $fv_override->panelcontrol_hint != ""))
        {
            $fv_override_panel_button_tooltip = $fv_override->panelcontrol_hint;
        }
        else
        {
            $fv_override_panel_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PANELCONTROL_LABEL');
        }
        if ((isset($fv_override->panel_detail_title) && $fv_override->panel_detail_title != ""))
        {
            $fv_override_panel_detail_title = $fv_override->panel_detail_title;
        }
        else
        {
            $fv_override_panel_detail_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_DETAIL_TITLE');
        }
        if ((isset($fv_override->panel_placemarklist_title) && $fv_override->panel_placemarklist_title != ""))
        {
            $fv_override_panel_placemarklist_title = $fv_override->panel_placemarklist_title;
        }
        else
        {
            $fv_override_panel_placemarklist_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_PLACEMARKLIST_TITLE');
        }
        if ((isset($fv_override->panel_route_title) && $fv_override->panel_route_title != ""))
        {
            $fv_override_panel_route_title = $fv_override->panel_route_title;
        }
        else
        {
            $fv_override_panel_route_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_ROUTE_TITLE');
        }        
        if ((isset($fv_override->panel_group_title) && $fv_override->panel_group_title != ""))
        {
            $fv_override_panel_group_title = $fv_override->panel_group_title;
        }
        else
        {
            $fv_override_panel_group_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_GROUP_TITLE');
        }

        if ((isset($fv_override->group_list_title) && $fv_override->group_list_title != ""))
        {
            $fv_override_group_title = $fv_override->group_list_title;
        }
        else
        {
            $fv_override_group_title = Text::_( 'COM_ZHOSMMAP_GROUPLIST_SEARCH_FIELD');
        }                
 
        if ((isset($fv_override->gogoogle_text) && $fv_override->gogoogle_text != ""))
        {
            $fv_override_gogoogle_text = $fv_override->gogoogle_text;
        }
        else
        {
            $fv_override_gogoogle_text = Text::_( 'COM_ZHOSMMAP_MAP_GOGOOGLE_TITLE');
        }                  
                
        if ((isset($fv_override->placemark_list_search) && $fv_override->placemark_list_search != ""))
        {
            $fv_override_placemark_list_search = (int)$fv_override->placemark_list_search;
        }
        else
        {
            $fv_override_placemark_list_search = 0;
        }               
                                
        if ((isset($fv_override->placemark_list_mapping_type) && $fv_override->placemark_list_mapping_type != ""))
        {
            $fv_override_placemark_list_mapping_type = (int)$fv_override->placemark_list_mapping_type;
        }
        else
        {
            $fv_override_placemark_list_mapping_type = 0;
        }      

        if ((isset($fv_override->placemark_list_accent_side) && $fv_override->placemark_list_accent_side != ""))
        {
            $fv_override_placemark_list_accent_side = (int)$fv_override->placemark_list_accent_side;
        }
        else
        {
            $fv_override_placemark_list_accent_side = 0;
        } 
                                             

        if ((isset($fv_override->placemark_list_mapping) && $fv_override->placemark_list_mapping != ""))
        {
            $fv_override_placemark_list_mapping = $fv_override->placemark_list_mapping;
        }
        else
        {
            $fv_override_placemark_list_mapping = ""; 
        }  
 
        if ((isset($fv_override->placemark_list_accent) && $fv_override->placemark_list_accent != ""))
        {
            $fv_override_placemark_list_accent = $fv_override->placemark_list_accent;
        }
        else
        {
            $fv_override_placemark_list_accent = ""; 
        }    
                
                //
        if ((isset($fv_override->group_list_search) && $fv_override->group_list_search != ""))
        {
            $fv_override_group_list_search = (int)$fv_override->group_list_search;
        }
        else
        {
            $fv_override_group_list_search = 0;
        } 
                
        if ((isset($fv_override->group_list_mapping_type) && $fv_override->group_list_mapping_type != ""))
        {
            $fv_override_group_list_mapping_type = (int)$fv_override->group_list_mapping_type;
        }
        else
        {
            $fv_override_group_list_mapping_type = 0;
        }      

        if ((isset($fv_override->group_list_accent_side) && $fv_override->group_list_accent_side != ""))
        {
            $fv_override_group_list_accent_side = (int)$fv_override->group_list_accent_side;
        }
        else
        {
            $fv_override_group_list_accent_side = 0;
        } 
                                             

        if ((isset($fv_override->group_list_mapping) && $fv_override->group_list_mapping != ""))
        {
            $fv_override_group_list_mapping = $fv_override->group_list_mapping;
        }
        else
        {
            $fv_override_group_list_mapping = ""; 
        }  
 
        if ((isset($fv_override->group_list_accent) && $fv_override->group_list_accent != ""))
        {
            $fv_override_group_list_accent = $fv_override->group_list_accent;
        }
        else
        {
            $fv_override_group_list_accent = ""; 
        }  

        if ((isset($fv_override->tabid) && (int)$fv_override->tabid != 0))
        {
            $fv_override_placemark_popup_style = (int)$fv_override->tabid;
        }
        else
        {
            $fv_override_placemark_popup_style = 0; 
        }  

                
        if ((isset($fv_override->geocoder_placeholder) && $fv_override->geocoder_placeholder != ""))
        {
            $fv_override_geocoder_placeholder = $fv_override->geocoder_placeholder;
        }
        else
        {
            $fv_override_geocoder_placeholder = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_PLACEHOLDER');
        }            
        if ((isset($fv_override->geocoder_not_found) && $fv_override->geocoder_not_found != ""))
        {
            $fv_override_geocoder_not_found = $fv_override->geocoder_not_found;
        }
        else
        {
            $fv_override_geocoder_not_found = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_NOT_FOUND');
        }          
        if ((isset($fv_override->invalidatediv) && $fv_override->invalidatediv != ""))
        {
            $fv_override_invalidatediv = $fv_override->invalidatediv;
        }
        else
        {
            $fv_override_invalidatediv = "";
        }  
        if ((isset($fv_override->invalidateindex) && $fv_override->invalidateindex != ""))
        {
            $fv_override_invalidateindex = $fv_override->invalidateindex;
        }
        else
        {
            $fv_override_invalidateindex = "";
        }
        if ((isset($fv_override->invalidatetype) && $fv_override->invalidatetype != ""))
        {
            $fv_override_invalidatetype = (int)$fv_override->invalidatetype;
        }
        else
        {
            $fv_override_invalidatetype = 0;
        } 
                
        if ((isset($fv_override->placemark_date_fmt) && $fv_override->placemark_date_fmt != ""))
        {
            $fv_placemark_date_fmt = $fv_override->placemark_date_fmt;
        }
        else
        {
            $fv_placemark_date_fmt = "";
        }
                
        if ((isset($fv_override->markerspinner_list_template) && $fv_override->markerspinner_list_template != ""))
        {
            $fv_override_item_template = $fv_override->markerspinner_list_template;
        }
        else
        {
            $fv_override_item_template = "default"; 
        } 

                
        if ((isset($fv_override->category_hierarchy) && $fv_override->category_hierarchy != ""))
        {
            $fv_override_category_hierarchy = (int)$fv_override->category_hierarchy;
        }
        else
        {
            $fv_override_category_hierarchy = 0;
        } 
        
        if ((isset($fv_override->category_expand) && $fv_override->category_expand != ""))
        {
            $fv_override_category_ex_hierarchy = (int)$fv_override->category_expand;
        }
        else
        {
            $fv_override_category_ex_hierarchy = 0;
        }
        
        if ((isset($fv_override->geocoderzoom) && $fv_override->geocoderzoom != ""))
        {
            $fv_override_geocoderzoom = $fv_override->geocoderzoom;
        }
        else
        {
            $fv_override_geocoderzoom = ""; 
        }
        
        // super override - change
        if ((isset($fv_override->load_delay) && $fv_override->load_delay != ""))
        {
            $fv_override_load_delay = $fv_override->load_delay;
        }

                
    }
    else
    {
        $fv_override_placemark_title = Text::_( 'COM_ZHOSMMAP_MARKERLIST_SEARCH_FIELD');
        $fv_override_placemark_button_title = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
        $fv_override_placemark_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
        
        $fv_override_panel_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PANELCONTROL_LABEL');
        $fv_override_panel_detail_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_DETAIL_TITLE');
        $fv_override_panel_placemarklist_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_PLACEMARKLIST_TITLE');
        $fv_override_panel_route_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_ROUTE_TITLE');
        $fv_override_panel_group_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_GROUP_TITLE');
                
        $fv_override_group_title = Text::_( 'COM_ZHOSMMAP_GROUPLIST_SEARCH_FIELD');

        $fv_override_gogoogle_text = Text::_( 'COM_ZHOSMMAP_MAP_GOGOOGLE_TITLE');

        $fv_override_placemark_list_search = 0;
        $fv_override_placemark_list_mapping_type = 0;
        $fv_override_placemark_list_mapping = "";       
        $fv_override_placemark_list_accent = "";
        $fv_override_placemark_list_accent_side = 0;

        $fv_override_group_list_search = 0;
        $fv_override_group_list_mapping_type = 0;
        $fv_override_group_list_mapping = ""; 
        $fv_override_group_list_accent = ""; 
        $fv_override_group_list_accent_side = 0;

        $fv_override_placemark_popup_style = 0;

        $fv_override_geocoder_placeholder = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_PLACEHOLDER');
        $fv_override_geocoder_not_found = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_NOT_FOUND');

        $fv_override_invalidatediv = "";
        $fv_override_invalidatetype = 0;
        $fv_placemark_date_fmt = "";
        $fv_override_item_template = "default"; 
        $fv_override_invalidateindex = "";
        
        $fv_override_category_hierarchy = 0;
        $fv_override_category_ex_hierarchy = 0;
        
        $fv_override_geocoderzoom = ""; 
    }    
}
else
{
    $fv_override_placemark_title = Text::_( 'COM_ZHOSMMAP_MARKERLIST_SEARCH_FIELD');
    $fv_override_placemark_button_title = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
    $fv_override_placemark_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PLACEMARKLIST');
    
    $fv_override_panel_button_tooltip = Text::_( 'COM_ZHOSMMAP_MAP_PANELCONTROL_LABEL');
    $fv_override_panel_detail_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_DETAIL_TITLE');
    $fv_override_panel_placemarklist_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_PLACEMARKLIST_TITLE');
    $fv_override_panel_route_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_ROUTE_TITLE');
    $fv_override_panel_group_title = Text::_( 'COM_ZHOSMMAP_MAP_PANEL_GROUP_TITLE');
        
    $fv_override_group_title = Text::_( 'COM_ZHOSMMAP_GROUPLIST_SEARCH_FIELD');

    $fv_override_gogoogle_text = Text::_( 'COM_ZHOSMMAP_MAP_GOGOOGLE_TITLE');

    $fv_override_placemark_list_search = 0;
    $fv_override_placemark_list_mapping_type = 0;
    $fv_override_placemark_list_mapping = "";       
    $fv_override_placemark_list_accent = "";
    $fv_override_placemark_list_accent_side = 0;

    $fv_override_group_list_search = 0;
    $fv_override_group_list_mapping_type = 0;
    $fv_override_group_list_mapping = ""; 
    $fv_override_group_list_accent = ""; 
    $fv_override_group_list_accent_side = 0;    

    $fv_override_placemark_popup_style = 0;

    $fv_override_geocoder_placeholder = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_PLACEHOLDER');
    $fv_override_geocoder_not_found = Text::_( 'COM_ZHOSMMAP_MAP_GEOCODER_NOT_FOUND');

    $fv_override_invalidatediv = "";
    $fv_override_invalidatetype = 0;
    $fv_placemark_date_fmt = "";
    $fv_override_item_template = "default"; 
    $fv_override_invalidateindex = "";
    
    $fv_override_category_hierarchy = 0;
    $fv_override_category_ex_hierarchy = 0;
    
    $fv_override_geocoderzoom = ""; 
        
}
// Overrides - end

// super override - fix
if ($fv_override_load_delay != "")
{
    $load_delay = (int)$fv_override_load_delay;
}
 

if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))
{
    if ((int)$map->hovermarker == 10)
    {
        $fv_hover_marker_options = ", {sticky : true}";
    }
    else
    {
        $fv_hover_marker_options = "";
    }
}
else
{
    $fv_hover_marker_options = "";
}

if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
{
    $placemarkSearch = (int)$map->markerlistsearch;    
}
else
{
    $placemarkSearch = 0;
}

if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0) 
{
    $groupSearch = (int)$map->markergroupsearch;    
}
else
{
    $groupSearch = 0;
}



$managePanelFeature = 0;

if ((isset($map->panelinfowin) && (int)$map->panelinfowin != 0))
{
    $managePanelInfowin = 1;
}
else
{
    $managePanelInfowin = 0;
}


if (($managePanelInfowin ==1)
||((isset($map->markerlistpos) && (int)$map->markerlistpos == 120))
||((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol == 120))
)
{
    $managePanelFeature = 1;
}

if ((isset($map->mapcentercontrol) && (int)$map->mapcentercontrol != 0) 
 || (isset($map->markerlistpos) && (int)$map->markerlistpos != 0 && isset($map->markerlistbuttontype) && (int)$map->markerlistbuttontype != 0)
 || (isset($map->geolocationcontrol) && ((int)$map->geolocationcontrol !=0))
 ||($managePanelFeature == 1)
)
{
    $layersButtons = 1;
}
else
{
    $layersButtons = 0;
}



$custMapTypeList = explode(";", $map->custommaptypelist);
if (count($custMapTypeList) != 0)
{
    $custMapTypeFirst = $custMapTypeList[0];
}
else
{
    $custMapTypeFirst = 0;
}

$needOverlayControl = 0;

if ((int)$map->overlayopacitycontrol != 0)
{
    if ($needOverlayControl == 0)
    {    
        if ((int)$map->custommaptype != 0)
        {
			if (isset($maptypes) && !empty($maptypes)) {
				foreach ($maptypes as $key => $currentmaptype)     
				{               
                for ($i=0; $i < count($custMapTypeList); $i++)
                {
                    if ($currentmaptype->id == (int)$custMapTypeList[$i]
                    && ($currentmaptype->gettileurl != "") || ($currentmaptype->url_template != ""))
                    {                              
                        if ((int)$currentmaptype->layertype == 1)
                        {
                            if ((int)$currentmaptype->opacitymanage == 1)
                            {
                                $needOverlayControl = 1;
                                break;
                            }
                        }
                    }
                }
            }
			}
		}
    }
    
    if ($needOverlayControl == 0)
    {
    if (isset($paths) && !empty($paths)) 
    {
            foreach ($paths as $key => $currentpath) 
            {
                if ($currentpath->imgurl != ""
                    && $currentpath->imgbounds != "") 
                {
                    if ((int)$currentpath->imgopacitymanage == 1)
                    {
                        $needOverlayControl = 1;
                        break;
                    }
                }
            }
        }    
    }
    
}

if ($needOverlayControl == 0)
{
    if ((int)$map->nztopomaps == 11)
    {
        $needOverlayControl = 1;
    }
}
    
$pathParse = 0;

if (isset($paths) && !empty($paths)) 
{
    foreach ($paths as $key => $currentpath) 
    {
        if ((int)$currentpath->kmllayertype != 0
            && $currentpath->kmllayer != "") 
        {
            if ((int)$currentpath->kmllayertype == 10
                || (int)$currentpath->kmllayertype == 11)
            {
                $pathParse = 1;
                break;
            }
        }
    }
}    

if ($placemarkSearch != 0
    || $groupSearch != 0
    || $managePanelFeature != 0
    )
{
    $wa->registerAndUseStyle('zhosmmaps.jquery-ui',URI::root() .'components/com_zhosmmap/assets/jquery-ui/1.13.2/jquery-ui.min.css');
    $wa->registerAndUseScript('zhosmmaps.jquery-ui',URI::root() .'components/com_zhosmmap/assets/jquery-ui/1.13.2/jquery-ui.min.js');
}


if (isset($map->usermarkers) 
  && ((int)$map->usermarkers == 1
      ||(int)$map->usermarkers == 2)) 
{
        $wa->registerAndUseStyle('zhosmmaps.usermarkers',URI::root() .'components/com_zhosmmap/assets/css/usermarkers.css');
}

if ($pathParse != 0
    )
{
    $wa->registerAndUseScript('zhosmmaps.pathparser',$current_custom_js_path .'pathparser-min.js');
}

// Extra checking - begin



// Extra checking - begin



$fullWidth = 0;
$fullHeight = 0;

// Size Value 
$currentMapWidth ="do not change";
$currentMapHeight ="do not change";

// Map Type Value 
//   add parameter to redefine (passed from plugin)
if (isset($currentMapType) && $currentMapType != "")
{
    $currentMapTypeValue ="";
}
else
{
    $currentMapType ="do not change";
    $currentMapTypeValue ="";
}
        
if ($mapMapWidth != "")
{
    $currentMapWidth = $mapMapWidth;
}

if ($mapMapHeight != "")
{
    $currentMapHeight = $mapMapHeight;
}

if ($map->headerhtml != "")
{
        $divmapheader .= '<div id="OMapInfoHeader'.$mapDivSuffix.'" class="zhom-map-header">'.$map->headerhtml;
        if (isset($map->headersep) && (int)$map->headersep == 1) 
        {
            $divmapheader .= '<hr id="mapHeaderLine" />';
        }
        $divmapheader .= '</div>';
}

if ($map->footerhtml != "")
{
       $divmapfooter .= '<div id="OMapInfoFooter'.$mapDivSuffix.'" class="zhom-map-footer">';
        if (isset($map->footersep) && (int)$map->footersep == 1) 
        {
            $divmapfooter .= '<hr id="mapFooterLine" />';
        }
       $divmapfooter .= $map->footerhtml.'</div>';
}

if ($currentMapWidth == "do not change")
{
    $currentMapWidthValue = (int)$map->width;
}
else
{
    $currentMapWidthValue = (int)$currentMapWidth;
}

if ($currentMapHeight == "do not change")
{
    $currentMapHeightValue = (int)$map->height;
}
else
{
    $currentMapHeightValue = (int)$currentMapHeight;
}


if ((!isset($currentMapWidthValue)) || (isset($currentMapWidthValue) && (int)$currentMapWidthValue < 1)) 
{
    $fullWidth = 1;
}
if ((!isset($currentMapHeightValue)) || (isset($currentMapHeightValue) && (int)$currentMapHeightValue < 1)) 
{
    $fullHeight = 1;
}

        
$hierarchyCategoryGroup = "";
$hierarchyCategoryGroupSep = "";
$hierarchyCategoryGroupCurrentID = 0;
$hierarchyCategoryGroupCurrentParentID = 0;
$hierarchyCategoryGroupRootAdded = 0;

if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0) 
{

        // BEFORE zThee styles, because override padding!
        $wa->registerAndUseStyle('zhosmmaps.markergroups',URI::root() .'components/com_zhosmmap/assets/css/markergroups.css');   
        
        if ((int)$map->markergroupshowicon == 50
         || (int)$map->markergroupshowicon == 51
         || (int)$map->markergroupshowicon == 52
         || (int)$map->markergroupshowicon == 55
        )
        {
            $wa->registerAndUseStyle('zhosmmaps.zTree',$current_custom_js_path.'zTree/3.5.42/css/zTreeStyle/zTreeStyle.css');      
            $wa->registerAndUseScript('zhosmmaps.zTree.core',$current_custom_js_path.'zTree/3.5.42/js/jquery.ztree.core.min.js');
            $wa->registerAndUseScript('zhosmmaps.zTree.excheck',$current_custom_js_path.'zTree/3.5.42/js/jquery.ztree.excheck.min.js');
            $manageGroupCSS = "false";
        }
        else
        {
            $manageGroupCSS = "true";
        }

        
        switch ((int)$map->markergroupcss) 
        {

            case 0:
                $markergroupcssstyle = '-simple';
            break;
            case 1:
                $markergroupcssstyle = '-advanced';
            break;
            case 2:
                $markergroupcssstyle = '-external';
            break;
            default:
                $markergroupcssstyle = '-simple';
            break;
        }


           $divmarkergroup =  '<div id="OMapsMenu'.$markergroupcssstyle.'" class= "zhom-mapsmenu'.$markergroupcssstyle.'" style="margin:0;padding:0;width=100%;">'."\n";
        if ($map->markergrouptitle != "")
        {
            $divmarkergroup .= '<div id="groupList"><h2 id="groupListHeadTitle" class="groupListHead">'.htmlspecialchars($map->markergrouptitle , ENT_QUOTES, 'UTF-8').'</h2></div>';
        }
        
        if ($map->markergroupdesc1 != "")
        {
            $divmarkergroup .= '<div id="groupListBodyTopContent" class="groupListBodyTop">'.$map->markergroupdesc1.'</div>';
        }

        if (isset($map->markergroupsep1) && (int)$map->markergroupsep1 == 1) 
        {
            $divmarkergroup .= '<hr id="groupListLineTop" />';
        }

        if ((int)$map->markergroupshowicon == 50
         || (int)$map->markergroupshowicon == 51
         || (int)$map->markergroupshowicon == 52
         || (int)$map->markergroupshowicon == 55
        )
        {
            if (isset($map->markergroupshowiconall) && ((int)$map->markergroupshowiconall!= 100))
            {
                    $imgimg1 = $imgpathUtils.'checkbox1.png';
                    $imgimg0 = $imgpathUtils.'checkbox0.png';

                    switch ((int)$map->markergroupshowiconall) 
                    {

                            case 0:
                                    $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '</div>'."\n";                                  
                            break;
                            case 1:
                                    $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg1.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" /></div><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg0.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" /></div><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '</div>'."\n";
                            break;
                            case 2:
                                    $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg1.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" /></div></a></div></div>'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg0.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" /></div></a></div></div>'."\n";
                                    $divmarkergroup .= '</div>'."\n";                                   
                            break;
                            default:
                                    $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                    $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                    $divmarkergroup .= '</div>'."\n";                                 
                            break;
                    }
            }
            
            $divmarkergroup .= '<ul id="zhom-menu'.$markergroupcssstyle.'" class="ztree">'."\n";
        }
        else
        {
            $divmarkergroup .= '<ul id="zhom-menu'.$markergroupcssstyle.'" class="zhom-markergroup-group-ul-menu'.$markergroupcssstyle.'">'."\n";
        }
        

        /* 19.02.2013 
           for flexible support group management 
           and have ability to set off placemarks from group managenent 
           markergroups changed to mgrgrouplist
           */

        if ((int)$map->markergroupshowicon != 50
         && (int)$map->markergroupshowicon != 51
         && (int)$map->markergroupshowicon != 52
         && (int)$map->markergroupshowicon != 55
        )
        {
        
            if (isset($mgrgrouplist) && !empty($mgrgrouplist)) 
            {

                    if (isset($map->markergroupshowiconall) && ((int)$map->markergroupshowiconall!= 100))
                    {
                            $imgimg1 = $imgpathUtils.'checkbox1.png';
                            $imgimg0 = $imgpathUtils.'checkbox0.png';

                            switch ((int)$map->markergroupshowiconall) 
                            {

                                    case 0:
                                            $divmarkergroup .= '<li id="li-all" class="zhom-markergroup-group-li-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '</div>'."\n";
                                            if ($groupSearch != 0)
                                            {
                                                $divmarkergroup .= '<div id="zhom-markergroup-search'.$mapDivSuffix.'" class="zhom-markergroup-search'.$markergroupcssstyle.'">'."\n";
                                                $divmarkergroup .= '<input id="OMapsGroupListSearchAutocomplete'.$mapDivSuffix.'"';
                                                $divmarkergroup .= ' placeholder="'.$fv_override_group_title.'"';
                                                $divmarkergroup .='>';                                   
                                                $divmarkergroup .= '</div>'."\n";
                                            }                                                
                                            $divmarkergroup .= '</li>'."\n";
                                    break;
                                    case 1:
                                            $divmarkergroup .= '<li id="li-all" class="zhom-markergroup-group-li-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg1.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" /></div><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg0.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" /></div><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '</div>'."\n";

                                            if ($groupSearch != 0)
                                            {
                                                $divmarkergroup .= '<div id="zhom-markergroup-search'.$mapDivSuffix.'" class="zhom-markergroup-search'.$markergroupcssstyle.'">'."\n";
                                                $divmarkergroup .= '<input id="OMapsGroupListSearchAutocomplete'.$mapDivSuffix.'"';
                                                $divmarkergroup .= ' placeholder="'.$fv_override_group_title.'"';
                                                $divmarkergroup .='>';                                   
                                                $divmarkergroup .= '</div>'."\n";
                                            }

                                            $divmarkergroup .= '</li>'."\n";
                                    break;
                                    case 2:
                                            $divmarkergroup .= '<li id="li-all" class="zhom-markergroup-group-li-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg1.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'" /></div></a></div></div>'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-img-all" class="zhom-markergroup-img-all'.$markergroupcssstyle.'"><img src="'.$imgimg0.'" alt="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" title="'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'" /></div></a></div></div>'."\n";
                                            $divmarkergroup .= '</div>'."\n";
                                            if ($groupSearch != 0)
                                            {
                                                $divmarkergroup .= '<div id="zhom-markergroup-search'.$mapDivSuffix.'" class="zhom-markergroup-search'.$markergroupcssstyle.'">'."\n";
                                                $divmarkergroup .= '<input id="OMapsGroupListSearchAutocomplete'.$mapDivSuffix.'"';
                                                $divmarkergroup .= ' placeholder="'.$fv_override_group_title.'"';
                                                $divmarkergroup .='>';                                   
                                                $divmarkergroup .= '</div>'."\n";
                                            }                                                
                                            $divmarkergroup .= '</li>'."\n";
                                    break;
                                    default:
                                            $divmarkergroup .= '<li id="li-all" class="zhom-markergroup-group-li-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-all" class="zhom-markergroup-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callShowAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_SHOW').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-div-all" class="zhom-markergroup-div-all'.$markergroupcssstyle.'">'."\n";
                                            $divmarkergroup .= '<div id="zhom-markergroup-a-all" class="zhom-markergroup-a-all'.$markergroupcssstyle.'"><a id="a-all" href="#" onclick="callHideAllGroup'.$mapDivSuffix.'();return false;" class="zhom-markergroup-link-all'.$markergroupcssstyle.'"><div id="zhom-markergroup-text-all" class="zhom-markergroup-text-all'.$markergroupcssstyle.'">'.Text::_('COM_ZHOSMMAP_MAP_DETAIL_MARKERGROUPSHOWICONALL_HIDE').'</div></a></div></div>'."\n";
                                            $divmarkergroup .= '</div>'."\n";
                                            if ($groupSearch != 0)
                                            {
                                                $divmarkergroup .= '<div id="zhom-markergroup-search'.$mapDivSuffix.'" class="zhom-markergroup-search'.$markergroupcssstyle.'">'."\n";
                                                $divmarkergroup .= '<input id="OMapsGroupListSearchAutocomplete'.$mapDivSuffix.'"';
                                                $divmarkergroup .= ' placeholder="'.$fv_override_group_title.'"';
                                                $divmarkergroup .='>';                                   
                                                $divmarkergroup .= '</div>'."\n";
                                            }                                                
                                            $divmarkergroup .= '</li>'."\n";
                                    break;
                            }
                    }
                    else
                    {
                        if ($groupSearch != 0)
                        {
                            $divmarkergroup .= '<li id="li-all" class="zhom-markergroup-group-li-all'.$markergroupcssstyle.'">'."\n";
                            $divmarkergroup .= '<div id="zhom-markergroup-search'.$mapDivSuffix.'" class="zhom-markergroup-search'.$markergroupcssstyle.'">'."\n";
                            $divmarkergroup .= '<input id="OMapsGroupListSearchAutocomplete'.$mapDivSuffix.'"';
                            $divmarkergroup .= ' placeholder="'.$fv_override_group_title.'"';
                            $divmarkergroup .='>';                                   
                            $divmarkergroup .= '</div>'."\n";
                            $divmarkergroup .= '</li>'."\n";                    
                        }                                                
                    }


					if (isset($mgrgrouplist) && !empty($mgrgrouplist)) {
						foreach ($mgrgrouplist as $key => $currentmarkergroup) 
						{
								if (((int)$currentmarkergroup->published == 1) || ($allowUserMarker == 1))
								{
										$imgimg = $imgpathIcons.str_replace("#", "%23", $currentmarkergroup->icontype).'.png';

										$markergroupname ='';
										$markergroupname = 'markergroup'. $currentmarkergroup->id;

										$markergroupname_article = 'markergroup'.$mapDivSuffix.'_'. $currentmarkergroup->id;

										if ((int)$currentmarkergroup->activeincluster == 1)
										{
												$markergroupactive = ' active';
										}
										else
										{
												$markergroupactive = '';
										}



										switch ((int)$map->markergroupshowicon) 
										{

												case 0:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-text-'.$markergroupname.'" class="zhom-markergroup-text'.$markergroupcssstyle.'">'.htmlspecialchars($currentmarkergroup->title, ENT_QUOTES, 'UTF-8').'</div></a></div></li>'."\n";
												break;
												case 1:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-img-'.$markergroupname.'" class="zhom-markergroup-img'.$markergroupcssstyle.'"><img src="'.$imgimg.'" alt="" /></div><div id="zhom-markergroup-text-'.$markergroupname.'" class="zhom-markergroup-text'.$markergroupcssstyle.'">'.htmlspecialchars($currentmarkergroup->title, ENT_QUOTES, 'UTF-8').'</div></a></div></li>'."\n";
												break;
												case 2:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-img-'.$markergroupname.'" class="zhom-markergroup-img'.$markergroupcssstyle.'"><img src="'.$imgimg.'" alt="" /></div></a></div></li>'."\n";
												break;

												case 10:
												case 20:
												case 30:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-text-'.$markergroupname.'" class="zhom-markergroup-text'.$markergroupcssstyle.'"><span id="t-'.$markergroupname_article.'" class="zhom-markergroup-link-title'.$markergroupcssstyle.$markergroupactive.'">'.htmlspecialchars(str_replace('\\', '/',$currentmarkergroup->title), ENT_QUOTES, 'UTF-8').'</span>'.'<span id="s-'.$markergroupname_article.'" class="zhom-markergroup-link-span'.$markergroupcssstyle.$markergroupactive.'"></span>'.'</div></a></div></li>'."\n";
												break;
												case 11:
												case 21:
												case 31:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-img-'.$markergroupname.'" class="zhom-markergroup-img'.$markergroupcssstyle.'"><img src="'.$imgimg.'" alt="" /></div><div id="zhom-markergroup-text-'.$markergroupname.'" class="zhom-markergroup-text'.$markergroupcssstyle.'"><span id="t-'.$markergroupname_article.'" class="zhom-markergroup-link-title'.$markergroupcssstyle.$markergroupactive.'">'.htmlspecialchars(str_replace('\\', '/',$currentmarkergroup->title), ENT_QUOTES, 'UTF-8').'</span>'.'<span id="s-'.$markergroupname_article.'" class="zhom-markergroup-link-span'.$markergroupcssstyle.$markergroupactive.'"></span>'.'</div></a></div></li>'."\n";
												break;
												case 12:
												case 22:
												case 32:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-img-'.$markergroupname.'" class="zhom-markergroup-img'.$markergroupcssstyle.'"><img src="'.$imgimg.'" alt="" />'.'<span id="s-'.$markergroupname_article.'" class="zhom-markergroup-link-span'.$markergroupcssstyle.$markergroupactive.'"></span>'.'</div></a></div></li>'."\n";
												break;
												default:
														$divmarkergroup .= '<li id="li-'.$markergroupname.'" class="zhom-markergroup-group-li'.$markergroupcssstyle.'"><div id="zhom-markergroup-a-'.$markergroupname.'" class="zhom-markergroup-a'.$markergroupcssstyle.'"><a id="a-'.$markergroupname_article.'" href="#" onclick="callToggleGroup'.$mapDivSuffix.'('.$currentmarkergroup->id.');return false;" class="zhom-markergroup-link'.$markergroupcssstyle.$markergroupactive.'"><div id="zhom-markergroup-text-'.$markergroupname.'" class="zhom-markergroup-text'.$markergroupcssstyle.'">'.htmlspecialchars($currentmarkergroup->title, ENT_QUOTES, 'UTF-8').'</div></a></div></li>'."\n";
												break;
										}


								}
						 }
				
					}
			}

        }
        else
        {
            // because checkboxes          
            $map->markergrouptype = 0;
            if (isset($mgrgrouplist) && !empty($mgrgrouplist)) 
            {
                $group_list_to_hierarchy = "";
                
                foreach ($mgrgrouplist as $key => $currentmarkergroup) 
                {
                    
                    if (((int)$currentmarkergroup->published == 1) || ($allowUserMarker == 1))
                    {
                            
                        if ((int)$currentmarkergroup->activeincluster == 1)
                        {
                            $hierarchyCategoryGroupActive = ", checked:true";
                            $hierarchyCategoryGroupState = ", zhomActionNodeState:true";
                        }
                        else
                        {
                            $hierarchyCategoryGroupActive = "";
                            $hierarchyCategoryGroupState = ", zhomActionNodeState:false";
                        }
                       
                        $imgimg = $imgpathIcons.str_replace("#", "%23", $currentmarkergroup->icontype).'.png';
                        
                        if ((int)$map->markergroupshowicon == 50)
                        {
                            $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->category).'"';
                            $hierarchyCategoryGroupGroup = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->title).'"';
                        }
                        elseif ((int)$map->markergroupshowicon == 51)
                        {
                            $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->category).'"';
                            $hierarchyCategoryGroupGroup = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->title).'", icon:"'.$imgimg.'"';
                        }
                        elseif ((int)$map->markergroupshowicon == 52)
                        {
                            $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->category).'"';
                            $hierarchyCategoryGroupGroup = ', name:"", icon:"'.$imgimg.'"';
                        }
                        elseif ((int)$map->markergroupshowicon == 55)
                        {
                            // where to get icon, then set variable and allow value in admin form
                            $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->category).'", icon:""';
                            $hierarchyCategoryGroupGroup = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->title).'"';
                        }
                        else
                        {
                            $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->category).'"';
                            $hierarchyCategoryGroupGroup = ', name:"'.str_replace("\"", "\\\"", $currentmarkergroup->title).'"';
                        }
         
                        // add category
                        if (($hierarchyCategoryGroupCurrentID == 0 && $hierarchyCategoryGroupRootAdded == 0) || $hierarchyCategoryGroupCurrentID != (int)$currentmarkergroup->catid)
                        {
                            if ($hierarchyCategoryGroupCurrentID == 0)
                            {
                                $hierarchyCategoryGroupRootAdded = 1;
                            }
                            $hierarchyCategoryGroupCurrentID = (int)$currentmarkergroup->catid;   
                            
                            $hierarchyCategoryExpand = "";
                            if ($fv_override_category_ex_hierarchy == 10)
                            {
                                $hierarchyCategoryExpand = ", open:true";
                            }
                            $hierarchyCategoryGroup .= $hierarchyCategoryGroupSep . '{ id:'.(int)$currentmarkergroup->catid.', pId:'.(int)$currentmarkergroup->catcatid.''.$hierarchyCategoryGroupCategory.$hierarchyCategoryGroupActive.$hierarchyCategoryExpand.'}'."\n";

                            $group_list_to_hierarchy .= $hierarchyCategoryGroupSep . (int)$currentmarkergroup->catcatid;
                            if ($hierarchyCategoryGroupSep == "")
                            {
                                $hierarchyCategoryGroupSep = ",";
                            }
                            
                        }

                        // add group
                        $hierarchyCategoryGroup .= $hierarchyCategoryGroupSep . '{ id:'.(-1*(int)$currentmarkergroup->id).', pId:'.(int)$currentmarkergroup->catid.$hierarchyCategoryGroupGroup.$hierarchyCategoryGroupActive.$hierarchyCategoryGroupState.'}'."\n";
                      
                        if ($hierarchyCategoryGroupSep == "")
                        {
                            $hierarchyCategoryGroupSep = ",";
                        }
                            
                    }
                }
                
                if ($group_list_to_hierarchy != "")
                {
                    $hierarchyCategoryGroup .= MapGroupsHelper::get_CategoryHierarchy($group_list_to_hierarchy, $fv_override_category_hierarchy, $fv_override_category_ex_hierarchy, -1, -1);
                }
            }
        }
        

        $divmarkergroup .= '</ul>'."\n";
                
        if (isset($map->markergroupsep2) && (int)$map->markergroupsep2 == 1) 
        {
            $divmarkergroup .= '<hr id="groupListLineBottom" />';
        }
        
        if ($map->markergroupdesc2 != "")
        {
            $divmarkergroup .= '<div id="groupListBodyBottomContent" class="groupListBodyBottom">'.$map->markergroupdesc2.'</div>';
        }
        
        $divmarkergroup .= '</div>'."\n";

 }



$zhomObjectManager = 0;
$ajaxLoadContent = 0;
$ajaxLoadScripts = 0;
$zhomK2Manager = 0;

$ajaxLoadObjects = (int)$map->useajaxobject;

$ajaxLoadObjectType = (int)$map->ajaxgetplacemark;


if (
 (isset($map->useajax) && ((int)$map->useajax !=0))
 || 
 (isset($map->placemark_rating) && ((int)$map->placemark_rating != 0))
)
{
    $ajaxLoadContent = 1;
}

if ($ajaxLoadObjects != 0)
{
    $ajaxLoadScripts = 1;
}

if (  ($ajaxLoadObjects != 0)
   || ($ajaxLoadContent != 0)
   || ($placemarkSearch != 0)
   || ($groupSearch != 0)
   || ($needOverlayControl != 0)
   || ($managePanelFeature != 0)
   || ($layersButtons != 0)
   || ($pathParse != 0)
   || (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
   || (isset($map->markermanager) && (int)$map->markermanager == 1)
   || (isset($map->markercluster) && (int)$map->markercluster == 1)
   //|| (isset($map->mapbounds) && $map->mapbounds != "") - map properties
   //|| (isset($map->hovermarker) && ((int)$map->hovermarker !=0))
   )
{
    $zhomObjectManager = 1;
}

if (isset($allowK2Manager) && $allowK2Manager) 
{
    $zhomK2Manager = 1;    
}



$wa->registerAndUseScript('zhosmmaps.common',$current_custom_js_path.'common-min.js');

if (isset($compatiblemode) && (int)$compatiblemode == 1)
{
    $wa->registerAndUseScript('zhosmmaps.compatibility',$current_custom_js_path.'compatibility-min.js');
}


//$mainScriptBegin = $current_custom_js_path . 'leaflet/';
$mainScriptBegin = "https://unpkg.com/leaflet";

$mainScriptMiddle = "";

$mainScriptEnd = "/dist/leaflet";

if (isset($useObjectStructure) && (int)$useObjectStructure == 1){
	if ($this->mapapiversion != "")
	{
		$mainScriptMiddle = $this->mapapiversion;
	}
	 else 
	{
		$mainScriptMiddle = '1.9.3';
	}
} else {
	if ($mapapiversion != "")
	{
		$mainScriptMiddle = $mapapiversion;
	}
	 else 
	{
		$mainScriptMiddle = '1.9.3';
	}

}

$mainScriptMiddle = "@" . $mainScriptMiddle;


$mainScriptBegin .= $mainScriptMiddle;


$mainScript = $mainScriptBegin . $mainScriptEnd;

$wa->registerAndUseStyle('zhosmmaps.main-css',$mainScript . '.css');
$wa->registerAndUseScript('zhosmmaps.main-script',$mainScript . '.js');


// allow loading animation everytime, because animation can enabled for definite center placemark, or for any placemark by definition, or by placemark list
//$wa->registerAndUseScript('zhosmmaps.smoothmarkerbouncing',$current_custom_js_path.'smoothmarkerbouncing/1.2.0/leaflet.smoothmarkerbouncing.js');
$wa->registerAndUseScript('zhosmmaps.smoothmarkerbouncing',$current_custom_js_path.'smoothmarkerbouncing/2.0.1/bundle.min.js');

$wa->registerAndUseScript('zhosmmaps.omnivore',$current_custom_js_path.'omnivore/0.3.1/leaflet-omnivore.min.js');


if ((int)$map->fullscreencontrol != 0)
{
    $wa->registerAndUseStyle('zhosmmaps.fullscreen',URI::root() .'components/com_zhosmmap/assets/js/fullscreen/2.4.0/Control.FullScreen.css');
    $wa->registerAndUseScript('zhosmmaps.fullscreen',URI::root() .'components/com_zhosmmap/assets/js/fullscreen/2.4.0/Control.FullScreen.js');
}
    

if ($zhomObjectManager != 0)
{
        if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
        {
            $this->use_object_manager = 1;
        }
        else
        {
            $use_object_manager = 1;
        }
}


$divmap = "";


if ((int)$map->routedriving == 2
   || ((int)$map->routewalking == 0 
    && (int)$map->routetransit == 0
    && (int)$map->routebicycling == 0))
{
    $routeSelectedDriving = ' selected="selected"';
    $routeSelectedWalking = '';
    $routeSelectedTransit = '';
    $routeSelectedBicycling = '';
}
else
{
    if ((int)$map->routedriving == 2)
    {
        $routeSelectedDriving = ' selected="selected"';
        $routeSelectedWalking = '';
        $routeSelectedTransit = '';
        $routeSelectedBicycling = '';
    }
    else if ((int)$map->routewalking == 2)
    {
        $routeSelectedDriving = '';
        $routeSelectedWalking = ' selected="selected"';
        $routeSelectedTransit = '';
        $routeSelectedBicycling = '';
    }
    else if ((int)$map->routetransit == 2)
    {
        $routeSelectedDriving = '';
        $routeSelectedWalking = '';
        $routeSelectedTransit = ' selected="selected"';
        $routeSelectedBicycling = '';
    }
    else if ((int)$map->routebicycling == 2)
    {
        $routeSelectedDriving = '';
        $routeSelectedWalking = '';
        $routeSelectedTransit = '';
        $routeSelectedBicycling = ' selected="selected"';
    }
    else
    {
        if ((int)$map->routedriving != 0)
        {
            $routeSelectedDriving = ' selected="selected"';
            $routeSelectedWalking = '';
            $routeSelectedTransit = '';
            $routeSelectedBicycling = '';
        }
        else if ((int)$map->routewalking != 0)
        {
            $routeSelectedDriving = '';
            $routeSelectedWalking = ' selected="selected"';
            $routeSelectedTransit = '';
            $routeSelectedBicycling = '';
        }
        else if ((int)$map->routetransit != 0)
        {
            $routeSelectedDriving = '';
            $routeSelectedWalking = '';
            $routeSelectedTransit = ' selected="selected"';
            $routeSelectedBicycling = '';
        }
        else if ((int)$map->routebicycling != 0)
        {
            $routeSelectedDriving = '';
            $routeSelectedWalking = '';
            $routeSelectedTransit = '';
            $routeSelectedBicycling = ' selected="selected"';
        }
        else
        {
            $routeSelectedDriving = '';
            $routeSelectedWalking = '';
            $routeSelectedTransit = '';
            $routeSelectedBicycling = '';
        }
    }
}


    $divmapbefore = "";
    $divmapafter = "";


    $service_DoDirection = 0;

    $doShowDivFind = 0;

    $divwrapmapstyle = '';
    $divtabcolmapstyle = '';
    
    if ($fullWidth == 1)
    {
        $divwrapmapstyle .= 'width:100%;';
    }
    if ($fullHeight == 1)
    {
        $divwrapmapstyle .= 'height:100%;';
        $divtabcolmapstyle .= 'height:100%;';
    }
    if ($divwrapmapstyle != "")
    {
        $divwrapmapstyle = 'style="'.$divwrapmapstyle.'"';
    }
    if ($divtabcolmapstyle != "")
    {
        $divtabcolmapstyle = 'style="'.$divtabcolmapstyle.'"';
    }

// adding markerlist (div)
$markerlistcssstyle = '';
if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
{

    $wa->registerAndUseStyle('zhosmmaps.markerlists',URI::root() .'components/com_zhosmmap/assets/css/markerlists.css');
    
    
    switch ((int)$map->markerlist) 
    {
        
        case 0:
            $markerlistcssstyle = 'markerList-simple';
        break;
        case 1:
            $markerlistcssstyle = 'markerList-advanced';
        break;
        case 2:
            $markerlistcssstyle = 'markerList-external';
        break;
        default:
            $markerlistcssstyle = 'markerList-simple';
        break;
    }


    $markerlistAddStyle ='';
    
    if ($map->markerlistbgcolor != "")
    {
        $markerlistAddStyle .= ' background: '.$map->markerlistbgcolor.';';
    }
    
    if ((int)$map->markerlistwidth == 0)
    {
        if ((int)$map->markerlistpos == 113
          ||(int)$map->markerlistpos == 114
          ||(int)$map->markerlistpos == 120
          ||(int)$map->markerlistpos == 121)
        {
            $divMarkerlistWidth = '100%';
        }
        else
        {
            $divMarkerlistWidth = '200px';
        }
    }
    else
    {
        $divMarkerlistWidth = $map->markerlistwidth;
        $divMarkerlistWidth = $divMarkerlistWidth. 'px';
    }


    if ((int)$map->markerlistpos == 111
      ||(int)$map->markerlistpos == 112)
    {
        if ($fullHeight == 1)
        {
            $divMarkerlistHeight = '100%';
        }
        else
        {
            $divMarkerlistHeight = $currentMapHeightValue;
            $divMarkerlistHeight = $divMarkerlistHeight. 'px';
        }
    }
    else
    {
        if ((int)$map->markerlistheight == 0)
        {
            $divMarkerlistHeight = 200;
        }
        else
        {
            $divMarkerlistHeight = $map->markerlistheight;
        }
        $divMarkerlistHeight = $divMarkerlistHeight. 'px';
    }        

    
    if ((int)$map->markerlistcontent < 100) 
    {
        $markerlisttag = '<div id="OMapsMarkerListMain" '.$mapDivSuffix.' class="zhom-listmain-ul-'.$markerlistcssstyle.'">';
        $markerlisttag .= '<ul id="OMapsMarkerUL'.$mapDivSuffix.'" class="zhom-ul-'.$markerlistcssstyle.'"></ul>';
        $markerlisttag .= '</div>';
    }
    else 
    {
        $markerlisttag = '<div id="OMapsMarkerListMain" '.$mapDivSuffix.' class="zhom-listmain-table-'.$markerlistcssstyle.'">';
        $markerlisttag .=  '<table id="OMapsMarkerTABLE'.$mapDivSuffix.'" class="zhom-ul-table-'.$markerlistcssstyle.'" ';
        if (((int)$map->markerlistpos == 113) 
        || ((int)$map->markerlistpos == 114) 
        || ((int)$map->markerlistpos == 120) 
        || ((int)$map->markerlistpos == 121))
        {
            if ($fullWidth == 1) 
            {
                $markerlisttag .= 'style="width:100%;" ';
            }
        }
        $markerlisttag .= '>';
        $markerlisttag .= '<tbody id="OMapsMarkerTABLEBODY'.$mapDivSuffix.'" class="zhom-ul-tablebody-'.$markerlistcssstyle.'">';
        $markerlisttag .= '</tbody>';
        $markerlisttag .= '</table>';
        $markerlisttag .= '</div>';
    }

    if ($placemarkSearch != 0)
    {
        if ((int)$map->markerlistpos == 120)
        {
            $markerlistsearch = '<div id="OMapsMarkerListSearch" '.$mapDivSuffix.' class="zhom-search-panel-'.$markerlistcssstyle.'"';
        }
        else
        {
            $markerlistsearch = '<div id="OMapsMarkerListSearch" '.$mapDivSuffix.' class="zhom-search-'.$markerlistcssstyle.'"';
        }

        $markerlistsearch .='>';
        $markerlistsearch .= '<input id="OMapsMarkerListSearchAutocomplete'.$mapDivSuffix.'"';
        $markerlistsearch .= ' placeholder="'.$fv_override_placemark_title.'"';
        $markerlistsearch .='>';
        $markerlistsearch .= '</div>';
    }
    else
    {
        $markerlistsearch = "";
    }
    
    // Add Placemark Search 
    $markerlisttag = $markerlistsearch . $markerlisttag;

    if (isset($map->markerlistpos) && (int)$map->markerlistpos == 120) 
    {
        $markerlistPanel = '';
    }    
    
    switch ((int)$map->markerlistpos) 
    {
        case 0:
            // None
        break;
        case 1:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 2:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 3:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 4:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 5:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 6:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 7:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 8:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 9:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 10:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 11:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 12:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 5px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 111:
            if ($fullWidth == 1) 
            {
                if ($fullHeight == 1) 
                {
                    $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" style="width:100%; height:100%;" >';
                }
                else
                {
                    $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" style="width:100%;" >';
                }
            }
            else
            {
                $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" >';
            }
            $divmap .= '<tbody>';
            if ($fullHeight == 1) 
            {
                $divmap .= '<tr style="height:100%;">';
            }
            else
            {
                $divmap .= '<tr>';
            }
            $divmap .= '<td style="width:'.$divMarkerlistWidth.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' float: left; padding: 0; margin: 0 10px 0 0; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
            $divmap .= '</td>';
            $divmap .= '<td>';
        break;
        case 112:
            if ($fullWidth == 1) 
            {
                if ($fullHeight == 1) 
                {
                    $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" style="width:100%; height:100%;" >';
                }
                else
                {
                    $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" style="width:100%;" >';
                }
            }
            else
            {
                $divmap .= '<table id="OMMapTable'.$mapDivSuffix.'" class="zhom-table-'.$markerlistcssstyle.'" >';
            }
            $divmap .= '<tbody>';
            if ($fullHeight == 1) 
            {
                $divmap .= '<tr style="height:100%;">';
            }
            else
            {
                $divmap .= '<tr>';
            }
            $divmap .= '<td>';
        break;
        case 113:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'" >';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 0; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
        break;
        case 114:
            $divmap .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-'.$markerlistcssstyle.'" >';
        break;
        case 120:
            // no height
            // new classes
            $markerlistPanel .= '<div id="OMMapWrapper" '.$divwrapmapstyle.' class="zhom-wrap-panel-'.$markerlistcssstyle.'">';
            $markerlistPanel .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-panel-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 0px; width: 100%;">'.$markerlisttag.'</div>';
            $markerlistPanel .='</div>';
        break;
        case 121:
        break;
        default:
        break;
    }

    
}



// SIZE - begin
$mainMapDivContentSize = '';
$mainPanelWrapDivContentSize = '';
$managePanelContentHeight = '';

if ($fullWidth == 1)
{
    if ($fullHeight == 1) 
    {

                if ($managePanelFeature == 1)
                {
                    $mainMapDivContentSize .= 'width:100%;height:100%;';
                    $mainPanelWrapDivContentSize = 'width:100%;height:100%;';
                    $managePanelContentHeight = '100%';
                }
                else
                {
                    $mainMapDivContentSize .= 'width:100%;height:100%;';
                }


    }
    else
    {

                if ($managePanelFeature == 1)
                {
                    $mainMapDivContentSize .= 'width:100%;height:'.$currentMapHeightValue.'px;';
                    $mainPanelWrapDivContentSize = 'width:100%;height:'.$currentMapHeightValue.'px;';
                    $managePanelContentHeight = $currentMapHeightValue.'px';
                }
                else
                {
                    $mainMapDivContentSize .= 'width:100%;height:'.$currentMapHeightValue.'px;';
                }


    }        
}
else
{
    if ($fullHeight == 1) 
    {

                if ($managePanelFeature == 1)
                {
                    $mainMapDivContentSize .= 'width:'.$currentMapWidthValue.'px;height:100%;';    
                    $mainPanelWrapDivContentSize = 'width:'.$currentMapWidthValue.'px;height:100%;';
                    $managePanelContentHeight = '100%';
                }
                else
                {
                    $mainMapDivContentSize .= 'width:'.$currentMapWidthValue.'px;height:100%;';    
                }                    


    }
    else
    {

                if ($managePanelFeature == 1)
                {
                    $mainMapDivContentSize .= 'width:'.$currentMapWidthValue.'px;height:'.$currentMapHeightValue.'px;';
                    $mainPanelWrapDivContentSize = 'width:'.$currentMapWidthValue.'px;height:'.$currentMapHeightValue.'px;';
                    $managePanelContentHeight = $currentMapHeightValue.'px';
                }
                else
                {
                    $mainMapDivContentSize .= 'width:'.$currentMapWidthValue.'px;height:'.$currentMapHeightValue.'px;';
                }


    }        
}     
// SIZE - end


$mapDivCSSStyle = 'margin:0;padding:0;';
$mapDivCSSStyle0 = $mapDivCSSStyle;

$mapDivCSSClassName = ' class="zhom-map-default"';
$mapPANWDivCSSClassName = ' class="zhom-map-mainpanel-wrap-default"';
$mapPANDivCSSClassName = ' class="zhom-map-mainpanel-default"';

if (isset($map->cssclassname) && ($map->cssclassname != ""))
{
    $mapDivCSSClassName = ' class="'.$map->cssclassname . $cssClassSuffix . '"';
}
else
{
    if (isset($cssClassSuffix) && ($cssClassSuffix != ""))
    {
        $mapDivCSSClassName = ' class="'. $cssClassSuffix . '"';
    }
}

$managePanelContent = '';

if ($managePanelFeature == 1)
{
    if (isset($map->panelwidth) && (int)$map->panelwidth != 0)
    {
        $managePanelContentWidth = (int)$map->panelwidth;
    }
    else
    {
        $managePanelContentWidth = '300';
    }
    


    //$managePanelContent = '<p>Hello world</p>';
    
    $managePanelContent .= '<div id="OMapsPanel'.$mapDivSuffix.'" style="overflow:auto; height:'.$managePanelContentHeight.';">';
    $managePanelContent .= '  <ul>';
    if ($managePanelInfowin == 1)    
    {
        $managePanelContent .= '    <li><a href="#OMapsPanel'.$mapDivSuffix.'tabs-1">'.$fv_override_panel_detail_title.'</a></li>';
    }
    

    if (isset($map->markerlistpos) && (int)$map->markerlistpos == 120) 
    {
        $managePanelContent .= '    <li><a href="#OMapsPanel'.$mapDivSuffix.'tabs-2">'.$fv_override_panel_placemarklist_title.'</a></li>';
    }

    if (1==2) 
    {
        $managePanelContent .= '    <li><a href="#OMapsPanel'.$mapDivSuffix.'tabs-3">'.$fv_override_panel_route_title.'</a></li>';
    }

    if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol == 120) 
    {
        $managePanelContent .= '    <li><a href="#OMapsPanel'.$mapDivSuffix.'tabs-5">'.$fv_override_panel_group_title.'</a></li>';
    }
    
    $managePanelContent .= '  </ul>';
    if ($managePanelInfowin == 1)    
    {
        $managePanelContent .= '  <div id="OMapsPanel'.$mapDivSuffix.'tabs-1">';
        $managePanelContent .= '  </div>';
    }

    if (isset($map->markerlistpos) && (int)$map->markerlistpos == 120) 
    {
        $managePanelContent .= '  <div id="OMapsPanel'.$mapDivSuffix.'tabs-2">';
        $managePanelContent .= $markerlistPanel;
        $managePanelContent .= '  </div>';
    }

    if (1==2) 
    {
        $routePanel ='';
        $managePanelContent .= '  <div id="OMapsPanel'.$mapDivSuffix.'tabs-3">';
        $managePanelContent .= $routePanel;
        $managePanelContent .= '  </div>';
    }    
    
    if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol == 120) 
    {
        $managePanelContent .= '  <div id="OMapsPanel'.$mapDivSuffix.'tabs-5">';
        $managePanelContent .= $divmarkergroup;
        $managePanelContent .= '  </div>';
    }
    
    $managePanelContent .= '</div>';

}
else
{
    $managePanelContentWidth = 0;
}

if ($managePanelFeature == 1)
{
    $managePanelWrapBegin = '<div id="OMapsMainPanelWrap'.$mapDivSuffix.'" '.$mapPANWDivCSSClassName.' style="'.$mapDivCSSStyle;
        $managePanelWrapBegin .= $mainPanelWrapDivContentSize;
        $managePanelWrapBegin .= '">';
    $managePanelDiv = '';
    $managePanelWrapEnd = '</div>';
    $mapDivCSSStyle .= 'display:inline-block;';
}
else
{
    $managePanelWrapBegin = '';
    $managePanelDiv = '';
    $managePanelWrapEnd = '';
}
	$mapEleDivCSSClassName = ' class="zhom-path-elevation"';
	
if ($fullWidth == 1) 
{
    if ($fullHeight == 1) 
    {

            $divmap .= $managePanelWrapBegin;
            $divmap .= '<div id="OMapsID'.$mapDivSuffix.'" '.$mapDivCSSClassName.' style="'.$mapDivCSSStyle.$mainMapDivContentSize.'"></div>';
                    
            $managePanelDiv = MapDivsHelper::get_MapPanelDIV(
                                    $managePanelFeature,
                                    $managePanelContentHeight,
                                    $managePanelContentWidth.'px',
                                    $mapDivSuffix,
                                    $mapPANDivCSSClassName,
                                    $managePanelContent);
                                    
            $divmap .= $managePanelDiv;

			if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0) {
				$divmap .= '<div id="OMapsElevation'.$mapDivSuffix.'"'.$mapEleDivCSSClassName.'></div>';
			}

            $divmap .= $managePanelWrapEnd;
        
    }
    else
    {

            $divmap .= $managePanelWrapBegin;
            $divmap .= '<div id="OMapsID'.$mapDivSuffix.'" '.$mapDivCSSClassName.' style="'.$mapDivCSSStyle.$mainMapDivContentSize.'"></div>';

            $managePanelDiv = MapDivsHelper::get_MapPanelDIV(
                                    $managePanelFeature,
                                    $managePanelContentHeight,
                                    $managePanelContentWidth.'px',
                                    $mapDivSuffix,
                                    $mapPANDivCSSClassName,
                                    $managePanelContent);
                                    
            $divmap .= $managePanelDiv;

			if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0) {
				$divmap .= '<div id="OMapsElevation'.$mapDivSuffix.'"'.$mapEleDivCSSClassName.'></div>';
			}

            $divmap .= $managePanelWrapEnd;

    }        
}
else
{
    if ($fullHeight == 1) 
    {

            $divmap .= $managePanelWrapBegin;
            $divmap .= '<div id="OMapsID'.$mapDivSuffix.'" '.$mapDivCSSClassName.' style="'.$mapDivCSSStyle.$mainMapDivContentSize.'"></div>';    

            $managePanelDiv = MapDivsHelper::get_MapPanelDIV(
                                    $managePanelFeature,
                                    $managePanelContentHeight,
                                    $managePanelContentWidth.'px',
                                    $mapDivSuffix,
                                    $mapPANDivCSSClassName,
                                    $managePanelContent);
                                            
            $divmap .= $managePanelDiv;

			if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0) {
				$divmap .= '<div id="OMapsElevation'.$mapDivSuffix.'"'.$mapEleDivCSSClassName.'></div>';
			}

            $divmap .= $managePanelWrapEnd;

    }
    else
    {

            $divmap .= $managePanelWrapBegin;
            $divmap .= '<div id="OMapsID'.$mapDivSuffix.'" '.$mapDivCSSClassName.' style="'.$mapDivCSSStyle.$mainMapDivContentSize.'"></div>';

            $managePanelDiv = MapDivsHelper::get_MapPanelDIV(
                                    $managePanelFeature,
                                    $managePanelContentHeight,
                                    $managePanelContentWidth.'px',
                                    $mapDivSuffix,
                                    $mapPANDivCSSClassName,
                                    $managePanelContent);
                                            
            $divmap .= $managePanelDiv;

			if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0) {
				$divmap .= '<div id="OMapsElevation'.$mapDivSuffix.'"'.$mapEleDivCSSClassName.'></div>';
			}

            $divmap .= $managePanelWrapEnd;

    }        
}

// adding markerlist (close div)
if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
{

    switch ((int)$map->markerlistpos) 
    {
        case 0:
            // None
        break;
        case 1:
            $divmap .='</div>';
        break;
        case 2:
            $divmap .='</div>';
        break;
        case 3:
            $divmap .='</div>';
        break;
        case 4:
            $divmap .='</div>';
        break;
        case 5:
            $divmap .='</div>';
        break;
        case 6:
            $divmap .='</div>';
        break;
        case 7:
            $divmap .='</div>';
        break;
        case 8:
            $divmap .='</div>';
        break;
        case 9:
            $divmap .='</div>';
        break;
        case 10:
            $divmap .='</div>';
        break;
        case 11:
            $divmap .='</div>';
        break;
        case 12:
            $divmap .='</div>';
        break;
        case 111:
            $divmap .= '</td>';
            $divmap .= '</tr>';
            $divmap .= '</tbody>';
            $divmap .='</table>';
        break;
        case 112:
            $divmap .= '</td>';
            $divmap .= '<td style="width:'.$divMarkerlistWidth.'">';
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' float: left; padding: 0; margin: 0 0 0 10px; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
            $divmap .= '</td>';
            $divmap .= '</tr>';
            $divmap .= '</tbody>';
            $divmap .='</table>';
        break;
        case 113:
            $divmap .='</div>';
        break;
        case 114:
            $divmap .='<div id="OMapsMarkerList'.$mapDivSuffix.'" class="zhom-list-'.$markerlistcssstyle.'" style="'.$markerlistAddStyle.' display: none; float: left; padding: 0; margin: 0; width:'.$divMarkerlistWidth.'; height:'.$divMarkerlistHeight.';">'.$markerlisttag.'</div>';
            $divmap .='</div>';
        break;
        case 120:
        break;        
        case 121:
        break;
        default:
        break;
    }


}

        
$divmap .= '<div id="OMapsCredit'.$mapDivSuffix.'" class="zhom-credit"></div>';

$divmap .= '<div id="OMapsLoading'.$mapDivSuffix.'" style="display: none;" ><img class="zhom-image-loading" src="'.$imgpathUtils.'loading.gif" alt="'.Text::_('COM_ZHOSMMAP_MAP_LOADING').'" /></div>';

$scripthead .= $divmapheader . $currentUserInfo;

// adding route panel in any case
$divmap4route = '<div id="OMapsMainRoutePanel'.$mapDivSuffix.'" class="zhom-map-route-main"><div id="OMapsMainRoutePanel_Total'.$mapDivSuffix.'" class="zhom-map-route-main-total"></div></div>';
$divmap4route .= '<div id="OMapsRoutePanel'.$mapDivSuffix.'" class="zhom-map-route"><div id="OMapsRoutePanel_Description'.$mapDivSuffix.'" class="zhom-map-route-description"></div><div id="OMapsRoutePanel_Total'.$mapDivSuffix.'" class="zhom-map-route-total"></div></div>';



// adding before and after sections
$divmap = $divmapbefore . $divmap . $divmapafter;


$divTabDivMain = '';

if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0) 
{
    switch ((int)$map->markergroupcontrol) 
    {
        
        case 1:
               if ($fullWidth == 1) 
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
                  $divTabDivMain .=  '<tr align="left" >';
                  if ((int)$map->markergroupwidth != 0)
                  {
                      $divTabDivMain .=  '<td valign="top" width="'.(int)$map->markergroupwidth.'%">';
                  }
                  else
                  {
                      $divTabDivMain .=  '<td valign="top" width="20%">';
                  }
                     $divTabDivMain .=  $divmarkergroup;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
                  $divTabDivMain .=  $divmap;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '</tr>';
               }
               else
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
                  $divTabDivMain .=  '<tr>';
                  $divTabDivMain .=  '<td valign="top">';
                  $divTabDivMain .=  $divmarkergroup;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
                  $divTabDivMain .=  $divmap;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '</tr>';
                       }
               $divTabDivMain .=  '</table>';
        break;
        case 2:
               if ($fullWidth == 1) 
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
               }
               else
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
               }
               $divTabDivMain .=  '<tr>';
               $divTabDivMain .=  '<td valign="top">';
               $divTabDivMain .=  $divmarkergroup;
               $divTabDivMain .=  '</td>';
               $divTabDivMain .=  '</tr>';
               $divTabDivMain .=  '<tr>';
               $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
               $divTabDivMain .=  $divmap;
               $divTabDivMain .=  '</td>';
               $divTabDivMain .=  '</tr>';
               $divTabDivMain .=  '</table>';

        break;
        case 3:
               if ($fullWidth == 1) 
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'">';
                  $divTabDivMain .=  '<tr>';
                  $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
                  $divTabDivMain .=  $divmap;
                  $divTabDivMain .=  '</td>';
                  if ((int)$map->markergroupwidth != 0)
                  {
                      $divTabDivMain .=  '<td valign="top" width="'.(int)$map->markergroupwidth.'%">';
                  }
                  else
                  {
                      $divTabDivMain .=  '<td valign="top" width="20%">';
                  }
                  $divTabDivMain .=  $divmarkergroup;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '</tr>';
               }
               else
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
                  $divTabDivMain .=  '<tr>';
                  $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
                  $divTabDivMain .=  $divmap;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '<td valign="top">';
                  $divTabDivMain .=  $divmarkergroup;
                  $divTabDivMain .=  '</td>';
                  $divTabDivMain .=  '</tr>';
               }
               $divTabDivMain .=  '</table>';

        break;
        case 4:
               if ($fullWidth == 1) 
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
               }
               else
               {
                  $divTabDivMain .=  '<table class="zhom-group-manage" '.$divwrapmapstyle.'>';
               }
               $divTabDivMain .=  '<tr>';
               $divTabDivMain .=  '<td '.$divtabcolmapstyle.'>';
               $divTabDivMain .=  $divmap;
               $divTabDivMain .=  '</td>';
               $divTabDivMain .=  '</tr>';
               $divTabDivMain .=  '<tr>';
               $divTabDivMain .=  '<td valign="top">';
               $divTabDivMain .=  $divmarkergroup;
               $divTabDivMain .=  '</td>';
               $divTabDivMain .=  '</tr>';
               $divTabDivMain .=  '</table>';
        break;
        case 5:
               $divTabDivMain .=  '<div id="zhom-wrapper" '.$divwrapmapstyle.'>';
               $divTabDivMain .=  $divmarkergroup;
               $divTabDivMain .=  $divmap;
               $divTabDivMain .=  '</div>';
        break;
        case 6:
               $divTabDivMain .=  '<div id="zhom-wrapper" '.$divwrapmapstyle.'>';
               $divTabDivMain .=  $divmap;
               $divTabDivMain .=  $divmarkergroup;
               $divTabDivMain .=  '</div>';
        break;
        case 10:
               $divTabDivMain .=  $divmap;
        break;
        case 120:
               $divTabDivMain .=  $divmap;
        break;
        default:
            $divTabDivMain .=  $divmap;
        break;
    }


        $scripthead .= $divTabDivMain;
    
}
else
{
        $scripthead .= $divmap;
}



    $scripthead .= $divmapfooter. $divmap4route;

if (isset($MapXdoLoad) && ((int)$MapXdoLoad == 0))
{
    if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
    {
        // all save at the end    
    }
    else if (isset($useObjectStructure) && (int)$useObjectStructure == 2)
    {
        // for module case
        echo $scripthead;
    }
    else
    {
    }
}
else
{
    echo $scripthead;
}    
    
$scripttext = '';
$scripttextBegin = '';
$scripttextEnd = '';


//Script begin
$scripttextBegin .= '<script type="text/javascript" >/*<![CDATA[*/' ."\n";


    // Global variable scope (for access from all functions)

    $scripttext .= 'var map'.$mapDivSuffix.', popup'.$mapDivSuffix.';' ."\n";


   $geocoder = 0;
    if (isset($map->geocoder) && ((int)$map->geocoder !=0))
    {
        $geocoder = (int)$map->geocoder;
        $scripttext .= 'var geocoder'.$mapDivSuffix.';' ."\n";
    }
    if (isset($map->geolocationcontrol) && ((int)$map->geolocationcontrol !=0))
    {
        $scripttext .= 'var geolocation'.$mapDivSuffix.';' ."\n";
    }

        
    if ($zhomObjectManager != 0)
    {
        $scripttext .= 'var zhomObjMgr'.$mapDivSuffix.';' ."\n";
    }
    
    if ($zhomK2Manager != 0) 
    {
        $scripttext .= 'var zhomK2Mgr'.$mapDivSuffix.';' ."\n";
    }
    

    
    $scripttext .= 'var latlng'.$mapDivSuffix.', latlng_mc'.$mapDivSuffix.';' ."\n";
    $scripttext .= 'var routedestination'.$mapDivSuffix.', routedirection'.$mapDivSuffix.';' ."\n";
    
    $scripttext .= 'var mapzoom'.$mapDivSuffix.';' ."\n";

    
    if ($externalmarkerlink == 1)
    {
        $scripttext .= 'var allPlacemarkArray = [];' ."\n";
    }


    if (isset($map->usercontactattributes) && $map->usercontactattributes != "")
    {
        $userContactAttrs = str_replace(";", ',',$map->usercontactattributes);
    }
    else
    {
        $userContactAttrs = str_replace(";", ',', 'name;position;address;phone;mobile;fax;email');
    }
    $scripttext .= 'var userContactAttrs = \''.$userContactAttrs.'\';' ."\n";
    

    $scripttext .= 'var icoIcon=\''.$imgpathIcons.'\';'."\n";
    $scripttext .= 'var icoUtils=\''.$imgpathUtils.'\';'."\n";
    $scripttext .= 'var icoDir=\''.$directoryIcons.'\';'."\n";   
    $scripttext .= 'var icoIcon4Size=\''.$imgpath4size.'\';'."\n";
        
    if ($zhomObjectManager != 0)
    {
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.' = new zhomMapObjectManager();' ."\n";

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMapID('.$map->id.');' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkDateFormat("'.$fv_placemark_date_fmt.'");' ."\n";

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkList("'.$placemarklistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setExcludePlacemarkList("'.$explacemarklistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkGroupList("'.$grouplistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkCategotyList("'.$categorylistid.'");' ."\n";
                
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPathList("'.$pathlistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setExcludePathList("'.$expathlistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPathGroupList("'.$pathgrouplistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPathCategotyList("'.$pathcategorylistid.'");' ."\n";    
         
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkTagList("'.$taglistid.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPathTagList("'.$pathtaglistid.'");' ."\n";
               
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setUserMarkersFilter("'.$usermarkersfilter.'");' ."\n";

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMapLanguageTag("'.$main_lang.'");' ."\n";
        
        
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setServiceDirection('.$service_DoDirection.');' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setIcoIcon(icoIcon);' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setIcoIcon4Size(icoIcon4Size);' ."\n";
        
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setIcoUtils(icoUtils);' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setIcoDir(icoDir);' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setArticleID("'.$mapDivSuffix.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkRating('.(int)$map->placemark_rating.');' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkTitleTag("'.$placemarkTitleTag.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setRequestURL("'.URI::root().'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkCreationInfo('.(int)$map->showcreateinfo.');' ."\n";

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setFeature4Control('.$feature4control.');' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPanelInfowin('.$managePanelInfowin.');' ."\n";
        
        if (isset($map->gogoogle) && ((int)$map->gogoogle != 0))
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setGoGoogle('.(int)$map->gogoogle.');' ."\n";
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setGoGoogleText("'.$fv_override_gogoogle_text.'");' ."\n";                   
        }
        
        if ($ajaxLoadObjects != 0)
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setAjaxBufferSizePlacemark('.(int)$map->ajaxbufferplacemark.');' ."\n";
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setAjaxBufferSizePath('.(int)$map->ajaxbufferpath.');' ."\n";
            //$scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setAjaxBufferSizeRoute('.(int)$map->ajaxbufferroute.');' ."\n";
        }

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setContactAttrs("'.$userContactAttrs.'");' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setUserContact('.(int)$map->usercontact.');' ."\n";
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setUserUser('.(int)$map->useruser.');' ."\n";


        if ($needOverlayControl != 0)
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enableOpacityOverlayControl();' ."\n";
        }
                
        if ($compatiblemode != 0)
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setCompatibleMode('.(int)$compatiblemode.');' ."\n";
        
        }    
                
        if ($hierarchyCategoryGroup != "")
        {
        $scripttext .= '
    var setting'.$mapDivSuffix.' = {
            check: {
                    enable: true,
                    autoCheckTrigger: true
            },
            view: {
                    showIcon: showIconForTree'.$mapDivSuffix.'
            },
            data: {
                    simpleData: {
                            enable: true
                    }
            },
            callback: {
                    onCheck: onCheck'.$mapDivSuffix.'
            }
    };

    var zNodes'.$mapDivSuffix.' = ['.$hierarchyCategoryGroup.'			
    ];

    function showIconForTree'.$mapDivSuffix.'(treeId, treeNode) {';
        if ((int)$map->markergroupshowicon == 55)
        {
            $scripttext .= '    return (typeof treeNode.icon !== \'undefined\' && treeNode.icon != "");';
        }
        else
        {
            $scripttext .= '    return (!treeNode.isParent && typeof treeNode.icon !== \'undefined\' && treeNode.icon != "");';
        }
        $scripttext .= '
    }
    
    function onCheck'.$mapDivSuffix.'(e, treeId, treeNode) {
        if (treeNode.id < 0 && (treeNode.zhomActionNodeState != treeNode.checked))
        {
            //alert(treeNode.name + ", toggle");
            callToggleGroup'.$mapDivSuffix.'(-1*treeNode.id);
        }
        treeNode.zhomActionNodeState = treeNode.checked;
    }
    
    zhomObjMgr'.$mapDivSuffix.'.enableManagementByCategory("zhom-menu'.$markergroupcssstyle.'", setting'.$mapDivSuffix.', zNodes'.$mapDivSuffix.');
    '."\n";
        }
    

        // for centering placemarks
        if ($ajaxLoadObjects != 0) {
            if ($currentPlacemarkCenter != "do not change") {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setCenterPlacemark('.(int)$currentPlacemarkCenter.');' ."\n";

            }
            
            if ($currentPlacemarkActionID != "do not change")
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setActionPlacemark('.(int)$currentPlacemarkActionID.');' ."\n";

                if ($currentPlacemarkAction != "do not change")
                {
                    $currentPlacemarkExecuteArray = explode(";", $currentPlacemarkAction);

                    for($i = 0; $i < count($currentPlacemarkExecuteArray); $i++) 
                    {
                        switch (strtolower(trim($currentPlacemarkExecuteArray[$i])))
                        {
                            case "":
                               // null
                            break;
                            case "do not change":
                                    // do not change
                            break;
                            case "click":
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("click");' ."\n";
                            break;
                            case "exclusive elastic bounce":
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("exclusive elastic bounce");' ."\n";
                            break;
                            case "elastic bounce":
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("elastic bounce");' ."\n";
                            break;
                            case "exclusive bounce":
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("exclusive bounce");' ."\n";
                            break;
                            case "bounce":
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("bounce");' ."\n";
                            break;
                            default:
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addActionPlacemarkAction("'. trim($currentPlacemarkExecuteArray[$i]).'");'."\n";
                            break;
                        }
                    }
                }


            }                        
        }
        
        if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0)
        {
            if (isset($map->markerlistsync) && (int)$map->markerlistsync != 0)
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkList();' ."\n";
            }
        }
        
        
    }
        
        if ($pathParse != 0)
        {
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.' = new zhomPathParser();' ."\n";
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.'.setRequestURL("'.URI::root().'");' ."\n";
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.'.setGPXIconPath("'. $imgpathGPX.'");' ."\n";
            
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.'.setObjectManager(zhomObjMgr'.$mapDivSuffix.');' ."\n";
            
        }
    
    if ($zhomK2Manager != 0) 
    {
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.' = new zhomK2Manager();' ."\n";
        if ($zhomObjectManager != 0)
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setObjectManager(zhomObjMgr'.$mapDivSuffix.');' ."\n";
        }
        
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setPlacemarkDateFormat("'.$fv_placemark_date_fmt.'");' ."\n";
              
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setIcoIcon(icoIcon);' ."\n";
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setIcoUtils(icoUtils);' ."\n";
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setIcoDir(icoDir);' ."\n";
                
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setArticleID("'.$mapDivSuffix.'");' ."\n";
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setPlacemarkTitleTag("'.$placemarkTitleTag.'");' ."\n";
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setRequestURL("'.URI::root().'");' ."\n";
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setPlacemarkCreationInfo('.(int)$map->showcreateinfo.');' ."\n";
                
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setMapLanguageTag("'.$main_lang.'");' ."\n";
                
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setMarkerSpinner("'.$map->markerspinner.'");' ."\n";

                
        if (isset($defaultIconType) && $defaultIconType != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setDefaultIcon("'.$defaultIconType.'", '.(int)$defaultIconTypeX.', '.(int)$defaultIconTypeY.');' ."\n";
        }
        if (isset($k2PopupTemplate) && $k2PopupTemplate != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setPopupTemplate("'.$k2PopupTemplate.'");' ."\n";
        }                
        if (isset($k2EnableFitBounds) && (int)$k2EnableFitBounds == 1)
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.enableFitBounds();' ."\n";
        }

        if (isset($k2AjaxForm) && (int)$k2AjaxForm != 0)
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setAjaxForm('.(int)$k2AjaxForm.');' ."\n";
        }
                
        if (isset($k2FormSelector) && $k2FormSelector != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setFormSelector("'.$k2FormSelector.'");' ."\n";
        }
        if (isset($k2SubmitSelector) && $k2SubmitSelector != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setSubmitSelector("'.$k2SubmitSelector.'");' ."\n";
        }
        if (isset($k2ResetSelector) && $k2ResetSelector != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setResetSelector("'.$k2ResetSelector.'");' ."\n";
        }
        if (isset($k2ContainerSelector) && $k2ContainerSelector != "")
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setResultSelector("'.$k2ContainerSelector.'");' ."\n";
        }
                
        if ($fv_override_placemark_popup_style != 0)
        {
            $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setPopupStyle('.$fv_override_placemark_popup_style.');' ."\n";
        }
    }
    
    if ($managePanelFeature == 1)
    {
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePanel();' ."\n";
        if ($fullHeight == 1) 
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPanelHeightDeltaFix(5);' ."\n";
        }               
    }


    if ((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0) 
     || (isset($map->markermanager) && (int)$map->markermanager == 1))
    {
		if (isset($mgrgrouplist) && !empty($mgrgrouplist)) {
			foreach ($mgrgrouplist as $key => $currentmarkergroup) 
			{
				if (((int)$currentmarkergroup->published == 1) || ($allowUserMarker == 1))
				{
					$scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addManagedGroup('.$currentmarkergroup->id.', "'.str_replace('"', '\\"',str_replace('\\', '\\\\',$currentmarkergroup->title)).'", "'.str_replace('"', '\\"',str_replace('\\', '\\\\',$currentmarkergroup->description)).'", '.$currentmarkergroup->markermanagerminzoom.', '.$currentmarkergroup->markermanagermaxzoom.');' ."\n";
				}
			}
		}
    }
    
    $scripttext .= 'function initialize'.$mapInitTag.'() {' ."\n";

    if ($load_delay != "" && (int)$load_delay > 0)
    {
       $scripttext .= 'setTimeout(function(){' ."\n";
    }
    //
    // MarkerGroups
    $placemarkGroupArray = array();
    $placemarkGroupArrayCluster = array();

    if ($zhomObjectManager)
    {
        $scripttext .= 'var markerCluster0;' ."\n";

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.GroupStateDefine(0, 1);' ."\n";

        // changed from $markergroups to $mgrgrouplist - reverted
        // for placemarks from paths 
        if (isset($markergroups) && !empty($markergroups)) 
        {
            foreach ($markergroups as $key => $currentmarkergroup) 
            {
                $scripttext .= 'var markerCluster'.$currentmarkergroup->id.';' ."\n";

                array_push($placemarkGroupArray, $currentmarkergroup->id);
                // 7.10.2019 - result push
                array_push($placemarkGroupArrayCluster, $currentmarkergroup);

                // 24.11.2015 - bugfix - unpublished groups caused error, because there is no link element
                if (((int)$currentmarkergroup->published == 1) || ($allowUserMarker == 1))
                {
                    $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.GroupStateDefine('.$currentmarkergroup->id.', '.(int)$currentmarkergroup->activeincluster.');' ."\n";
                }
            }
        }


        $scripttext .= 'var pathArray0 = [];' ."\n";
        if (isset($mgrgrouplist) && !empty($mgrgrouplist)) 
        {
            foreach ($mgrgrouplist as $key => $currentmarkergroup) 
            {
                if (!in_array($currentmarkergroup->id, $placemarkGroupArray))
                {
                        $scripttext .= 'var markerCluster'.$currentmarkergroup->id.';' ."\n";
                        // 7.10.2019 2 push
                        // check push
                        // result push
                        array_push($placemarkGroupArray, $currentmarkergroup->id);
                        array_push($placemarkGroupArrayCluster, $currentmarkergroup);

                        // 24.11.2015 - bugfix - unpublished groups caused error, because there is no link element
                        if (((int)$currentmarkergroup->published == 1) || ($allowUserMarker == 1))
                        {
                                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.GroupStateDefine('.$currentmarkergroup->id.', '.(int)$currentmarkergroup->activeincluster.');' ."\n";
                        }
                }
            }
        }
    }

    if (isset($map->useajax) && (int)$map->useajax != 0)
    {
        $scripttext .= 'var ajaxmarkersLL'.$mapDivSuffix.' = [];' ."\n";
        $scripttext .= 'var ajaxmarkersADR'.$mapDivSuffix.' = [];' ."\n";

        $scripttext .= 'var ajaxpaths'.$mapDivSuffix.' = [];' ."\n";
        $scripttext .= 'var ajaxpathsOVL'.$mapDivSuffix.' = [];' ."\n";

        if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
        {
            $scripttext .= 'var ajaxmarkersLLhover'.$mapDivSuffix.' = [];' ."\n";
            $scripttext .= 'var ajaxmarkersADRhover'.$mapDivSuffix.' = [];' ."\n";

        }

        $scripttext .= 'var ajaxpathshover'.$mapDivSuffix.' = [];' ."\n";                      

    }

    //
    $scripttext .= 'var toShowLoading = document.getElementById("OMapsLoading'.$mapDivSuffix.'");'."\n";
    $scripttext .= '  toShowLoading.style.display = \'block\';'."\n";
    
    $scripttext .= 'routedirection'.$mapDivSuffix.' = 1;'."\n";
    
    $scripttext .= 'latlng_mc'.$mapDivSuffix.' = L.latLng('.$map->latitude.', ' .$map->longitude.');' ."\n";
    if ($currentPlacemarkCenter != "do not change") {
        if ($currentPlacemarkCenterType == "placemark")
        {
            $curcenterLatLng = MapPlacemarksHelper::get_placemark_coordinates((int)$currentPlacemarkCenter);
        }
        elseif ($currentPlacemarkCenterType == "coordinates")
        {
            $curcenterLatLng = $currentPlacemarkCenterCoordinates;
        }
        elseif ($currentPlacemarkCenterType == "placemark manual")
        {
            // do not change map center, it will be changed later
            $curcenterLatLng = "";
        }
        else
        {
            $curcenterLatLng = "";
        }
        
        if ($curcenterLatLng != "") {
            if ($curcenterLatLng != "geocode") {
                $scripttext .= 'latlng'.$mapDivSuffix.' = '.$curcenterLatLng.';'."\n";
            }   
            else
            {
                $scripttext .= 'latlng'.$mapDivSuffix.' = L.latLng('.$map->latitude.', ' .$map->longitude.');' ."\n";
            }
        }
        else
        {
            $scripttext .= 'latlng'.$mapDivSuffix.' = L.latLng('.$map->latitude.', ' .$map->longitude.');' ."\n";
        }

    }
    else
    {
        $scripttext .= 'latlng'.$mapDivSuffix.' = L.latLng('.$map->latitude.', ' .$map->longitude.');' ."\n";
    }

    $scripttext .= 'routedestination'.$mapDivSuffix.' = latlng'.$mapDivSuffix.';'."\n";


    $scripttext .= 'popup'.$mapDivSuffix.' = L.popup();' ."\n";
    
    if (isset($mapzoom) && (int)$mapzoom != 0)
    {
        $scripttext .= 'mapzoom'.$mapDivSuffix.' ='.$mapzoom.';' ."\n";

        if (((int)$map->mapcentercontrol == 2)
           ||((int)$map->mapcentercontrol == 12))
        {
            $ctrl_zoom = $mapzoom;
        }
        else
        {
            $ctrl_zoom = 'do not change';
        }        
    }
    else
    {
        $scripttext .= 'mapzoom'.$mapDivSuffix.' ='.$map->zoom.';' ."\n";

        if (((int)$map->mapcentercontrol == 2)
           ||((int)$map->mapcentercontrol == 12))
        {
            $ctrl_zoom = $map->zoom;
        }
        else
        {
            $ctrl_zoom = 'do not change';
        }                
    }
    
    
    
    
    $scripttext .= 'var mapOptions'.$mapDivSuffix.' = {' ."\n";

    // will do without this, after that add "load" listener to addition process
    //$scripttext .= ' center: latlng'.$mapDivSuffix.',' ."\n";
    //$scripttext .= ' zoom: mapzoom'.$mapDivSuffix.',' ."\n";
    
   
        
    if (isset($map->scrollwheelzoom) && (int)$map->scrollwheelzoom == 1) 
    {
        $scripttext .= ' scrollWheelZoom: true,' ."\n";
    } 
    else 
    {
        $scripttext .= ' scrollWheelZoom: false,' ."\n";
    }
        
       
        
    if (isset($map->minzoom) && (int)$map->minzoom != 0)
    {
        $scripttext .= ' minZoom: '.(int)$map->minzoom.',' ."\n";
    }
    if (isset($map->maxzoom) && (int)$map->maxzoom != 0)
    {
        $scripttext .= ' maxZoom: '.(int)$map->maxzoom.',' ."\n";
    }
    if (isset($map->draggable) && (int)$map->draggable == 0)
    {
        $scripttext .= ' dragging: false ,' ."\n";
    }
    else
    {
        $scripttext .= ' dragging: true ,' ."\n";
    }

    // Map type
    // Change $map->maptype to $currentMapType

    //Zoom Control
    if ((isset($map->zoomcontrol) && (int)$map->zoomcontrol != 0)
           && (isset($map->poszoom) && (int)$map->poszoom == 122 ))
    {
        $scripttext .= ' zoomControl: true,' ."\n";

    } else 
    {
        $scripttext .= ' zoomControl: false,' ."\n";
    }


    // Map type Control
    
    // Map type
    if (isset($currentMapType)) 
    {

        if ($currentMapType == "do not change")
        {
            $currentMapTypeValue = $map->maptype;
        }
        else
        {
            $currentMapTypeValue = $currentMapType;
        }

    }
        
    // popup style for on map definition
    if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
    {
        $scripttext_pp_main_style = "{autoPan: false}";
    }



    if (isset($map->mapbounds) && $map->mapbounds != "")
    {
        $mapBoundsArray = explode(";", str_replace(',',';',$map->mapbounds));
        if (count($mapBoundsArray) != 4)
        {
            $scripttext .= 'alert("'.Text::_('COM_ZHOSMMAP_MAP_ERROR_MAPBOUNDS').'");'."\n";
        }
        else
        {
                $scripttext .= ' maxBounds: L.latLngBounds(L.latLng('.$mapBoundsArray[0].', '.$mapBoundsArray[1].'), L.latLng('.$mapBoundsArray[2].', '.$mapBoundsArray[3].')),' ."\n";        
        }
    }    
        if (isset($map->closepopuponclick) && (int)$map->closepopuponclick != 0) 
    {
        $scripttext .= ' closePopupOnClick: true,' ."\n";
    } 
    else 
    {
        $scripttext .= ' closePopupOnClick: false,' ."\n";
    }
    
	// last option, without ","
	//Double Click Zoom
    if (isset($map->doubleclickzoom) && (int)$map->doubleclickzoom != 0) 
    {
        $scripttext .= ' doubleClickZoom: true' ."\n";
    } 
    else 
    {
        $scripttext .= ' doubleClickZoom: false' ."\n";
    }

    //end of options
    $scripttext .= '};' ."\n";
        
    // to fix for ajax reload
    $scripttext .= 'if (map'.$mapDivSuffix.' != undefined) { map'.$mapDivSuffix.'.off(); map'.$mapDivSuffix.'.remove(); }' ."\n";

    $scripttext .= 'map'.$mapDivSuffix.' = L.map("OMapsID'.$mapDivSuffix.'", mapOptions'.$mapDivSuffix.');' ."\n";

        
    $scripttext .= ' map'.$mapDivSuffix.'.on(\'load\', function(event) {' ."\n";

    if (isset($doShowDivFind) && (int)$doShowDivFind == 1)
    {
        $scripttext .= ' var toShowDivFind = document.getElementById("OMapFindAddress'.$mapDivSuffix.'");' ."\n";
        $scripttext .= ' toShowDivFind.style.display = "block";' ."\n";
    }
           
    // Do open list if preset to yes
    if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
    {
        if ((int)$map->markerlistpos == 111
          ||(int)$map->markerlistpos == 112
          ||(int)$map->markerlistpos == 121
          ) 
        {
            // We don't have to do in any case when table or external
            // because it displayed        
        }
        else
        {
            if ((int)$map->markerlistbuttontype == 0
            ||(int)$map->markerlistpos == 120 // panel
            )                
            {
                // Open because for non-button
                $scripttext .= '    var toShowDiv = document.getElementById("OMapsMarkerList'.$mapDivSuffix.'");' ."\n";
                $scripttext .= '    toShowDiv.style.display = "block";' ."\n";
            }
            else
            {
                                switch ($map->markerlistbuttontype) 
                {
                    case 0:
                        $scripttext .= '    var toShowDiv = document.getElementById("OMapsMarkerList'.$mapDivSuffix.'");' ."\n";
                        $scripttext .= '    toShowDiv.style.display = "block";' ."\n";
                    break;
                    case 1:
                        $scripttext .= '';
                    break;
                    case 2:
                        $scripttext .= '';
                    break;
                    case 11:
                        $scripttext .= '    var toShowDiv = document.getElementById("OMapsMarkerList'.$mapDivSuffix.'");' ."\n";
                        $scripttext .= '    toShowDiv.style.display = "block";' ."\n";
                    break;
                    case 12:
                        $scripttext .= '    var toShowDiv = document.getElementById("OMapsMarkerList'.$mapDivSuffix.'");' ."\n";
                        $scripttext .= '    toShowDiv.style.display = "block";' ."\n";
                    break;
                    default:
                        $scripttext .= '';
                    break;
                }
            }
                                
        }    
    }
    // Open Placemark List Presets
        
    $scripttext .= '});' ."\n";

    $scripttext .= 'map'.$mapDivSuffix.'.setView(latlng'.$mapDivSuffix.', mapzoom'.$mapDivSuffix.');'."\n";

    if (isset($map->auto_center_zoom) && ((int)$map->auto_center_zoom !=0))
    {
        $scripttext .= 'var map_bounds'.$mapDivSuffix.' = L.latLngBounds(map'.$mapDivSuffix.'.getBounds());' ."\n";
    }

    if ($fv_override_invalidatediv != "")
    {
        $scripttext .= 'Map_Invalidate_Size('.$fv_override_invalidatetype.', map'.$mapDivSuffix.', "'.$fv_override_invalidatediv.'", "'.$fv_override_invalidateindex.'", "'.Text::_('COM_ZHOSMMAP_MAP_INVALIDATE_DIV').'");'."\n";
    }
            
    if ((isset($map->zoomcontrol) && (int)$map->zoomcontrol != 0)
           && (isset($map->poszoom) && (int)$map->poszoom != 122 ))
    {
        $scripttext .= 'L.control.zoom({'."\n";
        if (isset($map->poszoom)) 
        {
            switch ($map->poszoom) 
            {
                case 0:
                break;
                case 2:
                           $scripttext .= '  position: \'topleft\' ' ."\n";
                break;
                case 3:
                           $scripttext .= '  position: \'topright\' ' ."\n";
                break;
                case 11:
                           $scripttext .= '  position: \'bottomleft\' ' ."\n";
                break;
                case 12:
                           $scripttext .= '  position: \'bottomright\' ' ."\n";
                break;
                default:
                    $scripttext .= '' ."\n";
                break;
            }
                        $scripttext .= '}).addTo(map'.$mapDivSuffix.');'."\n";
        }

    } 

//           && (isset($map->posscale) && (int)$map->posscale != 122 ))
        
    if (isset($map->scalecontrol) && (int)$map->scalecontrol != 0)
    {
            $scripttext .= 'L.control.scale({'."\n";
            if (isset($map->posscale)) 
            {
                    if (isset($map->scale_metric) && (int)$map->scale_metric != 0)
                    {
                        $scripttext .= '   metric: true ' ."\n";
                    }
                    else
                    {
                        $scripttext .= '   metric: false ' ."\n";
                    }
                    if (isset($map->scale_imperial) && (int)$map->scale_imperial != 0)
                    {
                        $scripttext .= ' , imperial: true ' ."\n";
                    }
                    else
                    {
                        $scripttext .= ' , imperial: false ' ."\n";
                    }
                    if (isset($map->scale_update_when_idle) && (int)$map->scale_update_when_idle != 0)
                    {
                        $scripttext .= ' , updateWhenIdle: true ' ."\n";
                    }
                    else
                    {
                        $scripttext .= ' , updateWhenIdle: false ' ."\n";
                    }                        
                    if (isset($map->scale_maxwidth) && (int)$map->scale_maxwidth != 0)
                    {
                        $scripttext .= ' , maxWidth: '.(int)$map->scale_maxwidth ."\n";
                    }
                    switch ($map->posscale) 
                    {
                            case 0:
                            break;
                            case 2:
                                    $scripttext .= ' , position: \'topleft\' ' ."\n";
                            break;
                            case 3:
                                    $scripttext .= ' , position: \'topright\' ' ."\n";
                            break;
                            case 11:
                                    $scripttext .= ' , position: \'bottomleft\' ' ."\n";
                            break;
                            case 12:
                                    $scripttext .= ' , position: \'bottomright\' ' ."\n";
                            break;
                            case 122:
                                    $scripttext .= '';
                            break;
                            default:
                                    $scripttext .= '';
                            break;
                    }
                    $scripttext .= '}).addTo(map'.$mapDivSuffix.');'."\n";
            }

    } 
	
	
		     
	if ((int)$map->fullscreencontrol != 0)
	{
		$scripttext .= 'L.control.fullscreen({'."\n";
		
		if (isset($map->fullscreencontrolpos)) 
        {
			$scripttext .= '   title: "' . Text::_('COM_ZHOSMMAP_MAP_FULLSCREENCONTROL_BUTTON_CALL').'"'."\n";
            $scripttext .= ' , titleCancel: "' . Text::_('COM_ZHOSMMAP_MAP_FULLSCREENCONTROL_BUTTON_EXIT').'"'."\n";
            switch ($map->fullscreencontrolpos) 
            {
                case 0:
                break;
                case 2:
                           $scripttext .= ' , position: \'topleft\' ' ."\n";
                break;
                case 3:
                           $scripttext .= ' , position: \'topright\' ' ."\n";
                break;
                case 11:
                           $scripttext .= ' , position: \'bottomleft\' ' ."\n";
                break;
                case 12:
                           $scripttext .= ' , position: \'bottomright\' ' ."\n";
                break;
                default:
                    $scripttext .= '' ."\n";
                break;
            }
		
        }
		
		if ((int)$map->fullscreencontrol == 2)
		{
			$scripttext .= ' , forceSeparateButton: true' ."\n";
		}
		
	$scripttext .= '}).addTo(map'.$mapDivSuffix.');' ."\n";
		
	}

    if (isset($map->geocoder) && ((int)$map->geocoder !=0))
    {

        $geocoder_opts = "";
        $geocoder_opt_sep = "";
        if (isset($map->geocoderpos)) 
        {
                switch ($map->geocoderpos) 
                {
                        case 0:
                        break;
                        case 2:
                            $geocoder_opts .= $geocoder_opt_sep.'position: \'topleft\'';
                            $geocoder_opt_sep = "\n".", ";
                        break;
                        case 3:
                            $geocoder_opts .= $geocoder_opt_sep.'position: \'topright\'';
                            $geocoder_opt_sep = "\n".", ";
                        break;
                        case 11:
                            $geocoder_opts .= $geocoder_opt_sep.'position: \'bottomleft\'';
                            $geocoder_opt_sep = "\n".", ";
                        break;
                        case 12:
                            $geocoder_opts .= $geocoder_opt_sep.'position: \'bottomright\'';
                            $geocoder_opt_sep = "\n".", ";
                        break;
                        default:
                            $geocoder_opts .= '' ."\n";
                        break;
                }
        }

        if ($fv_override_geocoder_placeholder != "")
        {
            $geocoder_opts .= $geocoder_opt_sep."placeholder: \"".$fv_override_geocoder_placeholder."\"";
            $geocoder_opt_sep = "\n".", ";
        }
        if ($fv_override_geocoder_not_found != "")
        {
            $geocoder_opts .= $geocoder_opt_sep."errorMessage: \"".$fv_override_geocoder_not_found."\"";
            $geocoder_opt_sep = "\n".", ";
        }        

        if (isset($map->geocodercollapsed) && ((int)$map->geocodercollapsed == 0))
        {
            $geocoder_opts .= $geocoder_opt_sep."collapsed: false";
            $geocoder_opt_sep = "\n".", ";
        }  
        
        if ($geocoder_opts != "")
        {
            $geocoder_opts = "{".$geocoder_opts."}";
        }

        $scripttext .= 'var geocoder'.$mapDivSuffix.' = L.Control.geocoder('.$geocoder_opts.').addTo(map'.$mapDivSuffix.');' ."\n";
    }
        
    $scripttext_mapoverlays = ' var overlays'.$mapDivSuffix.' = {' ."\n";
    $scripttext_maptype = ' var baseLayers'.$mapDivSuffix.' = {' ."\n";
    $map_type_sep = "";
    $map_over_sep = "";
    
    $map_type_cnt = 0;
    
    $attribution_license = "";
    if (isset($licenseinfo) && (int)$licenseinfo == 115)
    {
        $attribution_license = '<a href="'.$urlProtocol.'://zhuk.cc" target="_blank" title="'.Text::_('COM_ZHOSMMAP_MAP_POWEREDBY').'">zhuk.cc</a>|';
    }

    if (isset($map->openstreet) && (int)$map->openstreet == 1)
    {
        $scripttext .=' var openStreetType'.$mapDivSuffix.' = L.tileLayer(\'https://tile.openstreetmap.org/{z}/{x}/{y}.png\', {' ."\n";
            
        $scripttext .= '        attribution: \''.$attribution_license.' &copy; <a href="'.$urlProtocol.'://www.openstreetmap.org/copyright">OpenStreetMap</a> '.Text::_('COM_ZHOSMMAP_MAP_CONTRIBUTORS').'\'' ."\n";
        $scripttext .= '    });' ."\n";

        $scripttext_maptype .= $map_type_sep . '"'.Text::_('COM_ZHOSMMAP_MAP_OPENSTREETLAYER').'":  openStreetType'.$mapDivSuffix;
        $map_type_sep = ",";

        $map_type_cnt += 1;
        
        if ((int)$currentMapTypeValue == 5)
    {
            $scripttext .= ' openStreetType'.$mapDivSuffix.'.addTo(map'.$mapDivSuffix.');'."\n";
        }
    }

    if (isset($map->opentopomap) && (int)$map->opentopomap == 1)
    {
    
        $scripttext .= ' var openTopoMapType'.$mapDivSuffix.' = L.tileLayer(\'https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png\', {' ."\n";
        $scripttext .= '        maxZoom: 18,' ."\n";
        $scripttext .= '        attribution: \''.$attribution_license.' '.Text::_('COM_ZHOSMMAP_MAP_MAPDATA').': <a href="'.$urlProtocol.'://openstreetmap.org/copyright">OpenStreetMap</a> '.Text::_('COM_ZHOSMMAP_MAP_CONTRIBUTORS').', <a href="'.$urlProtocol.'://viewfinderpanoramas.org">SRTM</a> | '.Text::_('COM_ZHOSMMAP_MAP_MAPSTYLE').': <a href="'.$urlProtocol.'://opentopomap.org">OpenTopoMap</a> (<a href="'.$urlProtocol.'://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)\'' ."\n";
        $scripttext .= '    });' ."\n";    

        $scripttext_maptype .= $map_type_sep . '"'.Text::_('COM_ZHOSMMAP_MAP_OPENTOPOMAPLAYER').'":  openTopoMapType'.$mapDivSuffix;
        $map_type_sep = ",";  

        $map_type_cnt += 1;
        
        if ((int)$currentMapTypeValue == 8)
    {
            $scripttext .= ' openTopoMapType'.$mapDivSuffix.'.addTo(map'.$mapDivSuffix.');'."\n";
        }
    }
        
    if (isset($map->nztopomaps) && (int)$map->nztopomaps != 0)
    {
            
    }
    
                
    if ((int)$map->custommaptype != 0)
    {
		if (isset($maptypes) && !empty($maptypes)) {
			foreach ($maptypes as $key => $currentmaptype)     
			{
			
				for ($i=0; $i < count($custMapTypeList); $i++)
				{
					if ($currentmaptype->id == (int)$custMapTypeList[$i]) 
									{

										if ($currentmaptype->url_template != "")
										{
											$map_type_cnt += 1;
											$scripttext .= ' var customMapType'.$currentmaptype->id.' = L.tileLayer(\''.$currentmaptype->url_template.'\', {' ."\n";
						if ((int)$currentmaptype->minzoom != 0)
						{
							$scripttext .= '  minZoom: '.(int)$currentmaptype->minzoom.',' ."\n";
						}
						if ((int)$currentmaptype->maxzoom != 0)
						{
							$scripttext .= '  maxZoom: '.(int)$currentmaptype->maxzoom.',' ."\n";
						}
											
											if ((int)$currentmaptype->tilewidth != 256
												|| (int)$currentmaptype->tileheight != 256)
											{
												if ((int)$currentmaptype->tilewidth == (int)$currentmaptype->tileheight)
												{
													$scripttext .= '  tileSize: '.(int)$currentmaptype->tilewidth.',' ."\n";
												}
												else
												{
													$scripttext .= '  tileSize: L.point('.$currentmaptype->tilewidth.', '.$currentmaptype->tileheight.'),' ."\n";
												}
											}
											
						 if ($currentmaptype->opacity != "")
						{
							$scripttext .= '  opacity: '.$currentmaptype->opacity.','."\n";
						}                                       
											$scripttext .= '        attribution: \''.$attribution_license.' '.str_replace('\'', '\\\'', $currentmaptype->license).'\'' ."\n";
											$scripttext .= '    });' ."\n";    

											if ((int)$map->maptype == 7)
											{
												if (((int)$custMapTypeFirst != 0) && ((int)$custMapTypeFirst == $currentmaptype->id))
												{
													$scripttext .= ' customMapType'.$currentmaptype->id.'.addTo(map'.$mapDivSuffix.');'."\n";
												}
											}
										
											if ((int)$currentmaptype->layertype == 1)
											{
												$scripttext_mapoverlays .= $map_over_sep . '"'.str_replace('"','', $currentmaptype->title).'": customMapType'.$currentmaptype->id;
												$map_over_sep = ",";  
											}
											else
											{
												$scripttext_maptype .= $map_type_sep . '"'.str_replace('"','', $currentmaptype->title).'": customMapType'.$currentmaptype->id;
												$map_type_sep = ",";                                                
											}
											
										}
										else if ($currentmaptype->gettileurl != "")
										{
											$map_type_cnt += 1;
											$scripttext .= ' L.TileLayer.CustomMapType'.$currentmaptype->id.' = L.TileLayer.extend({' ."\n";
											$scripttext .= '  getTileUrl: '.$currentmaptype->gettileurl ."\n";
											$scripttext .= '});' ."\n";    
										   
											$scripttext .= 'var customMapType'.$currentmaptype->id.' = new L.TileLayer.CustomMapType'.$currentmaptype->id.'(\'\', {'."\n";
						if ((int)$currentmaptype->minzoom != 0)
						{
							$scripttext .= '  minZoom: '.(int)$currentmaptype->minzoom.',' ."\n";
						}
						if ((int)$currentmaptype->maxzoom != 0)
						{
							$scripttext .= '  maxZoom: '.(int)$currentmaptype->maxzoom.',' ."\n";
						}
											
											if ((int)$currentmaptype->tilewidth != 256
												|| (int)$currentmaptype->tileheight != 256)
											{
												if ((int)$currentmaptype->tilewidth == (int)$currentmaptype->tileheight)
												{
													$scripttext .= '  tileSize: '.(int)$currentmaptype->tilewidth.',' ."\n";
												}
												else
												{
													$scripttext .= '  tileSize: L.point('.$currentmaptype->tilewidth.', '.$currentmaptype->tileheight.'),' ."\n";
												}
											}
											
						 if ($currentmaptype->opacity != "")
						{
							$scripttext .= '  opacity: '.$currentmaptype->opacity.','."\n";
						}                                       
											$scripttext .= '        attribution: \''.$attribution_license.' '.str_replace('\'', '\\\'', $currentmaptype->license).'\'' ."\n";
											$scripttext .= '    });' ."\n";    
											
											if ((int)$map->maptype == 7)
											{
												if (((int)$custMapTypeFirst != 0) && ((int)$custMapTypeFirst == $currentmaptype->id))
												{
													$scripttext .= ' customMapType'.$currentmaptype->id.'.addTo(map'.$mapDivSuffix.');'."\n";
												}
											}
										
											if ((int)$currentmaptype->layertype == 1)
											{
												$scripttext_mapoverlays .= $map_over_sep . '"'.str_replace('"','', $currentmaptype->title).'": customMapType'.$currentmaptype->id;
												$map_over_sep = ",";  
											}
											else
											{
												$scripttext_maptype .= $map_type_sep . '"'.str_replace('"','', $currentmaptype->title).'": customMapType'.$currentmaptype->id;
												$map_type_sep = ",";                                                
											}


										}
									
				
										
									}
							}
				// End loop by Enabled CustomMapTypes
			
			}
			// End loop by All CustomMapTypes
        }
    }

        $scripttext_maptype .= ' }' ."\n";
        $scripttext_mapoverlays .= ' }' ."\n";
    
        $scripttext .= $scripttext_maptype . $scripttext_mapoverlays;
        
        $map_opt_sep = "";  
        if ($map_type_cnt > 1)
        {
            $scripttext .='L.control.layers(baseLayers'.$mapDivSuffix.', overlays'.$mapDivSuffix.', {';
        if (isset($map->posmaptype)) 
        {
            switch ($map->posmaptype) 
            {
                case 0:
                break;
                case 2:
                           $scripttext .= $map_opt_sep.'  position: \'topleft\' ' ."\n";
                                        $map_opt_sep = ",";
                break;
                case 3:
                           $scripttext .= $map_opt_sep.'  position: \'topright\' ' ."\n";
                                        $map_opt_sep = ",";
                break;
                case 11:
                           $scripttext .= $map_opt_sep.'  position: \'bottomleft\' ' ."\n";
                                        $map_opt_sep = ",";
                break;
                case 12:
                           $scripttext .= $map_opt_sep.'  position: \'bottomright\' ' ."\n";
                                        $map_opt_sep = ",";
                break;
                case 122:
                break;
                default:
                    $scripttext .= '' ."\n";
                break;
            }
        }  
                
                if (isset($map->hidesinglebaselayer) && ((int)$map->hidesinglebaselayer == 1))
                {
                    $scripttext .= $map_opt_sep.'  hideSingleBase: true ' ."\n";
                    $map_opt_sep = ",";
                }
            $scripttext .= '}).addTo(map'.$mapDivSuffix.');'."\n";
        }
        
        
    if ($managePanelInfowin == 1
    || ((int)$map->markerlistpos != 0)
    )
    {
        $scripttext .='Map_Initialize_All(map'.$mapDivSuffix.');'."\n";
    }
    
        //if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
    //{
    //}

    if ($zhomObjectManager != 0)
    {
        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMap(map'.$mapDivSuffix.');' ."\n";
                if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                {
                    $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.disableAutoPan();' ."\n";
                }
    }
    
    if ($zhomK2Manager != 0) 
    {
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.setMap(map'.$mapDivSuffix.');' ."\n";
    }
        if ($pathParse != 0)
        {
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.'.setMap(map'.$mapDivSuffix.');' ."\n";
        }

    // Map is created

        if ($zhomObjectManager != 0)
    {
            //if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
            //{
            // alway pass it
                    $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setHoverMarkerType("'.$map->hovermarker.'");' ."\n";
            //}
        }
        if ($pathParse != 0)
        {
            $scripttext .= 'zhomPathParser'.$mapDivSuffix.'.setHoverMarkerType("'.$map->hovermarker.'");' ."\n";
        }
        
    /* leaflet supports native map bounds
    if (isset($map->mapbounds) && $map->mapbounds != "")
    {
        $mapBoundsArray = explode(";", str_replace(',',';',$map->mapbounds));
        if (count($mapBoundsArray) != 4)
        {
            $scripttext .= 'alert("'.Text::_('COM_ZHOSMMAP_MAP_ERROR_MAPBOUNDS').'");'."\n";
        }
        else
        {
        
            if ($zhomObjectManager != 0)
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMapBounds('.$mapBoundsArray[0].', '.$mapBoundsArray[1].','.$mapBoundsArray[2].', '.$mapBoundsArray[3].');' ."\n";
            }        

        }
    }    
    */

    
    
    if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
    {
    
        if ($zhomObjectManager != 0)
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMarkerListPos('.(int)$map->markerlistpos.');' ."\n";
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMarkerListContent('.(int)$map->markerlistcontent.');' ."\n";
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMarkerListAction('.(int)$map->markerlistaction.');' ."\n";
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setMarkerListCSSStyle("'.$markerlistcssstyle.'");' ."\n";
            
        }

        if ((int)$map->markerlistpos == 111
          ||(int)$map->markerlistpos == 112
          ||(int)$map->markerlistpos == 121
          ||(int)$map->markerlistpos == 120 // panel
          ) 
        {
            // Do not create button when table or external
        }
        else
        {
            if ((int)$map->markerlistbuttontype == 0)
            {
                // Skip creation for non-button
            }
            else
            {

                $scripttext .= '  var placemarklistControl = new zhomPlacemarkListButtonControl('.
                    '"OMapsMarkerList'.$mapDivSuffix.'",'.
                    'map'.$mapDivSuffix.','. 
                    $feature4control.','. 
                    (int)$map->markerlistbuttontype.','. 
                    (int)$map->markerlistbuttonpos.','. 
                    '"placemarklist",'. 
                    '"'.$fv_override_placemark_button_tooltip.'",'.
                    '16,'. 
                    '16,'. 
                    '"'.$imgpathUtils.'star.png"'.
                    ');'."\n";                
                
            }
        }
    
    }
    
    if ($managePanelFeature == 1)
    {
        
            $scripttext .= '  var panelControl = new zhomPanelButtonControl('.
                '"OMapsMainPanel'.$mapDivSuffix.'","OMapsID'.$mapDivSuffix.'","OMapsPanelAccordion'.$mapDivSuffix.'",'.$managePanelContentWidth.','.
                'map'.$mapDivSuffix.','. 'zhomObjMgr'.$mapDivSuffix.','.
                $feature4control.','. 
                (int)$map->panelstate.','. 
                '3,'. 
                '"panel",'. 
                '"'.$fv_override_panel_button_tooltip.'",'.
                '18,'. 
                '23,'. 
                '"'.$imgpathUtils.'panel_left.png"'.
                ');'."\n";            
    }
    
    // Pushing controls - Begin
    
            
    // Begin 3
    if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
    {
        $controlPosition = '';
        switch ((int)$map->markerlistpos) 
        {
            case 0:
                // None
                $controlPosition = '';
            break;
            case 2:
                $controlPosition = '\'topleft\'';
            break;
            case 3:
                $controlPosition = '\'topright\'';
            break;
            case 11:
                $controlPosition = '\'bottomleft\'';
            break;
            case 12:
                $controlPosition = '\'bottomright\'';
            break;
            case 111:
                $controlPosition = '';
            break;
            case 112:
                $controlPosition = '';
            break;
            case 113:
                $controlPosition = '';
            break;
            case 114:
                $controlPosition = '';
            break;
            case 120:
                $controlPosition = '';
            break;
            case 121:
                $controlPosition = '';
            break;
            default:
                $controlPosition = '';
            break;
        }

        if ($controlPosition != "")    
        {
            $scripttext .= 'map'.$mapDivSuffix.'.controls['.$controlPosition.'].push(';
            $scripttext .= 'document.getElementById(\'OMapsMarkerList'.$mapDivSuffix.'\'));' ."\n";
        }
    }
    // End 3
    
    // Pushing controls - End



        
    if (isset($map->nztopomaps) && (int)$map->nztopomaps != 0)
    {
    }



        
    if ((int)$map->custommaptype != 0)
    {
		if (isset($maptypes) && !empty($maptypes)) {
			foreach ($maptypes as $key => $currentmaptype)     
			{
				for ($i=0; $i < count($custMapTypeList); $i++)
				{
					if ($currentmaptype->id == (int)$custMapTypeList[$i]
					&& $currentmaptype->gettileurl != "")
					{
						if ((int)$currentmaptype->layertype == 1)
						{
							if ($needOverlayControl != 0)
													{
														if ((int)$currentmaptype->opacitymanage == 1)
														{
															$scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.addOverlayMapType(customMapType'.$currentmaptype->id.');'."\n";
														}
													}
						}
						else
						{
							if ((int)$map->maptype == 7)
							{
								if (((int)$custMapTypeFirst != 0) && ((int)$custMapTypeFirst == $currentmaptype->id))
								{
																$scripttext .= 'customMapType'.$currentmaptype->id.'.fire("click");'."\n";
								}
							}
						}
					}
				}
				// End loop by Enabled CustomMapTypes
				
			}
			// End loop by All CustomMapTypes
		}
    }


    
    if (isset($licenseinfo) && (int)$licenseinfo != 0) 
    {
    
        if ((int)$licenseinfo == 114 // Map-License (into credits)
          ) 
        {
            // Do not create button when L-M, M-L or external
            if ($credits != '')
            {
                $credits .= '<br />';
            }
            $credits .= ''.Text::_('COM_ZHOSMMAP_MAP_POWEREDBY').': ';
            $credits .= '<a href="'.$urlProtocol.'://zhuk.cc/" target="_blank" alt="'.Text::_('COM_ZHOSMMAP_MAP_POWEREDBY').'">zhuk.cc</a>';
        }
                else if ((int)$licenseinfo == 115 // Map attribution (into credits)
          ) 
        {
                    // added in other place
                }
        else
        {
                        $scripttext .= 'function LicenseControl(pi_map){' ."\n";
                        $scripttext .= 'L.Control.LicenseControlButton = L.Control.extend({' ."\n";
                        $scripttext .= '   onAdd: function LicenseControl(map) {' ."\n";

                        $scripttext .= '  var controlDiv = document.createElement(\'DIV\');' ."\n";
            // Set CSS styles for the DIV containing the control
            // Setting padding to 5 px will offset the control
            // from the edge of the map'.$mapDivSuffix.'.
            $scripttext .= '  controlDiv.style.padding = \'5px\';' ."\n";

            // Set CSS for the control border.
            $scripttext .= '  var controlUI = document.createElement(\'DIV\');' ."\n";
            $scripttext .= '  controlUI.title = "'.Text::_('COM_ZHOSMMAP_MAP_POWEREDBY').': zhuk.cc";' ."\n";
            $scripttext .= '  controlDiv.appendChild(controlUI);' ."\n";

            // Set CSS for the control interior.
            $scripttext .= '  var controlText = document.createElement(\'DIV\');' ."\n";

            $scripttext .= '  controlText.innerHTML = \'<a href="'.$urlProtocol.'://zhuk.cc/" target="_blank" alt="'.Text::_('COM_ZHOSMMAP_MAP_POWEREDBY').': zhuk.cc"><img style="border: 0px none; padding: 0px; margin: 0px; width: 60px; height: 53px;" src="'.$imgpathUtils.'ZhukLogo.png"></a>\';'."\n";;
            
            $scripttext .= '  controlUI.appendChild(controlText);' ."\n";
                        
                        $scripttext .= '  return controlDiv;' ."\n";

            $scripttext .= '  },' ."\n";
                        $scripttext .= '   onRemove: function(map) {' ."\n";
                            // Nothing to do here
                        $scripttext .= '  }' ."\n";

                         $scripttext .= '});' ."\n";
                         
                        
            $scripttext .= '  L.control.LicenseControlButton = function(opts) {' ."\n";
                        $scripttext .= '      return new L.Control.LicenseControlButton(opts);' ."\n";
                        $scripttext .= '  }' ."\n";

            $controlPosition ="";
            if (isset($licenseinfo)) 
            {
                switch ($licenseinfo) 
                {
                    case 0:
                    break;
                    case 2:
                            $controlPosition = '\'topleft\'';
                    break;
                    case 3:
                            $controlPosition = '\'topright\'';
                    break;
                    case 11:
                            $controlPosition = '\'bottomleft\'';
                    break;
                    case 12:
                            $controlPosition = '\'bottomright\'';
                    break;
                    default:
                        $controlPosition = '';
                        // fix to incorrect setting to 8
                        $controlPosition = '\'bottomleft\'';
                    break;
                }
            }
            
            if ($controlPosition != "")
            {
                            $scripttext .= ' L.control.LicenseControlButton({ position: '.$controlPosition .'}).addTo(pi_map);' ."\n";
            }
                        $scripttext .= '}'."\n";
                        
                        
                        $scripttext .= 'LicenseControl(map'.$mapDivSuffix.');' ."\n";
            
        }
    
    }
    
        

    // Create Placemark for Insert Users Placemarks - Begin
    //UserMarker - begin
    if ($allowUserMarker == 1
     && (((int)$map->usermarkersinsert == 1) || (int)$map->usermarkersupdate == 1))
    {        
        $db = Factory::getDBO();
        
        $query = $db->getQuery(true);
        
        $query->select('h.title as text, h.id as value ');
        $query->from('#__zhosmmaps_markergroups as h');
        $query->leftJoin('#__categories as c ON h.catid=c.id');
        $query->where('1=1');
        // get all groups, because you can add marker and disable group
        //$query->where('h.published=1');
        $query->order('h.title');
        
        $db->setQuery($query);    

		try {
			$db->execute();
			$newMarkerGroupList = $db->loadObjectList();
		} catch (ExecutionFailureException $e) {
			throw new \Exception("Error (Load Group List Item): " . $e->getMessage(), 500);
		} 

        // icon type
        $scripttext .= 'var contentInsertPlacemarkIcon = "" +' ."\n";
        if (isset($map->usermarkersicon) && (int)$map->usermarkersicon == 1) 
        {
            $iconTypeJS = " onchange=\"javascript: ";
            $iconTypeJS .= " if (document.forms.insertPlacemarkForm.markerimage.options[selectedIndex].value!=\'\') ";
            $iconTypeJS .= " {document.markericonimage.src=\'".$imgpathIcons."\' + document.forms.insertPlacemarkForm.markerimage.options[selectedIndex].value.replace(/#/g,\'%23\') + \'.png\'}";
            $iconTypeJS .= " else ";
            $iconTypeJS .= " {document.markericonimage.src=\'\'}\"";
            
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_ICON_TYPE' ).' \'+' ."\n";
            $scripttext .= ' \'';
            $scripttext .= '<img name="markericonimage" src="" alt="" />';
            $scripttext .= '\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= ' \'';
            $scripttext .= str_replace('.png<', '<', 
                                str_replace('.png"', '"', 
                                    str_replace('JOPTION_SELECT_IMAGE', Text::_('COM_ZHOSMMAP_MAP_USER_IMAGESELECT'),
                                        str_replace(array("\r", "\r\n", "\n"),'', HTMLHelper::_('list.images',  'markerimage', $active =  "", $iconTypeJS, $directoryIcons, $extensions =  "png")))));
            $scripttext .= '\'+' ."\n";

            $scripttext .= '    \'<br />\';' ."\n";
        }
        else
        {
            $scripttext .= '    \'<input name="markerimage" type="hidden" value="default#" />\'+' ."\n";    
            $scripttext .= '    \'\';' ."\n";
        }

    }

    if ($allowUserMarker == 1 && (int)$map->usermarkersinsert == 1)
    {        
        $scripttext .= 'var  latlngInsertPlacemark;' ."\n";
        $scripttext .= 'var  insertPlacemark = L.marker(latlng'.$mapDivSuffix.',{' ."\n";
        $scripttext .= '      draggable:true ' ."\n";
        $scripttext .= '  }).addTo(map'.$mapDivSuffix.');'."\n";
        
        $scripttext .= 'insertPlacemark.title = "'.Text::_( 'COM_ZHOSMMAP_MAP_USER_NEWMARKER' ).'";' ."\n";
        $scripttext .= 'insertPlacemark.description = "'.Text::_( 'COM_ZHOSMMAP_MAP_USER_NEWMARKER_DESC' ).'";' ."\n";

        $scripttext .= 'var contentInsertPlacemarkPart1 = \'<div id="contentInsertPlacemark">\' +' ."\n";
        $scripttext .= '\'<'.$placemarkTitleTag.' id="headContentInsertPlacemark" class="insertPlacemarkHead">'.
            '<img src="'.$imgpathUtils.'published'.(int)$map->usermarkerspublished.'.png" alt="" /> '.
            Text::_( 'COM_ZHOSMMAP_MAP_USER_NEWMARKER' ).'</'.$placemarkTitleTag.'>\'+' ."\n";
        $scripttext .= '\'<div id="bodyContentInsertPlacemark"  class="insertPlacemarkBody">\'+'."\n";
        //$scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_LNG' ).' \'+current.lng() + ' ."\n";
        //$scripttext .= '    \'<br />'.Text::_( 'COM_ZHOSMMAP_MAP_USER_LAT' ).' \'+current.lat() + ' ."\n";
        $scripttext .= '    \'<form id="insertPlacemarkForm" action="'.URI::current().'" method="post">\'+'."\n";

        // Begin Placemark Properties
        $scripttext .= '\'<div id="bodyInsertPlacemarkDivA"  class="bodyInsertProperties">\'+'."\n";
        $scripttext .= '\'<a id="bodyInsertPlacemarkA" href="javascript:showonlyone(\\\'Placemark\\\',\\\'\\\');" ><img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'</a>\'+'."\n";
        $scripttext .= '\'</div>\'+'."\n";
        $scripttext .= '\'<div id="bodyInsertPlacemark"  class="bodyInsertPlacemarkProperties">\'+'."\n";
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_NAME' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \'<input name="markername" type="text" maxlength="250" size="50" />\'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_DESCRIPTION' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \'<input name="markerdescription" type="text" maxlength="250" size="50" />\'+' ."\n";
        $scripttext .= '    \'<br />\';' ."\n";


        $scripttext .= 'var contentInsertPlacemarkPart2 = "" +' ."\n";
        /*
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_BALOON' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";

        $scripttext .= '    \' <select name="markerbaloon" > \'+' ."\n";
        $scripttext .= '    \' <option value="1" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_DROP').'</option> \'+' ."\n";
        $scripttext .= '    \' <option value="2" >'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_BOUNCE').'</option> \'+' ."\n";
        $scripttext .= '    \' <option value="3" >'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_SIMPLE').'</option> \'+' ."\n";
        $scripttext .= '    \' </select> \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        */
        
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAPMARKER_USER_MARKERCONTENT' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        
        $scripttext .= '    \' <select name="markermarkercontent" > \'+' ."\n";
        $scripttext .= '    \' <option value="0" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_TITLE_DESC').'</option> \'+' ."\n";
        $scripttext .= '    \' <option value="1" >'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_TITLE').'</option> \'+' ."\n";
        $scripttext .= '    \' <option value="2" >'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_DESCRIPTION').'</option> \'+' ."\n";
        $scripttext .= '    \' <option value="100" >'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_NONE').'</option> \'+' ."\n";
        $scripttext .= '    \' </select> \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
                
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_HREFIMAGE_LABEL' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \'<input name="markerhrefimage" type="text" maxlength="500" size="50" value="" />\'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";

        $scripttext .= '    \'<br />\'+' ."\n";
        
        $scripttext .= '\'</div>\'+'."\n";
        // End Placemark Properties

        // Begin Placemark Group Properties
        $scripttext .= '\'<div id="bodyInsertPlacemarkGrpDivA"  class="bodyInsertProperties">\'+'."\n";
        $scripttext .= '\'<a id="bodyInsertPlacemarkGrpA" href="javascript:showonlyone(\\\'PlacemarkGroup\\\',\\\'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'</a>\'+'."\n";
        $scripttext .= '\'</div>\'+'."\n";
        $scripttext .= '\'<div id="bodyInsertPlacemarkGrp"  class="bodyInsertPlacemarkGrpProperties">\'+'."\n";
        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_GROUP' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        
        $scripttext .= '    \' <select name="markergroup" > \'+' ."\n";
        $scripttext .= '    \' <option value="" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_FILTER_PLACEMARK_GROUP').'</option> \'+' ."\n";
        foreach ($newMarkerGroupList as $key => $newGrp) 
        {
            $scripttext .= '    \' <option value="'.$newGrp->value.'">'.$newGrp->text.'</option> \'+' ."\n";
        }
        $scripttext .= '    \' </select> \'+' ."\n";
        
        $scripttext .= '    \'<br />\'+' ."\n";

        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CATEGORY' ).' \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \' <select name="markercatid" > \'+' ."\n";
        $scripttext .= '    \' <option value="" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAP_FILTER_CATEGORY').'</option> \'+' ."\n";
        $scripttext .= '    \''.str_replace(array("\r", "\r\n", "\n"),'', 
                               HTMLHelper::_('select.options', HTMLHelper::_('category.options', 'com_zhosmmap'), 'value', 'text', '')) .
                               '\'+' ."\n";
        $scripttext .= '    \' </select> \'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '    \'<br />\'+' ."\n";
        $scripttext .= '\'</div>\'+'."\n";
        // End Placemark Group Properties
        
        // Begin Contact Properties
        if (isset($map->usercontact) && (int)$map->usercontact == 1) 
        {

            $scripttext .= '\'<div id="bodyInsertContactDivA"  class="bodyInsertProperties">\'+'."\n";
            $scripttext .= '\'<a id="bodyInsertContactA" href="javascript:showonlyone(\\\'Contact\\\',\\\'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'</a>\'+'."\n";
            $scripttext .= '\'</div>\'+'."\n";
            $scripttext .= '\'<div id="bodyInsertContact"  class="bodyInsertContactProperties">\'+'."\n";
            $scripttext .= '\'<img src="'.$imgpathUtils.'published'.(int)$map->usercontactpublished.'.png" alt="" /> \'+'."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_NAME' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactname" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_POSITION' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactposition" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PHONE' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactphone" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_MOBILE' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactmobile" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_FAX' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactfax" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_EMAIL' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactemail" type="text" maxlength="250" size="50" />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<input name="contactid" type="hidden" value="" />\'+' ."\n";
            $scripttext .= '\'</div>\'+'."\n";
            // Contact Address
            $scripttext .= '\'<div id="bodyInsertContactAdrDivA"  class="bodyInsertProperties">\'+'."\n";
            $scripttext .= '\'<a id="bodyInsertContactAdrA" href="javascript:showonlyone(\\\'ContactAddress\\\',\\\'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'</a>\'+'."\n";
            $scripttext .= '\'</div>\'+'."\n";
            $scripttext .= '\'<div id="bodyInsertContactAdr"  class="bodyInsertContactAdrProperties">\'+'."\n";
            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS' ).' \'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<textarea name="contactaddress" cols="35" rows="4"></textarea>\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '    \'<br />\'+' ."\n";
            $scripttext .= '\'</div>\'+'."\n";
        }
        // End Contact Properties
        
        $scripttext .= '\'\';'."\n";

        // for DML bugfix for every 2 time call show popup (see new marker)
        $scripttext .= '    insertPlacemark.bindPopup();'."\n";
        $scripttext .= '    insertPlacemark.on(\'drag\', function(event) {' ."\n";
        $scripttext .= '      latlngInsertPlacemark = event.latlng;' ."\n";

        $scripttext .= '    });' ."\n";

        $scripttext .= '    insertPlacemark.on(\'click\', function(event) {' ."\n";
        $scripttext .= '        latlngInsertPlacemark = event.latlng;' ."\n";

        $scripttext .= '  contentInsertPlacemarkButtons = \'<div id="contentInsertPlacemarkButtons">\' +' ."\n";
        $scripttext .= '    \'<hr />\'+' ."\n";                    
        $scripttext .= '    \'<input name="markerlat" type="hidden" value="\'+latlngInsertPlacemark.lat + \'" />\'+' ."\n";
        $scripttext .= '    \'<input name="markerlng" type="hidden" value="\'+latlngInsertPlacemark.lng + \'" />\'+' ."\n";
        $scripttext .= '    \'<input name="marker_action" type="hidden" value="insert" />\'+' ."\n";    
        $scripttext .= '    \'<input name="markersubmit" type="submit" value="'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BUTTON_ADD' ).'" />\'+' ."\n";
        $scripttext .= '    \'</form>\'+' ."\n";        
        $scripttext .= '\'</div>\'+'."\n";
        $scripttext .= '\'</div>\';'."\n";
      
        // for DML bugfix for every 2 time call show popup (see new marker)
        // do set its content
        //$scripttext .= '   this.closePopup();' ."\n";
        //$scripttext .= '   this.unbindPopup();'."\n";
        
        $scripttext .= '   this.setPopupContent(contentInsertPlacemarkPart1+';
        $scripttext .= 'contentInsertPlacemarkIcon+';
        //$scripttext .= 'contentInsertPlacemarkIcon.replace(\'"markericonimage" src="\', \'"markericonimage" src="'.$imgpathIcons.str_replace("#", "%23", "default#").'.png"\')+';
        $scripttext .= 'contentInsertPlacemarkPart2+';
        $scripttext .= 'contentInsertPlacemarkButtons).openPopup();' ."\n";
        $scripttext .= '   this.openPopup();' ."\n";
        $scripttext .= '    });' ."\n";
        
        $scripttext .= '    map'.$mapDivSuffix.'.on(\'click\', function(event) {' ."\n";
        $scripttext .= '      latlngInsertPlacemark = event.latlng;' ."\n";
        $scripttext .= '        insertPlacemark.setLatLng(latlngInsertPlacemark);' ."\n";

        $scripttext .= '    });' ."\n";
        
    }
    // New Marker - End

    
    // Create Placemark for Insert Users Placemarks - End
    
    if (isset($map->balloon)) 
    {

        $scripttext .= 'var contentString'.$mapDivSuffix.' = \'<div id="placemarkContent" class="placemarkContent" >\' +' ."\n";
        $scripttext .= '\'<'.$placemarkTitleTag.' id="headContent" class="placemarkHead">'.htmlspecialchars(str_replace('\\', '/', $map->title), ENT_QUOTES, 'UTF-8').'</'.$placemarkTitleTag.'>\'+' ."\n";
        $scripttext .= '\'<div id="bodyContent"  class="placemarkBody">\'+'."\n";
        $scripttext .= '\''.htmlspecialchars(str_replace('\\', '/', $map->description) , ENT_QUOTES, 'UTF-8').'\'+'."\n";
        $scripttext .= '\'</div>\'+'."\n";
                
                // 06.12.2017 Added link to Google map page like for placemark
                if ((int)$map->gogoogle_map == 10 || (int)$map->gogoogle_map == 11 
                  ||(int)$map->gogoogle_map == 30 || (int)$map->gogoogle_map == 31
                  ||(int)$map->gogoogle_map == 12 || (int)$map->gogoogle_map == 13
                  ||(int)$map->gogoogle_map == 14 || (int)$map->gogoogle_map == 15
                  ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33
                  ||(int)$map->gogoogle_map == 34 || (int)$map->gogoogle_map == 35
                )
                {    

                        if ((int)$map->gogoogle_map == 10 
                         || (int)$map->gogoogle_map == 30
                         || (int)$map->gogoogle_map == 12
                         || (int)$map->gogoogle_map == 14
                         || (int)$map->gogoogle_map == 32
                         || (int)$map->gogoogle_map == 34
                        )
                        {
                                $linkTarget = " target=\"_blank\"";
                        }
                        else
                        {
                                $linkTarget = "";
                        }




                        $scripttext .= '\'<div id="bodyContentGoGoogle" class="placemarkBodyGoGoogle">\'+'."\n";                
                        $scripttext .= '\'<p><a class="placemarkGOGOOGLE" href="';
                        
                        if ((int)$map->gogoogle_map == 12 || (int)$map->gogoogle_map == 13
                          ||(int)$map->gogoogle_map == 14 || (int)$map->gogoogle_map == 15
                          ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33
                          ||(int)$map->gogoogle_map == 34 || (int)$map->gogoogle_map == 35
                        )
                        {
                            $scripttext .= 'https://maps.google.com/?ll='.
                                            $map->latitude.','.$map->longitude;    
                            $scripttext .= '&amp;z='.$map->zoom; 
                            if ((int)$map->gogoogle_map == 12 || (int)$map->gogoogle_map == 13
                               ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33)
                            {
                                $scripttext .= '&amp;q='.htmlspecialchars(str_replace('\\', '/', $map->title) , ENT_QUOTES, 'UTF-8');
                            }
                            else
                            {
                                $scripttext .= '&amp;q='.$map->latitude.','.$map->longitude;    
                            }
                            
                            if ($main_lang_little != "")
                            {
                                $scripttext .= '&amp;hl='.$main_lang_little;    
                            }
                        }
                        else
                        {
                            $scripttext .= 'https://maps.google.com/maps?saddr=Current%20Location&amp;daddr='.
                                            $map->latitude.','.$map->longitude;                            
                        }

                                
                        $scripttext .= '" '.$linkTarget.' title="'.$fv_override_gogoogle_text.
                                '">'.$fv_override_gogoogle_text.'</a></p>\'+'."\n";
                        $scripttext .= '\'</div>\'+'."\n";

                }                   
        $scripttext .= '\'</div>\';'."\n";


        if ((int)$map->balloon != 0) 
        {
            $scripttext .= '  var marker'.$mapDivSuffix.' = L.marker(' ."\n";
            $scripttext .= '      latlng_mc'.$mapDivSuffix.', {' ."\n";

                        
            // Replace to new, because all charters are shown
            //$scripttext .= '      title:"'.htmlspecialchars(str_replace('\\', '/', $map->title) , ENT_QUOTES, 'UTF-8').'"' ."\n";
            $scripttext .= '      title:"'.str_replace('\\', '/', str_replace('"', '\'\'', $map->title)).'"' ."\n";
            $scripttext .= '})';

                        if ((isset($map->markercluster) && (int)$map->markercluster == 0))
                        {
                            $scripttext .= '.addTo(map'.$mapDivSuffix.');' ."\n";
                        }
                        else
                        {
                            $scripttext .= ';'."\n";
                        }

                        if ((int)$map->balloon == 2
                         ) 
                        {
                            $scripttext .= 'marker'.$mapDivSuffix.'.setBouncingOptions({';
                            $scripttext .= 'exclusive: false,';
                            $scripttext .= 'elastic: false';
                            $scripttext .= '});'."\n";
                            $scripttext .= 'marker'. $mapDivSuffix.'.bounce();'."\n";                                          
                        }     
                        else if ((int)$map->balloon == 4
                        )
                        {
                            $scripttext .= 'marker'.$mapDivSuffix.'.setBouncingOptions({';
                            $scripttext .= 'exclusive: false,';
                            $scripttext .= 'elastic: true';
                            $scripttext .= '});'."\n";
                            $scripttext .= 'marker'. $mapDivSuffix.'.bounce();'."\n";                                                            
                        }

                        if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                        {
                            $scripttext .= 'marker'.$mapDivSuffix.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(contentString'.$mapDivSuffix.'));'."\n";
                        }
                        else
                        {
                            $scripttext .= 'marker'.$mapDivSuffix.'.bindPopup(contentString'.$mapDivSuffix.');' ."\n";
                        }
                        
                        $scripttext .= '  marker'.$mapDivSuffix.'.on(\'click\', function(event) {' ."\n";
                        $scripttext .= '    this.openPopup();' ."\n";
                        //$scripttext .= '    event.stopPropagation();' ."\n";
                        $scripttext .= '  });' ."\n";                
                        
            if ($zhomObjectManager != 0)
            {
                $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkAdd(0, 0, marker'.$mapDivSuffix.', null);'."\n";
            }
                  


            
            }

    
                     
            if ((int)$map->openballoon == 1)
            {
                if ((int)$map->balloon != 0)
                {
                        $scripttext .= '  marker'.$mapDivSuffix.'.fire("click");' ."\n";
                 }
                else
                {
                    $scripttext .= ' popup'.$mapDivSuffix.'.setLatLng(latlng'.$mapDivSuffix.')' ."\n";
                    $scripttext .= '  .setContent(contentString'.$mapDivSuffix.')' ."\n";
                    $scripttext .= '  .openOn(map'.$mapDivSuffix.');' ."\n";

                }
            }
            
    }

    
        // 02.07.2019 move above, some thoubles with "bounce,click" when dynamic change map center by parameters
        // Overrides map center
        /*
        if ($ajaxLoadObjects != 0) {
            if ($currentPlacemarkCenter != "do not change") {
                $curcenterLatLng = MapPlacemarksHelper::get_placemark_coordinates((int)$currentPlacemarkCenter);

                if ($curcenterLatLng != "") {
                    if ($curcenterLatLng != "geocode") {
                        $scripttext .= 'latlng'.$mapDivSuffix.' = '.$curcenterLatLng.';'."\n";
                        $scripttext .= 'routedestination'.$mapDivSuffix.' = latlng'.$mapDivSuffix.';'."\n";    
                        $scripttext .= 'map'.$mapDivSuffix.'.setView(latlng'.$mapDivSuffix.', map'.$mapDivSuffix.'.getZoom());'."\n";
                    }   
                }

            }
        }
        */
        
        
    if ((isset($map->markercluster) && (int)$map->markercluster == 1))
    {      

        if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
        {
            $this->markercluster = 1;
        }
        else
        {
            $markercluster = 1;
        }

                if ((int)$map->markerspinner == 2 ||
                    (int)$map->markerspinner == 3 ||
                    (int)$map->markerspinner == 4 ||
                    (int)$map->markerspinner == 5)
                {
                    if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
                    {
                            $this->markerclusterlist = 1;
                    }
                    else
                    {
                            $markerclusterlist = 1;
                    }
                }

        $clustererOptions = ''; //imagePath: icoUtils+\'m\'' ."\n";
                $clustererOptionsSep = '';

                if ((int)$map->markerspinner == 1) {
                    $clustererOptions .= $clustererOptionsSep . 'spiderfyOnMaxZoom: true';
                    $clustererOptionsSep = ', ';
                } else {
                    $clustererOptions .= $clustererOptionsSep . 'spiderfyOnMaxZoom: false';
                    $clustererOptionsSep = ', ';                    
                }

                if ((int)$map->clusterzoombounds == 1) {
                    $clustererOptions .= $clustererOptionsSep . 'zoomToBoundsOnClick: true';
                    $clustererOptionsSep = ', ';
                } else {
                    $clustererOptions .= $clustererOptionsSep . 'zoomToBoundsOnClick: false';
                    $clustererOptionsSep = ', ';                    
                }
                if ((int)$map->clustershowhover == 1) {
                    $clustererOptions .= $clustererOptionsSep . 'showCoverageOnHover: true';
                    $clustererOptionsSep = ', ';
                } else {
                    $clustererOptions .= $clustererOptionsSep . 'showCoverageOnHover: false';
                    $clustererOptionsSep = ', ';                    
                }                
        if ((int)$map->clusterzoom != 0)
        {
                    $clustererOptions .= $clustererOptionsSep . 'disableClusteringAtZoom: '.$map->clusterzoom;
                    $clustererOptionsSep = ', ';                    
        }


        if ((int)$map->markerspinner == 2 ||
                    (int)$map->markerspinner == 3 ||
                    (int)$map->markerspinner == 4 ||
                    (int)$map->markerspinner == 5)
        {
                   
        $scripttext .= 
'var clusterWithListOptions'.$mapDivSuffix.' = {
    labelFn: function(el, ei, cluster) {';
        $scripttext .=' var ret_val = "";
';
        
        // to easy work in template
        $markerspinner = $map->markerspinner;
        $returnText = '';
        
        require_once (JPATH_SITE.'/components/com_zhosmmap/assets/templates/placemarks/cluster_list/'.$fv_override_item_template.'.php');
        
        $scripttext .= $returnText;
        
        $scripttext .= '
        return ret_val;
    },
    headerFn: function(els, cluster) {
      return "<p>cluster with " + els.length + " elements</p>";
    },
    sortFn: function(m1, m2) {';
    if ((int)$map->markerspinner == 2)
    {
        $scripttext .= '  return m1.zhomTitle > m2.zhomTitle ? 1 : -1;';
    }
    elseif ((int)$map->markerspinner == 3)
    {
        $scripttext .= 'if(m1.zhomCreateddate == m2.zhomCreateddate)';
        $scripttext .= '{';
        $scripttext .= '    return (m1.zhomTitle < m2.zhomTitle) ? -1 : (m1.zhomTitle > m2.zhomTitle) ? 1 : 0;';
        $scripttext .= '}';
        $scripttext .= 'else';
        $scripttext .= '{';
        $scripttext .= '    return (m1.zhomCreateddate < m2.zhomCreateddate) ? -1 : 1;';
        $scripttext .= '}';
        
        //$scripttext .= '  return m1.zhomCreateddate > m2.zhomCreateddate ? 1 : m1.zhomTitle > m2.zhomTitle ? 1 : -1;';
    }
    elseif ((int)$map->markerspinner == 4)
    {
        $scripttext .= 'if(m1.zhomTitle == m2.zhomTitle)';
        $scripttext .= '{';
        $scripttext .= '    return (m1.zhomCreateddate < m2.zhomCreateddate) ? -1 : (m1.zhomCreateddate > m2.zhomCreateddate) ? 1 : 0;';
        $scripttext .= '}';
        $scripttext .= 'else';
        $scripttext .= '{';
        $scripttext .= '    return (m1.zhomTitle < m2.zhomTitle) ? -1 : 1;';
        $scripttext .= '}';

        //$scripttext .= '  return m1.zhomTitle > m2.zhomTitle ? 1 : m1.zhomCreateddate > m2.zhomCreateddate ? 1 : -1;';
    }
    elseif ((int)$map->markerspinner == 5)
    {
        $scripttext .= '  return m1.zhomCreateddate > m2.zhomCreateddate ? 1 : -1;';
    }
    else
    {
        $scripttext .= '  return m1.zhomTitle > m2.zhomTitle ? 1 : -1;';
    }
    
    $scripttext .= '},
    showHeader: false,
    sidePanel: true,
    sidePanelWidth: 50,
    centerOnChange: true,
    showCoverageOnHover: false
    };'."\n";
        
            $scripttext .= 'markerCluster0 = L.markerClusterGroup.withList(clusterWithListOptions'.$mapDivSuffix.');' ."\n";
        }
        else
        {
            $scripttext .= 'markerCluster0 = L.markerClusterGroup({'.$clustererOptions.'});' ."\n";
        }
        $scripttext .= 'markerCluster0.addTo(map'.$mapDivSuffix.');' ."\n";

        if ($zhomObjectManager != 0)
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.ClusterAdd(0, markerCluster0);' ."\n";
        }

            if ($zhomK2Manager != 0) 
            {
                $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.enableClusterer(markerCluster0);' ."\n";             
            }

            if ((isset($map->markerclustergroup) && (int)$map->markerclustergroup == 1))
            {
                // changed from $markergroups to $mgrgrouplist - reverted
                // paths can create placemarks
                // 7.10.2019 new loop type
                //if (isset($mgrgrouplist) && !empty($mgrgrouplist))   
                if (count($placemarkGroupArrayCluster) > 0)
                {
                                    // 7.10.2019 new loop type
                    //foreach ($mgrgrouplist as $key => $currentmarkergroup)
                    foreach ($placemarkGroupArrayCluster as $currentmarkergroup)
                    {
                        $clustererOptions = ''; //imagePath: icoUtils+\'m\'' ."\n";
                        $clustererOptionsSep = '';

                        if ((int)$map->markerspinner == 1) {
                            $clustererOptions .= $clustererOptionsSep . 'spiderfyOnMaxZoom: true';
                            $clustererOptionsSep = ', ';
                        } else {
                            $clustererOptions .= $clustererOptionsSep . 'spiderfyOnMaxZoom: false';
                            $clustererOptionsSep = ', ';                    
                        }

                        if ((int)$map->clusterzoom != 0)
                        {
                            $clustererOptions .= $clustererOptionsSep . 'disableClusteringAtZoom: '.$map->clusterzoom;
                            $clustererOptionsSep = ', ';                    
                        }                    

                        if ((int)$currentmarkergroup->overridegroupicon == 1 && 1==2)
                        {
                            $imgimg = $imgpathIcons.str_replace("#", "%23", $currentmarkergroup->icontype).'.png';
                            $imgimg4size = $imgpath4size.$currentmarkergroup->icontype.'.png';

                            list ($imgwidth, $imgheight) = getimagesize($imgimg4size);

                            $markergroupstyle = ', styles: [{' ."\n";
                            $markergroupstyle .='height: '.$imgheight.',' ."\n";
                            $markergroupstyle .='width: '.$imgwidth.',' ."\n";
                            $markergroupstyle .='url: "'.$imgimg.'"' ."\n";
                            $markergroupstyle .='}]' ."\n";

                            $clustererOptions .= $markergroupstyle;
                        }

                        if ((int)$map->markerspinner == 2 ||
                            (int)$map->markerspinner == 3 ||
                            (int)$map->markerspinner == 4 ||
                            (int)$map->markerspinner == 5)
                        {      
                            $scripttext .= 'markerCluster'.$currentmarkergroup->id.' = L.markerClusterGroup.withList(clusterWithListOptions'.$mapDivSuffix.');' ."\n";
                        }
                        else
                        {
                            $scripttext .= 'markerCluster'.$currentmarkergroup->id.' = L.markerClusterGroup({'.$clustererOptions.'});' ."\n";
                        }


                        $scripttext .= 'markerCluster'.$currentmarkergroup->id.'.addTo(map'.$mapDivSuffix.');' ."\n";

                        if ($zhomObjectManager != 0)
                        {
                            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.ClusterAdd('.$currentmarkergroup->id.', markerCluster'.$currentmarkergroup->id.');' ."\n";
                        }
                    }
                }

        }
        
    }

  

    if (isset($map->markerlistpos) && (int)$map->markerlistpos != 0) 
    {
        if ((int)$map->markerlistcontent < 100) 
        {
            $tmp_str_message = Text::_('COM_ZHOSMMAP_MAP_MARKERUL_NOTFIND');
            if ($mapDivSuffix != "")
            {
                $tmp_str4replace = 'OMapsMarkerUL'.$mapDivSuffix;
                $tmp_str2replace = 'OMapsMarkerUL';
                $tmp_str_message = str_replace($tmp_str2replace, $tmp_str4replace, $tmp_str_message);
            }

            $scripttext .= 'var markerUL = document.getElementById("OMapsMarkerUL'.$mapDivSuffix.'");'."\n";
            $scripttext .= 'if (!markerUL)'."\n";
            $scripttext .= '{'."\n";
            $scripttext .= ' alert("'.$tmp_str_message .'");'."\n";
            $scripttext .= '}'."\n";
        }
        else
        {
            $tmp_str_message = Text::_('COM_ZHOSMMAP_MAP_MARKERTABLE_NOTFIND');
            if ($mapDivSuffix != "")
            {
                $tmp_str4replace = 'OMapsMarkerTABLEBODY'.$mapDivSuffix;
                $tmp_str2replace = 'OMapsMarkerTABLEBODY';
                $tmp_str_message = str_replace($tmp_str2replace, $tmp_str4replace, $tmp_str_message);
            }
            
            
            $scripttext .= 'var markerUL = document.getElementById("OMapsMarkerTABLEBODY'.$mapDivSuffix.'");'."\n";
            $scripttext .= 'if (!markerUL)'."\n";
            $scripttext .= '{'."\n";
            $scripttext .= ' alert("'.$tmp_str_message.'");'."\n";
            $scripttext .= '}'."\n";
        }
        
    }
        
    // External Group Control
    if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol == 10) 
    {
            $tmp_str_message = Text::_('COM_ZHOSMMAP_MAP_GROUPDIV_NOTFIND');

            if ($mapDivSuffix != "")
            {

                $tmp_str4replace = 'OMapsGroupDIV'.$mapDivSuffix;
                $tmp_str2replace = 'OMapsGroupDIV';
                $tmp_str_message = str_replace($tmp_str2replace, $tmp_str4replace, $tmp_str_message);

            }

            $scripttext .= 'var groupDivTag = document.getElementById("OMapsGroupDIV'.$mapDivSuffix.'");'."\n";
            $scripttext .= 'if (!groupDivTag)'."\n";
            $scripttext .= '{'."\n";
            $scripttext .= ' alert("'.$tmp_str_message.'");'."\n";
            $scripttext .= '}'."\n";
            $scripttext .= 'else'."\n";
            $scripttext .= '{'."\n";
            $scripttext .= ' groupDivTag.innerHTML = \''.str_replace('\'', '\\\'', str_replace(array("\r", "\r\n", "\n"),'', $divmarkergroup)).'\';'."\n";
            $scripttext .= '}'."\n";
    }
        

    // Markers
    
    $scripttext_pm_action = "";
    if (isset($markers) && !empty($markers)) 
    {
        // fix in plugin call case
        if(!class_exists('PlacemarkVisualization')) 
        {
            class PlacemarkVisualization
            {
                public $latitude;
                public $longitude;
                public $title;
                public $desc;
                public $addHTML;
            }
        }
                        
        //$scripttext .= '    alert("$map->markercluster='. $map->markercluster.'");'."\n";
        //$scripttext .= '    alert("$map->markerclustergroup='. $map->markerclustergroup.'");'."\n";
        //$scripttext .= '    alert("$map->markergroupcontrol='. $map->markergroupcontrol.'");'."\n";
            
        // Main loop
        foreach ($markers as $key => $currentmarker) 
        {

                    //$scripttext .= '    alert("try marker '. $currentmarker->id.'");'."\n";
                    //$scripttext .= '    alert("$currentmarker->publishedgroup='. $currentmarker->publishedgroup.'");'."\n";

                    $returnText = '';
                    require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_placemark.php';
                    $scripttext .= $returnText;
                    
                    // visualization for placemarks
                    //$scripttext .= "alert(\"data id:".(int)$currentmarker->data_id."\");";
                    if (isset($currentmarker->data_id) && (int)$currentmarker->data_id != 0) 
                    {

                        //$scripttext .= "alert(\"get data SQL\");";
                        $fv_datasql = MapPlacemarksHelper::get_DataSQL($currentmarker->data_id);
                        if (isset($fv_datasql) && (int)$fv_datasql->published == 1)
                        {
                            //$scripttext .= "alert(\"datasql done\");";
                            if (isset($fv_datasql->struct_id) && (int)$fv_datasql->struct_id != 0) 
                            {
                                $fv_struct = MapPlacemarksHelper::get_VisualizationStructure($fv_datasql->struct_id);
                                if (isset($fv_struct) && (int)$fv_struct->published == 1)
                                {
                                    //$scripttext .= "alert(\"struct done\");";
                                    if ($fv_struct->lat_lng_sep != "")
                                    {
                                            $fv_path_coords_sep = $fv_struct->lat_lng_sep; 
                                    }
                                    else
                                    {
                                            $fv_path_coords_sep = ",";
                                    }
                                    if ($fv_struct->lat_lng_order != ""
                                    && ((int)$fv_struct->lat_lng_order == 0 || (int)$fv_struct->lat_lng_order == 1))
                                    {
                                            $fv_path_coords_order = (int)$fv_struct->lat_lng_order; 
                                    }
                                    else
                                    {
                                            $fv_path_coords_order = 0;
                                    }
                                    if ($fv_struct->lat_lng_array_sep != "")
                                    {
                                            $fv_path_array_coords_sep = $fv_struct->lat_lng_array_sep; 
                                    }
                                    else
                                    {
                                            $fv_path_array_coords_sep = ";";
                                    }
                                    if ((int)$fv_datasql->query_type == 0)
                                    {
                                        $fv_sql_text_clause = str_replace(':userid', $currentUser->id, $fv_datasql->sql_text_clause);
                                        $fv_data_path = MapPlacemarksHelper::get_DataSQL_Data($fv_sql_text_clause, $fv_datasql->server_id);
                                        //$scripttext .= "alert(\"data done\");";
                                        if (isset($fv_data_path) and !empty($fv_data_path))
                                        {
                                            //$scripttext .= "alert(\"process data\");";
                                            $current_path_placemark_id = $currentmarker->id * 100000000;

                                            //$scripttext .= "alert(\"Placemark\");";
                                            $fv_path_array = [];
                                            foreach ($fv_data_path as $key => $current_data_path) 
                                            {
                                                $plObj = new PlacemarkVisualization();
                                                        
                                                if ($fv_struct->createddate != "")
                                                {
                                                    //$scripttext .= "alert(\"createddate added: ".$current_data_path[$fv_struct->createddate]."\");";
                                                    $plObj->createddate = $current_data_path[$fv_struct->createddate];
                                                }
                                                if ($fv_struct->icontype_column != "")
                                                {
                                                    $plObj->icontype = $current_data_path[$fv_struct->icontype_column];
                                                }
                                                if ($fv_struct->title_column != ""
                                                 || $fv_struct->description_column != ""
                                                 || $fv_struct->descriptionhtml_column != ""
                                                )
                                                {
                                                    if ($fv_struct->title_column != "")
                                                    {
                                                        if ($current_data_path[$fv_struct->title_column] != "")
                                                        {
                                                            $plObj->title = $current_data_path[$fv_struct->title_column];
                                                        }
                                                        else
                                                        {
                                                            $plObj->title = "";
                                                        }
                                                    }
                                                    else
                                                    {
                                                        $plObj->title = "";
                                                    }
                                                    if ($fv_struct->description_column != "")
                                                    {
                                                        if ($current_data_path[$fv_struct->description_column] != "")
                                                        {
                                                            $plObj->description = $current_data_path[$fv_struct->description_column];
                                                        }
                                                        else
                                                        {
                                                            $plObj->description = "";
                                                        }
                                                    }
                                                    else
                                                    {
                                                        $plObj->description = "";
                                                    }
                                                    
                                                    if ($fv_struct->descriptionhtml_column != "")
                                                    {
                                                        if ($current_data_path[$fv_struct->descriptionhtml_column] != "")
                                                        {
                                                            $plObj->descriptionhtml = $current_data_path[$fv_struct->descriptionhtml_column];
                                                        }
                                                        else
                                                        {
                                                            $plObj->descriptionhtml = "";
                                                        }
                                                    }
                                                    else
                                                    {
                                                        $plObj->descriptionhtml = "";
                                                    }
                                                    
                                                }
                                                
                                                if ($fv_struct->latitude != ""
                                                 && $fv_struct->longitude != "")
                                                {
                                                    $fv_struct_lat = $fv_struct->latitude;
                                                    $fv_struct_lng = $fv_struct->longitude;
                                                    $fv_data_lat = trim($current_data_path[$fv_struct_lat]);
                                                    $fv_data_lng = trim($current_data_path[$fv_struct_lng]);
                                                    if ($fv_data_lat != ""
                                                     && $fv_data_lng != "")
                                                    {
                                                        $plObj->latitude = $fv_data_lat;
                                                        $plObj->longitude = $fv_data_lng;
                                                        array_push($fv_path_array, $plObj);
                                                        //$scripttext .= "alert(\"push type 1\");";
                                                    } 

                                                }
                                                else if ($fv_struct->lat_lng != "")
                                                {
                                                    $fv_struct_lat_lng = $fv_struct->lat_lng;
                                                    if ($current_data_path[$fv_struct_lat_lng] != "")
                                                    {    
                                                        $fv_path_coords = explode($fv_path_coords_sep, $current_data_path[$fv_struct_lat_lng]);
                                                        $fv_data_c0 = trim($fv_path_coords[0]);
                                                        $fv_data_c1 = trim($fv_path_coords[1]);
                                                        if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                        {
                                                            if ($fv_path_coords_order == 0)
                                                            {
                                                                $fv_data_lat = $fv_data_c0;
                                                                $fv_data_lng = $fv_data_c1;
                                                            }
                                                            else
                                                            {
                                                                $fv_data_lat = $fv_data_c1;
                                                                $fv_data_lng = $fv_data_c0;
                                                            }

                                                            $plObj->latitude = $fv_data_lat;
                                                            $plObj->longitude = $fv_data_lng;
                                                            array_push($fv_path_array, $plObj);
                                                            //$scripttext .= "alert(\"push type 2\");";
                                                        }
                                                    }
                                                }
                                                else if ($fv_struct->lat_lng_array != "")
                                                {
                                                    $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                    if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                    {    

                                                        $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                        foreach ($fv_path_pairs as $key => $current_data_path) 
                                                        {
                                                            if ($fv_path_pairs != "")
                                                            {
                                                                $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                $fv_data_c0 = trim($fv_path_coords[0]);
                                                                $fv_data_c1 = trim($fv_path_coords[1]);
                                                                if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                {
                                                                    if ($fv_path_coords_order == 0)
                                                                    {
                                                                        $fv_data_lat = $fv_data_c0;
                                                                        $fv_data_lng = $fv_data_c1;
                                                                    }
                                                                    else
                                                                    {
                                                                        $fv_data_lat = $fv_data_c1;
                                                                        $fv_data_lng = $fv_data_c0;
                                                                    }

                                                                    $plObj->latitude = $fv_data_lat;
                                                                    $plObj->longitude = $fv_data_lng;
                                                                    array_push($fv_path_array, $plObj);
                                                                    //$scripttext .= "alert(\"push type 3\");";
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                else
                                                {

                                                }
                                            }
                                            
                                            //$scripttext .= "alert(\"count: ".count($fv_path_array)."\");";
                                            if (count($fv_path_array) != 0)
                                            {
                                                
                                                foreach ($fv_path_array as $current_data_marker) 
                                                {
                                                    
                                                    //$scripttext .= "alert(\"process: ".$current_data_marker."\");";
                                                    $currentmarker->latitude = $current_data_marker->latitude;
                                                    $currentmarker->longitude = $current_data_marker->longitude;
                                                    if ($fv_struct->createddate != "")
                                                    {
                                                        $currentmarker->createddate = $current_data_marker->createddate;
                                                    }
                                                    if ($fv_struct->icontype_column != "")
                                                    {
                                                        $currentmarker->icontype = $current_data_marker->icontype;
                                                    }
                                                    if ($fv_struct->title_column != ""
                                                     || $fv_struct->description_column != ""
                                                     || $fv_struct->descriptionhtml_column != ""
                                                    )
                                                    {
                                                        $currentmarker->title = $current_data_marker->title;
                                                        $currentmarker->description = $current_data_marker->description;
                                                        $currentmarker->descriptionhtml = $current_data_marker->descriptionhtml;
                                                    }
                                                    
                                                     // backup is done, just disable                                                            
                                                    $map->useajaxobject = 0;
                                                    if ($fv_struct->title_column != ""
                                                     || $fv_struct->description_column != ""
                                                     || $fv_struct->descriptionhtml_column != ""
                                                     || $fv_struct->createddate != ""
                                                    )
                                                    {
                                                        $map->useajax = 0;
                                                    }
                                                
                                                    $current_path_placemark_id += 1;
                                                    $currentmarker->id = $current_path_placemark_id;
                                                    
                                                    $returnText = '';
                                                    require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_placemark.php';
                                                    $scripttext .= $returnText;
                                                    
                                                    // restore
                                                    $map->useajaxobject = $backup_useajax;
                                                    if ($fv_struct->title_column != ""
                                                     || $fv_struct->description_column != ""
                                                     || $fv_struct->descriptionhtml_column != ""
                                                     || $fv_struct->createddate != ""
                                                    )
                                                    {
                                                        $map->useajax = $backup_useajaxobject;
                                                    }
                                                }
                                                
                                                $fv_path_array = [];
                                                
                                            }




                                        }
                                        //else 
                                        //{
                                        //    $scripttext .= "console.log(\"Visualization Array is empty\");"."\n";
                                        //}
                                    }

                                }
                                //else
                                //{
                                //    $scripttext .= "console.log(\"Visualization Structure is not published\");"."\n";
                                //}
                            }
                            //else
                            //{
                            //    $scripttext .= "console.log(\"Visualization Structure for placemark with ID ".$currentmarker->id." is not defined and Data SQL with ID ".$currentmarker->data_id."\");"."\n";
                            //}
                        }
                        //else
                        //{
                        //    $scripttext .= "console.log(\"Data SQL is not published\");"."\n";
                        //}
                    }
                    //else
                    //{
                    //    $scripttext .= "console.log(\"Data SQL for placemark with ID ".$currentmarker->id." is not defined\");"."\n";
                    //}


        }
        // Main loop by markers - End
    
    }
        
        // Ajax Marker Listeners
    if (isset($map->useajax) && (int)$map->useajax != 0) 
    {
        //$scripttext .= 'alert("begin: '.$mapDivSuffix.'");' ."\n";
        $scripttext .= 'for (var i=0; i<ajaxmarkersLL'.$mapDivSuffix.'.length; i++)' ."\n";
        $scripttext .= '{' ."\n";
        //$scripttext .= '    alert("Call:"+ajaxmarkersLL'.$mapDivSuffix.'[i].get("zhomPlacemarkID"));' ."\n";
        if ((int)$map->useajax == 1)
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkAddListeners("mootools", ajaxmarkersLL'.$mapDivSuffix.'[i]);' ."\n";
        }
        else
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkAddListeners("jquery", ajaxmarkersLL'.$mapDivSuffix.'[i]);' ."\n";
        }
        $scripttext .= '}' ."\n";
        //scripttext .= 'alert("-end");' ."\n";
        

            // For Hovering Feature - Begin
            if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
            {
                    $scripttext .= 'for (var i=0; i<ajaxmarkersLLhover'.$mapDivSuffix.'.length; i++)' ."\n";
                    $scripttext .= '{' ."\n";
                    //$scripttext .= '    alert("Call:"+ajaxmarkersLL'.$mapDivSuffix.'[i].get("zhomPlacemarkID"));' ."\n";
                    if ((int)$map->useajax == 1)
                    {
                            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkAddHoverListeners("mootools", ajaxmarkersLLhover'.$mapDivSuffix.'[i]);' ."\n";
                    }
                    else
                    {
                            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkAddHoverListeners("jquery", ajaxmarkersLLhover'.$mapDivSuffix.'[i]);' ."\n";
                    }
                    $scripttext .= '}' ."\n";
            }
            // For Hovering Feature - End
       
    }

    // Execute Action - Open InfoWin and etc
    if (isset($lastmarker2open)
    && (isset($map->useajaxobject) && (int)$map->useajaxobject == 0))
    {
        if ((int)$lastmarker2open->baloon != 0)
        {
            switch ((int)$lastmarker2open->actionbyclick)
            {
                case 0:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 1:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 2:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 3:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 4:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 5:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 10:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 11:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 12:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 13:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 14:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                case 15:
                    $scripttext .= '  marker'. $lastmarker2open->id.'.fire("click");' ."\n";
                break;
                            
                default:
                    $scripttext .= '' ."\n";
                break;
            }
        }
        else
        {
                /// ??? TODO
                
                $scripttext .= 'var contentString'. $lastmarker2open->id.' = '.
                    MapPlacemarksHelper::get_placemark_content_string(
                        $mapDivSuffix,
                        $lastmarker2open, $map->usercontact, $map->useruser,
                        $userContactAttrs, $service_DoDirection,
                        $imgpathIcons, $imgpathUtils, $directoryIcons, $map->placemark_rating, $main_lang, $placemarkTitleTag, $map->showcreateinfo,
                                                $map->gogoogle, $fv_override_gogoogle_text,
                                                $fv_placemark_date_fmt);
                $scripttext .= ';'."\n";
                /*
                $scripttext .= '  infowindow'.$mapDivSuffix.'.setContent(contentString'. $lastmarker2open->id.');' ."\n";
                $scripttext .= '  infowindow'.$mapDivSuffix.'.setPosition(latlng'. $lastmarker2open->id.');' ."\n";
                $scripttext .= '  infowindow'.$mapDivSuffix.'.open(map'.$mapDivSuffix.');' ."\n";
                */
        }

    }

        $scripttext .= $scripttext_pm_action;

    if ($placemarkSearch != 0)
    {
                if ($fv_override_placemark_list_mapping_type != 0)
                {
                    // remove new lines
                    // change comma to semicolon
                    // fix double quotes, back slash    
                    if ($fv_override_placemark_list_mapping_type == 100)
                    {
                        $fv_override_placemark_list_accent = str_replace("\\", "\\\\", str_replace("\"", "QQ", str_replace(",", ";", str_replace(array("\r", "\r\n", "\n", "\"", "\'", " "), '', $fv_override_placemark_list_accent))));
                        $fv_override_placemark_list_mapping = str_replace("\\", "\\\\", str_replace("\"", "QQ", str_replace(",", ";", str_replace(array("\r", "\r\n", "\n", "\"", "\'", " "), '', $fv_override_placemark_list_mapping))));                       
                    }
                    else
                    {
                        $fv_override_placemark_list_accent = "";
                        $fv_override_placemark_list_mapping = "";
                        
                    }
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setPlacemarkListSearchMapping('.$fv_override_placemark_list_mapping_type.','.$fv_override_placemark_list_accent_side.', "'.$fv_override_placemark_list_accent.'"'.', "'.$fv_override_placemark_list_mapping.'"'.');'."\n";
                }
        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkListSearch('.$fv_override_placemark_list_search.');'."\n";
    }
 
    if ($groupSearch != 0)
    {

                if ($fv_override_group_list_mapping_type != 0)
                {
                    // remove new lines
                    // change comma to semicolon
                    // fix double quotes, back slash    
                    if ($fv_override_group_list_mapping_type == 100)
                    {
                        $fv_override_group_list_accent = str_replace("\\", "\\\\", str_replace("\"", "QQ", str_replace(",", ";", str_replace(array("\r", "\r\n", "\n", "\"", "\'", " "), '', $fv_override_group_list_accent))));
                        $fv_override_group_list_mapping = str_replace("\\", "\\\\", str_replace("\"", "QQ", str_replace(",", ";", str_replace(array("\r", "\r\n", "\n", "\"", "\'", " "), '', $fv_override_group_list_mapping))));
                    }
                    else
                    {
                        $fv_override_group_list_accent = "";
                        $fv_override_group_list_mapping = "";
                    }
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setGroupListSearchMapping('.$fv_override_group_list_mapping_type.','.$fv_override_group_list_accent_side.', "'.$fv_override_group_list_accent.'"'.', "'.$fv_override_group_list_mapping.'"'.');'."\n";
                }            
        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.enableGroupListSearch('.$fv_override_group_list_search.');'."\n";
    }        
        
    
    // 16.08.2013 - ajax loading
    if ($zhomObjectManager != 0)
    {
        if ($ajaxLoadObjects != 0)
        {

            if ($ajaxLoadObjectType == 2)
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setPlacemarkLoadType('.$ajaxLoadObjectType.');' ."\n";
                $scripttext .= 'map'.$mapDivSuffix.'.whenReady(function() {' ."\n";
                if ($ajaxLoadObjects == 1)
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("mootools");' ."\n";
                }
                else if ($ajaxLoadObjects == 2)
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("jquery");' ."\n";
                }
                $scripttext .= '});' ."\n";    
                                
                $scripttext .= 'map'.$mapDivSuffix.'.whenReady(function() {' ."\n";
                if ($ajaxLoadObjects == 1)
                {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPathAJAX("mootools");' ."\n";
                }
                else if ($ajaxLoadObjects == 2)
                {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPathAJAX("jquery");' ."\n";
                }
                $scripttext .= '});' ."\n";    
                                
            }
            else
            {
                $scripttext .= 'map'.$mapDivSuffix.'.whenReady(function() {' ."\n";
                if ($ajaxLoadObjectType == 1)
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setPlacemarkLoadType(2);' ."\n";
                    if ($ajaxLoadObjects == 1)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("mootools");' ."\n";
                    }
                    else if ($ajaxLoadObjects == 2)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("jquery");' ."\n";
                    }
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setPlacemarkLoadType(0);' ."\n";
                    if ($ajaxLoadObjects == 1)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("mootools");' ."\n";
                    }
                    else if ($ajaxLoadObjects == 2)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("jquery");' ."\n";
                    }
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setPlacemarkLoadType('.$ajaxLoadObjectType.');' ."\n";
                }
                else
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.setPlacemarkLoadType('.$ajaxLoadObjectType.');' ."\n";
                    if ($ajaxLoadObjects == 1)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("mootools");' ."\n";
                    }
                    else if ($ajaxLoadObjects == 2)
                    {
                        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPlacemarkAJAX("jquery");' ."\n";
                    }
                }
                                
                if ($ajaxLoadObjects == 1)
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPathAJAX("mootools");' ."\n";
                }
                else if ($ajaxLoadObjects == 2)
                {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GetPathAJAX("jquery");' ."\n";
                }
                
                $scripttext .= '});' ."\n";    
                
            }
            
        }
    }
    
    // Routers
    if (isset($routers) && !empty($routers)) 
    {
        $routepanelcount = 0;
        $routepaneltotalcount = 0;
        $scripttext .= 'var directionsService = new google.maps.DirectionsService();' ."\n";

        $routeHTMLdescription ='';
        
        //Begin for each Route
        foreach ($routers as $key => $currentrouter) 
        {
            // Start Route by Address
            if ($currentrouter->route != "")
            {
                $routername ='';
                $routername = 'route'. $currentrouter->id;
                $scripttext .= 'var directionsDisplay'. $currentrouter->id.' = new google.maps.DirectionsRenderer();' ."\n";
                $scripttext .= 'directionsDisplay'. $currentrouter->id.'.setMap(map'.$mapDivSuffix.');' ."\n";

                if (isset($currentrouter->showpanel) && (int)$currentrouter->showpanel == 1) 
                {
                    $scripttext .= 'directionsDisplay'. $currentrouter->id.'.setPanel(document.getElementById("OMapsRoutePanel'.$mapDivSuffix.'"));' ."\n";
                    $routepanelcount++;
                    if (isset($currentrouter->showpaneltotal) && (int)$currentrouter->showpaneltotal == 1) 
                    {
                        $routepaneltotalcount++;
                    }
                }
                
                $cs = explode(";", $currentrouter->route);
                $cs_total = count($cs)-1;
                $cs_idx = 0;
                $wp_list = '';
                foreach($cs as $curroute)
                {    
                    if ($cs_idx == 0)
                    {
                        $scripttext .= 'var startposition='.$curroute.';'."\n";
                    }
                    else if ($cs_idx == $cs_total)
                    {
                        $scripttext .= 'var endposition='.$curroute.';'."\n";
                    }
                    else
                    {
                        if ($wp_list == '')
                        {
                            $wp_list .= '{ location: '.$curroute.', stopover:true }';
                        }
                        else
                        {
                            $wp_list .= ', '."\n".'{ location: '.$curroute.', stopover:true }';
                        }
                    }

                    $cs_idx += 1;
                }

                      
                
                $scripttext .= 'var rendererOptions'. $currentrouter->id.' = {' ."\n";
                if (isset($currentrouter->draggable))
                {
                    switch ($currentrouter->draggable) 
                    {
                    case 0:
                        $scripttext .= 'draggable:false' ."\n";
                    break;
                    case 1:
                        $scripttext .= 'draggable:true' ."\n";
                    break;
                    default:
                        $scripttext .= 'draggable:false' ."\n";
                    break;
                    }
                }
                if (isset($currentrouter->showtype))
                {
                    switch ($currentrouter->showtype) 
                    {
                    case 0:
                        $scripttext .= ', preserveViewport:false' ."\n";
                    break;
                    case 1:
                        $scripttext .= ', preserveViewport:true' ."\n";
                    break;
                    default:
                        $scripttext .= '' ."\n";
                    break;
                    }
                }

                if (isset($currentrouter->suppressmarkers))
                {
                    switch ($currentrouter->suppressmarkers) 
                    {
                    case 0:
                        $scripttext .= ', suppressMarkers:false' ."\n";
                    break;
                    case 1:
                        $scripttext .= ', suppressMarkers:true' ."\n";
                    break;
                    default:
                        $scripttext .= '' ."\n";
                    break;
                    }
                }
                
                // now you can alter route color options
                $scripttext .= ', polylineOptions: {' ."\n"; 
                $scripttext .= '    strokeColor: "'.$currentrouter->color.'"'."\n";
                $scripttext .= '  , strokeOpacity: '.$currentrouter->opacity."\n";
                $scripttext .= '  , strokeWeight: '.$currentrouter->weight."\n";
                $scripttext .= '}' ."\n";
                
                $scripttext .= '};' ."\n";
                
                $scripttext .= 'directionsDisplay'. $currentrouter->id.'.setOptions(rendererOptions'. $currentrouter->id.');' ."\n";

                $scripttext .= '  var directionsRequest'. $currentrouter->id.' = {' ."\n";
                $scripttext .= '    origin: startposition, ' ."\n";
                $scripttext .= '    destination: endposition,' ."\n";
                if ($wp_list != '')
                {
                    $scripttext .= ' waypoints: ['.$wp_list.'],'."\n";
                }
                if (isset($currentrouter->providealt) && (int)$currentrouter->providealt == 1) 
                {
                    $scripttext .= 'provideRouteAlternatives: true,' ."\n";
                } else {
                    $scripttext .= 'provideRouteAlternatives: false,' ."\n";
                }
                if (isset($currentrouter->avoidhighways) && (int)$currentrouter->avoidhighways == 1) 
                {
                    $scripttext .= 'avoidHighways: true,' ."\n";
                } else {
                    $scripttext .= 'avoidHighways: false,' ."\n";
                }
                if (isset($currentrouter->avoidtolls) && (int)$currentrouter->avoidtolls == 1) 
                {
                    $scripttext .= 'avoidTolls: true,' ."\n";
                } else {
                    $scripttext .= 'avoidTolls: false,' ."\n";
                }
                if (isset($currentrouter->optimizewaypoints) && (int)$currentrouter->optimizewaypoints == 1) 
                {
                    $scripttext .= 'optimizeWaypoints: true,' ."\n";
                } else {
                    $scripttext .= 'optimizeWaypoints: false,' ."\n";
                }

                if (isset($currentrouter->travelmode)) 
                {
                    switch ($currentrouter->travelmode) 
                    {
                    case 0:
                    break;
                    case 1:
                        $scripttext .= 'travelMode: google.maps.TravelMode.DRIVING,' ."\n";
                    break;
                    case 2:
                        $scripttext .= 'travelMode: google.maps.TravelMode.WALKING,' ."\n";
                    break;
                    case 3:
                        $scripttext .= 'travelMode: google.maps.TravelMode.BICYCLING,' ."\n";
                    break;
                    case 4:
                        $scripttext .= 'travelMode: google.maps.TravelMode.TRANSIT,' ."\n";
                    break;
                    default:
                        $scripttext .= '' ."\n";
                    break;
                    }
                }

                if (isset($currentrouter->unitsystem)) 
                {
                    switch ($currentrouter->unitsystem) 
                    {
                    case 0:
                    break;
                    case 1:
                        $scripttext .= 'unitSystem: google.maps.UnitSystem.METRIC' ."\n";
                    break;
                    case 2:
                        $scripttext .= 'unitSystem: google.maps.UnitSystem.IMPERIAL' ."\n";
                    break;
                    default:
                        $scripttext .= '' ."\n";
                    break;
                    }
                }
                $scripttext .= '  };' ."\n";

                
                if (isset($currentrouter->showpanel) && (int)$currentrouter->showpanel == 1) 
                {
                    $scripttext .= 'google.maps.event.addListener(directionsDisplay'. $currentrouter->id.', \'directions_changed\', function() {' ."\n";
                    $scripttext .= '  computeTotalDistance(directionsDisplay'. $currentrouter->id.'.directions);' ."\n";
                    $scripttext .= '});' ."\n";
                }
                
                $scripttext .= '  directionsService.route(directionsRequest'. $currentrouter->id.', function(result, status) {' ."\n";
                $scripttext .= '    if (status == google.maps.DirectionsStatus.OK) {' ."\n";
                $scripttext .= '      directionsDisplay'. $currentrouter->id.'.setDirections(result);' ."\n";
                $scripttext .= '    }' ."\n";
                $scripttext .= '    else {' ."\n";
                $scripttext .= '        alert("'.Text::_('COM_ZHOSMMAP_MAP_DIRECTION_FAILED').' " + status);' ."\n";
                $scripttext .= '    }' ."\n";
                $scripttext .= '});' ."\n";

            }
            // End Route by Address
            // Start Route by Marker
            if ($currentrouter->routebymarker != "")
            {
                $routername ='';
                $routername = 'routeByMarker'. $currentrouter->id;
                $scripttext .= 'var directionsDisplayByMarker'. $currentrouter->id.' = new google.maps.DirectionsRenderer();' ."\n";
                $scripttext .= 'directionsDisplayByMarker'. $currentrouter->id.'.setMap(map'.$mapDivSuffix.');' ."\n";

                if (isset($currentrouter->showpanel) && (int)$currentrouter->showpanel == 1) 
                {
                    $scripttext .= 'directionsDisplayByMarker'. $currentrouter->id.'.setPanel(document.getElementById("OMapsRoutePanel'.$mapDivSuffix.'"));' ."\n";
                    $routepanelcount++;
                    if (isset($currentrouter->showpaneltotal) && (int)$currentrouter->showpaneltotal == 1) 
                    {
                        $routepaneltotalcount++;
                    }
                }
                
                $cs = explode(";", $currentrouter->routebymarker);
                $cs_total = count($cs)-1;
                $cs_idx = 0;
                $wp_list = '';
                $skipRouteCreation = 0;
                foreach($cs as $curroute)
                {    
                    $currouteLatLng = MapPlacemarksHelper::get_placemark_coordinates($curroute);
                    //$scripttext .= 'alert("'.$currouteLatLng.'");'."\n";

                    if ($currouteLatLng != "")
                    {
                        if ($currouteLatLng == "geocode")
                        {
                            $scripttext .= 'alert(\''.Text::_('COM_ZHOSMMAP_MAPROUTER_FINDMARKER_ERROR_GEOCODE').' '.$curroute.'\');'."\n";
                            $skipRouteCreation = 1;
                        }
                        else
                        {
                            if ($cs_idx == 0)
                            {
                                $scripttext .= 'var startposition='.$currouteLatLng.';'."\n";
                            }
                            else if ($cs_idx == $cs_total)
                            {
                                $scripttext .= 'var endposition='.$currouteLatLng.';'."\n";
                            }
                            else
                            {
                                if ($wp_list == '')
                                {
                                    $wp_list .= '{ location: '.$currouteLatLng.', stopover:true }';
                                }
                                else
                                {
                                    $wp_list .= ', '."\n".'{ location: '.$currouteLatLng.', stopover:true }';
                                }
                            }
                        }
                    }
                    else
                    {
                        $scripttext .= 'alert(\''.Text::_('COM_ZHOSMMAP_MAPROUTER_FINDMARKER_ERROR_REASON').' '.$curroute.'\');'."\n";
                        $skipRouteCreation = 1;
                    }

                    $cs_idx += 1;
                }

                      
                if ($skipRouteCreation == 0)
                {
                    $scripttext .= 'var rendererOptionsByMarker'. $currentrouter->id.' = {' ."\n";
                    if (isset($currentrouter->draggable))
                    {
                        switch ($currentrouter->draggable) 
                        {
                        case 0:
                            $scripttext .= 'draggable:false' ."\n";
                        break;
                        case 1:
                            $scripttext .= 'draggable:true' ."\n";
                        break;
                        default:
                            $scripttext .= 'draggable:false' ."\n";
                        break;
                        }
                    }
                    if (isset($currentrouter->showtype))
                    {
                        switch ($currentrouter->showtype) 
                        {
                        case 0:
                            $scripttext .= ', preserveViewport:false' ."\n";
                        break;
                        case 1:
                            $scripttext .= ', preserveViewport:true' ."\n";
                        break;
                        default:
                            $scripttext .= '' ."\n";
                        break;
                        }
                    }

                    if (isset($currentrouter->suppressmarkers))
                    {
                        switch ($currentrouter->suppressmarkers) 
                        {
                        case 0:
                            $scripttext .= ', suppressMarkers:false' ."\n";
                        break;
                        case 1:
                            $scripttext .= ', suppressMarkers:true' ."\n";
                        break;
                        default:
                            $scripttext .= '' ."\n";
                        break;
                        }
                    }

                    // now you can alter route color options
                    $scripttext .= ', polylineOptions: {' ."\n"; 
                    $scripttext .= '    strokeColor: "'.$currentrouter->color.'"'."\n";
                    $scripttext .= '  , strokeOpacity: '.$currentrouter->opacity."\n";
                    $scripttext .= '  , strokeWeight: '.$currentrouter->weight."\n";
                    $scripttext .= '}' ."\n";    
                    

                    $scripttext .= '};' ."\n";
                    
                    $scripttext .= 'directionsDisplayByMarker'. $currentrouter->id.'.setOptions(rendererOptionsByMarker'. $currentrouter->id.');' ."\n";

                    $scripttext .= '  var directionsRequestByMarker'. $currentrouter->id.' = {' ."\n";
                    $scripttext .= '    origin: startposition, ' ."\n";
                    $scripttext .= '    destination: endposition,' ."\n";
                    if ($wp_list != '')
                    {
                        $scripttext .= ' waypoints: ['.$wp_list.'],'."\n";
                    }
                    if (isset($currentrouter->providealt) && (int)$currentrouter->providealt == 1) 
                    {
                        $scripttext .= 'provideRouteAlternatives: true,' ."\n";
                    } else {
                        $scripttext .= 'provideRouteAlternatives: false,' ."\n";
                    }
                    if (isset($currentrouter->avoidhighways) && (int)$currentrouter->avoidhighways == 1) 
                    {
                        $scripttext .= 'avoidHighways: true,' ."\n";
                    } else {
                        $scripttext .= 'avoidHighways: false,' ."\n";
                    }
                    if (isset($currentrouter->avoidtolls) && (int)$currentrouter->avoidtolls == 1) 
                    {
                        $scripttext .= 'avoidTolls: true,' ."\n";
                    } else {
                        $scripttext .= 'avoidTolls: false,' ."\n";
                    }
                    if (isset($currentrouter->optimizewaypoints) && (int)$currentrouter->optimizewaypoints == 1) 
                    {
                        $scripttext .= 'optimizeWaypoints: true,' ."\n";
                    } else {
                        $scripttext .= 'optimizeWaypoints: false,' ."\n";
                    }

                    if (isset($currentrouter->travelmode)) 
                    {
                        switch ($currentrouter->travelmode) 
                        {
                        case 0:
                        break;
                        case 1:
                            $scripttext .= 'travelMode: google.maps.TravelMode.DRIVING,' ."\n";
                        break;
                        case 2:
                            $scripttext .= 'travelMode: google.maps.TravelMode.WALKING,' ."\n";
                        break;
                        case 3:
                            $scripttext .= 'travelMode: google.maps.TravelMode.BICYCLING,' ."\n";
                        break;
                        case 4:
                            $scripttext .= 'travelMode: google.maps.TravelMode.TRANSIT,' ."\n";
                        break;
                        default:
                            $scripttext .= '' ."\n";
                        break;
                        }
                    }

                    if (isset($currentrouter->unitsystem)) 
                    {
                        switch ($currentrouter->unitsystem) 
                        {
                        case 0:
                        break;
                        case 1:
                            $scripttext .= 'unitSystem: google.maps.UnitSystem.METRIC' ."\n";
                        break;
                        case 2:
                            $scripttext .= 'unitSystem: google.maps.UnitSystem.IMPERIAL' ."\n";
                        break;
                        default:
                            $scripttext .= '' ."\n";
                        break;
                        }
                    }
                    $scripttext .= '  };' ."\n";
                    
                    if (isset($currentrouter->showpanel) && (int)$currentrouter->showpanel == 1) 
                    {
                        $scripttext .= 'google.maps.event.addListener(directionsDisplayByMarker'. $currentrouter->id.', \'directions_changed\', function() {' ."\n";
                        $scripttext .= '  computeTotalDistance(directionsDisplayByMarker'. $currentrouter->id.'.directions);' ."\n";
                        $scripttext .= '});' ."\n";
                    }
                    
                    $scripttext .= '  directionsService.route(directionsRequestByMarker'. $currentrouter->id.', function(result, status) {' ."\n";
                    $scripttext .= '    if (status == google.maps.DirectionsStatus.OK) {' ."\n";
                    $scripttext .= '      directionsDisplayByMarker'. $currentrouter->id.'.setDirections(result);' ."\n";
                    $scripttext .= '    }' ."\n";
                    $scripttext .= '    else {' ."\n";
                    $scripttext .= '        alert("'.Text::_('COM_ZHOSMMAP_MAP_DIRECTION_FAILED').' " + status);' ."\n";
                    $scripttext .= '    }' ."\n";
                    $scripttext .= '});' ."\n";

                }
            }
            // End Route by Marker

            if (isset($currentrouter->showdescription) && (int)$currentrouter->showdescription == 1) 
            {
                if ($currentrouter->description != "")
                {
                    $routeHTMLdescription .= '<h2>';
                    $routeHTMLdescription .= htmlspecialchars($currentrouter->description, ENT_QUOTES, 'UTF-8');
                    $routeHTMLdescription .= '</h2>';
                }
                if ($currentrouter->descriptionhtml != "")
                {
                    $routeHTMLdescription .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentrouter->descriptionhtml));
                }
            }
            
        }
        // End for each Route
        
        if ($routepanelcount > 1 || $routepanelcount == 0 || $routepaneltotalcount == 0)
        {
            $scripttext .= 'var toHideRouteDiv = document.getElementById("OMapsRoutePanel_Total'.$mapDivSuffix.'");' ."\n";
            $scripttext .= 'toHideRouteDiv.style.display = "none";' ."\n";
            //$scripttext .= 'alert("Hide because > 1 or = 0");';
        }

        if ($routeHTMLdescription != "")
        {
            $scripttext .= '  document.getElementById("OMapsRoutePanel_Description'.$mapDivSuffix.'").innerHTML =  "<p>'. $routeHTMLdescription .'</p>";'."\n";
        }
        
        $scripttext .= 'function computeTotalDistance(result) {' ."\n";
        if ($routepaneltotalcount == 1)
        {
            $scripttext .= '  var total = 0;' ."\n";
            $scripttext .= '  var myroute = result.routes[0];' ."\n";
            $scripttext .= '  for (i = 0; i < myroute.legs.length; i++) {' ."\n";
            $scripttext .= '      total += myroute.legs[i].distance.value;' ."\n";
            $scripttext .= '  }' ."\n";
            $scripttext .= '  total = total / 1000.;' ."\n";
            $scripttext .= '  total = total.toFixed(1);' ."\n";
            
            $scripttext .= '  document.getElementById("OMapsRoutePanel_Total'.$mapDivSuffix.'").innerHTML = "<p>'.Text::_('COM_ZHOSMMAP_MAPROUTER_DETAIL_SHOWPANEL_HDR_TOTAL').' " + total + " '.Text::_('COM_ZHOSMMAP_MAPROUTER_DETAIL_SHOWPANEL_HDR_KM').'</p>";' ."\n";
        }
        $scripttext .= '};' ."\n";
        
    }


    // Paths
    if (isset($paths) && !empty($paths)) 
    {
        foreach ($paths as $key => $currentpath) 
        {

            $scripttext .= 'var contentPathString'. $currentpath->id.' = "";'."\n";
                    if ((isset($map->useajax) && (int)$map->useajax != 0)
                     && !(isset($currentpath->data_id) && (int)$currentpath->data_id != 0) )
                    {
                        // do not create content string, create by loop only in the end
                    }
                    else
                    {
                        if ((int)$currentpath->actionbyclick == 1)
                        {
                                // contentPathString - Begin
                                $scripttext .= 'contentPathString'. $currentpath->id.' = '.
                                                        MapPathsHelper::get_path_content_string(
                                                                $mapDivSuffix,
                                                                $currentpath, 
                                                                $imgpathIcons, $imgpathUtils, $directoryIcons, $main_lang, $placemarkTitleTag);
                                // contentPathString - End
                        }    
                    }

                    $returnText = '';
                    require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                    $scripttext .= $returnText;
                    
                    $returnText = '';
                    require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path_layers.php';
                    $scripttext .= $returnText;
                    
                    if (isset($currentpath->objecttype))
                    {
                        // visualization for paths
                        if (isset($currentpath->data_id) && (int)$currentpath->data_id != 0) 
                        {
                            $fv_datasql = MapPathsHelper::get_DataSQL($currentpath->data_id);
                            if (isset($fv_datasql) && (int)$fv_datasql->published == 1)
                            {
                                //$scripttext .= "alert(\"datasql done\");";
                                if (isset($fv_datasql->struct_id) && (int)$fv_datasql->struct_id != 0) 
                                {
                                    $fv_struct = MapPathsHelper::get_VisualizationStructure($fv_datasql->struct_id);
                                    if (isset($fv_struct) && (int)$fv_struct->published == 1)
                                    {
                                        
                                        //$scripttext .= "alert(\"struct done\");";
                                        if ($fv_struct->lat_lng_sep != "")
                                        {
                                                $fv_path_coords_sep = $fv_struct->lat_lng_sep; 
                                        }
                                        else
                                        {
                                                $fv_path_coords_sep = ",";
                                        }
                                        if ($fv_struct->lat_lng_order != ""
                                        && ((int)$fv_struct->lat_lng_order == 0 || (int)$fv_struct->lat_lng_order == 1))
                                        {
                                                $fv_path_coords_order = (int)$fv_struct->lat_lng_order; 
                                        }
                                        else
                                        {
                                                $fv_path_coords_order = 0;
                                        }
                                        if ($fv_struct->lat_lng_array_sep != "")
                                        {
                                                $fv_path_array_coords_sep = $fv_struct->lat_lng_array_sep; 
                                        }
                                        else
                                        {
                                                $fv_path_array_coords_sep = ";";
                                        }
                                        if ((int)$fv_datasql->query_type == 0)
                                        {
                                            $fv_sql_text_clause = str_replace(':userid', $currentUser->id, $fv_datasql->sql_text_clause);
                                            $fv_data_path = MapPathsHelper::get_DataSQL_Data($fv_sql_text_clause, $fv_datasql->server_id);
                                            //$scripttext .= "alert(\"data done\");";
                                            if (isset($fv_data_path) and !empty($fv_data_path))
                                            {
                                                //$scripttext .= "alert(\"process data\");";
                                                
                                                $current_path_placemark_id = $currentpath->id * 100000000;
                                                $current_path_path_id = $currentpath->id * 100000000;
                                                $current_path_main_id = $currentpath->id;
                                                
                                                if ((int)$currentpath->objecttype == 0)  // LINE
                                                {
                                                 
                                                    if ((int)$fv_struct->result_object_type == 0) // one object
                                                    {
                                                        $fv_path_array = [];
                                                        $markers_line = [];
                                                        $current_pair = "";
                                                        //$scripttext .= "alert(\"Line\");";
                                                        foreach ($fv_data_path as $key => $current_data_path) 
                                                        {
                                                            if ($fv_struct->latitude != ""
                                                             && $fv_struct->longitude != "")
                                                            {
                                                                $fv_struct_lat = $fv_struct->latitude;
                                                                $fv_struct_lng = $fv_struct->longitude;
                                                                $fv_data_lat = trim($current_data_path[$fv_struct_lat]);
                                                                $fv_data_lng = trim($current_data_path[$fv_struct_lng]);
                                                                if ($fv_data_lat != ""
                                                                 && $fv_data_lng != "")
                                                                {
                                                                    if ($current_pair == "")
                                                                    {
                                                                        if ((int)$fv_struct->start_baloon != 0)
                                                                        {
                                                                            $mrk_row = [];
                                                                            $mrk_row["latitude"] = $fv_data_lat;
                                                                            $mrk_row["longitude"] = $fv_data_lng;
                                                                            
                                                                            $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                            $mrk_row["published"] = $currentpath->published;
                                                                            $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                            $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                            $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                            $mrk_row["mapid"] = $currentpath->mapid;
                                                                            $mrk_row["markergroup"] = $currentpath->markergroup;
                                                                            
                                                                            $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                            $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                            $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                            $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                            $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                            $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                            $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                            $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;
                                                                            
                                                                            $mrk_row["baloon"] = $fv_struct->start_baloon;
                                                                            $mrk_row["icontype"] = $fv_struct->start_icontype;
                                                                            $mrk_row["iconofsetx"] = $fv_struct->start_iconofsetx;
                                                                            $mrk_row["iconofsety"] = $fv_struct->start_iconofsety;
                                                                            $mrk_row["descriptionhtml"] = $fv_struct->start_descriptionhtml;  
                                                                            
                                                                            if ($fv_struct->createddate != "")
                                                                            {
                                                                                $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                            }

                                                                            if (isset($fv_struct->start_title) && $fv_struct->start_title != "")
                                                                            {
                                                                                $mrk_row["title"] = $fv_struct->start_title;
                                                                            }
                                                                            else
                                                                            {
                                                                                $mrk_row["title"] = $currentpath->title;
                                                                            }
                                                                            if (isset($fv_struct->start_description) && $fv_struct->start_description != "")
                                                                            {
                                                                                $mrk_row["description"] = $fv_struct->start_description;
                                                                            }
                                                                            else
                                                                            {
                                                                                $mrk_row["description"] = $currentpath->description;
                                                                            }

                                                                            array_push($markers_line, (object)$mrk_row);
                                                                        }
                                                                    }
                                                                    $current_pair = $fv_data_lat . ',' . $fv_data_lng;
                                                                    array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                } 
                                                                                                                        
                                                            }
                                                            else if ($fv_struct->lat_lng != "")
                                                            {
                                                                $fv_struct_lat_lng = $fv_struct->lat_lng;
                                                                if ($current_data_path[$fv_struct_lat_lng] != "")
                                                                {    
                                                                    $fv_path_coords = explode($fv_path_coords_sep, $current_data_path[$fv_struct_lat_lng]);
                                                                    $fv_data_c0 = trim($fv_path_coords[0]);
                                                                    $fv_data_c1 = trim($fv_path_coords[1]);
                                                                    if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                    {
                                                                        if ($fv_path_coords_order == 0)
                                                                        {
                                                                            $fv_data_lat = $fv_data_c0;
                                                                            $fv_data_lng = $fv_data_c1;
                                                                        }
                                                                        else
                                                                        {
                                                                            $fv_data_lat = $fv_data_c1;
                                                                            $fv_data_lng = $fv_data_c0;
                                                                        }
                                                                        
                                                                        if ($current_pair == "")
                                                                        {
                                                                            if ((int)$fv_struct->start_baloon != 0)
                                                                            {
                                                                                $mrk_row = [];
                                                                                $mrk_row["latitude"] = $fv_data_lat;
                                                                                $mrk_row["longitude"] = $fv_data_lng;
                                                                                
                                                                                $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                                $mrk_row["published"] = $currentpath->published;
                                                                                $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                                $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                                $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                                $mrk_row["mapid"] = $currentpath->mapid;
                                                                                $mrk_row["markergroup"] = $currentpath->markergroup;
                                                                                
                                                                                $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                                $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                                $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                                $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                                $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                                $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                                $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                                $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;

                                                                                $mrk_row["baloon"] = $fv_struct->start_baloon;
                                                                                $mrk_row["icontype"] = $fv_struct->start_icontype;
                                                                                $mrk_row["iconofsetx"] = $fv_struct->start_iconofsetx;
                                                                                $mrk_row["iconofsety"] = $fv_struct->start_iconofsety;
                                                                                $mrk_row["descriptionhtml"] = $fv_struct->start_descriptionhtml;
                                                                                
                                                                                if ($fv_struct->createddate != "")
                                                                                {
                                                                                    $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                                }
                                                                                
                                                                                if (isset($fv_struct->start_title) && $fv_struct->start_title != "")
                                                                                {
                                                                                    $mrk_row["title"] = $fv_struct->start_title;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $mrk_row["title"] = $currentpath->title;
                                                                                }
                                                                                if (isset($fv_struct->start_description) && $fv_struct->start_description != "")
                                                                                {
                                                                                    $mrk_row["description"] = $fv_struct->start_description;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $mrk_row["description"] = $currentpath->description;
                                                                                }
                                                                                
                                                                                array_push($markers_line, (object)$mrk_row);
                                                                            }
                                                                        }
                                                                        $current_pair = $fv_data_lat . ',' . $fv_data_lng;
                                                                        array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                    }
                                                                }
                                                            }
                                                            else if ($fv_struct->lat_lng_array != "")
                                                            {
                                                                $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                                if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                                {    
                                                                    
                                                                    $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                                    foreach ($fv_path_pairs as $key => $current_data_path) 
                                                                    {
                                                                        if ($fv_path_pairs != "")
                                                                        {
                                                                            $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                            $fv_data_c0 = trim($fv_path_coords[0]);
                                                                            $fv_data_c1 = trim($fv_path_coords[1]);
                                                                            if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                            {
                                                                                if ($fv_path_coords_order == 0)
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c0;
                                                                                    $fv_data_lng = $fv_data_c1;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c1;
                                                                                    $fv_data_lng = $fv_data_c0;
                                                                                }

                                                                                if ($current_pair == "")
                                                                                {
                                                                                    if ((int)$fv_struct->start_baloon != 0)
                                                                                    {
                                                                                        $mrk_row = [];
                                                                                        $mrk_row["latitude"] = $fv_data_lat;
                                                                                        $mrk_row["longitude"] = $fv_data_lng;
                                                                                        
                                                                                        $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                                        $mrk_row["published"] = $currentpath->published;
                                                                                        $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                                        $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                                        $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                                        $mrk_row["mapid"] = $currentpath->mapid;
                                                                                        $mrk_row["markergroup"] = $currentpath->markergroup;
                                                                                        
                                                                                        $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                                        $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                                        $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                                        $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                                        $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                                        $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                                        $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                                        $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;
                                                                            
                                                                                        $mrk_row["baloon"] = $fv_struct->start_baloon;
                                                                                        $mrk_row["icontype"] = $fv_struct->start_icontype;
                                                                                        $mrk_row["iconofsetx"] = $fv_struct->start_iconofsetx;
                                                                                        $mrk_row["iconofsety"] = $fv_struct->start_iconofsety;
                                                                                        $mrk_row["descriptionhtml"] = $fv_struct->start_descriptionhtml;
                                                                                        
                                                                                        if ($fv_struct->createddate != "")
                                                                                        {
                                                                                            $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                                        }

                                                                                        if (isset($fv_struct->start_title) && $fv_struct->start_title != "")
                                                                                        {
                                                                                            $mrk_row["title"] = $fv_struct->start_title;
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            $mrk_row["title"] = $currentpath->title;
                                                                                        }
                                                                                        if (isset($fv_struct->start_description) && $fv_struct->start_description != "")
                                                                                        {
                                                                                            $mrk_row["description"] = $fv_struct->start_description;
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            $mrk_row["description"] = $currentpath->description;
                                                                                        }
                                                                                        
                                                                                        array_push($markers_line, (object)$mrk_row);
                                                                                    }
                                                                                }
                                                                                $current_pair = $fv_data_lat . ',' . $fv_data_lng;
                                                                                array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                
                                                            }

                                                        }
                                                        
                                                        if ($current_pair != "")
                                                        {
                                                            if ((int)$fv_struct->end_baloon != 0)
                                                            {
                                                                $current_pairs = explode(',', $current_pair);
                                                                $mrk_row = [];
                                                                $mrk_row["latitude"] = $current_pairs[0];
                                                                $mrk_row["longitude"] = $current_pairs[1];
                                                                
                                                                $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                $mrk_row["published"] = $currentpath->published;
                                                                $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                $mrk_row["mapid"] = $currentpath->mapid;
                                                                $mrk_row["markergroup"] = $currentpath->markergroup;

                                                                $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;

                                                                $mrk_row["baloon"] = $fv_struct->end_baloon;
                                                                $mrk_row["icontype"] = $fv_struct->end_icontype;
                                                                $mrk_row["iconofsetx"] = $fv_struct->end_iconofsetx;
                                                                $mrk_row["iconofsety"] = $fv_struct->end_iconofsety;
                                                                $mrk_row["descriptionhtml"] = $fv_struct->end_descriptionhtml;
                                                                
                                                                if ($fv_struct->createddate != "")
                                                                {
                                                                    $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                }

                                                                if (isset($fv_struct->end_title) && $fv_struct->end_title != "")
                                                                {
                                                                    $mrk_row["title"] = $fv_struct->end_title;
                                                                }
                                                                else
                                                                {
                                                                    $mrk_row["title"] = $currentpath->title;
                                                                }
                                                                if (isset($fv_struct->end_description) && $fv_struct->end_description != "")
                                                                {
                                                                    $mrk_row["description"] = $fv_struct->end_description;
                                                                }
                                                                else
                                                                {
                                                                    $mrk_row["description"] = $currentpath->description;
                                                                }

                                                                array_push($markers_line, (object)$mrk_row);
                                                            }
                                                        }
                                                        
                                                        // backup is done, just disable                                                            
                                                        $map->useajax = 0;
                                                        $map->useajaxobject = 0;

                                                        if (count($fv_path_array) > 1)
                                                        {
                                                            $current_path_path_id += 1;
                                                            $currentpath->id = $current_path_path_id;
                                                            
                                                            $fv_path_array_text = implode(";", $fv_path_array);
                                                            $currentpath->path = $fv_path_array_text;
                                                            
                                                            $scripttext .= 'contentPathString'. $currentpath->id.' = '.'contentPathString'. $current_path_main_id.';'."\n";

                                                            $returnText = '';
                                                            require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                                                            $scripttext .= $returnText;
                                                            $fv_path_array = [];
                                                        }
                                                        
                                                        // restore
                                                        $map->useajax = $backup_useajax;
                                                        $map->useajaxobject = $backup_useajaxobject;
                                                        
                                                        // backup is done, just disable                                                            
                                                        $map->useajax = 0;
                                                        $map->useajaxobject = 0;
                                                        
                                                        if (count($markers_line) > 0)
                                                        {
                                                            foreach ($markers_line as $key => $currentmarker) 
                                                            {
                                                                $current_path_placemark_id += 1;
                                                                $currentmarker->id = $current_path_placemark_id;
                                                                
                                                                $returnText = '';
                                                                require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_placemark.php';
                                                                $scripttext .= $returnText;
                                                            }
                                                            $markers_line = [];
                                                        }
                                                            
                                                        // restore
                                                        $map->useajax = $backup_useajax;
                                                        $map->useajaxobject = $backup_useajaxobject;
                                                        
                                                    }
                                                    else if ((int)$fv_struct->result_object_type == 1) // each object
                                                    {
                                                        foreach ($fv_data_path as $key => $current_data_path) 
                                                        {
                                                            $fv_path_array = [];
                                                            $markers_line = [];
                                                            $current_pair = "";
                                                            if ($fv_struct->lat_lng_array != "")
                                                            {
                                                                $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                                if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                                {    

                                                                    $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                                    foreach ($fv_path_pairs as $key => $current_data_path) 
                                                                    {
                                                                        if ($fv_path_pairs != "")
                                                                        {
                                                                            $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                            $fv_data_c0 = trim($fv_path_coords[0]);
                                                                            $fv_data_c1 = trim($fv_path_coords[1]);
                                                                            if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                            {
                                                                                if ($fv_path_coords_order == 0)
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c0;
                                                                                    $fv_data_lng = $fv_data_c1;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c1;
                                                                                    $fv_data_lng = $fv_data_c0;
                                                                                }

                                                                                if ($current_pair == "")
                                                                                {
                                                                                    if ((int)$fv_struct->start_baloon != 0)
                                                                                    {
                                                                                        $mrk_row = [];
                                                                                        $mrk_row["latitude"] = $fv_data_lat;
                                                                                        $mrk_row["longitude"] = $fv_data_lng;
                                                                                        
                                                                                        $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                                        $mrk_row["published"] = $currentpath->published;
                                                                                        $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                                        $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                                        $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                                        $mrk_row["mapid"] = $currentpath->mapid;
                                                                                        $mrk_row["markergroup"] = $currentpath->markergroup;
                                                                                        
                                                                                        $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                                        $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                                        $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                                        $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                                        $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                                        $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                                        $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                                        $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;
                                                                            
                                                                                        $mrk_row["baloon"] = $fv_struct->start_baloon;
                                                                                        $mrk_row["icontype"] = $fv_struct->start_icontype;
                                                                                        $mrk_row["iconofsetx"] = $fv_struct->start_iconofsetx;
                                                                                        $mrk_row["iconofsety"] = $fv_struct->start_iconofsety;
                                                                                        $mrk_row["descriptionhtml"] = $fv_struct->start_descriptionhtml;
                                                                                        
                                                                                        if ($fv_struct->createddate != "")
                                                                                        {
                                                                                            $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                                        }

                                                                                        if (isset($fv_struct->start_title) && $fv_struct->start_title != "")
                                                                                        {
                                                                                            $mrk_row["title"] = $fv_struct->start_title;
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            $mrk_row["title"] = $currentpath->title;
                                                                                        }
                                                                                        if (isset($fv_struct->start_description) && $fv_struct->start_description != "")
                                                                                        {
                                                                                            $mrk_row["description"] = $fv_struct->start_description;
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            $mrk_row["description"] = $currentpath->description;
                                                                                        }
                                                                                        array_push($markers_line, (object)$mrk_row);
                                                                                    }
                                                                                }
                                                                                $current_pair = $fv_data_lat . ',' . $fv_data_lng;
                                                                                array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                // do nothing due to wrong shape
                                                            }
                                                            
                                                            if ($current_pair != "")
                                                            {
                                                                if ((int)$fv_struct->end_baloon != 0)
                                                                {
                                                                    $current_pairs = explode(',', $current_pair);
                                                                    $mrk_row = [];
                                                                    $mrk_row["latitude"] = $current_pairs[0];
                                                                    $mrk_row["longitude"] = $current_pairs[1];
                                                                    
                                                                    $mrk_row["actionbyclick"] = $currentpath->actionbyclick;
                                                                    $mrk_row["published"] = $currentpath->published;
                                                                    $mrk_row["markercontent"] = $currentpath->infowincontent;
                                                                    $mrk_row["hrefsite"] = $currentpath->hrefsite;
                                                                    $mrk_row["hrefsitename"] = $currentpath->hrefsitename;
                                                                    $mrk_row["mapid"] = $currentpath->mapid;
                                                                    $mrk_row["markergroup"] = $currentpath->markergroup;
                                                                    
                                                                    $mrk_row["groupicontype"] = $currentpath->groupicontype;
                                                                    $mrk_row["overridemarkericon"] = $currentpath->overridemarkericon;
                                                                    $mrk_row["publishedgroup"] = $currentpath->publishedgroup;
                                                                    $mrk_row["markermanagerminzoom"] = $currentpath->markermanagerminzoom;
                                                                    $mrk_row["markermanagermaxzoom"] = $currentpath->markermanagermaxzoom;
                                                                    $mrk_row["activeincluster"] = $currentpath->activeincluster;
                                                                    $mrk_row["groupiconofsetx"] = $currentpath->groupiconofsetx;
                                                                    $mrk_row["groupiconofsety"] = $currentpath->groupiconofsety;
                                                                            
                                                                    $mrk_row["baloon"] = $fv_struct->end_baloon;
                                                                    $mrk_row["icontype"] = $fv_struct->end_icontype;
                                                                    $mrk_row["iconofsetx"] = $fv_struct->end_iconofsetx;
                                                                    $mrk_row["iconofsety"] = $fv_struct->end_iconofsety;
                                                                    $mrk_row["descriptionhtml"] = $fv_struct->end_descriptionhtml;
                                                                    
                                                                    if ($fv_struct->createddate != "")
                                                                    {
                                                                        $mrk_row["createddate"] = $current_data_path[$fv_struct->createddate];
                                                                    }
                                                                    
                                                                    if (isset($fv_struct->end_title) && $fv_struct->end_title != "")
                                                                    {
                                                                        $mrk_row["title"] = $fv_struct->end_title;
                                                                    }
                                                                    else
                                                                    {
                                                                        $mrk_row["title"] = $currentpath->title;
                                                                    }
                                                                    if (isset($fv_struct->end_description) && $fv_struct->end_description != "")
                                                                    {
                                                                        $mrk_row["description"] = $fv_struct->end_description;
                                                                    }
                                                                    else
                                                                    {
                                                                        $mrk_row["description"] = $currentpath->description;
                                                                    }

                                                                    array_push($markers_line, (object)$mrk_row);
                                                                }
                                                            }
                                                            
                                                            // backup is done, just disable                                                            
                                                            $map->useajax = 0;
                                                            $map->useajaxobject = 0;
                                                            
                                                            if (count($fv_path_array) > 1)
                                                            {
                                                                $current_path_path_id += 1;
                                                                $currentpath->id = $current_path_path_id;                                                           
                                                            
                                                                $fv_path_array_text = implode(";", $fv_path_array);
                                                                $currentpath->path = $fv_path_array_text;
                                                                
                                                                $scripttext .= 'contentPathString'. $currentpath->id.' = '.'contentPathString'. $current_path_main_id.';'."\n";

                                                                $returnText = '';
                                                                require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                                                                $scripttext .= $returnText;
                                                                $fv_path_array = [];
                                                            }
                                                            
                                                            // restore
                                                            $map->useajax = $backup_useajax;
                                                            $map->useajaxobject = $backup_useajaxobject;
                                                            
                                                            // backup is done, just disable                                                            
                                                            $map->useajax = 0;
                                                            $map->useajaxobject = 0;
                                                            
                                                            
                                                            if (count($markers_line) > 0)
                                                            {
                                                                foreach ($markers_line as $key => $currentmarker) 
                                                                {
                                                                    $current_path_placemark_id += 1;
                                                                    $currentmarker->id = $current_path_placemark_id;
                                                    
                                                                    $returnText = '';
                                                                    require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_placemark.php';
                                                                    $scripttext .= $returnText;
                                                                }
                                                                $markers_line = [];
                                                            }
                                                            
                                                            // restore
                                                            $map->useajax = $backup_useajax;
                                                            $map->useajaxobject = $backup_useajaxobject;
                                                        }
                                                    
                                                        
                                                    }
                                                    else 
                                                    {
                                                        // unexpected value
                                                    }
                                                   
                                                }
                                                else if ($currentpath->objecttype == 1)  //POLYGON
                                                {
                                                    
                                                    if ((int)$fv_struct->result_object_type == 0) // one object
                                                    {
                                                        $fv_path_array = [];
                                                        //$scripttext .= "alert(\"Polygon\");";
                                                        foreach ($fv_data_path as $key => $current_data_path) 
                                                        {
                                                            if ($fv_struct->latitude != ""
                                                             && $fv_struct->longitude != "")
                                                            {
                                                                $fv_struct_lat = $fv_struct->latitude;
                                                                $fv_struct_lng = $fv_struct->longitude;
                                                                $fv_data_lat = trim($current_data_path[$fv_struct_lat]);
                                                                $fv_data_lng = trim($current_data_path[$fv_struct_lng]);
                                                                if ($fv_data_lat != ""
                                                                 && $fv_data_lng != "")
                                                                {
                                                                    array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                } 
                                                                                                                        
                                                            }
                                                            else if ($fv_struct->lat_lng != "")
                                                            {
                                                                $fv_struct_lat_lng = $fv_struct->lat_lng;
                                                                if ($current_data_path[$fv_struct_lat_lng] != "")
                                                                {    
                                                                    $fv_path_coords = explode($fv_path_coords_sep, $current_data_path[$fv_struct_lat_lng]);
                                                                    $fv_data_c0 = trim($fv_path_coords[0]);
                                                                    $fv_data_c1 = trim($fv_path_coords[1]);
                                                                    if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                    {
                                                                        if ($fv_path_coords_order == 0)
                                                                        {
                                                                            $fv_data_lat = $fv_data_c0;
                                                                            $fv_data_lng = $fv_data_c1;
                                                                        }
                                                                        else
                                                                        {
                                                                            $fv_data_lat = $fv_data_c1;
                                                                            $fv_data_lng = $fv_data_c0;
                                                                        }
                                                                        
                                                                        array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                    }
                                                                }
                                                            }
                                                            else if ($fv_struct->lat_lng_array != "")
                                                            {
                                                                $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                                if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                                {    
                                                                    
                                                                    $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                                    foreach ($fv_path_pairs as $key => $current_data_path) 
                                                                    {
                                                                        if ($fv_path_pairs != "")
                                                                        {
                                                                            $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                            $fv_data_c0 = trim($fv_path_coords[0]);
                                                                            $fv_data_c1 = trim($fv_path_coords[1]);
                                                                            if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                            {
                                                                                if ($fv_path_coords_order == 0)
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c0;
                                                                                    $fv_data_lng = $fv_data_c1;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c1;
                                                                                    $fv_data_lng = $fv_data_c0;
                                                                                }

                                                                                array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                
                                                            }
                                                        }                                                      
                                                        
                                                        // backup is done, just disable                                                            
                                                        $map->useajax = 0;
                                                        $map->useajaxobject = 0;
                                                            
                                                        if (count($fv_path_array) > 1)
                                                        {
                                                            $current_path_path_id += 1;
                                                            $currentpath->id = $current_path_path_id;
                                                                                                                        
                                                            $fv_path_array_text = implode(";", $fv_path_array);
                                                            $currentpath->path = $fv_path_array_text;
                                                            
                                                            $scripttext .= 'contentPathString'. $currentpath->id.' = '.'contentPathString'. $current_path_main_id.';'."\n";

                                                            $returnText = '';
                                                            require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                                                            $scripttext .= $returnText;
                                                            $fv_path_array = [];
                                                        }
                                                        
                                                        // restore
                                                        $map->useajax = $backup_useajax;
                                                        $map->useajaxobject = $backup_useajaxobject;
                                                            
                                                    }
                                                    else if ((int)$fv_struct->result_object_type == 1) // each object
                                                    {
                                                        foreach ($fv_data_path as $key => $current_data_path) 
                                                        {
                                                            $fv_path_array = [];
                                                            if ($fv_struct->lat_lng_array != "")
                                                            {
                                                                $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                                if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                                {    

                                                                    $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                                    foreach ($fv_path_pairs as $key => $current_data_path) 
                                                                    {
                                                                        if ($fv_path_pairs != "")
                                                                        {
                                                                            $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                            $fv_data_c0 = trim($fv_path_coords[0]);
                                                                            $fv_data_c1 = trim($fv_path_coords[1]);
                                                                            if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                            {
                                                                                if ($fv_path_coords_order == 0)
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c0;
                                                                                    $fv_data_lng = $fv_data_c1;
                                                                                }
                                                                                else
                                                                                {
                                                                                    $fv_data_lat = $fv_data_c1;
                                                                                    $fv_data_lng = $fv_data_c0;
                                                                                }

                                                                                array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                // do nothing due to wrong shape
                                                            }
                                                            
                                                            // backup is done, just disable                                                            
                                                            $map->useajax = 0;
                                                            $map->useajaxobject = 0;

                                                            if (count($fv_path_array) > 1)
                                                            {
                                                                $current_path_path_id += 1;
                                                                $currentpath->id = $current_path_path_id;
                                                                                                                       
                                                                $fv_path_array_text = implode(";", $fv_path_array);
                                                                $currentpath->path = $fv_path_array_text;
                                                                
                                                                $scripttext .= 'contentPathString'. $currentpath->id.' = '.'contentPathString'. $current_path_main_id.';'."\n";

                                                                $returnText = '';
                                                                require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                                                                $scripttext .= $returnText;
                                                                $fv_path_array = [];
                                                            }
                                                            
                                                            // restore
                                                            $map->useajax = $backup_useajax;
                                                            $map->useajaxobject = $backup_useajaxobject;
                                                        }
                                                    }
                                                    else 
                                                    {
                                                        // unexpected value
                                                    }
                                                                                                       
                                                    
                                                }
                                                else if ($currentpath->objecttype == 2)  //CIRCLE
                                                {
                                                    // do not process result_object_type, because it is points (circle center)
                                                    // $fv_struct->result_object_type
                                                    
                                                    //$scripttext .= "alert(\"Circle\");";
                                                    $fv_path_array = [];
                                                    foreach ($fv_data_path as $key => $current_data_path) 
                                                    {
                                                        if ($fv_struct->latitude != ""
                                                         && $fv_struct->longitude != "")
                                                        {
                                                            $fv_struct_lat = $fv_struct->latitude;
                                                            $fv_struct_lng = $fv_struct->longitude;
                                                            $fv_data_lat = trim($current_data_path[$fv_struct_lat]);
                                                            $fv_data_lng = trim($current_data_path[$fv_struct_lng]);
                                                            if ($fv_data_lat != ""
                                                             && $fv_data_lng != "")
                                                            {
                                                                array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                            } 

                                                        }
                                                        else if ($fv_struct->lat_lng != "")
                                                        {
                                                            $fv_struct_lat_lng = $fv_struct->lat_lng;
                                                            if ($current_data_path[$fv_struct_lat_lng] != "")
                                                            {    
                                                                $fv_path_coords = explode($fv_path_coords_sep, $current_data_path[$fv_struct_lat_lng]);
                                                                $fv_data_c0 = trim($fv_path_coords[0]);
                                                                $fv_data_c1 = trim($fv_path_coords[1]);
                                                                if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                {
                                                                    if ($fv_path_coords_order == 0)
                                                                    {
                                                                        $fv_data_lat = $fv_data_c0;
                                                                        $fv_data_lng = $fv_data_c1;
                                                                    }
                                                                    else
                                                                    {
                                                                        $fv_data_lat = $fv_data_c1;
                                                                        $fv_data_lng = $fv_data_c0;
                                                                    }

                                                                    array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                }
                                                            }
                                                        }
                                                        else if ($fv_struct->lat_lng_array != "")
                                                        {
                                                            $fv_struct_lat_lng_array = $fv_struct->lat_lng_array;
                                                            if ($current_data_path[$fv_struct_lat_lng_array] != "")
                                                            {    

                                                                $fv_path_pairs = explode($fv_path_array_coords_sep, $current_data_path[$fv_struct_lat_lng_array]);
                                                                foreach ($fv_path_pairs as $key => $current_data_path) 
                                                                {
                                                                    if ($fv_path_pairs != "")
                                                                    {
                                                                        $fv_path_coords = explode($fv_path_coords_sep, $current_data_path);
                                                                        $fv_data_c0 = trim($fv_path_coords[0]);
                                                                        $fv_data_c1 = trim($fv_path_coords[1]);
                                                                        if ($fv_data_c0 != "" && $fv_data_c1 != "")
                                                                        {
                                                                            if ($fv_path_coords_order == 0)
                                                                            {
                                                                                $fv_data_lat = $fv_data_c0;
                                                                                $fv_data_lng = $fv_data_c1;
                                                                            }
                                                                            else
                                                                            {
                                                                                $fv_data_lat = $fv_data_c1;
                                                                                $fv_data_lng = $fv_data_c0;
                                                                            }

                                                                            array_push($fv_path_array, $fv_data_lat . ',' . $fv_data_lng);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        else
                                                        {

                                                        }
                                                    }

                                                    // backup is done, just disable                                                            
                                                    $map->useajax = 0;
                                                    $map->useajaxobject = 0;
                                                            
                                                    if (count($fv_path_array) != 0)
                                                    {
                                                        $current_path_path_id += 1;
                                                        $currentpath->id = $current_path_path_id;                                                            
                                                            
                                                        $fv_path_array_text = implode(";", $fv_path_array);
                                                        $currentpath->path = $fv_path_array_text;
                                                        
                                                        $scripttext .= 'contentPathString'. $currentpath->id.' = '.'contentPathString'. $current_path_main_id.';'."\n";

                                                        $returnText = '';
                                                        require JPATH_SITE . '/components/com_zhosmmap/tmpl/map/process_path.php';
                                                        $scripttext .= $returnText;
                                                        $fv_path_array = [];
                                                    }
                                                    
                                                    // restore
                                                    $map->useajax = $backup_useajax;
                                                    $map->useajaxobject = $backup_useajaxobject;
                                                    
                                                }
                                                else
                                                {
                                                    
                                                }
                                                
                                                
                                            }
                                            //else 
                                            //{
                                            //    $scripttext .= "console.log(\"Visualization Array is empty\");"."\n";
                                            //}
                                        }

                                    }
                                    //else
                                    //{
                                    //    $scripttext .= "console.log(\"Visualization Structure is not published\");"."\n";
                                    //}
                                }
                                //else
                                //{
                                //    $scripttext .= "console.log(\"Visualization Structure for path with ID ".$currentpath->id." is not defined and Data SQL with ID ".$currentpath->data_id."\");"."\n";
                                //}
                            }
                            //else
                            //{
                            //    $scripttext .= "console.log(\"Data SQL is not published\");"."\n";
                            //}
                        }
                        //else
                        //{
                        //    $scripttext .= "console.log(\"Data SQL for path with ID ".$currentpath->id." is not defined\");"."\n";
                        //}

                    }
        } // end path loop

    }
        
    if (isset($map->useajax) && (int)$map->useajax != 0) 
    {

            $scripttext .= 'for (var i=0; i<ajaxpaths'.$mapDivSuffix.'.length; i++)' ."\n";
            $scripttext .= '{' ."\n";
            if ((int)$map->useajax == 1)
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddListeners("mootools", ajaxpaths'.$mapDivSuffix.'[i]);' ."\n";
            }
            else
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddListeners("jquery", ajaxpaths'.$mapDivSuffix.'[i]);' ."\n";
            }
            $scripttext .= '}' ."\n";
            
            // For Hovering Feature - Begin
            $scripttext .= 'for (var i=0; i<ajaxpathshover'.$mapDivSuffix.'.length; i++)' ."\n";
            $scripttext .= '{' ."\n";
            //$scripttext .= '    alert("Call:"+ajaxpathshover'.$mapDivSuffix.'[i].get("zhomPathID"));' ."\n";
            if ((int)$map->useajax == 1)
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddHoverListeners("mootools", ajaxpathshover'.$mapDivSuffix.'[i]);' ."\n";
            }
            else
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddHoverListeners("jquery", ajaxpathshover'.$mapDivSuffix.'[i]);' ."\n";
            }
            $scripttext .= '}' ."\n";
               
            // For Hovering Feature - End   
            
            $scripttext .= 'for (var i=0; i<ajaxpathsOVL'.$mapDivSuffix.'.length; i++)' ."\n";
            $scripttext .= '{' ."\n";
            if ((int)$map->useajax == 1)
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddListeners("mootools", ajaxpathsOVL'.$mapDivSuffix.'[i]);' ."\n";
            }
            else
            {
                    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PathAddListeners("jquery", ajaxpathsOVL'.$mapDivSuffix.'[i]);' ."\n";
            }
            $scripttext .= '}' ."\n";            
        }
        

    // Geolocation control
        if (isset($map->geolocationcontrol) && (int)$map->geolocationcontrol != 0) 
        {
            $scripttext .= '  var geolocationControl = new zhomGeolocationButtonControl('.
                        '"'.$mapDivSuffix.'",'. 
                        'map'.$mapDivSuffix.','. 
                        $feature4control.','. 
                        (int)$map->geolocationbutton.','. 
                        (int)$map->geolocationpos.','. 
                        '"geolocation",'. 
                        '"'.Text::_('COM_ZHOSMMAP_MAP_GEOLOCATIONBUTTON').'",'.
                        '16,'. 
                        '16,'. 
                        '"'.$imgpathUtils.'geolocation.png"'.
                        ');'."\n";
        }        
        //
        
        if ($needOverlayControl != 0)
        {

            $scripttext .= '  var overlayOpacityControl = new zhomOverlayOpacityControl('.
                    '"'.$mapDivSuffix.'",'. 
                    'map'.$mapDivSuffix.','. 
                    'zhomObjMgr'.$mapDivSuffix.','.
                    $feature4control.','. 
                    (int)$map->overlayopacitycontrol.','. 
                    (int)$map->overlayopacitycontrolpos.','. 
                    '"opacityoverlay",'. 
                    '"'.Text::_('COM_ZHOSMMAP_MAP_OPACITY_OVERLAY_CONTROL').'"'.
                    ');'."\n";       
             

        }
    
    // Map center - begin
    if ((int)$map->mapcentercontrol != 0) 
    {

            $scripttext .= '  var mapcenterControl = new zhomMapCenterButtonControl('.
                'latlng'.$mapDivSuffix.','.
                '"'.$ctrl_zoom.'",'.
                'map'.$mapDivSuffix.','. 
                $feature4control.','. 
                (int)$map->mapcentercontrol.','. 
                (int)$map->mapcentercontrolpos.','. 
                '"mapcenter",'. 
                '"'.Text::_('COM_ZHOSMMAP_MAP_HOMECONTROL_LABEL').'",'.
                '19,'. 
                '16,'. 
                '"'.$imgpathUtils.'home.png"'.
                ');'."\n";                
                                    
    }
    // Map center - end    


    
    if (isset($map->kmllayer) && $map->kmllayer != "") 
    {
        $scripttext .= 'var kmlLayer'.$mapDivSuffix.' = omnivore.kml(\''.$map->kmllayer.'\')' ."\n";
                $scripttext .= '.on(\'ready\', function() {' ."\n";
                // After the "ready" event fires, the GeoJSON contents are accessible
                // and you can iterate through layers to bind custom popups.
                $scripttext .= '  kmlLayer'.$mapDivSuffix.'.eachLayer(function(layer) {' ."\n";
                if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                {
                    $scripttext .= '    layer.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(layer.feature.properties.name));'."\n";
                }
                else
                {
                    $scripttext .= '    layer.bindPopup(layer.feature.properties.name);' ."\n";
                }
                
                $scripttext .= '  });' ."\n";
                $scripttext .= '});' ."\n";
        $scripttext .= 'kmlLayer'.$mapDivSuffix.'.addTo(map'.$mapDivSuffix.');' ."\n";
    }

    
    
    if (isset($map->auto_center_zoom) && ((int)$map->auto_center_zoom !=0))
    {
        if ($ajaxLoadObjects == 0)
        {   
			if (isset($markers) && !empty($markers))
			{
				if (count($markers) > 0)
				{
					$scripttext .= 'map'.$mapDivSuffix.'.fitBounds(map_bounds'.$mapDivSuffix.');' ."\n";
				}
			}
        }
        else
        {
             $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkCenterZoom(map_bounds'.$mapDivSuffix.');' ."\n";    
        }
    }


 
    if ((isset($map->autoposition) && (int)$map->autoposition == 1))
    {
            $scripttext .= 'findMyPosition'.$mapDivSuffix.'("Map");' ."\n";
    }


        // 06.12.2017 Added link to Google map page like for placemark
        if ((int)$map->balloon != 0) 
        {
            if ((int)$map->gogoogle_map == 20 || (int)$map->gogoogle_map == 21 
              ||(int)$map->gogoogle_map == 22 || (int)$map->gogoogle_map == 23
              ||(int)$map->gogoogle_map == 24 || (int)$map->gogoogle_map == 25
              ||(int)$map->gogoogle_map == 30 || (int)$map->gogoogle_map == 31
              ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33
              ||(int)$map->gogoogle_map == 34 || (int)$map->gogoogle_map == 35
            )
            {    

                    if ((int)$map->gogoogle_map == 20 
                     || (int)$map->gogoogle_map == 22
                     || (int)$map->gogoogle_map == 24
                     || (int)$map->gogoogle_map == 30
                     || (int)$map->gogoogle_map == 32
                     || (int)$map->gogoogle_map == 34
                    )
                    {
                            $linkTarget = " target=\"_blank\"";
                    }
                    else
                    {
                            $linkTarget = "";
                    }

                    if ($credits != '')
                    {
                            $credits .= '<br />';
                    }
                    $credits .= '<div id="bodyContentGoGoogle" class="placemarkBodyGoGoogle">';                
                    $credits .= '<p><a class="placemarkGOGOOGLE" href="';

                        if ((int)$map->gogoogle_map == 22 || (int)$map->gogoogle_map == 23
                          ||(int)$map->gogoogle_map == 24 || (int)$map->gogoogle_map == 25
                          ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33
                          ||(int)$map->gogoogle_map == 34 || (int)$map->gogoogle_map == 35
                        )
                        {
                            $credits .= 'https://maps.google.com/?ll='.
                                            $map->latitude.','.$map->longitude;    
                            $credits .= '&amp;z='.$map->zoom; 
                            if ((int)$map->gogoogle_map == 22 || (int)$map->gogoogle_map == 23
                              ||(int)$map->gogoogle_map == 32 || (int)$map->gogoogle_map == 33)
                            {
                                $credits .= '&amp;q='.htmlspecialchars(str_replace('\\', '/', $map->title) , ENT_QUOTES, 'UTF-8');
                            }
                            else
                            {
                                $credits .= '&amp;q='.$map->latitude.','.$map->longitude;    
                            }
                            if ($main_lang_little != "")
                            {
                                $credits .= '&amp;hl='.$main_lang_little;    
                            }                            
                        }
                        else
                        {
                            $credits .= 'https://maps.google.com/maps?saddr=Current%20Location&amp;daddr='.
                                            $map->latitude.','.$map->longitude;                            
                        }
                        
                    $credits .= '" '.$linkTarget.' title="'.$fv_override_gogoogle_text.
                            '">'.$fv_override_gogoogle_text.'</a></p>';
                    $credits .= '</div>';

            }     
        }
        
    if ($credits != '')
    {
        $scripttext .= '  document.getElementById("OMapsCredit'.$mapDivSuffix.'").innerHTML = \''.$credits.'\';'."\n";
    }


    //$scripttext .= 'alert("'.$doAddToListCount.'");'."\n";

    
    $scripttext .= 'var toShowLoading = document.getElementById("OMapsLoading'.$mapDivSuffix.'");'."\n";
    $scripttext .= '  toShowLoading.style.display = \'none\';'."\n";
    
    
    if ($zhomObjectManager != 0)
    {
        if ((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0))
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setGroupCountObject('.(int)$map->markergroupshowicon.');' ."\n";
                        
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enableObjectGroupManagement('.$manageGroupCSS.');' ."\n";
            
            if ((isset($map->markergrouptype) && (int)$map->markergrouptype == 1))
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.setObjectGroupManagementType("OnlyOneActive");' ."\n";
            }
            

            if ((isset($map->markergroupctlmarker) && (int)$map->markergroupctlmarker != 0))
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkGroupManagement();' ."\n";
            }
            if (isset($map->markergroupctlpath) 
            && (((int)$map->markergroupctlpath == 1) || ((int)$map->markergroupctlpath == 3)))
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePathGroupManagement();' ."\n";
            }
            
            if (isset($map->markergroupctlpath) 
            && (((int)$map->markergroupctlpath == 2) || ((int)$map->markergroupctlpath == 3)))
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePathXGroupManagement();' ."\n";
            }

        }

        
        if ((isset($map->markercluster) && (int)$map->markercluster == 1))
        {
            $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkClusterization();' ."\n";
            if ((isset($map->markerclustergroup) && (int)$map->markerclustergroup == 1))
            {
                $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.enablePlacemarkClusterizationByGroup();' ."\n";
            }
        }

        $scripttext .= 'zhomObjMgr'.$mapDivSuffix.'.InitializeByGroupState();'."\n";
        
    }
     
    if ($zhomK2Manager != 0) 
    {
        $scripttext .= 'zhomK2Mgr'.$mapDivSuffix.'.RenderMap();' ."\n";
    }
    
     if ($load_delay != "" && (int)$load_delay > 0)
    {
        $scripttext .= '}, '.(int)$load_delay.');' ."\n";  
    }
    
// end initialize
$scripttext .= '};' ."\n";

//
//

if ((isset($map->placemark_rating) && ((int)$map->placemark_rating !=0))  
  || ($ajaxLoadObjects != 0)
  || ($ajaxLoadContent != 0)
  )
{
    $scripttext .= 'function PlacemarkRateOver'.$mapDivSuffix.'(p_id, p_idx, p_max) {' ."\n";
    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateMouseOver(p_id, p_idx, p_max);' ."\n";
    $scripttext .= '};' ."\n";

    $scripttext .= 'function PlacemarkRateOut'.$mapDivSuffix.'(p_id, p_idx, p_max) {' ."\n";
    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateMouseOut(p_id, p_idx, p_max);' ."\n";
    $scripttext .= '};' ."\n";

    $scripttext .= 'function PlacemarkRateDivOut'.$mapDivSuffix.'(p_id, p_max) {' ."\n";
    $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateDivMouseOut(p_id, p_max);' ."\n";    
    $scripttext .= '};' ."\n";
    
    $scripttext .= 'function PlacemarkRateUpdate'.$mapDivSuffix.'(p_id, p_val, p_max) {' ."\n";
    if ($ajaxLoadObjects != 0)
    {
        if ($ajaxLoadObjects == 1)
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("mootools", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
        }
        else if ($ajaxLoadObjects == 2)
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("jquery", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
        }
    }
    else
    {
        if ((int)$map->useajax != 0)
        {
            if ((int)$map->useajax == 1)
            { 
                $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("mootools", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
            }
            else if ((int)$map->useajax == 2)
            {
                $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("jquery", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
            }
        }
        else 
        {
            if ((int)$map->placemark_rating == 1)
            { 
                $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("mootools", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
            }
            else if ((int)$map->placemark_rating == 2)
            {
                $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.PlacemarkRateUpdate("jquery", p_id, p_val, p_max, \''.$main_lang.'\');' ."\n";    
            }
        }
        
    }
    $scripttext .= '};' ."\n";
    
}

    $scripttext .= 'function PlacemarkByIDShow(p_id, p_action, p_zoom) {' ."\n";
    if ($externalmarkerlink == 1)
    {
        $scripttext .= '  if (p_zoom != undefined && p_zoom != "")' ."\n";
        $scripttext .= '  {' ."\n";
        $scripttext .= '      map'.$mapDivSuffix.'.setZoom(p_zoom);' ."\n";
        $scripttext .= '  }' ."\n";

        $scripttext .= '  if( allPlacemarkArray[p_id] === undefined ) ' ."\n";
        $scripttext .= '  {' ."\n";
        $scripttext .= '      alert("Unable to find placemark with ID = " + p_id);' ."\n";
        $scripttext .= '  }' ."\n";
        $scripttext .= '  else' ."\n";
        $scripttext .= '  {' ."\n";
        $scripttext .= '    cur_action = p_action.toLowerCase().split(",");' ."\n";
        $scripttext .= '    for (i = 0; i < cur_action.length; i++) {' ."\n";
        $scripttext .= '      if (cur_action[i] == "click")' ."\n";
        $scripttext .= '      {' ."\n";
        $scripttext .= '        allPlacemarkArray[p_id].markerobject.fire("click");' ."\n";
        $scripttext .= '      }' ."\n";
        $scripttext .= '      else if (cur_action[i] == "center")' ."\n";
        $scripttext .= '      {' ."\n";
        $scripttext .= '          map'.$mapDivSuffix.'.setView(allPlacemarkArray[p_id].latlngobject, map'.$mapDivSuffix.'.getZoom());' ."\n";
        $scripttext .= '      }' ."\n";
        $scripttext .= '    }' ."\n";
        $scripttext .= '  }' ."\n";
    }
    else
    {
        $scripttext .= '      alert("This feature is supported only when you enable it in map menu item or module property!");' ."\n";
    }
    $scripttext .= '}' ."\n";
    

    if ($externalmarkerlink == 1)
    {
        $scripttext .= 'function PlacemarkByID(p_id, p_lat, p_lng, p_obj, p_ll, p_rate) {' ."\n";
        $scripttext .= 'this.id = p_id;' ."\n";
        $scripttext .= 'this.lat = p_lat;' ."\n";
        $scripttext .= 'this.lng = p_lng;' ."\n";
        $scripttext .= 'this.markerobject = p_obj;' ."\n";
        $scripttext .= 'this.latlngobject = p_ll;' ."\n";
        $scripttext .= 'this.rate = p_rate;' ."\n";
        $scripttext .= '}' ."\n";
        
        $scripttext .= 'function PlacemarkByIDAdd(p_id, p_lat, p_lng, p_obj, p_ll, p_rate) {' ."\n";
        $scripttext .= '    allPlacemarkArray[p_id] = new PlacemarkByID(p_id, p_lat, p_lng, p_obj, p_ll, p_rate);' ."\n";
        $scripttext .= '}' ."\n";
    }
    
    
    // Infowin content generated by helper. Need more changes, static methods...




    if (isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0) 
    {
        $scripttext .= 'function callToggleGroup'.$mapDivSuffix.'(groupid){   ' ."\n";
        $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GroupStateToggle(groupid);' ."\n";
        $scripttext .= '}'."\n";
        
        $scripttext .= 'function callShowAllGroup'.$mapDivSuffix.'(){   ' ."\n";
        if ((int)$map->markergroupshowicon != 50
         && (int)$map->markergroupshowicon != 51
         && (int)$map->markergroupshowicon != 52
         && (int)$map->markergroupshowicon != 55
        )
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GroupStateShowAll();' ."\n";
        }
        else
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GroupStateShowAllCategoryGroup();' ."\n";
        }
        $scripttext .= '}'."\n";

        $scripttext .= 'function callHideAllGroup'.$mapDivSuffix.'(){   ' ."\n";
        if ((int)$map->markergroupshowicon != 50
         && (int)$map->markergroupshowicon != 51
         && (int)$map->markergroupshowicon != 52
         && (int)$map->markergroupshowicon != 55
        )
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GroupStateHideAll();' ."\n";
        }
        else
        {
            $scripttext .= '  zhomObjMgr'.$mapDivSuffix.'.GroupStateHideAllCategoryGroup();' ."\n";
        }
        $scripttext .= '}'."\n";
    }




    // Geo Position - Begin
if ((isset($map->autoposition) && (int)$map->autoposition == 1)
     || (isset($map->geolocationcontrol) && (int)$map->geolocationcontrol != 0))
    {
                $scripttext .= 'function findMyPosition'.$mapDivSuffix.'(AutoPosition, DirectionsDisplay, DirectionsService, Marker, SearchTravelMode, LocationDestination) {' ."\n";
            //$scripttext .= ' alert("AutoPosition: "+AutoPosition);' ."\n";                
                // Try W3C Geolocation method (Preferred)
                //$scripttext .= 'alert("Try to find");'."\n";
            $scripttext .= '    if (navigator.geolocation) {' ."\n";
                //$scripttext .= 'alert("Try W3C Geolocation method");'."\n";
            $scripttext .= '        browserSupportFlag = true;' ."\n";
            $scripttext .= '        navigator.geolocation.getCurrentPosition(function(position) {' ."\n";
            $scripttext .= '          initialLocation = L.latLng(position.coords.latitude,position.coords.longitude);' ."\n";
            if ($fv_override_geocoderzoom != "" && (int)$fv_override_geocoderzoom != 100)
            {
                $scripttext .= '          map'.$mapDivSuffix.'.setView(initialLocation, '.(int)$fv_override_geocoderzoom.');' ."\n";
            }
            else
            {
                $scripttext .= '          map'.$mapDivSuffix.'.setView(initialLocation, map'.$mapDivSuffix.'.getZoom());' ."\n";
            }

                $scripttext .= '         if (AutoPosition == "Button")' ."\n";
                $scripttext .= '         {' ."\n";
                if ((int)$map->geolocationcontrol == 2)
                {
                    $scripttext .= '         if (typeof geolocation'.$mapDivSuffix.' === \'undefined\')'."\n";
                    $scripttext .= '         {'."\n";
                    $scripttext .= '           geolocation'.$mapDivSuffix.' = L.marker(initialLocation, {draggable:false});'."\n";
                    $scripttext .= '           geolocation'.$mapDivSuffix.'.addTo(map'.$mapDivSuffix.');'."\n";
                    $scripttext .= '         }'."\n";
                    $scripttext .= '         else'."\n";
                    $scripttext .= '         {'."\n";
                    $scripttext .= '           geolocation'.$mapDivSuffix.'.setLatLng(initialLocation);'."\n";
                    $scripttext .= '         }'."\n";
                    
                }
                
                //$scripttext .= '           placesACbyButton'.$mapDivSuffix.'(0, DirectionsDisplay, DirectionsService, Marker, "", SearchTravelMode, initialLocation, LocationDestination);' ."\n";
                $scripttext .= '         }' ."\n";

            $scripttext .= '       }, function() {' ."\n";
            $scripttext .= '          handleNoGeolocation(browserSupportFlag);' ."\n";
            $scripttext .= '        });' ."\n";
            $scripttext .= '    } else {' ."\n";
            // Browser doesn\'t support Geolocation
                //$scripttext .= 'alert("Browser doesn\'t support Geolocation");'."\n";
            $scripttext .= '        browserSupportFlag = false;' ."\n";
            $scripttext .= '        handleNoGeolocation(browserSupportFlag);' ."\n";
            $scripttext .= '    }' ."\n";
                $scripttext .= '};' ."\n";

            $scripttext .= 'function handleNoGeolocation(errorFlag) {' ."\n";
            $scripttext .= '  if (errorFlag == true) {' ."\n";
            $scripttext .= '    alertContentString = "'.Text::_('COM_ZHOSMMAP_MAP_GEOLOCATION_FAILED').'";' ."\n";
            $scripttext .= '  } else {' ."\n";
            $scripttext .= '    alertContentString = "'.Text::_('COM_ZHOSMMAP_MAP_GEOLOCATION_BROWSER_NOT_SUPPORT').'";' ."\n";
            $scripttext .= '  }' ."\n";
            $scripttext .= ' popup'.$mapDivSuffix.'.setLatLng(map'.$mapDivSuffix.'.getCenter())' ."\n";
            $scripttext .= '  .setContent(alertContentString)' ."\n";
            $scripttext .= '  .openOn(map'.$mapDivSuffix.');' ."\n";
            $scripttext .= '};' ."\n";

            
    }
    // Geo Position - End
    

    // Toggle for Insert Markers - Begin
    if (isset($map->usermarkers) 
        && ((int)$map->usermarkersinsert == 1 || (int)$map->usermarkersupdate == 1)
        && ((int)$map->usermarkers == 1
            ||(int)$map->usermarkers == 2)) 
    {
        if ($allowUserMarker == 1)
        {
                $scripttext .= 'function showonlyone(thename, theid) {'."\n";
                $scripttext .= '  var xPlacemarkA = document.getElementById("bodyInsertPlacemarkA"+theid);'."\n";
                $scripttext .= '  var xPlacemarkGrpA = document.getElementById("bodyInsertPlacemarkGrpA"+theid);'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '  var xContactA = document.getElementById("bodyInsertContactA"+theid);'."\n";
                $scripttext .= '  var xContactAdrA = document.getElementById("bodyInsertContactAdrA"+theid);'."\n";
            }
                $scripttext .= '  if (thename == \'Contact\')'."\n";
                $scripttext .= '  {'."\n";
                $scripttext .= '    var toHide2 = document.getElementById("bodyInsertPlacemark"+theid);'."\n";
                $scripttext .= '    var toHide3 = document.getElementById("bodyInsertPlacemarkGrp"+theid);'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    var toHide1 = document.getElementById("bodyInsertContactAdr"+theid);'."\n";
                $scripttext .= '    var toShow = document.getElementById("bodyInsertContact"+theid);'."\n";
            }
                $scripttext .= '    xPlacemarkA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xPlacemarkGrpA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'\';'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    xContactA.innerHTML = \'<img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xContactAdrA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'\';'."\n";
            }
                $scripttext .= '  }'."\n";
                $scripttext .= '  else if (thename == \'Placemark\')'."\n";
                $scripttext .= '  {'."\n";
                $scripttext .= '    var toHide1 = document.getElementById("bodyInsertPlacemarkGrp"+theid);'."\n";
                $scripttext .= '    var toShow = document.getElementById("bodyInsertPlacemark"+theid);'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    var toHide2 = document.getElementById("bodyInsertContact"+theid);'."\n";
                $scripttext .= '    var toHide3 = document.getElementById("bodyInsertContactAdr"+theid);'."\n";
            }
                $scripttext .= '    xPlacemarkA.innerHTML = \'<img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xPlacemarkGrpA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'\';'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    xContactA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xContactAdrA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'\';'."\n";
            }
                $scripttext .= '  }'."\n";
                $scripttext .= '  else if (thename == \'PlacemarkGroup\')'."\n";
                $scripttext .= '  {'."\n";
                $scripttext .= '    var toShow = document.getElementById("bodyInsertPlacemarkGrp"+theid);'."\n";
                $scripttext .= '    var toHide1 = document.getElementById("bodyInsertPlacemark"+theid);'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    var toHide2 = document.getElementById("bodyInsertContact"+theid);'."\n";
                $scripttext .= '    var toHide3 = document.getElementById("bodyInsertContactAdr"+theid);'."\n";
            }
                $scripttext .= '    xPlacemarkA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xPlacemarkGrpA.innerHTML = \'<img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'\';'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    xContactA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xContactAdrA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'\';'."\n";
            }
                $scripttext .= '  }'."\n";
                $scripttext .= '  else if (thename == \'ContactAddress\')'."\n";
                $scripttext .= '  {'."\n";
                $scripttext .= '    var toHide2 = document.getElementById("bodyInsertPlacemark"+theid);'."\n";
                $scripttext .= '    var toHide3 = document.getElementById("bodyInsertPlacemarkGrp"+theid);'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    var toHide1 = document.getElementById("bodyInsertContact"+theid);'."\n";
                $scripttext .= '    var toShow = document.getElementById("bodyInsertContactAdr"+theid);'."\n";
            }
                $scripttext .= '    xPlacemarkA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xPlacemarkGrpA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'\';'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '    xContactA.innerHTML = \'<img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'\';'."\n";
                $scripttext .= '    xContactAdrA.innerHTML = \'<img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'\';'."\n";
            }
                $scripttext .= '  }'."\n";
                $scripttext .= '  toHide1.style.display = \'none\';'."\n";
                $scripttext .= '  toShow.style.display = \'block\';'."\n";
            if (isset($map->usercontact) && (int)$map->usercontact == 1)
            {
                $scripttext .= '  toHide2.style.display = \'none\';'."\n";
                $scripttext .= '  toHide3.style.display = \'none\';'."\n";
            }
                $scripttext .= '}'."\n";
        }   
    }
    // Toggle for Insert Markers - End

if (isset($MapXdoLoad) && ((int)$MapXdoLoad == 0)
&& (isset($useObjectStructure) && (int)$useObjectStructure == 1))
{
    // Do not add loader
}
else
{
    if ($loadtype == "1")
    {
        $scripttext .= ' window.addEvent(\'domready\', initialize'.$mapInitTag.');' ."\n";
    }
    else if ($loadtype == "2")
    {
        $scripttext .= 'var tmpJQ'.$mapDivSuffix.' = jQuery.noConflict();'."\n";
		
		/*
		$app = Factory::getApplication();
		$input = $app->getInput();
		
		$cookieName = 'zhosm-test';
        $cookieValue = $input->cookie->getString(ApplicationHelper::getHash($cookieName));
		
		$cookieExists = ($cookieValue !== null);
        
		if ($cookieExists) {
			$scripttext .= 'alert("Cookie is exist" + '.$cookieValue.');'."\n";
		}
		else
		{
			$scripttext .= 'alert("Cookie does not exist");'."\n";
			$cookieLifeTime = time() + 365 * 86400;
			$cookieDomain   = $app->get('cookie_domain', '');
			$cookiePath     = $app->get('cookie_path', '/');
			$isHttpsForced  = $app->isHttpsForced();
			
			$input->cookie->set(
                ApplicationHelper::getHash($cookieName),
                '123',
                [
                    'expires'  => $cookieLifeTime,
                    'path'     => $cookiePath,
                    'domain'   => $cookieDomain,
                    'secure'   => $isHttpsForced,
                    'httponly' => true,
                ]
            );
		}
		*/
			
        $scripttext .= ' tmpJQ'.$mapDivSuffix.'(document).ready(function() {initialize'.$mapInitTag.'();});' ."\n";
    }
    else
    {
        $scripttext .= ' function addLoadEvent(func) {' ."\n";
        $scripttext .= '  var oldonload = window.onload;' ."\n";
        $scripttext .= '  if (typeof window.onload != \'function\') {' ."\n";
        $scripttext .= '    window.onload = func;' ."\n";
        $scripttext .= '  } else {' ."\n";
        $scripttext .= '    window.onload = function() {' ."\n";
        $scripttext .= '      if (oldonload) {' ."\n";
        $scripttext .= '        oldonload();' ."\n";
        $scripttext .= '      }' ."\n";
        $scripttext .= '      func();' ."\n";
        $scripttext .= '    }' ."\n";
        $scripttext .= '  }' ."\n";
        $scripttext .= '}    ' ."\n";    

        $scripttext .= 'addLoadEvent(initialize'.$mapInitTag.');' ."\n";
    }
            

}


    
$scripttextEnd .= '/*]]>*/</script>' ."\n";
// Script end

if (isset($MapXdoLoad) && ((int)$MapXdoLoad == 0))
{
    if (isset($useObjectStructure) && (int)$useObjectStructure == 1)
    {
        $this->scripttext = $scripttext;
        $this->scripthead = $scripthead;
        $this->scriptinitialize .= ' initialize'.$mapInitTag.'();' ."\n";
    }
    else if (isset($useObjectStructure) && (int)$useObjectStructure == 2)
    {
        // for module case
        $scripttextFull = $scripttextBegin . $scripttext. $scripttextEnd;
        echo $scripttextFull;
    }
    else
    {
    }
}
else
{
    $scripttextFull = $scripttextBegin . $scripttext. $scripttextEnd;
    echo $scripttextFull;
}

}
// end of main part
