<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap Component
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Site\Helper;
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\Database\DatabaseDriver;

/**
 * Zh OpenStreetMap Helper
 */
abstract class MapPlacemarksHelper
{

    public static function get_ArticleCategory($Id)
    {
        $ret_val = 0;
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.catid')
                ->from('#__content as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();      
            
        }
        
        if (isset($mySO))
        {
            $ret_val = $mySO->catid;
        }

        return $ret_val;
    }


    public static function get_MapOverride($Id)
    {
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__zhosmmaps_text_overrides as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();
            
            
        }

        return $mySO;
    }
        
        
    public static function get_placemark_coordinates($markerId)
    {
        if ((int)$markerId != 0)
        {
            $dbMrk = Factory::getDBO();

            $queryMrk = $dbMrk->getQuery(true);
            $queryMrk->select('h.*')
                ->from('#__zhosmmaps_markers as h')
                ->where('h.id = '.(int) $markerId);
            $dbMrk->setQuery($queryMrk);        
            $myMarker = $dbMrk->loadObject();
            
            if (isset($myMarker))
            {
                if ($myMarker->latitude != "" && $myMarker->longitude != "")
                {
                    return 'new L.latLng('.$myMarker->latitude.', ' .$myMarker->longitude.')';
                }
                else
                {
                    return 'geocode';
                }
            }
            else
            {
                return '';
            }    
        }
    }
    
    public static function get_placemark_tags($id, $type, $style)
    {
            $addWhereClause = "";
            
            if ((int)$id != 0 && $type != ""
            && ($type == "com_zhosmmap.mapmarker" || $type == "com_contact.contact"))
            {
                    switch ((int)$style) 
                    {

                        case 0:
                                $tagstyle = '-simple';
                        break;
                        case 1:
                                $tagstyle = '-advanced';
                        break;
                        case 2:
                                $tagstyle = '-external';
                        break;
                        default:
                                $tagstyle = '-simple';
                        break;
                    }
                            
                    $dbMrk = Factory::getDBO();

                    $addWhereClause .= 'm.content_item_id='.(int)$id;
                    $addWhereClause .= ' and t.type_alias=\''.$type.'\'';                    

                    $queryMrk = $dbMrk->getQuery(true);
                    $queryMrk->select('tg.title')
                            ->from('#__contentitem_tag_map as m')
                            ->leftJoin('#__content_types as t ON m.type_id=t.type_id')
                            ->leftJoin('#__tags as tg ON m.tag_id=tg.id')
                            ->where($addWhereClause)
                            ;
                    
                    $queryMrk->order('tg.title');
                    
                    $dbMrk->setQuery($queryMrk);        

                    $myMarker = $dbMrk->loadObjectList();

                    $cur_name = "";

                    if (isset($myMarker) && !empty($myMarker))
                    {
                        //$cur_name = count($myMarker);

                        foreach ($myMarker as $key => $myMrk) 
                        {
                            $cur_name .= '<div id="OMapsMarkerTagITEM'.(int)$id.'" class="zhom-placemark-tag-item'.$tagstyle.'-div">';
                            $cur_name .= htmlspecialchars(str_replace('\\', '/', $myMrk->title) , ENT_QUOTES, 'UTF-8');
                            $cur_name .= '</div>';
                        }
                    }

                    return $cur_name;
            }

    }
   
    public static function get_placemark_content_string(
                        $currentArticleId,
                        $currentmarker, $usercontact, $useruser,
                        $usercontactattributes, $service_DoDirection,
                        $imgpathIcons, $imgpathUtils, $directoryIcons, $placemarkrating, $lang, $titleTag, $showCreateInfo,
                        $gogoogle, $gogoogleText,
                        $date_format)
    {

        $currentLanguage = Factory::getLanguage();
        $currentLangTag = $currentLanguage->getTag();
        

        $currentTitleTag = $titleTag;

        
        $main_lang_little = "";
                
        if (isset($lang) && $lang != "")
        {
            $main_lang_little = substr($lang,0, strpos($lang, '-'));
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $lang, true);    
        }
        else
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $currentLangTag, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $currentLangTag, true);        
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $currentLangTag, true);        
        }
        
        $returnText = '';
        $userContactAttrs = explode(",", $usercontactattributes);

        for($i = 0; $i < count($userContactAttrs); $i++) 
        {
            $userContactAttrs[$i] = strtolower(trim($userContactAttrs[$i]));
        }
      
            $returnText .= '\'<div id="placemarkContent'. $currentmarker->id.'" class="placemarkContent" >\' +    ' ."\n";

            if (isset($placemarkrating) && (int)$placemarkrating != 0)
            {
                $val_cnt_max = 5;
                
                $val_main = $currentmarker->rating_value;
                $val_int = floor($val_main);

                $returnText .= '\'<div id="rateBoby'. $currentmarker->id.'" class="placemarkRateBody" >\' +    ' ."\n";
                $returnText .= '\'<div id="rateContent'. $currentmarker->id.'"  class="placemarkRate" ';
                $returnText .= 'onmouseout="PlacemarkRateDivOut'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt_max.'); return false;" ';
                $returnText .= '>\'+'."\n";
                
                if ($val_main > $val_cnt_max)
                {
                    $val_main = $val_cnt_max;
                    $val_int = $val_cnt_max;
                }
                
                $val_cnt = 0;
                $returnText .= '\'';
                if ($val_main == 0)
                {
                    $val_cnt++;
                    $returnText .= '<img id="placemarkRateImage'. $currentmarker->id.'_'.$val_cnt.'" src="'.$imgpathUtils .'star0_00.png" alt="" ';
                    $returnText .= 'onmouseover="PlacemarkRateOver'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onmouseout="PlacemarkRateOut'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onclick="PlacemarkRateUpdate'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= '/>';
                }
                else if ($val_int == 0 && $val_main > 0)
                {
                    $val_cnt++;
                    $returnText .= '<img id="placemarkRateImage'. $currentmarker->id.'_'.$val_cnt.'" src="'.$imgpathUtils .'star0_05.png" alt="" ';
                    $returnText .= 'onmouseover="PlacemarkRateOver'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onmouseout="PlacemarkRateOut'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onclick="PlacemarkRateUpdate'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                    $returnText .= '/>';
                }
                else
                {
                    for ($i=0; $i<$val_int; $i++)
                    {
                        $val_cnt++;
                        $returnText .= '<img id="placemarkRateImage'. $currentmarker->id.'_'.$val_cnt.'" src="'.$imgpathUtils .'star0_10.png" alt="" ';
                        $returnText .= 'onmouseover="PlacemarkRateOver'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= 'onmouseout="PlacemarkRateOut'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= 'onclick="PlacemarkRateUpdate'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= '/>';
                    }
                    if (ceil(($val_main-$val_int)*10)>4)
                    {
                        $val_cnt++;
                        $returnText .= '<img id="placemarkRateImage'. $currentmarker->id.'_'.$val_cnt.'" src="'.$imgpathUtils .'star0_05.png" alt="" ';
                        $returnText .= 'onmouseover="PlacemarkRateOver'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= 'onmouseout="PlacemarkRateOut'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= 'onclick="PlacemarkRateUpdate'.$currentArticleId.'('. $currentmarker->id.', '.$val_cnt.', '.$val_cnt_max.'); return false;" ';
                        $returnText .= '/>';
                    }
                }
                for ($i=$val_cnt; $i < $val_cnt_max; $i++)
                {
                    $returnText .= '<img id="placemarkRateImage'. $currentmarker->id.'_'.($i+1).'" src="'.$imgpathUtils .'star0_00.png" alt="" ';
                    $returnText .= 'onmouseover="PlacemarkRateOver'.$currentArticleId.'('. $currentmarker->id.', '.($i+1).', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onmouseout="PlacemarkRateOut'.$currentArticleId.'('. $currentmarker->id.', '.($i+1).', '.$val_cnt_max.'); return false;" ';
                    $returnText .= 'onclick="PlacemarkRateUpdate'.$currentArticleId.'('. $currentmarker->id.', '.($i+1).', '.$val_cnt_max.'); return false;" ';
                    $returnText .= '/>';
                }
                $returnText .= '\'+';
                $returnText .= '\'</div>\'+'."\n";
                $returnText .= '\'<div id="rateContentResult'. $currentmarker->id.'"  class="placemarkRateResult"></div>\'+'."\n";
                $returnText .= '\'</div>\'+'."\n";
            }

            if (isset($currentmarker->markercontent) &&
                (((int)$currentmarker->markercontent == 0) ||
                 ((int)$currentmarker->markercontent == 1) ||
                 ((int)$currentmarker->markercontent == 9) )
                )
            {
                $returnText .= '\'<'.$currentTitleTag.' id="headContent'. $currentmarker->id.'" class="placemarkHead">'.'\'+' ."\n";
                $returnText .= '\''.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'\'+'."\n";
                $returnText .= '\'</'.$currentTitleTag.'>\'+' ."\n";
            }
            
            
            if (isset($currentmarker->showgps) &&
                  ((int)$currentmarker->showgps != 0)
                )
            {
                $returnText .= '\'<div id="gpsContent'. $currentmarker->id.'"  class="placemarkGPS">\'+'."\n";
                $returnText .= '\'<p class="placemarkGPSLatitude">\'+Convert_Latitude_Decimal2DMS('.$currentmarker->latitude.')+\'</p>\'+'."\n";                
                $returnText .= '\'<p class="placemarkGPSLongitude">\'+Convert_Longitude_Decimal2DMS('.$currentmarker->longitude.')+\'</p>\'+'."\n";                
                $returnText .= '\'</div>\'+'."\n";
            }
            
            $returnText .= '\'<div id="bodyContent'. $currentmarker->id.'"  class="placemarkBody">\'+'."\n";

            if ($currentmarker->hrefimage!="")
            {
                $tmp_image_path = strtolower($currentmarker->hrefimage);
                if (substr($tmp_image_path,0,5) == "http:"
                || substr($tmp_image_path,0,6) == "https:"
                || substr($tmp_image_path,0,1) == "/"
                || substr($tmp_image_path,0,1) == ".")
                {
                    $tmp_image_path_add = "";
                }
                else
                {
                    $tmp_image_path_add = "/";
                }
                
                $imagecss = "";
                if ($currentmarker->hrefimagecss != "")
                {
                    $imagecss = " style=\"".$currentmarker->hrefimagecss."\"";
                }
                $returnText .= '\'<img src="'.$tmp_image_path_add.$currentmarker->hrefimage.'"'.$imagecss.' alt="" />\'+'."\n";
            }

            if (isset($currentmarker->markercontent) &&
                (((int)$currentmarker->markercontent == 0) ||
                 ((int)$currentmarker->markercontent == 2))
                )
            {
                $returnText .= '\''.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'\'+'."\n";
            }
                        
                        $pluginPrepContentText = $currentmarker->descriptionhtml;
                        
                        if (isset($currentmarker->preparecontent) && (int)$currentmarker->preparecontent != 0)
                        {
                            $pluginPrepContentText = HTMLHelper::_('content.prepare', $pluginPrepContentText);
                            $pluginPrepContentText = str_replace(array("\r", "\r\n", "\n"), '', $pluginPrepContentText);
                            // protect double replace in case \'  
                            $pluginPrepContentText = str_replace("\\\'", "\n", $pluginPrepContentText);
                            $pluginPrepContentText = str_replace("'", "\'", $pluginPrepContentText);
                            $pluginPrepContentText = str_replace("\n", "\'", $pluginPrepContentText);
                        }
                        else 
                        {
                            $pluginPrepContentText = str_replace(array("\r", "\r\n", "\n"), '', $pluginPrepContentText);
                            $pluginPrepContentText = str_replace("'", "\'", $pluginPrepContentText);                            
                        }
                        
                        //$pluginPrepContentText = str_replace("CDATA[*\\", "CDATA[*\\\n", $pluginPrepContentText);
                        //$pluginPrepContentText = str_replace("*]]>*/</script>", "*]]>*/</script>\n", $pluginPrepContentText);
                        
                        $returnText .= '\''.$pluginPrepContentText.'\'+'."\n";
                        
            //$returnText .= '\''.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $pluginPrepContentText)).'\'+'."\n";

            //$returnText .= ' latlng'. $currentmarker->id. '.toString()+'."\n";

            if (isset($currentmarker->markercontent) &&
                ((int)$currentmarker->markercontent == 9 
                 || (int)$currentmarker->markercontent == 8) &&
                ((isset($currentmarker->articleid) && (int)$currentmarker->articleid != 0) 
                  || (isset($currentmarker->hrefarticle) && $currentmarker->hrefarticle != ""))
                )
            {            
                $returnText .= '\'<div id="article'. $currentmarker->id.'"  class="iframeArticle">\'+'."\n";        
                $returnText .= '\'<iframe id="articleiframe'. $currentmarker->id.'"';
                if ($currentmarker->hrefarticle != "")
                {
                    $returnText .= ' src="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->hrefarticle), ENT_QUOTES, 'UTF-8').'"';
                }
                else
                {
                    $article_category = MapPlacemarksHelper::get_ArticleCategory($currentmarker->articleid);
                    $returnText .= ' src="'.Route::_('index.php?option=com_content&view=article&id='.$currentmarker->articleid.'&catid='.(int)$article_category.'&tmpl=component').'"';
                }
                if (isset($currentmarker->iframearticleclass) && $currentmarker->iframearticleclass)
                {
                    $returnText .= ' class="'.$currentmarker->iframearticleclass.'"';    
                }                
                $returnText .= '>';    
                $returnText .= '</iframe>\'+'."\n";
                $returnText .= '\'</div>\'+'."\n";
            }
            
            // Contact info - begin
            if (isset($usercontact) && ((int)$usercontact != 0))
            {
                if (isset($currentmarker->showcontact) && ((int)$currentmarker->showcontact != 0))
                {
                    switch ((int)$currentmarker->showcontact) 
                    {
                        case 1:
                            for($i = 0; $i < count($userContactAttrs); $i++) 
                            {
                                if ($currentmarker->contact_name != ""
                                && $userContactAttrs[$i] == 'name') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_NAME').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_position != ""
                                && $userContactAttrs[$i] == 'position') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_POSITION').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_position), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_address != ""
                                && $userContactAttrs[$i] == 'address') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS').' '.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'suburb') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_SUBURB_SUBURB').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'city') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_SUBURB_CITY').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'state') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_STATE_STATE').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'province') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_STATE_PROVINCE').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_country != ""
                                && $userContactAttrs[$i] == 'country') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_COUNTRY').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_country), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'postcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_POSTCODE_POSTAL').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'zipcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_POSTCODE_ZIP').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_phone != ""
                                && $userContactAttrs[$i] == 'phone') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_PHONE').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_mobile != ""
                                && $userContactAttrs[$i] == 'mobile') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_MOBILE').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_mobile), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_fax != ""
                                && $userContactAttrs[$i] == 'fax') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_FAX').' '.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_fax), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_email != ""
                                && $userContactAttrs[$i] == 'email') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_EMAIL').' '.str_replace('@','&#64;',htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_email), ENT_QUOTES, 'UTF-8')).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_webpage != ""
                                && $userContactAttrs[$i] == 'website') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_WEBSITE').' '.'<a href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'" target="_blank">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'</a> '.'</p>\'+'."\n";
                                }
                                
                            }            

                        break;
                        case 2:
                            for($i = 0; $i < count($userContactAttrs); $i++) 
                            {
                                if ($currentmarker->contact_name != ""
                                && $userContactAttrs[$i] == 'name') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_position != ""
                                && $userContactAttrs[$i] == 'position') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_position), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_address != ""
                                && $userContactAttrs[$i] == 'address') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'address.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS').'" />'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'suburb') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'city') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'state') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'province') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_country != ""
                                && $userContactAttrs[$i] == 'country') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_country), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'postcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'zipcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_phone != ""
                                && $userContactAttrs[$i] == 'phone') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'phone.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_PHONE').'" />'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_mobile != ""
                                && $userContactAttrs[$i] == 'mobile') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'mobile.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_MOBILE').'" />'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_mobile), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_fax != ""
                                && $userContactAttrs[$i] == 'fax') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'fax.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_FAX').'" />'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_fax), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_email != ""
                                && $userContactAttrs[$i] == 'email') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'email.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_EMAIL').'" />'.str_replace('@','&#64;',htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_email), ENT_QUOTES, 'UTF-8')).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_webpage != ""
                                && $userContactAttrs[$i] == 'website') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact"><img src="'.$imgpathUtils.'website.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_CONTACT_WEBSITE').'" />'.'<a href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'" target="_blank">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'</a> '.'</p>\'+'."\n";
                                }
                                
                            }
                        break;
                        case 3:
                            for($i = 0; $i < count($userContactAttrs); $i++) 
                            {
                                if ($currentmarker->contact_name != ""
                                && $userContactAttrs[$i] == 'name') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_position != ""
                                && $userContactAttrs[$i] == 'position') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_position), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_address != ""
                                && $userContactAttrs[$i] == 'address') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'suburb') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'city') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'state') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'province') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_country != ""
                                && $userContactAttrs[$i] == 'country') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_country), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'postcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'zipcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_phone != ""
                                && $userContactAttrs[$i] == 'phone') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_mobile != ""
                                && $userContactAttrs[$i] == 'mobile') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_mobile), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_fax != ""
                                && $userContactAttrs[$i] == 'fax') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_fax), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_email != ""
                                && $userContactAttrs[$i] == 'email') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.str_replace('@','&#64;',htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_email), ENT_QUOTES, 'UTF-8')).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_webpage != ""
                                && $userContactAttrs[$i] == 'website') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.'<a href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'" target="_blank">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'</a> '.'</p>\'+'."\n";
                                }
                                
                            }
                        break;
                        default:
                            for($i = 0; $i < count($userContactAttrs); $i++) 
                            {
                                if ($currentmarker->contact_name != ""
                                && $userContactAttrs[$i] == 'name') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_position != ""
                                && $userContactAttrs[$i] == 'position') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_position), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_address != ""
                                && $userContactAttrs[$i] == 'address') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'suburb') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_suburb != ""
                                && $userContactAttrs[$i] == 'city') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_suburb), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'state') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_state != ""
                                && $userContactAttrs[$i] == 'province') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_state), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_country != ""
                                && $userContactAttrs[$i] == 'country') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_country), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'postcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_postcode != ""
                                && $userContactAttrs[$i] == 'zipcode') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_postcode), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_phone != ""
                                && $userContactAttrs[$i] == 'phone') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_mobile != ""
                                && $userContactAttrs[$i] == 'mobile') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_mobile), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                if ($currentmarker->contact_fax != ""
                                && $userContactAttrs[$i] == 'fax') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_fax), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                                }
                                
                                if ($currentmarker->contact_email != ""
                                && $userContactAttrs[$i] == 'email') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.str_replace('@','&#64;',htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_email), ENT_QUOTES, 'UTF-8')).'</p>\'+'."\n";
                                }

                                if ($currentmarker->contact_webpage != ""
                                && $userContactAttrs[$i] == 'website') 
                                {
                                    $returnText .= '\'<p class="placemarkBodyContact">'.'<a href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'" target="_blank">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->contact_webpage), ENT_QUOTES, 'UTF-8').'</a> '.'</p>\'+'."\n";
                                }
                                
                            }
                        break;                                        
                    }
                }
            }
            // Contact info - end
            // User info - begin
            if (isset($useruser) && ((int)$useruser != 0))
            {
                $returnText .= MapPlacemarksHelper::get_userinfo_for_marker(
                                                        $currentmarker->createdbyuser, $currentmarker->showuser,
                                                        $imgpathIcons, $imgpathUtils, $directoryIcons);
            }
            // User info - end
            
            if ($currentmarker->hrefsite!="")
            {
                $returnText .= '\'<p><a class="placemarkHREF" href="'.$currentmarker->hrefsite.'" target="_blank">';
                if ($currentmarker->hrefsitename != "")
                {
                    $returnText .= htmlspecialchars($currentmarker->hrefsitename, ENT_QUOTES, 'UTF-8');
                }
                else
                {
                    $returnText .= $currentmarker->hrefsite;
                }
                $returnText .= '</a></p>\'+'."\n";
            }

                        
            if (isset($gogoogle) && (int)$gogoogle == 1 && isset($currentmarker->gogoogle) && 
                                ((int)$currentmarker->gogoogle == 20 || (int)$currentmarker->gogoogle == 21
                              || (int)$currentmarker->gogoogle == 22 || (int)$currentmarker->gogoogle == 23
                              || (int)$currentmarker->gogoogle == 24 || (int)$currentmarker->gogoogle == 25
                                ))
            {    
                
                if ((int)$currentmarker->gogoogle == 20 
                                 || (int)$currentmarker->gogoogle == 22
                                 || (int)$currentmarker->gogoogle == 24
                                )
                {
                    $linkTarget = " target=\"_blank\"";
                }
                else
                {
                    $linkTarget = "";
                }
                
                $returnText .= '\'<p><a class="placemarkGOGOOGLE" href="';

                if ((int)$currentmarker->gogoogle == 22 || (int)$currentmarker->gogoogle == 23
                 || (int)$currentmarker->gogoogle == 24 || (int)$currentmarker->gogoogle == 25
                )
                {
                    $returnText .= 'https://maps.google.com/?ll='.
                                    $currentmarker->latitude.','.$currentmarker->longitude;    
                    //$scripttext .= '&z='.$map->zoom; 
                    if ((int)$currentmarker->gogoogle == 22 || (int)$currentmarker->gogoogle == 23)
                    {
                        $returnText .= '&q='.htmlspecialchars(str_replace('\\', '/', $currentmarker->title) , ENT_QUOTES, 'UTF-8');
                    }
                    else
                    {
                        $returnText .= '&q='.$currentmarker->latitude.','.$currentmarker->longitude;    
                    }
                    if ($main_lang_little != "")
                    {
                        $returnText .= '&hl='.$main_lang_little;    
                    }                                    
                }
                else
                {
                    $returnText .= 'https://maps.google.com/maps?saddr=Current%20Location&daddr='.
                                    $currentmarker->latitude.','.$currentmarker->longitude;                            
                }                                

                $returnText .= '" '.$linkTarget.' title="'.$gogoogleText.'">'.$gogoogleText.'</a></p>\'+'."\n";

            }                        
                        
            $returnText .= '\'</div>\'+'."\n";
            
            if ((int)$currentmarker->tag_show != 0)
            {
                switch ((int)$currentmarker->tag_style) 
                {

                    case 0:
                            $tagstyle = '-simple';
                    break;
                    case 1:
                            $tagstyle = '-advanced';
                    break;
                    case 2:
                            $tagstyle = '-external';
                    break;
                    default:
                            $tagstyle = '-simple';
                    break;
                }

                $returnText .= '\'<div id="OMapsMarkerTagDIV'.(int)$currentmarker->id.'" class="zhom-placemark-tag'.$tagstyle.'-div">\'+'."\n";

                if ((int)$currentmarker->tag_show == 1)
                {
                    $markerTags = MapPlacemarksHelper::get_placemark_tags($currentmarker->id, "com_zhosmmap.mapmarker", $currentmarker->tag_style);
                    $returnText .= '\'<div id="OMapsMarkerTagMarker'.(int)$currentmarker->id.'" class="zhom-placemark-tag-marker'.$tagstyle.'-div">'.$markerTags.'</div>\'+'."\n";
                }
                if ((int)$currentmarker->tag_show == 2)
                {
                    if ((int)$currentmarker->contactid != 0)
                    {
                        $markerTags = MapPlacemarksHelper::get_placemark_tags($currentmarker->contactid, "com_contact.contact", $currentmarker->tag_style);
                        $returnText .= '\'<div id="OMapsMarkerTagContact'.(int)$currentmarker->id.'" class="zhom-placemark-tag-contact'.$tagstyle.'-div">'.$markerTags.'</div>\'+'."\n";
                    }
                }
                
                $returnText .= '\'</div>\'+'."\n";
                        
            }

            $toolbarCreateInfoFlg = 0;
            
            if (isset($showCreateInfo) && (int)$showCreateInfo != 0)
            {
                $toolbarCreateInfoText = "";
                
                
                if ((((int)$showCreateInfo == 1) || ((int)$showCreateInfo == 3) ||
                     ((int)$showCreateInfo == 51) || ((int)$showCreateInfo == 53))
                )
                {
                    $toolbarCreateInfo = MapPlacemarksHelper::get_userinfo_for_marker_timestamp(
                                                        $currentmarker->createdbyuser);
                    if ($toolbarCreateInfo != "")
                    {
                        if (((int)$showCreateInfo == 1) || ((int)$showCreateInfo == 3))
                        {
                                $toolbarCreateInfoFlg = 1;
                        }
                        elseif (((int)$showCreateInfo == 51) || ((int)$showCreateInfo == 53))
                        {
                                $toolbarCreateInfoFlg = 2;
                        }
                        else
                        {
                                $toolbarCreateInfoFlg = 1;
                        }

                        $toolbarCreateInfoText .=  '\'<div id="OMapsMarkerStampUserDIV" class="zhom-placemark-stamp-user-div">\'+'."\n";
                        $toolbarCreateInfoText .= '\''.$toolbarCreateInfo.'\'+'."\n";
                        $toolbarCreateInfoText .= '\'</div>\'+'."\n";
                    }
                }
                
                
                if ((((int)$showCreateInfo == 2) || ((int)$showCreateInfo == 3) ||
                     ((int)$showCreateInfo == 52) || ((int)$showCreateInfo == 53))
                )
                {
                        $toolbarCreateInfo = MapPlacemarksHelper::get_datetime_for_marker_timestamp(
                                            $currentmarker->createddate,
                                            $date_format);
                        if ( $toolbarCreateInfo != "")
                        {
                            if (((int)$showCreateInfo == 2) || ((int)$showCreateInfo == 3))
                            {
                                $toolbarCreateInfoFlg = 1;
                            }
                            elseif (((int)$showCreateInfo == 52) || ((int)$showCreateInfo == 53))
                            {
                                $toolbarCreateInfoFlg = 2;
                            }
                            else
                            {
                                $toolbarCreateInfoFlg = 1;
                            }

                            $toolbarCreateInfoText .=  '\'<div id="OMapsMarkerStampDateDIV" class="zhom-placemark-stamp-date-div">\'+'."\n";
                            $toolbarCreateInfoText .= '\''.$toolbarCreateInfo.'\'+'."\n";
                            $toolbarCreateInfoText .= '\'</div>\'+'."\n";
                        }
                }
                
            }
            
            // Placemark Toolbar - begin
            $toolbarToolbarFlg = 0;
            $toolbarToolbarText = "";


            if ($service_DoDirection == 1)
            {
                $toolbarToolbarFlg = 1;
                $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-start" href="#" title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_FINISH').'" onclick="';
                $toolbarToolbarText .= 'setRouteDestination'.$currentArticleId.'(0);';
                $toolbarToolbarText .= ' return false;"><img class="zhom-placemark-action-toolbaritem-img-start" src="'.$imgpathUtils.'start.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_FINISH').'" /></a>\'+'."\n";
                $toolbarToolbarText .= '\'</div>\'+'."\n";
                $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-finish" href="#" title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_START').'" onclick="';
                $toolbarToolbarText .= 'setRouteDestination'.$currentArticleId.'(1);';
                $toolbarToolbarText .= ' return false;"><img class="zhom-placemark-action-toolbaritem-img-finish" src="'.$imgpathUtils.'finish.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_START').'" /></a>\'+'."\n";
                $toolbarToolbarText .= '\'</div>\'+'."\n";
            }

            
            
            if (isset($usercontact) && (int)$usercontact != 0 && isset($currentmarker->toolbarcontact) && (int)$currentmarker->toolbarcontact != 0)
            {    
                
                if ((int)$currentmarker->toolbarcontact == 1)
                {
                    $toolbarLinkTarget = " target=\"_blank\"";
                }
                else
                {
                    $toolbarLinkTarget = "";
                }
                
                if (isset($currentmarker->hrefcontact) && $currentmarker->hrefcontact != "")
                {
                    // Check alternative contact URL
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-contact" href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->hrefcontact), ENT_QUOTES, 'UTF-8').'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_CONTACT').'"><img class="zhom-placemark-action-toolbaritem-img-contact" src="'.$imgpathUtils.'contact.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_CONTACT').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
                else if (isset($currentmarker->contactid) && (int)$currentmarker->contactid != 0)
                {
                    // Check contact ID for default URL
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-contact" href="'.Route::_('index.php?option=com_contact&view=contact&id='.$currentmarker->contactid).'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_CONTACT').'"><img class="zhom-placemark-action-toolbaritem-img-contact" src="'.$imgpathUtils.'contact.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_CONTACT').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
            }

            if (isset($currentmarker->toolbararticle) && (int)$currentmarker->toolbararticle != 0)
            {

                if ((int)$currentmarker->toolbararticle == 1)
                {
                    $toolbarLinkTarget = " target=\"_blank\"";
                }
                else
                {
                    $toolbarLinkTarget = "";
                }
            
                if (isset($currentmarker->hrefarticle) && $currentmarker->hrefarticle != "")
                {
                    // Check alternative article URL
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-article" href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->hrefarticle), ENT_QUOTES, 'UTF-8').'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_ARTICLE').'"><img class="zhom-placemark-action-toolbaritem-img-article" src="'.$imgpathUtils.'article.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_ARTICLE').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
                else if (isset($currentmarker->articleid) && (int)$currentmarker->articleid != 0)
                {
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $article_category = MapPlacemarksHelper::get_ArticleCategory($currentmarker->articleid);
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-article" href="'.Route::_('index.php?option=com_content&view=article&id='.$currentmarker->articleid.'&catid='.(int)$article_category).'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_ARTICLE').'"><img class="zhom-placemark-action-toolbaritem-img-article" src="'.$imgpathUtils.'article.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_ARTICLE').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
            }

            if (isset($currentmarker->toolbardetail) && (int)$currentmarker->toolbardetail != 0)
            {    
                if ((int)$currentmarker->toolbardetail == 1)
                {
                    $toolbarLinkTarget = " target=\"_blank\"";
                }
                else
                {
                    $toolbarLinkTarget = "";
                }
                
        
                if (isset($currentmarker->hrefdetail) && $currentmarker->hrefdetail != "")
                {
                    
                    
                    // Check alternative details URL
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-details" href="'.htmlspecialchars(str_replace('\\', '/', $currentmarker->hrefdetail), ENT_QUOTES, 'UTF-8').'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_DETAILS').'"><img class="zhom-placemark-action-toolbaritem-img-details" src="'.$imgpathUtils.'details.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_DETAILS').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
                else if (isset($currentmarker->id) && (int)$currentmarker->id != 0)
                {
                    
                    $toolbarToolbarFlg = 1;

                    $detailsAttrs = str_replace(";", ',',$currentmarker->attributesdetail);
                    $detailsAttrArray = explode(",", $detailsAttrs);

                    for($i = 0; $i < count($detailsAttrArray); $i++) 
                    {
                        $detailsAttrArray[$i] = strtolower(trim($detailsAttrArray[$i]));
                    }

                    $load_bs = 9;
                    $prop_thumbnail = 0;
                    $prop_imagegalery = 0;
                    $prop_hidedescriptionhtml = 1;
                    $prop_showdescriptionfullhtml = 0;
                    
                    for($i = 0; $i < count($detailsAttrArray); $i++) 
                    {
                    
                        switch ($detailsAttrArray[$i]) 
                        {
                            
                            case 'load bootstrap':
                                $load_bs = 0;
                            break;
                            case 'load bootstrap styles':
                                $load_bs = 1;
                            break;
                            case 'thumbnail':
                                $prop_thumbnail = 1;
                            break;
                            case 'image gallery':
                                $prop_imagegalery = 1;
                            break;
                            case 'image galery':
                                $prop_imagegalery = 1;
                            break;
                            case 'addition html text':
                                $prop_hidedescriptionhtml = 0;
                            break;
                            case 'full description': 
                                $prop_showdescriptionfullhtml = 1;
                            break;
                        }                        
                    }
                    
                    
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-details" href="'.URI::base().'index.php?option=com_zhosmmap&view=placemark&load_bootstrap='.$load_bs
                                                              .'&thumbnail='.$prop_thumbnail
                                                              .'&imagegalery='.$prop_imagegalery
                                                              .'&hidedescriptionhtml='.$prop_hidedescriptionhtml
                                                              .'&showdescriptionfullhtml='.$prop_showdescriptionfullhtml
                                                              .'&id=' . $currentmarker->id.'" '.$toolbarLinkTarget.' title="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_DETAILS').'"><img class="zhom-placemark-action-toolbaritem-img-details" src="'.$imgpathUtils.'details.png" alt="'.Text::_('COM_ZHOSMMAP_MAPMARKER_ACTION_DETAILS').'" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";
                }
            }

             
            if (isset($gogoogle) && (int)$gogoogle == 1 && isset($currentmarker->gogoogle) && 
                    ((int)$currentmarker->gogoogle == 10 || (int)$currentmarker->gogoogle == 11
                  || (int)$currentmarker->gogoogle == 12 || (int)$currentmarker->gogoogle == 13
                  || (int)$currentmarker->gogoogle == 14 || (int)$currentmarker->gogoogle == 15
            ))
            {    
                
                if ((int)$currentmarker->gogoogle == 10 
                 || (int)$currentmarker->gogoogle == 12
                 || (int)$currentmarker->gogoogle == 14
                )
                {
                    $toolbarLinkTarget = " target=\"_blank\"";
                }
                else
                {
                    $toolbarLinkTarget = "";
                }
                

                                
                    $toolbarToolbarFlg = 1;
                    $toolbarToolbarText .= '\'<div class="zhom-placemark-action-toolbaritem">\'+'."\n";
                    $toolbarToolbarText .= '\'<a class="zhom-placemark-action-toolbaritem-a-gogoogle" href="';

                    if ((int)$currentmarker->gogoogle == 12 || (int)$currentmarker->gogoogle == 13
                     || (int)$currentmarker->gogoogle == 14 || (int)$currentmarker->gogoogle == 15
                    )
                    {
                        $toolbarToolbarText .= 'https://maps.google.com/?ll='.
                                        $currentmarker->latitude.','.$currentmarker->longitude;    
                        //$scripttext .= '&z='.$map->zoom; 
                        if ((int)$currentmarker->gogoogle == 12 || (int)$currentmarker->gogoogle == 13)
                        {
                            $toolbarToolbarText .= '&q='.htmlspecialchars(str_replace('\\', '/', $currentmarker->title) , ENT_QUOTES, 'UTF-8');
                        }
                        else
                        {
                            $toolbarToolbarText .= '&q='.$currentmarker->latitude.','.$currentmarker->longitude;    
                        }
                        
                        if ($main_lang_little != "")
                        {
                            $toolbarToolbarText .= '&hl='.$main_lang_little;    
                        }
                    }
                    else
                    {
                        $toolbarToolbarText .= 'https://maps.google.com/maps?saddr=Current%20Location&daddr='.
                                        $currentmarker->latitude.','.$currentmarker->longitude;                            
                    }                                

                    $toolbarToolbarText .=  '" '.$toolbarLinkTarget.' title="'.$gogoogleText.
                                            '"><img class="zhom-placemark-action-toolbaritem-img-gogoogle" src="'.$imgpathUtils.'gogoogle.png" alt="'.$gogoogleText.
                                            '" /></a>\'+'."\n";
                    $toolbarToolbarText .= '\'</div>\'+'."\n";

            }                       
            
            if ($toolbarToolbarFlg == 1)
            {
                if ($toolbarCreateInfoFlg == 1)
                {
                    $returnText .=  '\'<div id="OMapsMarkerStampDIV" class="zhom-placemark-stamp-top-div">\'+'."\n";
                    $returnText .=  $toolbarCreateInfoText;
                    $returnText .= '\'</div>\'+'."\n";
                }

                $returnText .=  '\'<div id="OMapsMarkerActionDIV" class="zhom-placemark-action-div">\'+'."\n";
                $returnText .=  '\'<div id="OMapsMarkerActionTOOLBAR" class="zhom-placemark-action-toolbar">\'+'."\n";
                $returnText .=  $toolbarToolbarText;
                $returnText .= '\'</div>\'+'."\n";
                $returnText .= '\'</div>\'+'."\n";

                if ($toolbarCreateInfoFlg == 2)
                {
                    $returnText .=  '\'<div id="OMapsMarkerStampDIV" class="zhom-placemark-stamp-bottom-div">\'+'."\n";
                    $returnText .=  $toolbarCreateInfoText;
                    $returnText .= '\'</div>\'+'."\n";
                }

            }
            else
            {
                if ($toolbarCreateInfoFlg != 0)
                {
                    $returnText .=  '\'<div id="OMapsMarkerStampDIV" class="zhom-placemark-stamp-top-bottom-div">\'+'."\n";
                    $returnText .=  $toolbarCreateInfoText;
                    $returnText .= '\'</div>\'+'."\n";
                }
            }
            
            
            // Placemark Toolbar - end
            
            $returnText .= '\'</div>\'';
            // contentString - End

        return $returnText;
    }
    

    public static function get_k2_placemark_content_string(
                        $item_template,
                        $currentArticleId,
                        $currentmarker, 
                        $imgpathIcons, $imgpathUtils, $directoryIcons, $lang, $titleTag, $showCreateInfo,
                        $date_format, $ex1, $ex2, $ex3)
    {

        $currentLanguage = Factory::getLanguage();
        $currentLangTag = $currentLanguage->getTag();
        

        $currentTitleTag = $titleTag;

        
        $main_lang_little = "";
                
        if (isset($lang) && $lang != "")
        {
            $main_lang_little = substr($lang,0, strpos($lang, '-'));
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $lang, true);    
        }
        else
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $currentLangTag, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $currentLangTag, true);        
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $currentLangTag, true);        
        }
        
        $returnText = '';
      
        require_once (JPATH_SITE.'/components/com_zhosmmap/assets/templates/k2/popup/'.$item_template.'.php');

        return $returnText;
    }
    

    public static function get_placemark_content_update_string($usermarkersicon, $usercontact, $currentmarker, $imgpathIcons, $imgpathUtils, $directoryIcons, $newMarkerGroupList)
    {
            $scripttext ='';

            // contentString - User Placemark can Update - Begin
                    // Change UserMarker - begin
                        
                        $scripttext .= 'var contentStringPart1'.$currentmarker->id.' = "" +' ."\n";
                        $scripttext .= '\'<div id="contentUpdatePlacemark">\'+'."\n";
                        //$scripttext .= '    \'<br />\'+' ."\n";
                        //$scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_LNG' ).' \'+'.$currentLng.' + ' ."\n";
                        //$scripttext .= '    \'<br />'.Text::_( 'COM_ZHOSMMAP_MAP_USER_LAT' ).' \'+'.$currentLat.' + ' ."\n";
                        //$scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_LNG' ).' \'+latlng'.$currentmarker->id.'.lng() + ' ."\n";
                        //$scripttext .= '    \'<br />'.Text::_( 'COM_ZHOSMMAP_MAP_USER_LAT' ).' \'+latlng'.$currentmarker->id.'.lat() + ' ."\n";
                        
                        // Form Update
                        $scripttext .= '    \'<form id="updatePlacemarkForm'.$currentmarker->id.'" action="'.URI::current().'" method="post">\'+'."\n";
                        $scripttext .= '    \''.'<img src="'.$imgpathUtils.'published'.(int)$currentmarker->published.'.png" alt="" />  \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";

                    // Begin Placemark Properties
                    $scripttext .= '\'<div id="bodyInsertPlacemarkDivA'.$currentmarker->id.'"  class="bodyInsertProperties">\'+'."\n";
                    $scripttext .= '\'<a id="bodyInsertPlacemarkA'.$currentmarker->id.'" href="javascript:showonlyone(\\\'Placemark\\\',\\\''.$currentmarker->id.'\\\');" ><img src="'.$imgpathUtils.'collapse.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_PROPERTIES' ).'</a>\'+'."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                    $scripttext .= '\'<div id="bodyInsertPlacemark'.$currentmarker->id.'"  class="bodyInsertPlacemarkProperties">\'+'."\n";
                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_NAME' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        $scripttext .= '    \'<input name="markername" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->title, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        //$scripttext .= '    \'<br />\'+' ."\n";
                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_DESCRIPTION' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        $scripttext .= '    \'<input name="markerdescription" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->description, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                        $scripttext .= '    \'<br />\';' ."\n";

                        // icon type
                        /*
                        if(isset($usermarkersicon) && (int)$usermarkersicon == 1) 
                        {
                            $iconTypeJS = " onchange=\"javascript: ";
                            $iconTypeJS .= " if (document.forms.updatePlacemarkForm".$currentmarker->id.".markerimage.options[selectedIndex].value!=\'\') ";
                            $iconTypeJS .= " {document.markericonimage".$currentmarker->id.".src=\'".$imgpathIcons."\' + document.forms.updatePlacemarkForm".$currentmarker->id.".markerimage.options[selectedIndex].value.replace(/#/g,\'%23\') + \'.png\'}";
                            $iconTypeJS .= " else ";
                            $iconTypeJS .= " {document.markericonimage".$currentmarker->id.".src=\'\'}\"";
                            
                            $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_ICON_TYPE' ).' \'+' ."\n";
                            $scripttext .= ' \'';
                            $scripttext .= '<img name="markericonimage'.$currentmarker->id.'" src="'.$imgpathIcons .str_replace("#", "%23", $currentmarker->icontype).'.png" alt="" />';
                            $scripttext .= '\'+' ."\n";
                            $scripttext .= '    \'<br />\'+' ."\n";
                            $scripttext .= ' \'';
                            $scripttext .= str_replace('.png<', '<', 
                                                str_replace('.png"', '"', 
                                                    str_replace('JOPTION_SELECT_IMAGE', Text::_('COM_ZHOSMMAP_MAP_USER_IMAGESELECT'),
                                                        str_replace(array("\r", "\r\n", "\n"),'', HTMLHelper::_('list.images',  'markerimage', $active = $currentmarker->icontype.'.png', $iconTypeJS, $directoryIcons, $extensions =  "png")))));
                            $scripttext .= '\'+' ."\n";
                            $scripttext .= '    \'<br />\'+' ."\n";        
                        }
                        else
                        {
                            $scripttext .= '    \'<input name="markerimage" type="hidden" value="default#" />\'+' ."\n";    
                        }
                        */

                        $scripttext .= 'var contentStringPart2'.$currentmarker->id.' = "" +' ."\n";    
                        
                        /*                        
                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_BALOON' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";

             
                        $scripttext .= '    \' <select name="markerbaloon" > \'+' ."\n";
                        $scripttext .= '    \' <option value="1" ';
                        if ($currentmarker->baloon == 1)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_DROP').'</option> \'+' ."\n";
                        $scripttext .= '    \' <option value="2" ';
                        if ($currentmarker->baloon == 2)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_BOUNCE').'</option> \'+' ."\n";
                        $scripttext .= '    \' <option value="3" ';
                        if ($currentmarker->baloon == 3)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_BALOON_SIMPLE').'</option> \'+' ."\n";
                        $scripttext .= '    \' </select> \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        */

                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAPMARKER_USER_MARKERCONTENT' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        
                        $scripttext .= '    \' <select name="markermarkercontent" > \'+' ."\n";
                        $scripttext .= '    \' <option value="0" ';
                        if ($currentmarker->baloon == 0)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_TITLE_DESC').'</option> \'+' ."\n";
                        $scripttext .= '    \' <option value="1" ';
                        if ($currentmarker->baloon == 1)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_TITLE').'</option> \'+' ."\n";
                        $scripttext .= '    \' <option value="2" ';
                        if ($currentmarker->baloon == 2)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_DESCRIPTION').'</option> \'+' ."\n";
                        $scripttext .= '    \' <option value="100" ';
                        if ($currentmarker->baloon == 100)
                        {
                            $scripttext .= 'selected="selected"';
                        }
                        $scripttext .= '>'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_MARKERCONTENT_NONE').'</option> \'+' ."\n";
                        $scripttext .= '    \' </select> \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        
                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAPMARKER_DETAIL_HREFIMAGE_LABEL' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        $scripttext .= '    \'<input name="markerhrefimage" type="text" maxlength="500" size="50" value="'. htmlspecialchars($currentmarker->hrefimage, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";

                        $scripttext .= '    \'<br />\'+' ."\n";

                    $scripttext .= '\'</div>\'+'."\n";
                    // End Placemark Properties
                                    
                    // Begin Placemark Group Properties
                    $scripttext .= '\'<div id="bodyInsertPlacemarkGrpDivA'.$currentmarker->id.'"  class="bodyInsertProperties">\'+'."\n";
                    $scripttext .= '\'<a id="bodyInsertPlacemarkGrpA'.$currentmarker->id.'" href="javascript:showonlyone(\\\'PlacemarkGroup\\\',\\\''.$currentmarker->id.'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_BASIC_GROUP_PROPERTIES' ).'</a>\'+'."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                    $scripttext .= '\'<div id="bodyInsertPlacemarkGrp'.$currentmarker->id.'"  class="bodyInsertPlacemarkGrpProperties">\'+'."\n";
                        $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_GROUP' ).' \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";
                        
                        $scripttext .= '    \' <select name="markergroup" > \'+' ."\n";
                        if ($currentmarker->markergroup == 0)
                        {
                            $scripttext .= '    \' <option value="" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_FILTER_PLACEMARK_GROUP').'</option> \'+' ."\n";
                        }
                        else
                        {
                            $scripttext .= '    \' <option value="">'.Text::_( 'COM_ZHOSMMAP_MAPMARKER_FILTER_PLACEMARK_GROUP').'</option> \'+' ."\n";
                        }
                        foreach ($newMarkerGroupList as $key => $newGrp) 
                        {
                            if ($currentmarker->markergroup == $newGrp->value)
                            {
                                $scripttext .= '    \' <option value="'.$newGrp->value.'" selected="selected">'.$newGrp->text.'</option> \'+' ."\n";
                            }
                            else
                            {
                                $scripttext .= '    \' <option value="'.$newGrp->value.'">'.$newGrp->text.'</option> \'+' ."\n";
                            }
                        }
                        $scripttext .= '    \' </select> \'+' ."\n";
                        $scripttext .= '    \'<br />\'+' ."\n";


                $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CATEGORY' ).' \'+' ."\n";
                $scripttext .= '    \'<br />\'+' ."\n";
                $scripttext .= '    \' <select name="markercatid" > \'+' ."\n";
                $scripttext .= '    \' <option value="" selected="selected">'.Text::_( 'COM_ZHOSMMAP_MAP_FILTER_CATEGORY').'</option> \'+' ."\n";
                $scripttext .= '    \''.str_replace(array("\r", "\r\n", "\n"),'', 
                                       HTMLHelper::_('select.options', HTMLHelper::_('category.options', 'com_zhosmmap'), 'value', 'text', $currentmarker->catid)) .
                                       '\'+' ."\n";
                $scripttext .= '    \' </select> \'+' ."\n";
                $scripttext .= '    \'<br />\'+' ."\n";

                $scripttext .= '    \'<br />\'+' ."\n";
                $scripttext .= '\'</div>\'+'."\n";
                // End Placemark Group Properties

                // Begin Contact Properties
                if (isset($usercontact) && (int)$usercontact == 1) 
                {

                    $scripttext .= '\'<div id="bodyInsertContactDivA'.$currentmarker->id.'"  class="bodyInsertProperties">\'+'."\n";
                    $scripttext .= '\'<a id="bodyInsertContactA'.$currentmarker->id.'" href="javascript:showonlyone(\\\'Contact\\\',\\\''.$currentmarker->id.'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PROPERTIES' ).'</a>\'+'."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                    $scripttext .= '\'<div id="bodyInsertContact'.$currentmarker->id.'"  class="bodyInsertContactProperties">\'+'."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_NAME' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactname" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_name, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_POSITION' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactposition" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_position, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_PHONE' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactphone" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_phone, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_MOBILE' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactmobile" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_mobile, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_FAX' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactfax" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_fax, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_EMAIL' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<input name="contactemail" type="text" maxlength="250" size="50" value="'. htmlspecialchars($currentmarker->contact_email, ENT_QUOTES, 'UTF-8').'" />\'+' ."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                    // Contact Address
                    $scripttext .= '\'<div id="bodyInsertContactAdrDivA'.$currentmarker->id.'"  class="bodyInsertProperties">\'+'."\n";
                    $scripttext .= '\'<a id="bodyInsertContactAdrA'.$currentmarker->id.'" href="javascript:showonlyone(\\\'ContactAddress\\\',\\\''.$currentmarker->id.'\\\');" ><img src="'.$imgpathUtils.'expand.png">'.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS_PROPERTIES' ).'</a>\'+'."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                    $scripttext .= '\'<div id="bodyInsertContactAdr'.$currentmarker->id.'"  class="bodyInsertContactAdrProperties">\'+'."\n";
                    $scripttext .= '    \''.Text::_( 'COM_ZHOSMMAP_MAP_USER_CONTACT_ADDRESS' ).' \'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<textarea name="contactaddress" cols="35" rows="4" >'. str_replace("\n\n", "'+'\\n'+'", str_replace(array("\r", "\r\n", "\n"), "\n",htmlspecialchars($currentmarker->contact_address, ENT_QUOTES, 'UTF-8'))).'</textarea>\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '    \'<br />\'+' ."\n";
                    $scripttext .= '\'</div>\'+'."\n";
                }
                // End Contact Properties
        
                $scripttext .= '\'\';'."\n";

                    // Change UserMarker - end
                    // contentString - User Placemark can Update - End

            return $scripttext;
    }
        
    private static function add_tab_to_placemark_content($titleTag, $infowin_type, 
                        $title, $content, 
                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class,
                        $div_style)
    {
        $returnText = '';
                $currentTitleTag = $titleTag;

                if ($div_add_div_tag == "popup")
                {
                    $returnText .= '\'<div';
                    if ($div_id != "")
                    {
                        $returnText .= ' id="'.$div_id.'"';
                    }
                    if ($div_class != "")
                    {
                        $returnText .= ' class="'.$div_class.'"';
                    }
                    if ($div_style != "")
                    {
                        $returnText .= ' style="'.$div_style.'"';
                    }
                    $returnText .= '>\'+'."\n";
                }
                
        if ($title != "")
        {
                    if ($infowin_type != "popup")
                    {
            $returnText .= '\'<'.$currentTitleTag.'>'.$title.'</'.$currentTitleTag.'>\'+'."\n";
                    }
                    $returnText .= '\'<div>'.$content.'</div>\'+'."\n";
        }
                
                if ($div_add_div_tag == "popup")
                {
                    $returnText .= '\'</div>\'+'."\n";
                } 
                
        return $returnText;
    }
    private static function add_tab_to_placemark_content_div(
                                    $titleTag, $infowin_type, $title, $div_content, 
                                    $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class,
                                    $div_style)
    {
        $returnText = '';
                $currentTitleTag = $titleTag;
        
                if ($div_add_div_tag == "popup")
                {
                    $returnText .= '\'<div';
                    if ($div_id != "")
                    {
                        $returnText .= ' id="'.$div_id.'"';
                    }
                    if ($div_class != "")
                    {
                        $returnText .= ' class="'.$div_class.'"';
                    }
                    
                    if ($div_style != "")
                    {
                        $returnText .= ' style="'.$div_style.'"';
                    }
                    $returnText .= '>\'+'."\n";
                }
                
        if ($title != "")
        {
                    if ($infowin_type != "popup")
                    {
            $returnText .= '\'<'.$currentTitleTag.'>'.$title.'</'.$currentTitleTag.'>\'+'."\n";
                    }
                    $returnText .= $div_content;
        }
                
                if ($div_add_div_tag == "popup")
                {
                    $returnText .= "\n";
                    $returnText .= '\'</div>\'+'."\n";
                }                
                else
                {
                    $returnText .= ''."\n";
                }
        return $returnText;
    }
    
    public static function get_placemark_tabs_content_string(
                        $titleTag, $infowin_type,
                        $currentArticleId, $currentmarker,
                        $contentString,
                        $imgpathIcons, $imgpathUtils, $directoryIcons, $lang)
    {

        $currentLanguage = Factory::getLanguage();
        $currentLangTag = $currentLanguage->getTag();
        
        $div_add_div_tag = "";
        $div_id_base = "";
        $div_id = "";
        $div_class_base = "";
        $div_class = "";
        $div_link_id_base = "";
        $div_link_id = "";
        $div_link_class_base = "";
        $div_link_class = "";
        
        // for content div
        $div_style = "";
        // for popup wrap div
        $div_style_popup = "";
        
        if ($infowin_type == "popup")
        {
            $div_add_div_tag = "popup";

            $div_id_base = "tabcontent".(int)$currentmarker->id;
            $div_id = $div_id_base;
            
            $div_class_base = "zhom-tabcontent".(int)$currentmarker->id;
            $div_class = "zhom-tabcontent " . $div_class_base;

            $div_link_id_base = "zhom-tablinks".(int)$currentmarker->id;
            $div_link_id = $div_link_id_base;
            
            $div_link_class_base = "zhom-tablinks".(int)$currentmarker->id;
            $div_link_class = "zhom-tablinks " . $div_link_class_base;
            
            if (isset($currentmarker->infobubblepublished) && (int)$currentmarker->infobubblepublished == 1)
            {
                if (isset($currentmarker->minheight) && (int)$currentmarker->minheight != "")
                {
                    $div_style = "min-height: ".(int)$currentmarker->minheight . "px;";
                }
            }

        }

        if (isset($lang) && $lang != "")
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $lang, true);    
        }
        else
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $currentLangTag, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $currentLangTag, true);        
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $currentLangTag, true);        
        }
        
        $returnText = '';
        $returnTextTabMenu = '';
        $returnTextTabMenuTab = '';
        $returnTextTabCount = 0;

        if ((int)$currentmarker->tab_info == 9)
        {
        }
        else
        {
            if ($infowin_type == "panel")
            {
                $returnText = '\'<div id="OMapsPanelAccordion'.$currentArticleId.'">\'+'."\n";
            }
            else if($infowin_type == "popup")
            {
                
            }
        }

        
        // InfoBubble Create Tabs - Begin                    
        if ((int)$currentmarker->tab_info == 1)
        {        
                        $returnTextTabCount += 1;                       
                        $div_id = $div_id_base .'_'. $returnTextTabCount;
                        $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                        $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
            $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content_div($titleTag, $infowin_type, str_replace("'", "\'", 
                                    str_replace(array("\r", "\r\n", "\n"), '', Text::_( 'COM_ZHOSMMAP_INFOBUBBLE_TAB_INFO_TITLE'))), $contentString .'+',
                                    $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                        $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                        $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                        $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', Text::_( 'COM_ZHOSMMAP_INFOBUBBLE_TAB_INFO_TITLE'))).'</button>\'+'."\n";                        
        }
        
        if ((int)$currentmarker->tab_info == 9)
        {    
                        $returnText .= $contentString;
        }
        else
        {
            
            if ($currentmarker->tab1 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab1title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab1)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab1title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab2 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                 $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab2title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab2)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab2title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab3 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab3title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab3)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab3title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab4 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab4title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab4)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab4title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab5 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab5title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab5)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab5title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab6 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab6title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab6)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab6title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab7 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab7title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab7)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab7title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab8 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab8title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab8)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab8title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab9 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab9title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab9)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab9title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab10 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab10title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab10)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab10title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab11 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab11title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab11)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab11title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab12 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab12title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab12)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab12title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab13 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab13title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab13)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab13title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab14 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab14title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab14)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab14title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab15 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab15title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab15)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab15title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab16 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab16title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab16)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab16title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab17 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab17title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab17)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab17title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab18 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab18title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab18)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab18title)).'</button>\'+'."\n";
            }
            if ($currentmarker->tab19 != "")
            {
                                $returnTextTabCount += 1;                       
                                $div_id = $div_id_base .'_'. $returnTextTabCount;
                                $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
                $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content($titleTag, $infowin_type, 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab19title)), 
                                        str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab19)),
                                        $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                                $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                                $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                                $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->tab19title)).'</button>\'+'."\n";
            }
        }
        
        
        if ((int)$currentmarker->tab_info == 2)
        {                    
                        $returnTextTabCount += 1;                       
                        $div_id = $div_id_base .'_'. $returnTextTabCount;
                        $div_link_class = $div_link_class_base .'_'. $returnTextTabCount;
                        $div_link_id = $div_link_id_base .'_'. $returnTextTabCount;
            $returnText .= MapPlacemarksHelper::add_tab_to_placemark_content_div($titleTag, $infowin_type, str_replace("'", "\'", 
                                    str_replace(array("\r", "\r\n", "\n"), '', Text::_( 'COM_ZHOSMMAP_INFOBUBBLE_TAB_INFO_TITLE'))), $contentString .'+',
                                    $div_add_div_tag, $div_id, $div_class, $div_link_id, $div_link_class, $div_style);
                        $returnTextTabMenuTab .= '\'<button id="'.$div_link_id.'" class="zhom-tablinks '.$div_link_class_base.' '.$div_link_class.'" ';
                        $returnTextTabMenuTab .= 'onclick="openPopupTab(event, \\\''.$div_id.'\\\', \\\''.$div_class_base.'\\\', \\\''.$div_link_class_base.'\\\')">';
                        $returnTextTabMenuTab .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', Text::_( 'COM_ZHOSMMAP_INFOBUBBLE_TAB_INFO_TITLE'))).'</button>\'+'."\n";                        
                        
        }

                if ((int)$currentmarker->tab_info == 9)
        {
        }
        else
        {
                    if ($infowin_type == "panel")
                    {
            $returnText .= '\'</div>\'';
                    }
                    else if($infowin_type == "popup")
                    {
                        
                        $returnTextTabMenu = '\'<div id="OMapsPopupWrap'.(int)$currentmarker->id.'"';
                        if ($div_style_popup != "")
                        {
                            $returnTextTabMenu .= ' style="'.$div_style_popup.'"';
                        }
                        $returnTextTabMenu .= '>\'+'."\n";
                        $returnTextTabMenu .= '\'<div id="OMapsPopup'.(int)$currentmarker->id.'" class="zhom-tab">\'+'."\n";
                        $returnTextTabMenu .= $returnTextTabMenuTab;
                        $returnTextTabMenu .= '\'</div>\'+'."\n";
                        $returnText .= '\'</div>\'+'."\n";
                        $returnText .= '\'\'';
                        
                    }
                    else
                    {
                        $returnText .= '\'\'';
                    }
        }

                        
        $returnText = $returnTextTabMenu . $returnText;
        
        // InfoBubble Create Tabs - End
        return $returnText;
    }
    
    
    public static function get_placemark_hover_string(
                        $currentmarker)
    {

        $returnText = '';
      
            $returnText .= '\'<div id="placemarkHoverContent'. $currentmarker->id.'">\' +    ' ."\n";

            $returnText .= '\'<div id="bodyHoverContent'. $currentmarker->id.'"  class="placemarkHoverBody">\'+'."\n";

            $returnText .= '\''.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->hoverhtml)).'\'+'."\n";


            $returnText .= '\'</div>\'+'."\n";
            
            
            $returnText .= '\'</div>\';'."\n";

        return $returnText;
    }
    
    public static function get_placemark_infobubble_style_by_id($id, $defaultStyle)
    {
        $db = Factory::getDBO();

        $query = $db->getQuery(true);

  
        $addWhereClause = '';
        $addWhereClause .= ' and bub.id = '. (int)$id;
        
        $scriptInfoBubbleStyle = '';
        
        if ((int)$id != 0)
        {
            $query->select('bub.id tabid, bub.minwidth, bub.maxwidth, bub.minheight, bub.maxheight, bub.disableautopan, bub.published infobubblepublished, bub.offsetx, bub.offsety')
                ->from('#__zhosmmaps_infobubbles as bub')
                ->where('1=1' . $addWhereClause)
                ;
            $db->setQuery($query);        
            
            $bubble = $db->loadObject();

            if (isset($bubble))
            {
                $scriptInfoBubbleStyle = MapPlacemarksHelper::get_placemark_infobubble_style_string($bubble, $defaultStyle);
            }
            else
            {
                $scriptInfoBubbleStyle = $defaultStyle;
            }
            
        }
        else
        {
            $scriptInfoBubbleStyle = $defaultStyle;
        }

        return $scriptInfoBubbleStyle;
        
    }
    
    
    public static function get_placemark_infobubble_style_string($currentmarker, $defaultStyle)
    {
        $scriptInfoBubbleStyle = '';

                if (isset($currentmarker->tabid) && (int)$currentmarker->tabid != 0)
                {
                    if (isset($currentmarker->infobubblepublished) && (int)$currentmarker->infobubblepublished == 1)
                    {

                            if (isset($currentmarker->minwidth) && $currentmarker->minwidth != "")
                            {
                                    if ($scriptInfoBubbleStyle == "")
                                    {
                                            $scriptInfoBubbleStyle .= 'minWidth: '.$currentmarker->minwidth;
                                    }
                                    else
                                    {
                                            $scriptInfoBubbleStyle .= "\n".', minWidth: '.$currentmarker->minwidth;
                                    }
                            }
                            if (isset($currentmarker->maxwidth) && $currentmarker->maxwidth != "")
                            {
                                    if ($scriptInfoBubbleStyle == "")
                                    {
                                            $scriptInfoBubbleStyle .= 'maxWidth: '.$currentmarker->maxwidth;
                                    }
                                    else
                                    {
                                            $scriptInfoBubbleStyle .= "\n".', maxWidth: '.$currentmarker->maxwidth;
                                    }
                            }
                            /* it is not Popup property
                            if (isset($currentmarker->minheight) && $currentmarker->minheight != "")
                            {
                                    if ($scriptInfoBubbleStyle == "")
                                    {
                                            $scriptInfoBubbleStyle .= 'minHeight: '.$currentmarker->minheight;
                                    }
                                    else
                                    {
                                            $scriptInfoBubbleStyle .= "\n".', minHeight: '.$currentmarker->minheight;
                                    }
                            }
                            */
                            if (isset($currentmarker->maxheight) && $currentmarker->maxheight != "")
                            {
                                    if ($scriptInfoBubbleStyle == "")
                                    {
                                            $scriptInfoBubbleStyle .= 'maxHeight: '.$currentmarker->maxheight;
                                    }
                                    else
                                    {
                                            $scriptInfoBubbleStyle .= "\n".', maxHeight: '.$currentmarker->maxheight;
                                    }
                            }            
                            if (isset($currentmarker->disableautopan))
                            {
                                    if ($scriptInfoBubbleStyle == "")
                                    {
                                            if ((int)$currentmarker->disableautopan == 1)
                                            {
                                                    $scriptInfoBubbleStyle .= 'autoPan: false';
                                            }
                                            else
                                            {
                                                    $scriptInfoBubbleStyle .= 'autoPan: true';
                                            }

                                    }
                                    else
                                    {
                                            if ((int)$currentmarker->disableautopan == 1)
                                            {
                                                    $scriptInfoBubbleStyle .= "\n".', autoPan: false';
                                            }
                                            else
                                            {
                                                    $scriptInfoBubbleStyle .= "\n".', autoPan: true';
                                            }
                                    }
                            }
                            if (isset($currentmarker->offsetx) && isset($currentmarker->offsety))
                            {
                                if ((int)$currentmarker->offsetx !=0 || (int)$currentmarker->offsety !=0)
                                {
                                    $scriptInfoBubbleStyle .= "\n".', offset: L.point('.(int)$currentmarker->offsetx .', '. (int)$currentmarker->offsety.')';
                                }
                            }
                            
                            if ($scriptInfoBubbleStyle != "")
                            {
                                    $scriptInfoBubbleStyle = '{'."\n" . $scriptInfoBubbleStyle. '}'."\n";
                            }
                    }

                }
                if ($scriptInfoBubbleStyle == "")
        {
            if (isset($defaultStyle))
            {
                $scriptInfoBubbleStyle = $defaultStyle;
            }
        }
        
        
        return $scriptInfoBubbleStyle;
    }    
    
    
    protected static function get_userinfo_for_marker($userId, $showuser, $imgpathIcons, $imgpathUtils, $directoryIcons)
    {
        
        if ((int)$userId != 0)
        {
            $cur_user_name = '';
            $cur_user_address = '';
            $cur_user_phone = '';
            
            $dbUsr = Factory::getDBO();
            $queryUsr = $dbUsr->getQuery(true);
            
            $queryUsr->select('p.*, h.name as profile_username')
                ->from('#__users as h')
                ->leftJoin('#__user_profiles as p ON p.user_id=h.id')
                ->where('h.id = '.(int)$userId);

            $dbUsr->setQuery($queryUsr);        
            $myUsr = $dbUsr->loadObjectList();
            
            if (isset($myUsr))
            {
                
                foreach ($myUsr as $key => $currentUsers) 
                {
                    $cur_user_name = $currentUsers->profile_username;

                    if ($currentUsers->profile_key == 'profile.address1')
                    {
                        $cur_user_address = $currentUsers->profile_value;
                    }
                    else if ($currentUsers->profile_key == 'profile.phone')
                    {
                        $cur_user_phone = $currentUsers->profile_value;
                    }
                    
                    
                }
                
                $cur_scripttext = '';
                
                if (isset($showuser) && ((int)$showuser != 0))
                {
                    switch ((int)$showuser) 
                    {
                        case 1:
                            if ($cur_user_name != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.Text::_('COM_ZHOSMMAP_MAP_USER_USER_NAME').' '.htmlspecialchars(str_replace('\\', '/', $cur_user_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                            if ($cur_user_address != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.Text::_('COM_ZHOSMMAP_MAP_USER_USER_ADDRESS').' '.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $cur_user_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                            }
                            if ($cur_user_phone != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.Text::_('COM_ZHOSMMAP_MAP_USER_USER_PHONE').' '.htmlspecialchars(str_replace('\\', '/', $cur_user_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                        break;
                        case 2:
                            if ($cur_user_name != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.htmlspecialchars(str_replace('\\', '/', $cur_user_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                            if ($cur_user_address != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser"><img src="'.$imgpathUtils.'address.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_USER_ADDRESS').'" />'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $cur_user_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                            }
                            if ($cur_user_phone != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser"><img src="'.$imgpathUtils.'phone.png" alt="'.Text::_('COM_ZHOSMMAP_MAP_USER_USER_PHONE').'" />'.htmlspecialchars(str_replace('\\', '/', $cur_user_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                        break;
                        case 3:
                            if ($cur_user_name != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.htmlspecialchars(str_replace('\\', '/', $cur_user_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                            if ($cur_user_address != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $cur_user_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                            }
                            if ($cur_user_phone != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.htmlspecialchars(str_replace('\\', '/', $cur_user_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                        break;
                        default:
                            if ($cur_user_name != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.htmlspecialchars(str_replace('\\', '/', $cur_user_name), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                            if ($cur_user_address != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.str_replace('<br /><br />', '<br />',str_replace(array("\r", "\r\n", "\n"), '<br />', htmlspecialchars(str_replace('\\', '/', $cur_user_address), ENT_QUOTES, 'UTF-8'))).'</p>\'+'."\n";
                            }
                            if ($cur_user_phone != "") 
                            {
                                $cur_scripttext .= '\'<p class="placemarkBodyUser">'.htmlspecialchars(str_replace('\\', '/', $cur_user_phone), ENT_QUOTES, 'UTF-8').'</p>\'+'."\n";
                            }
                        break;                                        
                    }
                }
                
                return $cur_scripttext;
            }
            else
            {
                return '';
            }    
        }
        else
        {
            return '';
        }    
        
        
    }

    protected static function get_datetime_for_marker_timestamp($datetime, $date_format)
    {
        $db = Factory::getDBO();

        $private_ret_val = '';
    
        
        if ($datetime != "")
        {
            if ($date_format != "")
            {                    
                $fv_date = new DateTime($datetime);
                $fv_date_user = $fv_date->format($date_format);
                $private_ret_val = htmlspecialchars(str_replace('\\', '/', $fv_date_user), ENT_QUOTES, 'UTF-8');
            }
            else
            {                
                $private_ret_val = htmlspecialchars(str_replace('\\', '/', $datetime), ENT_QUOTES, 'UTF-8');
            }
        }
                
        return $private_ret_val;
        
    }
    
    
    protected static function get_userinfo_for_marker_timestamp($userId)
    {

        $cur_user_name = '';
    
        if ((int)$userId != 0)
        {
            
            $dbUsr = Factory::getDBO();
            $queryUsr = $dbUsr->getQuery(true);
            
            $queryUsr->select('h.name as usr_username')
                ->from('#__users as h')
                ->where('h.id = '.(int)$userId);

            $dbUsr->setQuery($queryUsr);        
            $myUsr = $dbUsr->loadObject();
            
            if (isset($myUsr))
            {
                $cur_user_name = htmlspecialchars(str_replace('\\', '/', $myUsr->usr_username), ENT_QUOTES, 'UTF-8');
            }
        }

        return $cur_user_name;
        
    }
    
	// have to copy to PlacemarkModel.php
    public static function get_placemark_icon_definition(
                        $imgpathIcons,
                        $imgpath4size,
                        $currentmarker)
    {
        $scripttext = '';
        
        if ((int)$currentmarker->overridemarkericon == 0)
        {

            if ((int)$currentmarker->baloon == 21
            || (int)$currentmarker->baloon == 22
            || (int)$currentmarker->baloon == 23
            || (int)$currentmarker->baloon == 24)
            {

                $ofsX = (int)$currentmarker->labelanchorx;
                $ofsY = (int)$currentmarker->labelanchory;

                $scripttextPlacemarkContent = $currentmarker->labelcontent;

                if (isset($currentmarker->labelstyle) && $currentmarker->labelstyle != "")
                {
                    $scripttextPlacemarkContent = '<div class="placemarkLabel" style="'.str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->labelstyle).'">'.$scripttextPlacemarkContent."</div>";
                }

                $scripttextStart = '  L.divIcon({ ';
                $scripttextStart .= ' html: \''; 
                $scripttextStart .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $scripttextPlacemarkContent));
                $scripttextStart .= '\''."\n"; 

                $scripttextEnd = "";
                if ($currentmarker->labelclass != "")
                {
                        $scripttextEnd .= ', className: "'. $currentmarker->labelclass .'"'."\n";
                }        
                else
                {
                    // remove default little white rectangle
                    $scripttextEnd .= ', className: "zhom-placemark-label-default"'."\n";
                }
                if ($ofsX != 0 || $ofsY != 0)
                {
                    $scripttextEnd .= ', iconAnchor: ['.$ofsX.','.$ofsY.']';
                }
                $scripttextEnd .= '}) ' ."\n";
            }
            else
            {
                // do it everry time, because it needs to pass size
                //if ((int)$currentmarker->iconofsetx != 0
                //     || (int)$currentmarker->iconofsety != 0)
                //{
                        $imgimg = $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype).'.png';
                        $imgimg4size = $imgpath4size.$currentmarker->icontype.'.png';                            

                        list ($imgwidth, $imgheight) = getimagesize($imgimg4size);

                        if (substr($currentmarker->icontype, 0, 8) == "default#")
                        {
                                $offset_fix = 7;
                        }
                        else
                        {
                                $offset_fix = $imgwidth/2;
                        }                                
                        $ofsX = (int)$currentmarker->iconofsetx + $offset_fix;
                        $ofsY = (int)$currentmarker->iconofsety + $imgheight;

                        $scripttextStart = '      L.icon({ ';
                        $scripttextStart .= 'iconUrl: ';
                        $scripttextEnd = ', iconSize: ['.$imgwidth.', '.$imgheight.']';
                        $scripttextEnd .= ', iconAnchor: ['.$ofsX.','.$ofsY.']';
                        $scripttextEnd .= '}) ' ."\n";
                //}
                //else
                //{
                //    $scripttextStart = '      L.icon({ ';
                //    $scripttextStart .= 'iconUrl: ';
                //    $scripttextEnd = '})'."\n";
                //}
            }
                        
            switch ((int)$currentmarker->baloon) 
            {
            case 1:
                // DROP
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 2:
                // BOUNCE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 3:
                // SIMPLE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;            
            case 4:
                // BOUNCE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 5:
                // SIMPLE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 52:
                // BOUNCE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 54:
                // BOUNCE
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            case 21:
                // DROP MARKER WITH LABEL
                $scripttext .= $scripttextStart;
                $scripttext .= $scripttextEnd;
            break;
            case 22:
                // BOUNCE
                $scripttext .= $scripttextStart;
                $scripttext .= $scripttextEnd;
            break;
            case 23:
                // SIMPLE MARKER WITH LABEL
                $scripttext .= $scripttextStart;
                $scripttext .= $scripttextEnd;
            break;
            case 24:
                // BOUNCE MARKER WITH LABEL
                $scripttext .= $scripttextStart;
                $scripttext .= $scripttextEnd;
            break;
            default:
                $scripttext .= $scripttextStart;
                $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->icontype).'.png"';
                $scripttext .= $scripttextEnd;
            break;
            }
        }    
        else
        {
                        // do it everry time, because it needs to pass size
            //if ((int)$currentmarker->groupiconofsetx != 0
            //     || (int)$currentmarker->groupiconofsety != 0)
            //{
                $imgimg = $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype).'.png';
                $imgimg4size = $imgpath4size.$currentmarker->groupicontype.'.png';                            
                
                list ($imgwidth, $imgheight) = getimagesize($imgimg4size);
                if (substr($currentmarker->groupicontype, 0, 8) == "default#")
                {
                        $offset_fix = 7;
                }
                else
                {
                        $offset_fix = $imgwidth/2;
                }
                $ofsX = (int)$currentmarker->groupiconofsetx + $offset_fix;
                $ofsY = (int)$currentmarker->groupiconofsety + $imgheight;

                $scripttextStart = '      L.icon({ ';
                $scripttextStart .= 'iconUrl: ';
                $scripttextEnd = ', iconSize: ['.$imgwidth.', '.$imgheight.']';
                $scripttextEnd .= ', iconAnchor: ['.$ofsX.','.$ofsY.']';
                $scripttextEnd .= '}) ' ."\n";
            //}
            //else
            //{
            //    $scripttextStart = '      L.icon({ ';
            //    $scripttextStart .= 'iconUrl: ';
            //    $scripttextEnd = '})'."\n";
            //}
            
            $scripttext .= $scripttextStart;
            $scripttext .= 'icoIcon + "'.str_replace("#", "%23", $currentmarker->groupicontype).'.png"';
            $scripttext .= $scripttextEnd;
        }
    
        return $scripttext;
    }    
    
    
    private static function get_placemarklist_action_string($type, $currentArticleId, $currentmarkerid, $markerlistaction)
    {
        $scripttext = '';
        
        if ($type == 1)
        {
                                $scripttext .= ' markerLI.onclick = function(){ zhomObjMgr'.$currentArticleId.'.PlacemarkListAction('. $currentmarkerid.')};'."\n";
        }
        else
        {
                if ((int)$markerlistaction == 0) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ map'.$currentArticleId.'.setView(latlng'. $currentmarkerid.', map'.$currentArticleId.'.getZoom())};'."\n";
                }
                else if ((int)$markerlistaction == 1) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ marker'. $currentmarkerid.'.fire("click")};'."\n";
                }
                else if ((int)$markerlistaction == 11) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ '.
                    ' map'.$currentArticleId.'.setView(latlng'. $currentmarkerid.', map'.$currentArticleId.'.getZoom());'.
                    ' marker'. $currentmarkerid.'.fire("click");'.
                    '};'."\n";
                }
                else if ((int)$markerlistaction == 2) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ '.
                    ' map'.$currentArticleId.'.setView(latlng'. $currentmarkerid.', map'.$currentArticleId.'.getZoom());'.
                    ' Map_Animate_Marker(map'.$currentArticleId.', marker'. $currentmarkerid.');'.
                    '};'."\n";
                }
                else if ((int)$markerlistaction == 3) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ '.
                    ' Map_Animate_Marker(map'.$currentArticleId.', marker'. $currentmarkerid.');'.
                    ' marker'. $currentmarkerid.'.fire("click");'.
                    '};'."\n";
                }                                            
                else if ((int)$markerlistaction == 12) 
                {
                    $scripttext .= ' markerLI.onclick = function(){ '.
                    ' map'.$currentArticleId.'.setView(latlng'. $currentmarkerid.', map'.$currentArticleId.'.getZoom());'.
                    ' Map_Animate_Marker(map'.$currentArticleId.', marker'. $currentmarkerid.');'.
                    ' marker'. $currentmarkerid.'.fire("click");'.
                    '};'."\n";
                }
                else
                {
                    $scripttext .= ' markerLI.onclick = function(){ map'.$currentArticleId.'.setView(latlng'. $currentmarkerid.', map'.$currentArticleId.'.getZoom())};'."\n";
                }            
        }

        
        return $scripttext;
    }

    public static function get_placemarklist_string(
                        $type,
                        $currentArticleId, 
                        $currentmarker, 
                        $markerlistcssstyle,
                        $markerlistpos,
                        $markerlistcontent,
                        $markerlistaction,
                        $imgpathIcons)
    {
        $scripttext = '';
        if (isset($markerlistpos) && (int)$markerlistpos != 0) 
        {                        
            if (isset($currentmarker->includeinlist))
            {
                $doAddToList = (int)$currentmarker->includeinlist;                             
            }
            else
            {
                $doAddToList = 1;
            }
            
            if ($doAddToList == 1)
            {
                $scripttext .= 'if (markerUL)'."\n";
                $scripttext .= '{'."\n";
                if ((int)$markerlistcontent < 100) 
                {                                
                        $scripttext .= ' var markerLI = document.createElement(\'li\');'."\n";
                        $scripttext .= ' markerLI.id = "zhom_pmlist_item_'.$currentArticleId.'_'.$currentmarker->id.'";'."\n";
                        $scripttext .= ' markerLI.className = "zhom-li-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerLIWrp = document.createElement(\'div\');'."\n";
                        $scripttext .= ' markerLIWrp.className = "zhom-li-wrp-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerASelWrp = document.createElement(\'div\');'."\n";
                        $scripttext .= ' markerASelWrp.className = "zhom-li-wrp-a-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerASel = document.createElement(\'a\');'."\n";
                        $scripttext .= ' markerASel.className = "zhom-li-a-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' markerASel.id = "zhom_pmlist_'.$currentArticleId.'_'.$currentmarker->id.'";'."\n";
                        $scripttext .= ' markerASel.href = \'javascript:void(0);\';'."\n";
                        if ((int)$markerlistcontent == 0) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASel'. $currentmarker->id.'" class="zhom-0-li-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 1) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASel'. $currentmarker->id.'" class="zhom-1-lit-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-1-liw-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-1-lid-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 5) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASel'. $currentmarker->id.'" class="zhom-5-lit-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-5-liw-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-5-lid-'.$markerlistcssstyle.'">'.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml)).'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 2) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-2-liw-icon-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDIcon'. $currentmarker->id.'" class="zhom-2-lii-icon-'.$markerlistcssstyle.'"><img src="';
                            if ((int)$currentmarker->overridemarkericon == 0)
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype);
                            }
                            else
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype);
                            }
                            $scripttext .= '.png" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-2-lit-icon-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'\'+'."\n";
                            $scripttext .= ' \'</div></div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 3) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-3-liw-icon-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDIcon'. $currentmarker->id.'" class="zhom-3-lii-icon-'.$markerlistcssstyle.'"><img src="';
                            if ((int)$currentmarker->overridemarkericon == 0)
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype);
                            }
                            else
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype);
                            }
                            $scripttext .= '.png" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-3-lit-icon-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-3-liwd-icon-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-3-lid-icon-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 6) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-6-liw-icon-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDIcon'. $currentmarker->id.'" class="zhom-6-lii-icon-'.$markerlistcssstyle.'"><img src="';
                            if ((int)$currentmarker->overridemarkericon == 0)
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype);
                            }
                            else
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype);
                            }
                            $scripttext .= '.png" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-6-lit-icon-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-6-liwd-icon-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-6-lid-icon-'.$markerlistcssstyle.'">'.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml)).'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 4) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'';                                    
                            $scripttext .= '<table class="zhom-4-table-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<tbody>';
                            $scripttext .= '<tr class="zhom-4-row-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<td rowspan=2 class="zhom-4-tdicon-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<img src="';
                            if ((int)$currentmarker->overridemarkericon == 0)
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype);
                            }
                            else
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype);
                            }
                            $scripttext .= '.png" alt="" />';
                            $scripttext .= '</td>';
                            $scripttext .= '<td class="zhom-4-tdtitle-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '<tr>';
                            $scripttext .= '<td class="zhom-4-tddesc-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '</tbody>';
                            $scripttext .= '</table>';
                            $scripttext .= ' \';'."\n";
                        }
                        else if ((int)$markerlistcontent == 7) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'';                                    
                            $scripttext .= '<table class="zhom-7-table-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<tbody>';
                            $scripttext .= '<tr class="zhom-7-row-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<td rowspan=2 class="zhom-7-tdicon-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= '<img src="';
                            if ((int)$currentmarker->overridemarkericon == 0)
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->icontype);
                            }
                            else
                            {
                                    $scripttext .= $imgpathIcons.str_replace("#", "%23", $currentmarker->groupicontype);
                            }
                            $scripttext .= '.png" alt="" />';
                            $scripttext .= '</td>';
                            $scripttext .= '<td class="zhom-7-tdtitle-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '<tr>';
                            $scripttext .= '<td class="zhom-7-tddesc-icon-'.$markerlistcssstyle.'">';
                            $scripttext .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml));
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '</tbody>';
                            $scripttext .= '</table>';
                            $scripttext .= ' \';'."\n";
                        }
                        else if ((int)$markerlistcontent == 11) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-11-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-11-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-11-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" />\'+'."\n";
                            $scripttext .= ' \'</div></div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 12) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-12-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-12-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-12-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" /></div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-12-liwd-image-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-12-lid-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 16) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-16-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-16-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-16-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" /></div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-16-liwd-image-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-16-lid-image-'.$markerlistcssstyle.'">'.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml)).'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 13) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-13-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-13-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-13-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'\'+'."\n";
                            $scripttext .= ' \'</div></div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 14) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-14-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-14-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-14-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-14-liwd-image-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-14-lid-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 17) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDWrp'. $currentmarker->id.'" class="zhom-17-liw-image-'.$markerlistcssstyle.'">\'+'."\n";
                            $scripttext .= ' \'<div id="markerDImage'. $currentmarker->id.'" class="zhom-17-lii-image-'.$markerlistcssstyle.'"><img src="'.$currentmarker->hrefimagethumbnail.'" alt="" /></div>\'+'."\n";
                            $scripttext .= ' \'<div id="markerASel'. $currentmarker->id.'" class="zhom-17-lit-image-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-17-liwd-image-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDesc'. $currentmarker->id.'" class="zhom-17-lid-image-'.$markerlistcssstyle.'">'.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml)).'</div>\'+'."\n";
                            $scripttext .= ' \'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 15) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'';                                    
                            $scripttext .= '<table class="zhom-15-table-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<tbody>';
                            $scripttext .= '<tr class="zhom-15-row-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<td rowspan=2 class="zhom-15-tdicon-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<img src="'.$currentmarker->hrefimagethumbnail.'" alt="" />';
                            $scripttext .= '</td>';
                            $scripttext .= '<td class="zhom-15-tdtitle-image-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '<tr>';
                            $scripttext .= '<td class="zhom-15-tddesc-image-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '</tbody>';
                            $scripttext .= '</table>';
                            $scripttext .= ' \';'."\n";
                        }
                        else if ((int)$markerlistcontent == 18) 
                        {
                            $scripttext .= ' markerASel.innerHTML = ';
                            $scripttext .= ' \'';                                    
                            $scripttext .= '<table class="zhom-18-table-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<tbody>';
                            $scripttext .= '<tr class="zhom-18-row-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<td rowspan=2 class="zhom-18-tdicon-image-'.$markerlistcssstyle.'">';
                            $scripttext .= '<img src="'.$currentmarker->hrefimagethumbnail.'" alt="" />';
                            $scripttext .= '</td>';
                            $scripttext .= '<td class="zhom-18-tdtitle-image-'.$markerlistcssstyle.'">';
                            $scripttext .= htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8');
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '<tr>';
                            $scripttext .= '<td class="zhom-18-tddesc-image-'.$markerlistcssstyle.'">';
                            $scripttext .= str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml));
                            $scripttext .= '</td>';
                            $scripttext .= '</tr>';
                            $scripttext .= '</tbody>';
                            $scripttext .= '</table>';
                            $scripttext .= ' \';'."\n";
                        }
                        else
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASel'. $currentmarker->id.'" class="zhom-0-li-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                        }


                        $scripttext .= MapPlacemarksHelper::get_placemarklist_action_string($type, $currentArticleId, $currentmarker->id, $markerlistaction);

                        $scripttext .= ' markerASelWrp.appendChild(markerASel);'."\n";
                        $scripttext .= ' markerLIWrp.appendChild(markerASelWrp);'."\n";
                        if ((int)$markerlistcontent == 1
                         || (int)$markerlistcontent == 5) 
                        {
                            $scripttext .= ' markerLIWrp.appendChild(markerDSel);'."\n";
                        }
                        else if ((int)$markerlistcontent == 3
                              || (int)$markerlistcontent == 6) 
                        {
                            $scripttext .= ' markerLIWrp.appendChild(markerDSel);'."\n";
                        }
                        else if ((int)$markerlistcontent == 12
                              || (int)$markerlistcontent == 16) 
                        {
                            $scripttext .= ' markerLIWrp.appendChild(markerDSel);'."\n";
                        }
                        else if ((int)$markerlistcontent == 14
                              || (int)$markerlistcontent == 17) 
                        {
                            $scripttext .= ' markerLIWrp.appendChild(markerDSel);'."\n";
                        }
                        
                        
                        $scripttext .= ' markerLI.appendChild(markerLIWrp);'."\n";
                        $scripttext .= ' markerUL.appendChild(markerLI);'."\n";
                }
                else
                {
                        $scripttext .= ' var markerLI = document.createElement(\'tr\');'."\n";
                        $scripttext .= ' markerLI.id = "zhom_pmlist_item_'.$currentArticleId.'_'.$currentmarker->id.'";'."\n";
                        $scripttext .= ' markerLI.className = "zhom-li-table-tr-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerLI_C1 = document.createElement(\'td\');'."\n";
                        $scripttext .= ' markerLI_C1.className = "zhom-li-table-c1-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerASelWrp = document.createElement(\'div\');'."\n";
                        $scripttext .= ' markerASelWrp.className = "zhom-li-table-a-wrp-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' var markerASel = document.createElement(\'a\');'."\n";
                        $scripttext .= ' markerASel.className = "zhom-li-table-a-'.$markerlistcssstyle.'";'."\n";
                        $scripttext .= ' markerASel.id = "zhom_pmlist_'.$currentArticleId.'_'.$currentmarker->id.'";'."\n";
                        $scripttext .= ' markerASel.href = \'javascript:void(0);\';'."\n";
                        if ((int)$markerlistcontent == 101) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASelTable'. $currentmarker->id.'" class="zhom-101-td-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 102) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASelTable'. $currentmarker->id.'" class="zhom-102-td1-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";

                            $scripttext .= ' var markerLI_C2 = document.createElement(\'td\');'."\n";
                            $scripttext .= ' markerLI_C2.className = "zhom-li-table-c2-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-li-table-desc2-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDescTable'. $currentmarker->id.'" class="zhom-102-td2-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->description), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";
                        }
                        else if ((int)$markerlistcontent == 103) 
                        {
                            $scripttext .= ' markerASel.innerHTML = \'<div id="markerASelTable'. $currentmarker->id.'" class="zhom-103-td1-'.$markerlistcssstyle.'">'.htmlspecialchars(str_replace('\\', '/', $currentmarker->title), ENT_QUOTES, 'UTF-8').'</div>\';'."\n";

                            $scripttext .= ' var markerLI_C2 = document.createElement(\'td\');'."\n";
                            $scripttext .= ' markerLI_C2.className = "zhom-li-table-c3-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' var markerDSel = document.createElement(\'div\');'."\n";
                            $scripttext .= ' markerDSel.className = "zhom-li-table-desc3-'.$markerlistcssstyle.'";'."\n";
                            $scripttext .= ' markerDSel.innerHTML = ';
                            $scripttext .= ' \'<div id="markerDDescTable'. $currentmarker->id.'" class="zhom-103-td2-'.$markerlistcssstyle.'">'.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentmarker->descriptionhtml)).'</div>\';'."\n";
                        }
                        
                        $scripttext .= MapPlacemarksHelper::get_placemarklist_action_string($type, $currentArticleId, $currentmarker->id, $markerlistaction);

                        $scripttext .= ' markerASelWrp.appendChild(markerASel);'."\n";
                        $scripttext .= ' markerLI_C1.appendChild(markerASelWrp);'."\n";
                        if ((int)$markerlistcontent == 102
                         || (int)$markerlistcontent == 103) 
                        {
                            $scripttext .= ' markerLI_C2.appendChild(markerDSel);'."\n";
                        }
                        
                        
                        $scripttext .= ' markerLI.appendChild(markerLI_C1);'."\n";
                        if ((int)$markerlistcontent == 102
                         || (int)$markerlistcontent == 103) 
                        {
                            $scripttext .= ' markerLI.appendChild(markerLI_C2);'."\n";
                        }
                        $scripttext .= ' markerUL.appendChild(markerLI);'."\n";
                }
                $scripttext .= '}'."\n";
            }
        }
        return $scripttext;
    }
    
    public static function get_DataSQL($Id)
    {
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__zhosmmaps_data_sqls as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();
                        
        }

        return $mySO;
    }
        
    public static function get_DataSQL_Data(
                                $data_sql,
                                $data_server)
    {
                if ($data_sql != "")
                {
                    if (isset($data_server) && (int)$data_server != 0)
                    {
                            $dbSO1 = Factory::getDBO();

                            $querySO1 = $dbSO1->getQuery(true);
                            $querySO1->select('h.*')
                                    ->from('#__zhosmmaps_data_servers as h')
                                    ->where('h.id = '.(int) $data_server);
                            $dbSO1->setQuery($querySO1);        
                            $mySO1 = $dbSO1->loadObject();
                            
                            if (isset($mySO1) && (int)$mySO1->published == 1)
                            {
                                $option = array(); //prevent problems

                                $option['driver']   = $mySO1->srv_driver;            // Database driver name
                                $option['host']     = $mySO1->srv_host;    // Database host name
                                $option['user']     = $mySO1->srv_user;       // User for database authentication
                                $option['password'] = $mySO1->srv_password;   // Password for database authentication
                                $option['database'] = $mySO1->srv_database;      // Database name
                                $option['prefix']   = $mySO1->srv_prefix;             // Database prefix (may be empty)

                                $dbSO = DatabaseDriver::getInstance( $option );
                            }
                            else
                            {
                                $dbSO = Factory::getDBO();
                            }
                    }
                    else
                    {
                        $dbSO = Factory::getDBO();
                    }

                    $dbSO->setQuery($data_sql);        
                    $mySO = $dbSO->loadAssocList();
                
                }

        return $mySO;
    }
        
    public static function get_VisualizationStructure($Id)
    {
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__zhosmmaps_visual_structs as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();
                        
        }

        return $mySO;
    }

    
}
