<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap Component
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Site\Helper;
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;

/**
 * Zh OpenStreetMap Helper
 */
abstract class MapPathsHelper
{

    public static function get_path_content_string(
                        $currentArticleId,
                        $currentpath, 
                        $imgpathIcons, $imgpathUtils, $directoryIcons, $lang, $titleTag)
    {

        $currentLanguage = Factory::getLanguage();
        $currentLangTag = $currentLanguage->getTag();
        
        if (isset($titleTag) && $titleTag != "")
        {
            if ($titleTag == "h2"
             || $titleTag == "h3")
            {
                $currentTitleTag = $titleTag;
            }
            else
            {
                $currentTitleTag ='h2';
            }
        }
        else
        {
            $currentTitleTag ='h2';
        }
        
        if (isset($lang) && $lang != "")
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $lang, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap' , $lang, true);    
        }
        else
        {
            $currentLanguage->load('com_zhosmmap', JPATH_SITE, $currentLangTag, true);    
            $currentLanguage->load('com_zhosmmap', JPATH_COMPONENT, $currentLangTag, true);        
            $currentLanguage->load('com_zhosmmap', JPATH_SITE . '/components/com_zhosmmap', $currentLangTag, true);        
        }
        
        $returnText = '';

        $returnText .= '\'<div id="pathContent'. $currentpath->id.'" class="pathContent">\' +    ' ."\n";
        if (isset($currentpath->infowincontent) &&
            (((int)$currentpath->infowincontent == 0) ||
             ((int)$currentpath->infowincontent == 1))
            )
        {
            $returnText .= '\'<'.$currentTitleTag.' id="headContent'. $currentpath->id.'" class="pathHead">'.'\'+' ."\n";
            $returnText .= '\''.htmlspecialchars(str_replace('\\', '/', $currentpath->title), ENT_QUOTES, 'UTF-8').'\'+'."\n";
            $returnText .= '\'</'.$currentTitleTag.'>\'+' ."\n";
        }
        $returnText .= '\'<div id="bodyContent'. $currentpath->id.'" class="pathBody">\'+'."\n";


        if (isset($currentpath->infowincontent) &&
            (((int)$currentpath->infowincontent == 0) ||
             ((int)$currentpath->infowincontent == 2))
            )
        {
            $returnText .= '\''.htmlspecialchars(str_replace('\\', '/', $currentpath->description), ENT_QUOTES, 'UTF-8').'\'+'."\n";
        }
        $returnText .= '\''.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentpath->descriptionhtml)).'\'+'."\n";

        if ($currentpath->hrefsite!="")
        {
            $returnText .= '\'<p><a class="pathHREF" href="'.$currentpath->hrefsite.'" target="_blank">';
            if ($currentpath->hrefsitename != "")
            {
                $returnText .= htmlspecialchars($currentpath->hrefsitename, ENT_QUOTES, 'UTF-8');
            }
            else
            {
                $returnText .= $currentpath->hrefsite;
            }
            $returnText .= '</a></p>\'+'."\n";
        }

        
        $returnText .= '\'</div>\'+'."\n";
        $returnText .= '\'</div>\';'."\n";
                                
        return $returnText;
    }
    
    public static function get_path_hover_string(
                        $currentpath)
    {

        $returnText = '';
      
            $returnText .= '\'<div id="pathHoverContent'. $currentpath->id.'">\' +    ' ."\n";

            $returnText .= '\'<div id="bodyHoverContent'. $currentpath->id.'"  class="pathHoverBody">\'+'."\n";

            $returnText .= '\''.str_replace("'", "\'", str_replace(array("\r", "\r\n", "\n"), '', $currentpath->hoverhtml)).'\'+'."\n";


            $returnText .= '\'</div>\'+'."\n";
            
            
            $returnText .= '\'</div>\';'."\n";

        return $returnText;
    }

    public static function get_DataSQL($Id)
    {
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__zhosmmaps_data_sqls as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();
                        
        }

        return $mySO;
    }
        
    public static function get_DataSQL_Data(
                                $data_sql,
                                $data_server)
    {
                if ($data_sql != "")
                {
                    if (isset($data_server) && (int)$data_server != 0)
                    {
                            $dbSO1 = Factory::getDBO();

                            $querySO1 = $dbSO1->getQuery(true);
                            $querySO1->select('h.*')
                                    ->from('#__zhosmmaps_data_servers as h')
                                    ->where('h.id = '.(int) $data_server);
                            $dbSO1->setQuery($querySO1);        
                            $mySO1 = $dbSO1->loadObject();
                            
                            if (isset($mySO1) && (int)$mySO1->published == 1)
                            {
                                $option = array(); //prevent problems

                                $option['driver']   = $mySO1->srv_driver;            // Database driver name
                                $option['host']     = $mySO1->srv_host;    // Database host name
                                $option['user']     = $mySO1->srv_user;       // User for database authentication
                                $option['password'] = $mySO1->srv_password;   // Password for database authentication
                                $option['database'] = $mySO1->srv_database;      // Database name
                                $option['prefix']   = $mySO1->srv_prefix;             // Database prefix (may be empty)

                                $dbSO = DatabaseDriver::getInstance( $option );
                            }
                            else
                            {
                                $dbSO = Factory::getDBO();
                            }
                    }
                    else
                    {
                        $dbSO = Factory::getDBO();
                    }

                    $dbSO->setQuery($data_sql);        
                    $mySO = $dbSO->loadAssocList();
                
                }

        return $mySO;
    }
        
    public static function get_VisualizationStructure($Id)
    {
        
        if ((int)$Id != 0)
        {
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__zhosmmaps_visual_structs as h')
                ->where('h.id = '.(int) $Id);
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObject();
                        
        }

        return $mySO;
    }

}
