<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap Component
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Site\Helper;
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;

/**
 * Zh OpenStreetMap Helper
 */
abstract class MapGroupsHelper
{


    public static function get_CategoryHierarchy($list_id, $category_hierarchy, $category_ex_hierarchy, $up_level, $up_ex_level)
    {
        $addWhereClause = "";
        $return_CategoryHierarchy = "";
        $parent_list_id = "";
        $parent_level = -1;
        $parent_ex_level = -1;
        
        if ($list_id != "" && $category_hierarchy != 0)
        {
            $tmp_expl_ids = explode(',', str_replace(';',',', $list_id));                                       
            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
            $tmp_expl_ids = implode(',', $tmp_expl_ids);

            if (strpos($tmp_expl_ids, ','))
            {
                    $addWhereClause .= ' and h.id IN ('.$tmp_expl_ids.')';
            }
            else
            {
                    $addWhereClause .= ' and h.id = '.(int)$tmp_expl_ids;
            }
            
            
            if ($category_hierarchy == 1
             || $category_hierarchy == 2
             || $category_hierarchy == 3
             || $category_hierarchy == 4
             || $category_hierarchy == 5
            )
            {
                $addWhereClause .= ' and h.level >= '.$category_hierarchy;
            }
            elseif ($category_hierarchy == 10)
            {
                $addWhereClause .= ' and h.level > 1';
            }
            elseif ($category_hierarchy == 21
             || $category_hierarchy == 22
             || $category_hierarchy == 23
             || $category_hierarchy == 24
             || $category_hierarchy == 25
            )
            {
                if ($up_level == -1)
                {
                    if ($category_hierarchy == 21)
                    {
                        $parent_level = 0;
                    }
                    elseif ($category_hierarchy == 22)
                    {
                        $parent_level = 1;
                    }
                    elseif ($category_hierarchy == 23)
                    {
                        $parent_level = 2;
                    }
                    elseif ($category_hierarchy == 24)
                    {
                        $parent_level = 3;
                    }
                    elseif ($category_hierarchy == 25)
                    {
                        $parent_level = 4;
                    }     
                    else
                    {
                        $parent_level = -1;
                    }
                }
                else
                {
                    $parent_level = $up_level - 1;
                }
            }
            else
            {

            }
                            
            $dbSO = Factory::getDBO();

            $querySO = $dbSO->getQuery(true);
            $querySO->select('h.*')
                ->from('#__categories as h')
                ->where('h.extension = \'com_zhosmmap\'' . $addWhereClause);
                
            
            $querySO->order('h.title');

                
            $dbSO->setQuery($querySO);        
            $mySO = $dbSO->loadObjectList();
                        
            
            if (isset($mySO) && !empty($mySO)) 
            {
                $parent_sep = "";
                foreach ($mySO as $key => $mySO) 
                {
                    $hierarchyCategoryGroupCategory = ', name:"'.str_replace("\"", "\\\"", $mySO->title).'"';
                    $hierarchyCategoryExpand = "";
                        
                    if ($category_ex_hierarchy == 1
                     || $category_ex_hierarchy == 2
                     || $category_ex_hierarchy == 3
                     || $category_ex_hierarchy == 4
                     || $category_ex_hierarchy == 5
                    )
                    {
                        if ((int)$mySO->level <= $category_ex_hierarchy)
                        {
                            $hierarchyCategoryExpand = ", open:true";
                        }
                    }
                    elseif ($category_ex_hierarchy == 10)
                    {
                        $hierarchyCategoryExpand = ", open:true";
                    }
                    elseif ($category_ex_hierarchy == 21
                     || $category_ex_hierarchy == 22
                     || $category_ex_hierarchy == 23
                     || $category_ex_hierarchy == 24
                     || $category_ex_hierarchy == 25
                    )
                    {
                        if ($up_ex_level == -1)
                        {
                            if ($category_ex_hierarchy == 21)
                            {
                                $parent_ex_level = 0;
                            }
                            elseif ($category_ex_hierarchy == 22)
                            {
                                $parent_ex_level = 1;
                            }
                            elseif ($category_ex_hierarchy == 23)
                            {
                                $parent_ex_level = 2;
                            }
                            elseif ($category_ex_hierarchy == 24)
                            {
                                $parent_ex_level = 3;
                            }
                            elseif ($category_ex_hierarchy == 25)
                            {
                                $parent_ex_level = 4;
                            }     
                            else
                            {
                                $parent_ex_level = -1;
                            }
                        }
                        else
                        {
                            $parent_ex_level = $up_ex_level - 1;
                        }
                        
                        if ($parent_ex_level <= 0)
                        {
                            $hierarchyCategoryExpand = ", open:true";
                        }
                        
                    }
                    else
                    {

                    }
            

                    $return_CategoryHierarchy .= ', ' . '{ id:'.(int)$mySO->id.', pId:'.(int)$mySO->parent_id.''.$hierarchyCategoryGroupCategory.$hierarchyCategoryExpand.'}'."\n";  
                    $parent_list_id .= $parent_sep . (int)$mySO->parent_id;
                    if ($parent_sep == "")
                    {
                        $parent_sep = ",";
                    }
                }
            }
            
            if ($parent_list_id != "" && $parent_level != 0)
            {
                $return_CategoryHierarchy .= MapGroupsHelper::get_CategoryHierarchy($parent_list_id, $category_hierarchy, $category_ex_hierarchy, $parent_level, $parent_ex_level);
            }
        }

        return $return_CategoryHierarchy;
    }
        
}
