L.Control.Elevation=L.Control.extend({includes:L.Evented?L.Evented.prototype:L.Mixin.Events,options:{autohide:true,autohideMarker:true,collapsed:false,controlButton:{iconCssClass:"elevation-toggle-icon",title:"Elevation"},detached:true,distanceFactor:1,download:"link",elevationDiv:"#elevation-div",followMarker:true,forceAxisBounds:false,gpxOptions:{async:true,marker_options:{startIconUrl:null,endIconUrl:null,shadowUrl:null,wptIcons:{"":L.divIcon({className:"elevation-waypoint-marker",html:'<i class="elevation-waypoint-icon"></i>',
iconSize:[30,30],iconAnchor:[8,30]})}},polyline_options:{className:"",color:"#566B13",opacity:.75,weight:5,lineCap:"round"}},height:200,heightFactor:1,hoverNumber:{decimalsX:2,decimalsY:0,formatter:undefined},imperial:false,interpolation:"curveLinear",lazyLoadJS:true,marker:"elevation-line",markerIcon:L.divIcon({className:"elevation-position-marker",html:'<i class="elevation-position-icon"></i>',iconSize:[32,32],iconAnchor:[16,16]}),position:"topright",reverseCoords:false,theme:"lightblue-theme",
margins:{top:10,right:20,bottom:30,left:50},responsive:true,summary:"inline",width:600,xLabel:"km",xTicks:undefined,yAxisMax:undefined,yAxisMin:undefined,yLabel:"m",yTicks:undefined,zFollow:13},__mileFactor:.621371,__footFactor:3.28084,addData:function(d,layer){this._addData(d);if(this._container)this._applyData();if((typeof layer==="undefined"||layer===null)&&d.on)layer=d;if(layer){if(layer._path)L.DomUtil.addClass(layer._path,"elevation-polyline "+this.options.theme);layer.on("mousemove",this._mousemoveLayerHandler,
this).on("mouseout",this._mouseoutHandler,this)}this.track_info=this.track_info||{};this.track_info.distance=this._distance;this.track_info.elevation_max=this._maxElevation;this.track_info.elevation_min=this._minElevation;this._layers=this._layers||{};this._layers[L.Util.stamp(layer)]=layer;var evt={data:d,layer:layer,track_info:this.track_info};if(this.fire)this.fire("eledata_added",evt,true);if(this._map)this._map.fire("eledata_added",evt,true)},addTo:function(map){if(this.options.detached)this._addToChartDiv(map);
else L.Control.prototype.addTo.call(this,map)},clear:function(){this._clearPath();this._clearChart();this._clearData();if(this.fire)this.fire("eledata_clear");if(this._map)this._map.fire("eledata_clear")},disableDragging:function(){this._draggingEnabled=false;this._resetDrag()},enableDragging:function(){this._draggingEnabled=true},fitBounds:function(){if(this._map)this._map.fitBounds(this._fullExtent)},getZFollow:function(){return this._zFollow},hide:function(){this._container.style.display="none"},
initialize:function(options){this.options.autohide=typeof options.autohide!=="undefined"?options.autohide:!L.Browser.mobile;if(typeof options.detachedView!=="undefined")this.options.detached=options.detachedView;if(typeof options.responsiveView!=="undefined")this.options.responsive=options.responsiveView;if(typeof options.showTrackInfo!=="undefined")this.options.summary=options.showTrackInfo;if(typeof options.summaryType!=="undefined")this.options.summary=options.summaryType;if(typeof options.autohidePositionMarker!==
"undefined")this.options.autohideMarker=options.autohidePositionMarker;if(typeof options.followPositionMarker!=="undefined")this.options.followMarker=options.followPositionMarker;if(typeof options.useLeafletMarker!=="undefined")this.options.marker=options.useLeafletMarker?"position-marker":"elevation-line";if(typeof options.leafletMarkerIcon!=="undefined")this.options.markerIcon=options.leafletMarkerIcon;this.options=this._deepExtend(this.options,options);this._draggingEnabled=!L.Browser.mobile;if(options.imperial){this._distanceFactor=
this.__mileFactor;this._heightFactor=this.__footFactor;this._xLabel="mi";this._yLabel="ft"}else{this._distanceFactor=this.options.distanceFactor;this._heightFactor=this.options.heightFactor;this._xLabel=this.options.xLabel;this._yLabel=this.options.yLabel}this._zFollow=this.options.zFollow;if(this.options.followMarker)this._setMapView=L.Util.throttle(this._setMapView,300,this)},load:function(data){this.loadData(data)},loadChart:function(map){this.addTo(map)},loadData:function(data){if(this._isXMLDoc(data))this.loadGPX(data);
else if(this._isJSONDoc(data))this.loadGeoJSON(data);else this.loadFile(data)},loadFile:function(url){this._downloadURL=url;try{var xhr=new XMLHttpRequest;xhr.responseType="text";xhr.open("GET",url);xhr.onload=function(){if(xhr.status!==200)throw"Error "+xhr.status+" while fetching remote file: "+url;else this.loadData(xhr.response)}.bind(this);xhr.send()}catch(e){console.warn(e)}},loadGeoJSON:function(data){if(typeof data==="string")data=JSON.parse(data);this.layer=this.geojson=L.geoJson(data,{style:function(feature){return{color:"#566B13",
className:"elevation-polyline "+this.options.theme}}.bind(this),onEachFeature:function(feature,layer){this.addData(feature,layer);this.track_info=this.track_info||{};this.track_info.type="geojson";this.track_info.name=data.name;this.track_info.distance=this._distance;this.track_info.elevation_max=this._maxElevation;this.track_info.elevation_min=this._minElevation}.bind(this)});if(this._map){this._map.once("layeradd",function(e){this._map.fitBounds(this.layer.getBounds());var evt={data:data,layer:this.layer,
name:this.track_info.name,track_info:this.track_info};if(this.fire)this.fire("eledata_loaded",evt,true);if(this._map)this._map.fire("eledata_loaded",evt,true)},this);this.layer.addTo(this._map)}else console.warn("Undefined elevation map object")},loadGPX:function(data){var callback=function(data){this.options.gpxOptions.polyline_options.className+="elevation-polyline "+this.options.theme;this.layer=this.gpx=new L.GPX(data,this.options.gpxOptions);this.layer.on("loaded",function(e){if(this._map)this._map.fitBounds(e.target.getBounds())},
this);this.layer.on("addpoint",function(e){if(e.point._popup){e.point._popup.options.className="elevation-popup";e.point._popup._content=decodeURI(e.point._popup._content)}if(e.point._popup&&e.point._popup._content)e.point.bindTooltip(e.point._popup._content,{direction:"top",sticky:true,opacity:1,className:"elevation-tooltip"}).openTooltip()});this.layer.once("addline",function(e){this.addData(e.line);this.track_info=this.track_info||{};this.track_info.type="gpx";this.track_info.name=this.layer.get_name();
this.track_info.distance=this._distance;this.track_info.elevation_max=this._maxElevation;this.track_info.elevation_min=this._minElevation;var evt={data:data,layer:this.layer,name:this.track_info.name,track_info:this.track_info};if(this.fire)this.fire("eledata_loaded",evt,true);if(this._map)this._map.fire("eledata_loaded",evt,true)},this);if(this._map)this.layer.addTo(this._map);else console.warn("Undefined elevation map object")}.bind(this,data);if(typeof L.GPX!=="function"&&this.options.lazyLoadJS){L.Control.Elevation._gpxLazyLoader=
this._lazyLoadJS("https://cdnjs.cloudflare.com/ajax/libs/leaflet-gpx/1.4.0/gpx.js",L.Control.Elevation._gpxLazyLoader);L.Control.Elevation._gpxLazyLoader.then(callback)}else callback.call()},onAdd:function(map){this._map=map;var opts=this.options;var container=this._container=L.DomUtil.create("div","elevation-control elevation");if(!this.options.detached)L.DomUtil.addClass(container,"leaflet-control");if(this.options.theme)L.DomUtil.addClass(container,opts.theme);var callback=function(map,container){this._initToggle(container);
this._initChart(container);this._applyData();this._map.on("zoom viewreset zoomanim",this._hidePositionMarker,this);this._map.on("resize",this._resetView,this);this._map.on("resize",this._resizeChart,this);this._map.on("mousedown",this._resetDrag,this);this._map.on("eledata_loaded",this._updateSummary,this);L.DomEvent.on(this._map._container,"mousewheel",this._resetDrag,this);L.DomEvent.on(this._map._container,"touchstart",this._resetDrag,this)}.bind(this,map,container);if(typeof d3!=="object"&&this.options.lazyLoadJS){L.Control.Elevation._d3LazyLoader=
this._lazyLoadJS("https://unpkg.com/d3@4.13.0/build/d3.min.js",L.Control.Elevation._d3LazyLoader);L.Control.Elevation._d3LazyLoader.then(callback)}else callback.call();return container},onRemove:function(map){this._container=null},setZFollow:function(zoom){this._zFollow=zoom},show:function(){this._container.style.display="block"},_addData:function(d){var geom=d&&d.geometry&&d.geometry;var i;if(geom)switch(geom.type){case "LineString":this._addGeoJSONData(geom.coordinates);break;case "MultiLineString":for(i=
0;i<geom.coordinates.length;i++)this._addGeoJSONData(geom.coordinates[i]);break;default:console.warn("Unsopperted GeoJSON feature geometry type:"+geom.type)}var feat=d&&d.type==="FeatureCollection";if(feat)for(i=0;i<d.features.length;i++)this._addData(d.features[i]);if(d&&d._latlngs)this._addGPXdata(d._latlngs)},_addGeoJSONData:function(coords){if(coords)for(var i=0;i<coords.length;i++)this._addPoint(coords[i][1],coords[i][0],coords[i][2])},_addGPXdata:function(coords){if(coords)for(var i=0;i<coords.length;i++)this._addPoint(coords[i].lat,
coords[i].lng,coords[i].meta.ele)},_addPoint:function(x,y,z){if(this.options.reverseCoords){var tmp=x;x=y;y=tmp}var data=this._data||[];var eleMax=this._maxElevation||-Infinity;var eleMin=this._minElevation||+Infinity;var dist=this._distance||0;var curr=new L.LatLng(x,y);var prev=data.length?data[data.length-1].latlng:curr;var delta=curr.distanceTo(prev)*this._distanceFactor;dist=dist+Math.round(delta/1E3*1E5)/1E5;if(typeof z!=="undefined"){z=z*this._heightFactor;eleMax=eleMax<z?z:eleMax;eleMin=eleMin>
z?z:eleMin;data.push({dist:dist,x:x,y:y,z:z,latlng:curr})}this._data=data;this._distance=dist;this._maxElevation=eleMax;this._minElevation=eleMin},_addToChartDiv:function(map){this._appendElevationDiv(map._container).appendChild(this.onAdd(map))},_appendChart:function(svg){var g=svg.append("g").attr("transform","translate("+this.options.margins.left+","+this.options.margins.top+")");this._appendGrid(g);this._appendAreaPath(g);this._appendAxis(g);this._appendFocusRect(g);this._appendMouseFocusG(g)},
_appendElevationDiv:function(container){var eleDiv=document.querySelector(this.options.elevationDiv);if(!eleDiv){eleDiv=L.DomUtil.create("div","leaflet-control elevation elevation-div");this.options.elevationDiv="#elevation-div_"+Math.random().toString(36).substr(2,9);eleDiv.id=this.options.elevationDiv.substr(1);container.parentNode.insertBefore(eleDiv,container.nextSibling)}if(this.options.detached){L.DomUtil.addClass(eleDiv,"elevation-detached");L.DomUtil.removeClass(eleDiv,"leaflet-control")}this.eleDiv=
eleDiv;return this.eleDiv},_appendXaxis:function(axis){axis.append("g").attr("class","x axis").attr("transform","translate(0,"+this._height()+")").call(d3.axisBottom().scale(this._x).ticks(this.options.xTicks)).append("text").attr("x",this._width()+6).attr("y",30).text(this._xLabel)},_appendXGrid:function(grid){grid.append("g").attr("class","x grid").attr("transform","translate(0,"+this._height()+")").call(d3.axisBottom().scale(this._x).ticks(this.options.xTicks).tickSize(-this._height()).tickFormat(""))},
_appendYaxis:function(axis){axis.append("g").attr("class","y axis").call(d3.axisLeft().scale(this._y).ticks(this.options.yTicks)).append("text").attr("x",-30).attr("y",3).text(this._yLabel)},_appendYGrid:function(grid){grid.append("g").attr("class","y grid").call(d3.axisLeft().scale(this._y).ticks(this.options.yTicks).tickSize(-this._width()).tickFormat(""))},_appendAreaPath:function(g){this._areapath=g.append("path").attr("class","area")},_appendAxis:function(g){this._axis=g.append("g").attr("class",
"axis");this._appendXaxis(this._axis);this._appendYaxis(this._axis)},_appendFocusRect:function(g){var focusRect=this._focusRect=g.append("rect").attr("width",this._width()).attr("height",this._height()).style("fill","none").style("stroke","none").style("pointer-events","all");if(L.Browser.mobile){focusRect.on("touchmove.drag",this._dragHandler.bind(this)).on("touchstart.drag",this._dragStartHandler.bind(this)).on("touchstart.focus",this._mousemoveHandler.bind(this)).on("touchmove.focus",this._mousemoveHandler.bind(this));
L.DomEvent.on(this._container,"touchend",this._dragEndHandler,this)}focusRect.on("mousemove.drag",this._dragHandler.bind(this)).on("mousedown.drag",this._dragStartHandler.bind(this)).on("mousemove.focus",this._mousemoveHandler.bind(this)).on("mouseout.focus",this._mouseoutHandler.bind(this));L.DomEvent.on(this._container,"mouseup",this._dragEndHandler,this)},_appendGrid:function(g){this._grid=g.append("g").attr("class","grid");this._appendXGrid(this._grid);this._appendYGrid(this._grid)},_appendMouseFocusG:function(g){var focusG=
this._focusG=g.append("g").attr("class","mouse-focus-group");this._mousefocus=focusG.append("svg:line").attr("class","mouse-focus-line").attr("x2","0").attr("y2","0").attr("x1","0").attr("y1","0");this._focuslabelrect=focusG.append("rect").attr("class","mouse-focus-label").attr("x",0).attr("y",0).attr("width",0).attr("height",0).attr("rx",3).attr("ry",3);this._focuslabeltext=focusG.append("svg:text").attr("class","mouse-focus-label-text");this._focuslabelY=this._focuslabeltext.append("svg:tspan").attr("class",
"mouse-focus-label-y").attr("dy","-1em");this._focuslabelX=this._focuslabeltext.append("svg:tspan").attr("class","mouse-focus-label-x").attr("dy","2em")},_appendPositionMarker:function(pane){var theme=this.options.theme;var heightG=pane.select("g");this._mouseHeightFocus=heightG.append("svg:line").attr("class",theme+" height-focus line").attr("x2",0).attr("y2",0).attr("x1",0).attr("y1",0);this._pointG=heightG.append("g");this._pointG.append("svg:circle").attr("class",theme+" height-focus circle-lower").attr("r",
6).attr("cx",0).attr("cy",0);this._mouseHeightFocusLabel=heightG.append("svg:text").attr("class",theme+" height-focus-label").style("pointer-events","none")},_applyData:function(){if(!this._data)return;var xdomain=d3.extent(this._data,function(d){return d.dist});var ydomain=d3.extent(this._data,function(d){return d.z});var opts=this.options;if(opts.yAxisMin!==undefined&&(opts.yAxisMin<ydomain[0]||opts.forceAxisBounds))ydomain[0]=opts.yAxisMin;if(opts.yAxisMax!==undefined&&(opts.yAxisMax>ydomain[1]||
opts.forceAxisBounds))ydomain[1]=opts.yAxisMax;this._x.domain(xdomain);this._y.domain(ydomain);this._areapath.datum(this._data).attr("d",this._area);this._updateAxis();this._fullExtent=this._calculateFullExtent(this._data)},_calculateFullExtent:function(data){if(!data||data.length<1)throw new Error("no data in parameters");var ext=new L.latLngBounds(data[0].latlng,data[0].latlng);data.forEach(function(item){ext.extend(item.latlng)});return ext},_clearChart:function(){this._resetDrag();if(this._areapath){this._areapath.attr("d",
"M0 0");this._x.domain([0,1]);this._y.domain([0,1]);this._updateAxis()}},_clearData:function(){this._data=null;this._distance=null;this._maxElevation=null;this._minElevation=null;this.track_info=null;this._layers=null},_clearPath:function(){this._hidePositionMarker();for(var id in this._layers){L.DomUtil.removeClass(this._layers[id]._path,"elevation-polyline");L.DomUtil.removeClass(this._layers[id]._path,this.options.theme)}},_collapse:function(){if(this._container){L.DomUtil.removeClass(this._container,
"elevation-expanded");L.DomUtil.addClass(this._container,"elevation-collapsed")}},_deepExtend:function(out){out=out||{};for(var i=1,len=arguments.length;i<len;++i){var obj=arguments[i];if(!obj)continue;for(var key in obj){if(!obj.hasOwnProperty(key))continue;if(Object.prototype.toString.call(obj[key])==="[object Object]"){out[key]=this._deepExtend(out[key],obj[key]);continue}out[key]=obj[key]}}return out},_saveFile:function(fileUrl){var d=document,a=d.createElement("a"),b=d.body;a.href=fileUrl;a.target=
"_new";a.download="";a.style.display="none";b.appendChild(a);a.click();b.removeChild(a)},_dragHandler:function(){d3.event.preventDefault();d3.event.stopPropagation();this._gotDragged=true;this._drawDragRectangle()},_dragEndHandler:function(){if(!this._dragStartCoords||!this._dragCurrentCoords||!this._gotDragged){this._dragStartCoords=null;this._gotDragged=false;if(this._draggingEnabled)this._resetDrag();return}var item1=this._findItemForX(this._dragStartCoords[0]),item2=this._findItemForX(this._dragCurrentCoords[0]);
if(item1==item2)return;this._hidePositionMarker();this._fitSection(item1,item2);this._dragStartCoords=null;this._gotDragged=false;var evt={data:{dragstart:this._data[item1],dragend:this._data[item2]}};if(this.fire)this.fire("elechart_dragged",evt,true);if(this._map)this._map.fire("elechart_dragged",evt,true)},_dragStartHandler:function(){d3.event.preventDefault();d3.event.stopPropagation();this._gotDragged=false;this._dragStartCoords=d3.mouse(this._focusRect.node())},_drawDragRectangle:function(){if(!this._dragStartCoords||
!this._draggingEnabled)return;var dragEndCoords=this._dragCurrentCoords=d3.mouse(this._focusRect.node());var x1=Math.min(this._dragStartCoords[0],dragEndCoords[0]),x2=Math.max(this._dragStartCoords[0],dragEndCoords[0]);if(!this._dragRectangle&&!this._dragRectangleG){var g=d3.select(this._container).select("svg").select("g");this._dragRectangleG=g.insert("g",".mouse-focus-group");this._dragRectangle=this._dragRectangleG.append("rect").attr("width",x2-x1).attr("height",this._height()).attr("x",x1).attr("class",
"mouse-drag").style("pointer-events","none")}else this._dragRectangle.attr("width",x2-x1).attr("x",x1)},_expand:function(){if(this._container){L.DomUtil.removeClass(this._container,"elevation-collapsed");L.DomUtil.addClass(this._container,"elevation-expanded")}},_findItemForLatLng:function(latlng){var result=null,d=Infinity;this._data.forEach(function(item){var dist=latlng.distanceTo(item.latlng);if(dist<d){d=dist;result=item}});return result},_findItemForX:function(x){var bisect=d3.bisector(function(d){return d.dist}).left;
var xinvert=this._x.invert(x);return bisect(this._data,xinvert)},_fitSection:function(index1,index2){var start=Math.min(index1,index2),end=Math.max(index1,index2);var ext=this._calculateFullExtent(this._data.slice(start,end));if(this._map)this._map.fitBounds(ext)},_formatter:function(num,dec,sep){var res;if(dec===0)res=Math.round(num)+"";else res=L.Util.formatNum(num,dec)+"";var numbers=res.split(".");if(numbers[1]){var d=dec-numbers[1].length;for(;d>0;d--)numbers[1]+="0";res=numbers.join(sep||".")}return res},
_height:function(){var opts=this.options;return opts.height-opts.margins.top-opts.margins.bottom},_hidePositionMarker:function(){if(!this.options.autohideMarker)return;this._selectedItem=null;if(this._marker){if(this._map)this._map.removeLayer(this._marker);this._marker=null}if(this._mouseHeightFocus){this._mouseHeightFocus.style("visibility","hidden");this._mouseHeightFocusLabel.style("visibility","hidden")}if(this._pointG)this._pointG.style("visibility","hidden");if(this._focusG)this._focusG.style("visibility",
"hidden")},_initChart:function(){var opts=this.options;opts.xTicks=opts.xTicks||Math.round(this._width()/75);opts.yTicks=opts.yTicks||Math.round(this._height()/30);opts.hoverNumber.formatter=opts.hoverNumber.formatter||this._formatter;if(opts.responsive)if(opts.detached){var offsetWi=this.eleDiv.offsetWidth;var offsetHe=this.eleDiv.offsetHeight;opts.width=offsetWi>0?offsetWi:opts.width;opts.height=offsetHe-20>0?offsetHe-20:opts.height}else{opts._maxWidth=opts._maxWidth>opts.width?opts._maxWidth:opts.width;
var containerWidth=this._map._container.clientWidth;opts.width=opts._maxWidth>containerWidth?containerWidth-30:opts.width}var x=this._x=d3.scaleLinear().range([0,this._width()]);var y=this._y=d3.scaleLinear().range([this._height(),0]);var interpolation=typeof opts.interpolation==="function"?opts.interpolation:d3[opts.interpolation];var area=this._area=d3.area().curve(interpolation).x(function(d){return d.xDiagCoord=x(d.dist)}).y0(this._height()).y1(function(d){return y(d.z)});var line=this._line=
d3.line().x(function(d){return d3.mouse(svg.select("g"))[0]}).y(function(d){return this._height()});var container=d3.select(this._container);var svg=container.append("svg").attr("class","background").attr("width",opts.width).attr("height",opts.height);var summary=this.summaryDiv=container.append("div").attr("class","elevation-summary "+this.options.summary+"-summary").node();this._appendChart(svg);this._updateSummary()},_initToggle:function(container){container.setAttribute("aria-haspopup",true);
if(!this.options.detached)L.DomEvent.disableClickPropagation(container);if(L.Browser.mobile)L.DomEvent.on(container,"click",L.DomEvent.stopPropagation);L.DomEvent.on(container,"mousewheel",this._mousewheelHandler,this);if(!this.options.detached){var iconCssClass="elevation-toggle "+this.options.controlButton.iconCssClass+(this.options.autohide?"":" close-button");var link=this._button=L.DomUtil.create("a",iconCssClass,container);link.href="#";link.title=this.options.controlButton.title;if(this.options.collapsed){this._collapse();
if(this.options.autohide)L.DomEvent.on(container,"mouseover",this._expand,this).on(container,"mouseout",this._collapse,this);else L.DomEvent.on(link,"click",L.DomEvent.stop).on(link,"click",this._toggle,this);L.DomEvent.on(link,"focus",this._toggle,this);this._map.on("click",this._collapse,this)}}else;},_isJSONDoc:function(doc,lazy){lazy=typeof lazy==="undefined"?true:lazy;if(typeof doc==="string"&&lazy){doc=doc.trim();return doc.indexOf("{")==0||doc.indexOf("[")==0}else{try{JSON.parse(doc.toString())}catch(e){if(typeof doc===
"object"&&lazy)return true;console.warn(e);return false}return true}},_isXMLDoc:function(doc,lazy){lazy=typeof lazy==="undefined"?true:lazy;if(typeof doc==="string"&&lazy){doc=doc.trim();return doc.indexOf("<")==0}else{var documentElement=(doc?doc.ownerDocument||doc:0).documentElement;return documentElement?documentElement.nodeName!=="HTML":false}},_isDomVisible:function(elem){return!!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length)},_lazyLoadJS:function(url,skip){if(typeof skip==
"undefined")skip=false;return new Promise(function(resolve,reject){if(skip)return resolve();var tag=document.createElement("script");tag.addEventListener("load",resolve,{once:true});tag.src=url;document.head.appendChild(tag)})},_mousemoveHandler:function(d,i,ctx){if(!this._data||this._data.length===0)return;var coords=d3.mouse(this._focusRect.node());var xCoord=coords[0];var item=this._data[this._findItemForX(xCoord)];this._hidePositionMarker();this._showDiagramIndicator(item,xCoord);this._showPositionMarker(item);
this._setMapView(item);var evt={data:item};if(this.fire)this.fire("elechart_change",evt,true);if(this._map)this._map.fire("elechart_change",evt,true)},_mousemoveLayerHandler:function(e){if(!this._data||this._data.length===0)return;var latlng=e.latlng;var item=this._findItemForLatLng(latlng);if(item){var x=item.xDiagCoord;this._hidePositionMarker();this._showDiagramIndicator(item,x);this._showPositionMarker(item)}},_mouseoutHandler:function(){if(!this.options.detached)this._hidePositionMarker()},_mousewheelHandler:function(e){if(this._map.gestureHandling&&
this._map.gestureHandling._enabled)return;var ll=this._selectedItem?this._selectedItem.latlng:this._map.getCenter();var z=e.deltaY>0?this._map.getZoom()-1:this._map.getZoom()+1;this._resetDrag();this._map.flyTo(ll,z)},_resetDrag:function(){if(this._dragRectangleG){this._dragRectangleG.remove();this._dragRectangleG=null;this._dragRectangle=null;this._hidePositionMarker()}},_resetView:function(){this._resetDrag();this._hidePositionMarker();if(this._map)this._map.fitBounds(this._fullExtent)},_resizeChart:function(){if(this.options.responsive)if(this.options.detached){var newWidth=
this.eleDiv.offsetWidth;if(newWidth<=0)return;this.options.width=newWidth;this.eleDiv.innerHTML="";var container=this.onAdd(this._map);this.eleDiv.appendChild(container)}else{this._map.removeControl(this._container);this.addTo(this._map)}},_showDiagramIndicator:function(item,xCoordinate){var opts=this.options;this._focusG.style("visibility","visible");this._mousefocus.attr("x1",xCoordinate).attr("y1",0).attr("x2",xCoordinate).attr("y2",this._height()).classed("hidden",false);var alt=item.z,dist=item.dist,
ll=item.latlng,numY=opts.hoverNumber.formatter(alt,opts.hoverNumber.decimalsY),numX=opts.hoverNumber.formatter(dist,opts.hoverNumber.decimalsX);this._focuslabeltext.attr("y",this._y(item.z)).style("font-weight","700");this._focuslabelX.text(numX+" "+this._xLabel).attr("x",xCoordinate+10);this._focuslabelY.text(numY+" "+this._yLabel).attr("x",xCoordinate+10);var focuslabeltext=this._focuslabeltext.node();if(this._isDomVisible(focuslabeltext)){var bbox=focuslabeltext.getBBox();var padding=2;this._focuslabelrect.attr("x",
bbox.x-padding).attr("y",bbox.y-padding).attr("width",bbox.width+padding*2).attr("height",bbox.height+padding*2);if(xCoordinate>=this._width()/2){this._focuslabelrect.attr("x",this._focuslabelrect.attr("x")-this._focuslabelrect.attr("width")-padding*2-10);this._focuslabelX.attr("x",this._focuslabelX.attr("x")-this._focuslabelrect.attr("width")-padding*2-10);this._focuslabelY.attr("x",this._focuslabelY.attr("x")-this._focuslabelrect.attr("width")-padding*2-10)}}},_toggle:function(){if(L.DomUtil.hasClass(this._container,
"elevation-expanded"))this._collapse();else this._expand()},_setMapView:function(item){if(!this.options.followMarker||!this._map)return;var zoom=this._map.getZoom();zoom=zoom<this._zFollow?this._zFollow:zoom;this._map.setView(item.latlng,zoom,{animate:true,duration:.25})},_showPositionMarker:function(item){this._selectedItem=item;if(this._map&&!this._map.getPane("elevationPane")){this._map.createPane("elevationPane");this._map.getPane("elevationPane").style.zIndex=625;this._map.getPane("elevationPane").style.pointerEvents=
"none"}if(this.options.marker=="elevation-line")this._updatePositionMarker(item);else if(this.options.marker=="position-marker")this._updateLeafletMarker(item)},_updateAxis:function(){this._grid.selectAll("g").remove();this._axis.selectAll("g").remove();this._appendXGrid(this._grid);this._appendYGrid(this._grid);this._appendXaxis(this._axis);this._appendYaxis(this._axis)},_updateHeightIndicator:function(item){var opts=this.options;var numY=opts.hoverNumber.formatter(item.z,opts.hoverNumber.decimalsY),
numX=opts.hoverNumber.formatter(item.dist,opts.hoverNumber.decimalsX);var normalizedAlt=this._height()/this._maxElevation*item.z,normalizedY=item.y-normalizedAlt;this._mouseHeightFocus.attr("x1",item.x).attr("x2",item.x).attr("y1",item.y).attr("y2",normalizedY).style("visibility","visible");this._mouseHeightFocusLabel.attr("x",item.x).attr("y",normalizedY).text(numY+" "+this._yLabel).style("visibility","visible")},_updateLeafletMarker:function(item){var ll=item.latlng;if(!this._marker){this._marker=
new L.Marker(ll,{icon:this.options.MarkerIcon,zIndexOffset:1E6});this._marker.addTo(this._map,{pane:"elevationPane"})}else this._marker.setLatLng(ll)},_updatePointG:function(item){this._pointG.attr("transform","translate("+item.x+","+item.y+")").style("visibility","visible")},_updatePositionMarker:function(item){var point=this._map.latLngToLayerPoint(item.latlng);var layerpoint={dist:item.dist,x:point.x,y:point.y,z:item.z};if(!this._mouseHeightFocus){L.svg({pane:"elevationPane"}).addTo(this._map);
var layerpane=d3.select(this._map.getContainer()).select(".leaflet-elevation-pane svg");this._appendPositionMarker(layerpane)}this._updatePointG(layerpoint);this._updateHeightIndicator(layerpoint)},_updateSummary:function(){if(this.options.summary){this.track_info=this.track_info||{};this.track_info.distance=this._distance||0;this.track_info.elevation_max=this._maxElevation||0;this.track_info.elevation_min=this._minElevation||0;d3.select(this.summaryDiv).html('<span class="totlen"><span class="summarylabel">Total Length: </span><span class="summaryvalue">'+
this.track_info.distance.toFixed(2)+" "+this._xLabel+'</span></span><span class="maxele"><span class="summarylabel">Max Elevation: </span><span class="summaryvalue">'+this.track_info.elevation_max.toFixed(2)+" "+this._yLabel+'</span></span><span class="minele"><span class="summarylabel">Min Elevation: </span><span class="summaryvalue">'+this.track_info.elevation_min.toFixed(2)+" "+this._yLabel+"</span></span>")}if(this.options.download&&this._downloadURL){var span=document.createElement("span");span.className=
"download";var save=document.createElement("a");save.innerHTML="Download";save.href="#";save.onclick=function(e){e.preventDefault();var evt={confirm:this._saveFile.bind(this,this._downloadURL)};var type=this.options.download;if(type=="modal"){if(typeof CustomEvent==="function")document.dispatchEvent(new CustomEvent("eletrack_download",{detail:evt}));if(this.fire)this.fire("eletrack_download",evt);if(this._map)this._map.fire("eletrack_download",evt)}else if(type=="link"||type===true)evt.confirm()}.bind(this);
this.summaryDiv.appendChild(span).appendChild(save)}},_width:function(){var opts=this.options;return opts.width-opts.margins.left-opts.margins.right}});L.control.elevation=function(options){return new L.Control.Elevation(options)};
