<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
   ->useScript('form.validate');

$imgpath = URI::root() .'components/com_zhosmmap/assets/icons/';
$utilspath = URI::root() .'administrator/components/com_zhosmmap/assets/utils/';
  
$document = Factory::getDocument();

// Map Types
$maptypes = $this->mapTypeList;

$current_custom_js_path = URI::root() .'components/com_zhosmmap/assets/js/';

$urlProtocol = "http";
if ($this->httpsprotocol != "")
{
    if ((int)$this->httpsprotocol == 0)
    {
        $urlProtocol = 'https';
    }
}    

if ($this->map_height != "")
{
    if ((int)$this->map_height == 0)
    {
        $map_height = "420px";
        $map_height_wrap = "450px";
    }
    else
    {
        $map_height = ((int)$this->map_height - 30) . "px";
        $map_height_wrap = (int)$this->map_height . "px";
    }
}
else 
{
    $map_height = "420px";
    $map_height_wrap = "450px";
}

//$mainScriptBegin = $current_custom_js_path . 'leaflet/';
$mainScriptBegin = "https://unpkg.com/leaflet";

$mainScriptMiddle = "";

$mainScriptEnd = "/dist/leaflet";

if ($this->mapapiversion != "")
{
    $mainScriptMiddle = $this->mapapiversion;
}
 else 
{
    $mainScriptMiddle = '1.9.3';
}

$mainScriptMiddle = "@" . $mainScriptMiddle;


$mainScriptBegin .= $mainScriptMiddle;


$mainScript = $mainScriptBegin . $mainScriptEnd;

if ((int) $this->item->id != 0)
{
    $flg_show_map = false;
}
else
{
    $flg_show_map = true;
}

$wa->registerAndUseStyle('zhosmmaps.mapmarker_main.style', $mainScript . '.css');
$wa->registerAndUseScript('zhosmmaps.mapmarker_main.script', $mainScript . '.js');

$wa->registerAndUseStyle('zhosmmaps.mapmarker_geocoder.style', $current_custom_js_path.'leaflet-control-geocoder/1.6.0/Control.Geocoder.css');
$wa->registerAndUseScript('zhosmmaps.mapmarker_geocoder.script', $current_custom_js_path.'leaflet-control-geocoder/1.6.0/Control.Geocoder.js');
    
// Load for contact translation
$currentLanguage = Factory::getLanguage();
$currentLangTag = $currentLanguage->getTag();

$currentLanguage->load('com_contact', JPATH_ADMINISTRATOR, $currentLangTag, true);    

?>
<form action="<?php echo Route::_('index.php?option=com_zhosmmap&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">

<div class="main-card">

    <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'markermain', 'recall' => true, 'breakpoint' => 768]); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'markermain', Text::_('COM_ZHOSMMAP_MAPMARKER_MARKER')); ?>
    <div class="row" id="tab0">
        <div>
            <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('markermain') as $field): ?>
                    
                    
                    <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                    </div>


                <?php endforeach; ?>
            
            </fieldset>
        
            <div>

                <div>
                <?php if (!$flg_show_map) { ?>
                <button id="zhosm-display-map" class="btn btn-primary" type="button" onclick="document.getElementById('mapDivWrapper').style.display = 'block';initializeMap();document.getElementById('zhosm-display-map').style.display = 'none';"><?php echo Text::_('COM_ZHOSMMAP_MAP_SHOW_MAP_BUTTON'); ?></button>
                <?php } ?>
                    </div>   

                <div id="mapDivWrapper" style="margin:0;padding:0;width:100%;height:<?php echo $map_height_wrap ?>">

                <div id="OMapsID" style="margin:0;padding:0;width:100%;height:<?php echo $map_height ?>">
                    
                <?php 

                $wa->registerAndUseStyle('zhosmmaps.mapmarker.style', URI::root() .'administrator/components/com_zhosmmap/assets/css/admin.css');

                $mapDefLat = $this->mapDefLat;
                $mapDefLng = $this->mapDefLng;

                $mapMapTypeCustom = $this->mapMapTypeCustom;

                //Script begin
                $scripttext = '<script type="text/javascript" >//<![CDATA[' ."\n";

                    $scripttext .= 'var initialLocation;' ."\n";
                    $scripttext .= 'var spblocation;' ."\n";
                    $scripttext .= 'var browserSupportFlag =  new Boolean();' ."\n";
                    $scripttext .= 'var map;' ."\n";
                    $scripttext .= 'var infowindow;' ."\n";
                    $scripttext .= 'var marker;' ."\n";

                    

                    $scripttext .= 'function initializeMap() {' ."\n";


                                               
                        
                        if ($mapDefLat != "" && $mapDefLng !="")
                        {
                            $scripttext .= 'spblocation = L.latLng('.$mapDefLat.', '.$mapDefLng.');' ."\n";
                        }
                        else
                        {
                            $scripttext .= 'spblocation = L.latLng(59.9388, 30.3158);' ."\n";
                        }

                        $scripttext .= 'var myOptions = {' ."\n";
                        $scripttext .= '    zoom: 14,' ."\n";                            
                                                    $scripttext .= '      scrollWheelZoom: false,' ."\n";    
                        $scripttext .= '      zoomControl: true' ."\n";
                        $scripttext .= '  };' ."\n";


                        $scripttext .= '    map = L.map("OMapsID", myOptions);' ."\n";

                                                    $scripttext .= '    L.tileLayer(\'https://tile.openstreetmap.org/{z}/{x}/{y}.png\', {' ."\n";
                                                    $scripttext .= '        attribution: \'&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> '.Text::_('COM_ZHOSMMAP_MAP_CONTRIBUTORS').'\'' ."\n";
                                                    $scripttext .= '    }).addTo(map);' ."\n";                                                        
                                                    
                        $scripttext .= '    L.Control.geocoder({position: \'topleft\'}).addTo(map);' ."\n";
                        
                        if (isset($this->item->latitude) && isset($this->item->longitude) 
                            && $this->item->latitude != '' && $this->item->longitude != '' 
                            && !empty($this->item->latitude) && !empty($this->item->longitude) 
                         )
                        {
                            $scripttext .= 'initialLocation = L.latLng('.$this->item->latitude.', ' .$this->item->longitude.');' ."\n";
                            $scripttext .= '  map.setView(initialLocation, 14);' ."\n";

                            $scripttext .= '  marker = L.marker(initialLocation, {' ."\n";
                            $scripttext .= '      draggable:true ' ."\n";
                            $scripttext .= '}).addTo(map);'."\n";

                            $scripttext .= '    marker.on(\'drag\', function(event) {' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";
                            
                            $scripttext .= '    map.on(\'click\', function(event) {' ."\n";
                            $scripttext .= '    marker.setLatLng(event.latlng);' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";

                        }
                        else
                        {
                            $scripttext .= 'initialLocation = spblocation;' ."\n";
                            $scripttext .= '  map.setView(initialLocation, 14);' ."\n";

                            $scripttext .= '  marker = L.marker(initialLocation, {' ."\n";
                            $scripttext .= '      draggable:true ' ."\n";
                            $scripttext .= '}).addTo(map);'."\n";

                            $scripttext .= '    marker.on(\'drag\', function(event) {' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";
                            
                            $scripttext .= '    map.on(\'click\', function(event) {' ."\n";
                            $scripttext .= '    marker.setLatLng(event.latlng);' ."\n";
                                                            
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";

                            $scripttext .= '    map.setView(initialLocation, 14);' ."\n";
                                                            $scripttext .= '    marker.setLatLng(initialLocation);' ."\n";
                                $scripttext .= '      // Try W3C Geolocation method (Preferred)' ."\n";
                                $scripttext .= '      if(navigator.geolocation) {' ."\n";
                                $scripttext .= '        browserSupportFlag = true;' ."\n";
                                $scripttext .= '        navigator.geolocation.getCurrentPosition(function(position) {' ."\n";
                                $scripttext .= '          initialLocation = L.latLng(position.coords.latitude,position.coords.longitude);' ."\n";
                                                                    $scripttext .= '    map.setView(initialLocation, 14);' ."\n";
                                                                    $scripttext .= '    marker.setLatLng(initialLocation);' ."\n";
                                $scripttext .= '        }, function() {' ."\n";
                                $scripttext .= '          handleNoGeolocation(browserSupportFlag);' ."\n";
                                $scripttext .= '        });' ."\n";
                                $scripttext .= '      } else {' ."\n";
                                $scripttext .= '        // Browser doesn\'t support Geolocation' ."\n";
                                $scripttext .= '        browserSupportFlag = false;' ."\n";
                                $scripttext .= '        handleNoGeolocation(browserSupportFlag);' ."\n";
                                $scripttext .= '      }' ."\n";
                        }


                    // end initialize    
                    $scripttext .= '};' ."\n";

                    $scripttext .= 'function handleNoGeolocation(errorFlag) {' ."\n";
                    $scripttext .= '  if (errorFlag == true) {' ."\n";
                    $scripttext .= '    initialLocation = spblocation;' ."\n";
                    //$scripttext .= '    contentString = "Error: The Geolocation service failed.";' ."\n";
                    $scripttext .= '  } else {' ."\n";
                    $scripttext .= '    initialLocation = spblocation;' ."\n";
                    //$scripttext .= '    contentString = "Error: Your browser doesn\'t support geolocation.";' ."\n";
                    $scripttext .= '  }' ."\n";
                    $scripttext .= '  map.setView(initialLocation, 14);' ."\n";
                    $scripttext .= '  marker.setLatLng(initialLocation);' ."\n";


                // end initialize    
                $scripttext .= '};' ."\n";

                $scripttext .= 'function handleNoGeolocation(errorFlag) {' ."\n";
                $scripttext .= '  if (errorFlag == true) {' ."\n";
                $scripttext .= '    initialLocation = spblocation;' ."\n";
                //$scripttext .= '    contentString = "Error: The Geolocation service failed.";' ."\n";
                $scripttext .= '  } else {' ."\n";
                $scripttext .= '    initialLocation = spblocation;' ."\n";
                //$scripttext .= '    contentString = "Error: Your browser doesn\'t support geolocation.";' ."\n";
                $scripttext .= '  }' ."\n";
                $scripttext .= '  map.setView(initialLocation, 14);' ."\n";
                $scripttext .= '  marker.setLatLng(initialLocation);' ."\n";
                $scripttext .= '};' ."\n";


                    $scripttext .= ' function addLoadEvent(func) {' ."\n";
                    $scripttext .= '  var oldonload = window.onload;' ."\n";
                    $scripttext .= '  if (typeof window.onload != \'function\') {' ."\n";
                    $scripttext .= '    window.onload = func;' ."\n";
                    $scripttext .= '  } else {' ."\n";
                    $scripttext .= '    window.onload = function() {' ."\n";
                    $scripttext .= '      if (oldonload) {' ."\n";
                    $scripttext .= '        oldonload();' ."\n";
                    $scripttext .= '      }' ."\n";
                    $scripttext .= '      func();' ."\n";
                    $scripttext .= '    }' ."\n";
                    $scripttext .= '  }' ."\n";
                    $scripttext .= '}    ' ."\n";    

                    if ($flg_show_map)
                    {
                        $scripttext .= 'document.getElementById("mapDivWrapper").style.display = "block";' ."\n";
                        $scripttext .= 'addLoadEvent(initializeMap);' ."\n";
                    }
                    else
                    {
                        $scripttext .= 'document.getElementById("mapDivWrapper").style.display = "none";' ."\n";
                    }
                    
                $scripttext .= '//]]></script>' ."\n";
                // Script end

                echo $scripttext;


                ?>
                </div>
                <?php
                    $credits ='<div>'."\n";
                    $credits .='</div>'."\n";
                echo $credits;
                ?>


                </div>

            </div>
        </div>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL')); ?>
    <div class="row" id="tab1">
        <fieldset class="adminform">
                <?php foreach($this->form->getFieldset('details') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_descriptionhtml')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else if ($field->id == 'jform_descriptionfullhtml')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else if ($field->id == 'jform_hoverhtml')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else if ($field->id == 'jform_rating_value')
                        {
                        
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 

                                
                                echo "<div>";
                                $val_cnt_max = 5;
                                
                                $val_main = $this->item->rating_value;
                                $val_int = floor($val_main);
                                
                                if ($val_main > $val_cnt_max)
                                {
                                    $val_main = $val_cnt_max;
                                    $val_int = $val_cnt_max;
                                }
                                
                                $val_cnt = 0;
                                if ($val_main == 0)
                                {
                                    echo '<img name="image'.$val_cnt.'" src="'.$utilspath .'star5_00.png" alt="" />';
                                    $val_cnt++;
                                }
                                else if ($val_int == 0 && $val_main > 0)
                                {
                                    echo '<img name="image'.$val_cnt.'" src="'.$utilspath .'star5_05.png" alt="" />';
                                    $val_cnt++;
                                }
                                else
                                {
                                    for ($i=0; $i<$val_int; $i++)
                                    {
                                        echo '<img name="image'.$val_cnt.'" src="'.$utilspath .'star5_10.png" alt="" />';
                                        $val_cnt++;
                                    }
                                    if (ceil(($val_main-$val_int)*10)>4)
                                    {
                                        echo '<img name="image'.$val_cnt.'" src="'.$utilspath .'star5_05.png" alt="" />';
                                        $val_cnt++;
                                    }
                                }
                                for ($i=$val_cnt; $i < $val_cnt_max; $i++)
                                {
                                    echo '<img name="image'.$val_cnt.'" src="'.$utilspath .'star5_00.png" alt="" />';
                                }
                                
                                
                                echo "</div>";
                                
                                echo $field->input;

                            ?>
                            </div>
                            <?php 
                                
                        }
                        else if ($field->id == 'jform_ordering')
                        {
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>

            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'markeradvanced', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_APPEARANCE')); ?>
    <div class="row" id="tab2">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('markeradvanced') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_icontype')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 


                                $iconTypeJS = " onchange=\"javascript:
                                if (document.forms.adminForm.jform_icontype.options[selectedIndex].value!='') 
                                {document.image.src='".$imgpath."' + document.forms.adminForm.jform_icontype.options[selectedIndex].value.replace(/#/g,'%23') + '.png'}
                                else 
                                {document.image.src=''}\"";


                                $scriptPosition = ' name=';

                                echo str_replace($scriptPosition, $iconTypeJS.$scriptPosition, $field->input);
                                echo '<img name="image" src="'.$imgpath .str_replace("#", "%23", $this->item->icontype).'.png" alt="" />';

                                echo '<div class="clr"></div>';
                                echo '<a class="btn btn-primary" href="'.$urlProtocol.'://wiki.zhuk.cc/index.php?title=Zh_OpenStreetMap_Credits_Icons" target="_blank">'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).' <img src="'.$utilspath.'info.png" alt="'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).'" style="margin: 0;" /></a>';
                                echo '<div class="clr"></div>';
                                echo '<br />';
                            ?>
                            </div>
                            <?php 
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'markerwithlabel', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_WITHLABEL')); ?>
    <div class="row" id="tab6">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('markerwithlabel') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>    
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'infowintabs', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_TABS')); ?>
    <div class="row" id="tab3">
                    <fieldset class="options-form">
                <legend><?php echo Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_TABS'); ?></legend>
                    <?php foreach($this->form->getFieldset('infowintabs') as $field): ?>
                    <div class="control-group">
                        <?php                           
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                    </div>
                    <?php endforeach; ?>
                
            </fieldset>

            <?php 
            for ($i = 1; $i <= 19; $i++) {
            ?>
            <fieldset class="options-form">
                <legend><?php echo Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_TAB'.$i); ?></legend>
                    <?php foreach($this->form->getFieldset('infowintab'.$i) as $field): ?>
                    <div class="control-group">
                        <?php 
                            if ($field->id == 'jform_tab'.$i)
                            {
                                ?>
                                <div class="control-label">
                                <?php 
                                    echo $field->label;
                                ?>
                                </div>
                                <div class="controls">
                                <?php 
                                    echo $field->input;
                                ?>
                                </div>
                                <?php 
                            }
                            else
                            {
                                ?>
                                <div class="control-label">
                                <?php 
                                    echo $field->label;
                                ?>
                                </div>
                                <div class="controls">
                                <?php 
                                    echo $field->input;
                                ?>
                                </div>
                                <?php 
                            }
                        ?>
                    </div>
                    <?php endforeach; ?>
                
            </fieldset>
            <?php }; ?>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'integration', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_INTEGRATION')); ?>
    <div class="row" id="tab4">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('integration') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_contactid')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>
            
            
                <?php foreach($this->form->getFieldset('integration_article') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_articleid')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>
            
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'extraattributes', Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_ATTRIBUTES')); ?>
    <div class="row" id="tab5">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('extraattributes') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.endTabSet'); ?>

</div>

<div class="row-fluid">
    <input type="hidden" name="task" value="mapmarker.edit" />
    <?php echo HTMLHelper::_('form.token'); ?>
</div>


</form>


