<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\View\Visualstruct;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;

use ZhukDL\Component\ZhOSMMap\Administrator\Model\VisualstructModel;

use ZhukDL\Component\ZhOSMMap\Administrator\Helper\ZhosmmapHelper;

/**
 * ZhOSM VisualStruct View
 */
class HtmlView extends BaseHTMLView
{
    protected $form;

	protected $item;

    protected $canDo;
 
    /**
     * display method of ZhOSM VisualStruct view
     * @return void
     */
    public function display($tpl = null): void 
    {
        $model       = $this->getModel();
		$this->form  = $model->getForm();
		$this->item  = $model->getItem();

        $this->canDo = ContentHelper::getActions('com_zhosmmap');

        $this->httpsprotocol = ZhosmmapHelper::getHttpsProtocol();         
        
        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        // Set the toolbar
        $this->addToolBar();


        // Display the template
        parent::display($tpl);

        // Set the document
		/* 18.10.2023 for Joomla!4.4
        $this->setDocument();
		*/

    }

    /**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {
        Factory::getApplication()->input->set('hidemainmenu', true);
        $user = Factory::getUser();
        $userId = $user->id;
        $isNew = $this->item->id == 0;                
                
        $canDo = ContentHelper::getActions('com_zhosmmap');
        ToolBarHelper::title($isNew ? Text::_('COM_ZHOSMMAP_VISUAL_STRUCT_NEW') : Text::_('COM_ZHOSMMAP_VISUAL_STRUCT_EDIT'), 'visualstruct');
        
        // Get the toolbar object instance
		$toolbar = Toolbar::getInstance('toolbar');
        $toolbarButtons = [];
        
        // Built the actions for new and existing records.
                if ($isNew) 
        {
            // For new records, check the create permission.
            if ($canDo->get('core.create')) 
            {
                $toolbar->apply('visualstruct.apply');
                $toolbarButtons[] = ['save', 'visualstruct.save'];
                $toolbarButtons[] = ['save2new', 'visualstruct.save2new'];
            }
        }
        else
        {
            if ($canDo->get('core.edit'))
            {
                $toolbar->apply('visualstruct.apply');
                $toolbarButtons[] = ['save', 'visualstruct.save'];

                // We can save this record, but check the create permission to see if we can return to make a new one.
                if ($canDo->get('core.create')) 
                {
                    $toolbarButtons[] = ['save2new', 'visualstruct.save2new'];
                }
            }
            if ($canDo->get('core.create')) 
            {
                $toolbarButtons[] = ['save2copy', 'visualstruct.save2copy'];
            }
        }
        
        ToolbarHelper::saveGroup(
			$toolbarButtons,
			'btn-success'
		);

        $toolbar->cancel('visualstruct.cancel');
        
        $help_url = 'http://wiki.zhuk.cc/index.php/Zh_OpenStreetMap_Description#Structure';
        $toolbar->help('', false, $help_url);

    }

    /**
     * Method to set up the document properties
     *
     * @return void
     */
	 /* 18.10.2023 for Joomla!4.4
    protected function setDocument() 
    {
        $isNew = $this->item->id == 0;
        $document = Factory::getDocument();
        $document->setTitle($isNew ? Text::_('COM_ZHOSMMAP_ADMINISTRATION_VISUAL_STRUCT_CREATING') : Text::_('COM_ZHOSMMAP_ADMINISTRATION_VISUAL_STRUCT_EDITING'));
    }
	*/
}
