<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\Model;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;

/**
 * ZhOSMBufmrk Model
 */
class ImportzhgmModel extends AdminModel
{
        
        public function getForm($data = array(), $loadData = true) 
    {
        // Get the form.
        $form = $this->loadForm('com_zhosmmap.importzhgm', 'importzhgm', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form)) 
        {
            return false;
        }
        return $form;
    }
        
        function insertLog($extension, $kind, $title, $id_target, $id_src, $id_find, $description, $remark) {
            
            $rec2ins = new stdClass();
            
            $rec2ins->extension = $extension;
            $rec2ins->title = $title;           
            $rec2ins->kind = $kind;
            $rec2ins->description = $description;
            $rec2ins->remarks = $remark;
            $rec2ins->id = null;

            $rec2ins->id_target = $id_target;
            $rec2ins->id_source = $id_src;
            $rec2ins->id_find = $id_find;

            
            $result = Factory::getDbo()->insertObject('#__zhosmmaps_log', $rec2ins, 'id');

        }
        
        public function deleteLog($extension) {

            $db = Factory::getDbo();

            $query = $db->getQuery(true);

            $query->delete($db->quoteName('#__zhosmmaps_log'));
            $query->where('extension='.$db->quote($extension));

            $db->setQuery($query);
          
            try
            {
                $db->execute();
            }
            catch (\RuntimeException $e)
            {
                $this->setError($e->getMessage());

                return false;
            }
                        
            return true;

        }

        public function checkLog($extension) {
            $ret_val = 0;

            $db = Factory::getDbo();

            $query = $db->getQuery(true);

            $query->select('h.id ')
                ->from('#__zhosmmaps_log as h')
                ->where('h.extension='.$db->quote($extension))
                ->order('h.id');
            ;

            $db->setQuery($query);        

            $loglines = $db->loadObject();

            if (isset($loglines) && !empty($loglines)) 
            {
                $ret_val = 1;
            }

            return $ret_val;
        } 
        
        
}
