<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\Helper;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Database\ParameterType;

/**
 * Helper.
 *
 * @since  1.6
 */
class ZhosmmapHelper extends ContentHelper
{
    

    public static function getAPIVersion() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $mapapiversion = $params->get( 'map_api_version', '' );
    }
    
    public static function getDefLat() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $mapDefLat = $params->get( 'map_lat', '' );
    }

    public static function getDefLng() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $mapDefLng = $params->get( 'map_lng', '' );
    }

    public static function getMapTypeOSM() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $mapMapTypeOSM = $params->get( 'map_type_osm', '' );
    }
    public static function getMapTypeCustom() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $mapMapTypeCustom = $params->get( 'map_type_custom', '' );
    }
    
    public static function getHttpsProtocol() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $httpsprotocol = $params->get( 'httpsprotocol', '' );
    }
        
    public static function getMapHeight() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $map_height = $params->get( 'map_height', '' );
    }

    public static function getLoadJQuery() 
    {
        // Get global params
        $params = ComponentHelper::getParams( 'com_zhosmmap' );

        return $load_jquery = $params->get( 'load_jquery', '' );
    }

	

	public static function getMapTypeList()
	{

        $db   = Factory::getDbo();
        $query = $db->getQuery(true)
                ->select('h.*, c.title as category ')
                ->from('#__zhosmmaps_maptypes as h')
                ->leftJoin('#__categories as c ON h.catid=c.id')
                ->where('h.published=1')
                ->order('h.title');
                    
        $db->setQuery($query);
        
        try
        {
            $mapTypeList = $db->loadObjectList();           
        }
        catch (RuntimeException $e)
        {
            Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
        }
                      
        return $mapTypeList;

	}
    
        
}
