DROP TABLE IF EXISTS "#__zhosmmaps_maps";

CREATE TABLE "#__zhosmmaps_maps" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(255) default '' NOT NULL,
  "width" integer default 0 NOT NULL,
  "height" integer default 0 NOT NULL,
  "latitude" varchar(20) default '' NOT NULL,
  "longitude" varchar(20) default '' NOT NULL,
  "zoom" smallint default 0 NOT NULL,
  "minzoom" smallint default 0 NOT NULL,
  "maxzoom" smallint default 0 NOT NULL,
  "draggable" smallint default 1 NOT NULL,
  "doubleclickzoom" smallint default 0 NOT NULL,
  "scrollwheelzoom" smallint default 0 NOT NULL,
  "scalecontrol" smallint default 0 NOT NULL,
  "zoomcontrol" smallint default 0 NOT NULL,
  "maptype" smallint default 0 NOT NULL,
  "maptypecontrol" smallint default 0 NOT NULL,
  "balloon" smallint default 0 NOT NULL,
  "openballoon" smallint default 0 NOT NULL,
  "posmaptype" smallint default 0 NOT NULL,
  "poszoom" smallint default 0 NOT NULL,
  "posscale" smallint default 0 NOT NULL,
  "scale_maxwidth" smallint default 100 NOT NULL ,
  "scale_metric"  smallint default 1 NOT NULL,
  "scale_imperial" smallint default 1 NOT NULL,
  "scale_update_when_idle" smallint default 0 NOT NULL,
  "description" text,
  "markermanager" smallint default 0 NOT NULL,
  "published" smallint default 0 NOT NULL,
  "markercluster" smallint default 0 NOT NULL,
  "markerclustergroup" smallint default 0 NOT NULL,
  "clusterzoom" smallint default 0 NOT NULL,
  "kmllayer" text,
  "markergroupcontrol" smallint default 0 NOT NULL,
  "markergrouptype" smallint default 0 NOT NULL,
  "markergroupwidth" integer default 20 NOT NULL,
  "markergroupshowicon" smallint default 0 NOT NULL,
  "markergroupshowiconall" smallint default 100 NOT NULL ,
  "markergroupcss" integer default 0 NOT NULL,
  "markergroupdesc1" text,
  "markergroupdesc2" text,
  "markergrouptitle" varchar(255),
  "markergroupsep1" smallint default 0 NOT NULL,
  "markergroupsep2" smallint default 0 NOT NULL,
  "markergrouporder" smallint default 0 NOT NULL,
  "markergroupsearch" smallint default 0 NOT NULL,
  "markerlist" smallint default 0 NOT NULL,
  "markerlistpos" smallint default 0 NOT NULL,
  "markerlistwidth" integer default 0 NOT NULL,
  "markerlistheight" integer default 0 NOT NULL,
  "markerlistbgcolor" text,
  "markerlistaction" smallint default 0 NOT NULL,
  "markerlistcontent" smallint default 0 NOT NULL,
  "markerlistbuttonpos" smallint default 3 NOT NULL ,
  "markerlistbuttontype" smallint default 0 NOT NULL,
  "markerlistsearch" smallint default 0 NOT NULL,
  "markerlistsync" smallint default 0 NOT NULL,
  "headerhtml" text,
  "footerhtml" text,
  "headersep" smallint default 0 NOT NULL,
  "footersep" smallint default 0 NOT NULL,
  "openstreet" smallint default 1 NOT NULL,
  "opentopomap" smallint default 0 NOT NULL,
  "nztopomaps" smallint default 0 NOT NULL,
  "usercontact" smallint default 0 NOT NULL,
  "useruser" smallint default 0 NOT NULL,
  "usermarkers" smallint default 0 NOT NULL,
  "usermarkersfilter" smallint default 0 NOT NULL,
  "usermarkerspublished" smallint default 0 NOT NULL,
  "usermarkersicon" smallint default 1 NOT NULL,
  "usercontactpublished" smallint default 0 NOT NULL,
  "usermarkersinsert" smallint default 1 NOT NULL,
  "usermarkersupdate" smallint default 1 NOT NULL,
  "usermarkersdelete" smallint default 1 NOT NULL,
  "routedraggable" smallint default 0 NOT NULL,
  "routeshowpanel" smallint default 0 NOT NULL,
  "autoposition" smallint default 0 NOT NULL,
  "geolocationcontrol" smallint default 0 NOT NULL,
  "geolocationpos" smallint default 2 NOT NULL ,
  "geolocationbutton" smallint default 1 NOT NULL,
  "lang" varchar(20),
  "custommaptype" smallint default 0 NOT NULL,
  "custommaptypelist" text,
  "usercontactattributes" text,
  "css2load" text,
  "js2load" text,
  "cssclassname" text,
  "mapbounds" varchar(100),
  "routedriving" smallint default 1 NOT NULL,
  "routewalking" smallint default 1 NOT NULL,
  "routebicycling" smallint default 1 NOT NULL,
  "routetransit" smallint default 0 NOT NULL,
  "routeavoidhighways" smallint default 0 NOT NULL,
  "routeavoidtolls" smallint default 0 NOT NULL,
  "routeunitsystem" smallint default 0 NOT NULL,
  "useajax" smallint default 0 NOT NULL,
  "useajaxobject" smallint default 0 NOT NULL,
  "markergroupctlmarker" smallint default 1 NOT NULL,
  "markergroupctlpath" smallint default 0 NOT NULL,
  "placemark_rating" smallint default 0 NOT NULL,
  "hovermarker" smallint default 0 NOT NULL,
  "hoverinfobubble" integer default 0 NOT NULL,
  "disableautopan" smallint default 0 NOT NULL,
  "ajaxbufferplacemark" integer default 0 NOT NULL,
  "ajaxbufferpath" integer default 0 NOT NULL,
  "ajaxbufferroute" integer default 0 NOT NULL,
  "ajaxgetplacemark" smallint default 0 NOT NULL,
  "mapcentercontrol" smallint default 0 NOT NULL,
  "mapcentercontrolpos" smallint default 2 NOT NULL ,
  "markerorder" smallint default 0 NOT NULL,
  "markerspinner" smallint default 1 NOT NULL,
  "showcreateinfo" smallint default 0 NOT NULL,
  "override_id" integer default 0 NOT NULL,
  "panelinfowin" smallint default 0 NOT NULL,
  "panelwidth" smallint default 300 NOT NULL ,
  "panelstate" smallint default 0 NOT NULL,
  "overlayopacitycontrol" smallint default 0 NOT NULL,
  "overlayopacitycontrolpos" smallint default 2 NOT NULL ,  
  "gogoogle" smallint default 0 NOT NULL,
  "gogoogle_map" smallint default 0 NOT NULL,
  "auto_center_zoom" smallint default 0 NOT NULL,
  "clusterzoombounds" smallint default 1 NOT NULL,
  "clustershowhover" smallint default 1 NOT NULL,
  "hidesinglebaselayer" smallint default 1 NOT NULL,
  "geocoder" smallint default 0 NOT NULL,
  "geocoderpos" smallint default 3 NOT NULL ,
  "geocodercollapsed" smallint default 1 NOT NULL,
  "geocoderprovider" smallint default 0 NOT NULL,
  "closepopuponclick" smallint default 1 NOT NULL,
  "fullscreencontrol" smallint default 1 NOT NULL,
  "fullscreencontrolpos" smallint default 2 NOT NULL ,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_markers";

CREATE TABLE "#__zhosmmaps_markers" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "latitude" varchar(20) default '' NOT NULL,
  "longitude" varchar(20) default '' NOT NULL,
  "addresstext" text,
  "mapid" integer default 0 NOT NULL,
  "openbaloon" smallint default 0 NOT NULL,
  "actionbyclick" smallint default 1 NOT NULL,
  "zoombyclick" smallint default 100 NOT NULL ,
  "baloon" smallint default 0 NOT NULL,
  "icontype" varchar(250) default '' NOT NULL ,
  "iconofsetx" smallint default 0 NOT NULL,
  "iconofsety" smallint default 0 NOT NULL,
  "description" text,
  "descriptionhtml" text,
  "descriptionfullhtml" text,
  "hoverhtml" text,
  "published" smallint default 0 NOT NULL,
  "hrefsite" text,
  "hrefimage" text,
  "hrefimagecss" text,
  "hrefimagethumbnail" text,
  "hrefsitename" text,
  "markergroup" integer default 0 NOT NULL,
  "markercontent" smallint default 0 NOT NULL,
  "contactid" integer default 0 NOT NULL,
  "createdbyuser" integer default 0 NOT NULL,
  "showcontact" smallint default 0 NOT NULL,
  "showuser" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "createddate" timestamp without time zone,
  "userprotection" smallint default 0 NOT NULL,
  "params" text,
  "attribute1" text,
  "attribute2" text,
  "attribute3" text,
  "attribute4" text,
  "attribute5" text,
  "attribute6" text,
  "attribute7" text,
  "attribute8" text,
  "attribute9" text,
  "tabid" integer default 0 NOT NULL,
  "tab1" text,
  "tab2" text,
  "tab3" text,
  "tab4" text,
  "tab5" text,
  "tab6" text,
  "tab7" text,
  "tab8" text,
  "tab9" text,
  "tab10" text,
  "tab11" text,
  "tab12" text,
  "tab13" text,
  "tab14" text,
  "tab15" text,
  "tab16" text,
  "tab17" text,
  "tab18" text,
  "tab19" text,
  "tab1title" varchar(250),
  "tab2title" varchar(250),
  "tab3title" varchar(250),
  "tab4title" varchar(250),
  "tab5title" varchar(250),
  "tab6title" varchar(250),
  "tab7title" varchar(250),
  "tab8title" varchar(250),
  "tab9title" varchar(250),
  "tab10title" varchar(250),
  "tab11title" varchar(250),
  "tab12title" varchar(250),
  "tab13title" varchar(250),
  "tab14title" varchar(250),
  "tab15title" varchar(250),
  "tab16title" varchar(250),
  "tab17title" varchar(250),
  "tab18title" varchar(250),
  "tab19title" varchar(250),
  "tab1image" text,
  "tab2image" text,
  "tab3image" text,
  "tab4image" text,
  "tab5image" text,
  "tab6image" text,
  "tab7image" text,
  "tab8image" text,
  "tab9image" text,
  "tab10image" text,
  "tab11image" text,
  "tab12image" text,
  "tab13image" text,
  "tab14image" text,
  "tab15image" text,
  "tab16image" text,
  "tab17image" text,
  "tab18image" text,
  "tab19image" text,
  "tab_info" smallint default 0 NOT NULL,
  "ordering" integer default 0 NOT NULL ,
  "rating_value" REAL DEFAULT 0 NOT NULL,
  "rating_count" integer default 0 NOT NULL ,
  "labelanchorx" integer default 0 NOT NULL,
  "labelanchory" integer default 0 NOT NULL,
  "labelclass" varchar(250),
  "labelcontent" text,
  "labelstyle" text,
  "includeinlist" smallint default 1 NOT NULL,
  "access" integer default 1 NOT NULL,
  "alias" varchar(255),
  "hrefcontact" text,
  "hrefarticle" text,
  "hrefdetail" text,
  "toolbarcontact" smallint default 0 NOT NULL,
  "toolbararticle" smallint default 0 NOT NULL,
  "toolbardetail" smallint default 0 NOT NULL,
  "articleid" integer default 0 NOT NULL,
  "attributesdetail" text,
  "userorder" integer default 0 NOT NULL,
  "showgps" smallint default 0 NOT NULL,
  "iframearticleclass" varchar(250),
  "gogoogle" smallint default 0 NOT NULL,
  "preparecontent" smallint default 0 NOT NULL,
  "tag_show" smallint default 0 NOT NULL,
  "tag_style" smallint default 0 NOT NULL,
  "data_id" integer default 0 NOT NULL,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_routers";

CREATE TABLE "#__zhosmmaps_routers" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "providealt" smallint default 0 NOT NULL,
  "optimizewaypoints" smallint default 0 NOT NULL,
  "avoidhighways" smallint default 0 NOT NULL,
  "avoidtolls" smallint default 0 NOT NULL,
  "travelmode" smallint default 0 NOT NULL,
  "unitsystem" smallint default 0 NOT NULL,
  "route" text,
  "routebymarker" text,
  "mapid" integer default 0 NOT NULL,
  "description" text,
  "descriptionhtml" text,
  "published" smallint default 0 NOT NULL,
  "showtype" smallint default 0 NOT NULL,
  "draggable" smallint default 0 NOT NULL,
  "showpanel" smallint default 0 NOT NULL,
  "showpaneltotal" smallint default 1 NOT NULL,
  "showdescription" smallint default 0 NOT NULL,  
  "suppressmarkers" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "weight" smallint default 5 NOT NULL,
  "color" varchar(250) default '#4FA4FF' NOT NULL,
  "opacity" varchar(20) default '0.7' NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_paths";

CREATE TABLE "#__zhosmmaps_paths" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "weight" smallint default 0 NOT NULL,
  "color" varchar(250),
  "hover_color" varchar(250),
  "opacity" varchar(20),
  "path" text,
  "data_id" integer default 0 NOT NULL,
  "kmllayer" text,
  "kmllayertype" smallint default 0 NOT NULL,
  "mapid" integer default 0 NOT NULL,
  "description" text,
  "descriptionhtml" text,
  "published" smallint default 0 NOT NULL,
  "showtype" smallint default 0 NOT NULL,
  "suppressinfowindows" smallint default 0 NOT NULL,
  "geodesic" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "infowincontent" smallint default 0 NOT NULL,
  "actionbyclick" smallint default 0 NOT NULL,
  "objecttype" smallint default 0 NOT NULL,
  "fillcolor" varchar(250),
  "fillopacity" varchar(20),
  "hover_fillcolor" varchar(250),
  "radius" varchar(250),
  "markergroup" integer default 0 NOT NULL,
  "hoverhtml" text,
  "hrefsite" text,
  "hrefsitename" text, 
  "imgurl" text,
  "imgclickable" smallint default 0 NOT NULL,  
  "imgbounds" varchar(100),
  "imgopacity" varchar(20),
  "imgopacitymanage" smallint default 1 NOT NULL,
  "gridtilefunc" text,
  "gridopacity" varchar(20),
  "popup_placemark" smallint default 2 NOT NULL ,
  "popup_polyline" smallint default 2 NOT NULL ,
  "popup_polygon" smallint default 2 NOT NULL ,
  "tooltip_polyline" smallint default 1 NOT NULL,
  "tooltip_polygon" smallint default 1 NOT NULL,
  "tooltip_placemark" smallint default 0 NOT NULL,
  "override_placemarks" smallint default 0 NOT NULL,
  "override_paths" smallint default 0 NOT NULL,
  "labelanchorx" integer default 0 NOT NULL,
  "labelanchory" integer default 0 NOT NULL,
  "labelclass" varchar(250),
  "labelcontent" text,
  "labelstyle" text,
  "labelpublished" smallint default 0 NOT NULL,
  "dasharray" varchar(250),
  "dashoffset" varchar(250),
  "linecap" smallint default 0 NOT NULL,
  "linejoin" smallint default 0 NOT NULL,
  "elevation" smallint default 0 NOT NULL,
  "elevation_width" varchar(10),
  "elevation_height" varchar(10),
  "y_min_value" varchar(20),
  "y_max_value" varchar(20),
  "elevation_theme" smallint default 0 NOT NULL,
  "y_gridline_count" varchar(5),
  "x_gridline_count" varchar(5),
  "elevation_summary" smallint default 0 NOT NULL,
  "elevation_follow" smallint default 0 NOT NULL,
  "elevation_unitsystem" smallint default 1 NOT NULL,
  "override_styles" smallint default 1 NOT NULL,
  "show_time" smallint default 1 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_markergroups";

CREATE TABLE "#__zhosmmaps_markergroups" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "icontype" varchar(250),
  "iconofsetx" smallint default 0 NOT NULL,
  "iconofsety" smallint default 0 NOT NULL,
  "overridegroupicon" smallint default 0 NOT NULL,
  "overridemarkericon" smallint default 0 NOT NULL,
  "markermanagerminzoom" smallint default 0 NOT NULL,
  "markermanagermaxzoom" smallint default 18 NOT NULL,
  "activeincluster" smallint default 0 NOT NULL,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "userorder" integer default 0 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_maptypes";

CREATE TABLE "#__zhosmmaps_maptypes" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "url_template" text,
  "license" text,
  "gettileurl" text,
  "tilewidth" integer default 256 NOT NULL,
  "tileheight" integer default 256 NOT NULL,
  "ispng" smallint default 1 NOT NULL,
  "minzoom" smallint default 0 NOT NULL,
  "maxzoom" smallint default 18 NOT NULL,
  "opacity" varchar(20),
  "opacitymanage" smallint default 1 NOT NULL,
  "layertype" smallint default 1 NOT NULL,
  "projectionglobal" text,
  "projectiondefinition" text,
  "fromlatlngtopoint" text,
  "frompointtolatlng" text,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_infobubbles";

CREATE TABLE "#__zhosmmaps_infobubbles" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "minwidth" varchar(50),
  "maxwidth" varchar(50),
  "minheight" varchar(50),
  "maxheight" varchar(50),
  "disableautopan" smallint default 0 NOT NULL,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "offsetx" smallint default 0 NOT NULL,
  "offsety" smallint default 0 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);


DROP TABLE IF EXISTS "#__zhosmmaps_marker_rates";

CREATE TABLE "#__zhosmmaps_marker_rates" (
  "id" serial NOT NULL,
  "markerid" integer default 0 NOT NULL,
  "rating_value" REAL DEFAULT 0 NOT NULL,
  "rating_date" timestamp without time zone,
  "ip" text NOT NULL,
  "hostname" text NOT NULL,
  "createdbyuser" integer default 0 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_text_overrides";

CREATE TABLE "#__zhosmmaps_text_overrides" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "placemark_list_title" text,
  "placemark_list_button_title" text,
  "placemark_list_button_hint" text,
  "panelcontrol_hint" text,
  "panel_detail_title" text,
  "panel_placemarklist_title" text,
  "panel_route_title" text,
  "panel_group_title" text,
  "group_list_title" text,
  "gogoogle_text" text,
  "placemark_list_search" smallint default 0 NOT NULL,
  "placemark_list_mapping_type" smallint default 0 NOT NULL,
  "placemark_list_accent" text,
  "placemark_list_mapping" text,
  "placemark_list_accent_side" smallint default 3 NOT NULL ,
  "group_list_search" smallint default 0 NOT NULL,
  "group_list_mapping_type" smallint default 0 NOT NULL,
  "group_list_accent" text,
  "group_list_mapping" text,
  "group_list_accent_side" smallint default 3 NOT NULL ,
  "tabid" integer default 0 NOT NULL,
  "geocoder_placeholder" text,
  "geocoder_not_found" text,
  "invalidatediv" text,
  "invalidatetype" smallint default 0 NOT NULL,
  "invalidateindex" text,
  "placemark_date_fmt" text,
  "markerspinner_list_template" text,
  "load_delay" integer default 0 NOT NULL,
  "category_hierarchy" smallint default 0 NOT NULL,
  "category_expand" smallint default 0 NOT NULL,
  "geocoderzoom" smallint default 100 NOT NULL ,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_marker_content";

CREATE TABLE "#__zhosmmaps_marker_content" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_log";

CREATE TABLE "#__zhosmmaps_log" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "extension" varchar(250),
  "kind" varchar(250),
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "remarks" text,
  "id_target" integer default 0 NOT NULL,
  "id_source" integer default 0 NOT NULL,
  "id_find" integer default 0 NOT NULL,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_marker_buffer";

CREATE TABLE "#__zhosmmaps_marker_buffer" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "latitude" varchar(20) default '' NOT NULL,
  "longitude" varchar(20) default '' NOT NULL,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "addresstext" text,
  "icontype" varchar(250),
  "iconofsetx" smallint default 0 NOT NULL,
  "iconofsety" smallint default 0 NOT NULL,
  "description" text,
  "descriptionhtml" text,
  "hrefimage" text,
  "markergroup" integer default 0 NOT NULL,
  "createdbyuser" integer default 0 NOT NULL,
  "showuser" smallint default 0 NOT NULL,
  "createddate" timestamp without time zone,
  "showgps" smallint default 0 NOT NULL,
  "preparecontent" smallint default 0 NOT NULL,
  "markercontent" smallint default 0 NOT NULL,
  "status" smallint default 0 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_data_sqls";

CREATE TABLE "#__zhosmmaps_data_sqls" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "sql_text_clause" text NOT NULL,
  "query_type" smallint default 0 NOT NULL,
  "struct_id" integer default 0 NOT NULL,
  "server_id" integer default 0 NOT NULL,
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_visual_structs";

CREATE TABLE "#__zhosmmaps_visual_structs" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "latitude" varchar(50),
  "longitude" varchar(50),
  "lat_lng" varchar(50),
  "lat_lng_order" smallint default 0 NOT NULL,
  "lat_lng_sep" varchar(10) default ',' NOT NULL,
  "lat_lng_array" varchar(50),
  "lat_lng_array_sep" varchar(10) default ';' NOT NULL,
  "result_object_type" smallint default 0 NOT NULL,
  "createddate" varchar(50),
  "start_title" varchar(250),
  "start_description" text,
  "start_baloon" smallint default 0 NOT NULL,
  "start_icontype" varchar(250),
  "start_iconofsetx" smallint default 0 NOT NULL,
  "start_iconofsety" smallint default 0 NOT NULL,
  "start_descriptionhtml" text,
  "end_title" varchar(250),
  "end_description" text,
  "end_baloon" smallint default 0 NOT NULL,
  "end_icontype" varchar(250),
  "end_iconofsetx" smallint default 0 NOT NULL,
  "end_iconofsety" smallint default 0 NOT NULL,
  "end_descriptionhtml" text,  
  "title_column" varchar(50),
  "description_column" varchar(50),
  "descriptionhtml_column" varchar(50),
  "icontype_column" varchar(50),
  "params" text,
  PRIMARY KEY  ("id")
);

DROP TABLE IF EXISTS "#__zhosmmaps_data_servers";

CREATE TABLE "#__zhosmmaps_data_servers" (
  "id" serial NOT NULL,
  "catid" integer default 0 NOT NULL,
  "title" varchar(250) default '' NOT NULL ,
  "description" text,
  "published" smallint default 0 NOT NULL,
  "publish_up" timestamp without time zone,
  "publish_down" timestamp without time zone,
  "ordering" integer default 0 NOT NULL ,
  "srv_driver" text,
  "srv_host" text,
  "srv_user" text,
  "srv_password" text,
  "srv_database" text,
  "srv_prefix" text,
  "params" text,
  PRIMARY KEY  ("id")
);


CREATE INDEX "zhom_idx_server" ON "#__zhosmmaps_data_sqls" ("server_id");
CREATE INDEX "zhom_idx_catid1" ON "#__zhosmmaps_data_servers" ("catid");
CREATE INDEX "zhom_idx_struct" ON "#__zhosmmaps_data_sqls" ("struct_id");
CREATE INDEX "zhom_idx_catid2" ON "#__zhosmmaps_data_sqls" ("catid");
CREATE INDEX "zhom_idx_catid3" ON "#__zhosmmaps_visual_structs" ("catid");

CREATE INDEX "zhom_idx_catid4" ON "#__zhosmmaps_marker_buffer" ("catid");
CREATE INDEX "zhom_idx_markergroup4" ON "#__zhosmmaps_marker_buffer" ("markergroup");
CREATE INDEX "zhom_idx_createdbyuser4" ON "#__zhosmmaps_marker_buffer" ("createdbyuser");

CREATE INDEX "zhom_idx_catid5" ON "#__zhosmmaps_maps" ("catid");
CREATE INDEX "zhom_idx_override" ON "#__zhosmmaps_maps" ("override_id");
CREATE INDEX "zhom_idx_hoverinfobubble" ON "#__zhosmmaps_maps" ("hoverinfobubble");

CREATE INDEX "zhom_idx_catid6" ON "#__zhosmmaps_markers" ("catid");
CREATE INDEX "zhom_idx_mapid6" ON "#__zhosmmaps_markers" ("mapid");
CREATE INDEX "zhom_idx_markergroup6" ON "#__zhosmmaps_markers" ("markergroup");
CREATE INDEX "zhom_idx_createdbyuser6" ON "#__zhosmmaps_markers" ("createdbyuser");
CREATE INDEX "zhom_idx_access" ON "#__zhosmmaps_markers" ("access");
CREATE INDEX "zhom_idx_alias" ON "#__zhosmmaps_markers" ("alias");
CREATE INDEX "zhom_idx_tabid6" ON "#__zhosmmaps_markers" ("tabid");
CREATE INDEX "zhom_idx_articleid" ON "#__zhosmmaps_markers" ("articleid");
CREATE INDEX "zhom_idx_contactid" ON "#__zhosmmaps_markers" ("contactid");
CREATE INDEX "zhom_idx_userorder6" ON "#__zhosmmaps_markers" ("userorder");
CREATE INDEX "zhom_idx_data6" ON "#__zhosmmaps_markers" ("data_id");

CREATE INDEX "zhom_idx_catid7" ON "#__zhosmmaps_routers" ("catid");
CREATE INDEX "zhom_idx_mapid7" ON "#__zhosmmaps_routers" ("mapid");

CREATE INDEX "zhom_idx_catid8" ON "#__zhosmmaps_paths" ("catid");
CREATE INDEX "zhom_idx_mapid8" ON "#__zhosmmaps_paths" ("mapid");
CREATE INDEX "zhom_idx_markergroup8" ON "#__zhosmmaps_paths" ("markergroup");
CREATE INDEX "zhom_idx_data8" ON "#__zhosmmaps_paths" ("data_id");

CREATE INDEX "zhom_idx_catid11" ON "#__zhosmmaps_markergroups" ("catid");
CREATE INDEX "zhom_idx_userorder11" ON "#__zhosmmaps_markergroups" ("userorder");

CREATE INDEX "zhom_idx_catid9" ON "#__zhosmmaps_maptypes" ("catid");

CREATE INDEX "zhom_idx_catid10" ON "#__zhosmmaps_infobubbles" ("catid");

CREATE INDEX "zhom_idx_markerid" ON "#__zhosmmaps_marker_rates" ("markerid");

CREATE INDEX "zhom_idx_catid12" ON "#__zhosmmaps_text_overrides" ("catid");
CREATE INDEX "zhom_idx_tabid12" ON "#__zhosmmaps_text_overrides" ("tabid");

CREATE INDEX "zhom_idx_catid13" ON "#__zhosmmaps_marker_content" ("catid");

CREATE INDEX "zhom_idx_catid14" ON "#__zhosmmaps_log" ("catid");
CREATE INDEX "zhom_idx_ext" ON "#__zhosmmaps_log" ("extension");


INSERT INTO "#__content_types" ("type_title", "type_alias", "table", "rules", "field_mappings", "router", "content_history_options") 
VALUES (	
	'ZhOSMMap Category', 
	'com_zhosmmap.category', 
	'{"special":
		{"dbtable":"#__categories"
		,"key":"id"
		,"type":"CategoryTable"
		,"prefix":"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"Joomla\\\\CMS\\\\Table\\\\"
		,"config":"array()"}}'
	,''
	, '{"common": {
        "core_content_item_id": "id",
        "core_title": "title",
        "core_state": "published",
        "core_alias": "alias",
        "core_created_time": "created_time",
        "core_modified_time": "modified_time",
        "core_body": "description",
        "core_hits": "hits",
        "core_publish_up": "null",
        "core_publish_down": "null",
        "core_access": "access",
        "core_params": "params",
        "core_featured": "null",
        "core_metadata": "metadata",
        "core_language": "language",
        "core_images": "null",
        "core_urls": "null",
        "core_version": "version",
        "core_ordering": "null",
        "core_metakey": "metakey",
        "core_metadesc": "metadesc",
        "core_catid": "parent_id",
        "asset_id": "asset_id"
    },
    "special": {
        "parent_id": "parent_id",
        "lft": "lft",
        "rgt": "rgt",
        "level": "level",
        "path": "path",
        "extension": "extension",
        "note": "note"
    }}'
	,''
	, ''
	);
	


INSERT INTO "#__content_types" ("type_title", "type_alias", "table", "rules", "field_mappings", "router", "content_history_options") 
VALUES (	
	'ZhOSMMap Marker', 
	'com_zhosmmap.mapmarker', 
	'{"special":
		{"dbtable":"#__zhosmmaps_markers"
		,"key":"id"
		,"type":"MapmarkerTable"
		,"prefix":"ZhukDL\\\\Component\\\\ZhOpenStreetMap\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"JTable"
		,"config":"array()"}}'
	,''
	, '{"common":
			{"core_content_item_id":"id"
			,"core_title":"title"
			,"core_state":"null"
			,"core_alias":"alias"
			,"core_created_time":"null"
			,"core_modified_time":"null"
			,"core_body":"null"
			, "core_hits":"null"
			,"core_publish_up":"publish_up"
			,"core_publish_down":"publish_down"
			,"core_access":"access"
			, "core_params":"null"
			, "core_featured":"null"
			, "core_metadata":"null"
			, "core_language":"null"
			, "core_images":"null"
			, "core_urls":"null"
			, "core_version":"null"
			, "core_ordering":"ordering"
			, "core_metakey":"null"
			, "core_metadesc":"null"
			, "core_catid":"catid"
			, "core_xreference":"null"
			, "asset_id":"null"}
			, "special":{"fulltext":"null"}}'
	,''
	, ''
	);
	
INSERT INTO "#__content_types" ("type_title", "type_alias", "table", "rules", "field_mappings", "router", "content_history_options") 
VALUES (	
	'ZhOSMMap Path', 
	'com_zhosmmap.mappath', 
	'{"special":
		{"dbtable":"#__zhosmmaps_paths"
		,"key":"id"
		,"type":"MappathTable"
		,"prefix":"ZhukDL\\\\Component\\\\ZhOpenStreetMap\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"JTable"
		,"config":"array()"}}'
	,''
	, '{"common":
			{"core_content_item_id":"id"
			,"core_title":"title"
			,"core_state":"null"
			,"core_alias":"alias"
			,"core_created_time":"null"
			,"core_modified_time":"null"
			,"core_body":"null"
			, "core_hits":"null"
			,"core_publish_up":"publish_up"
			,"core_publish_down":"publish_down"
			,"core_access":"access"
			, "core_params":"null"
			, "core_featured":"null"
			, "core_metadata":"null"
			, "core_language":"null"
			, "core_images":"null"
			, "core_urls":"null"
			, "core_version":"null"
			, "core_ordering":"ordering"
			, "core_metakey":"null"
			, "core_metadesc":"null"
			, "core_catid":"catid"
			, "core_xreference":"null"
			, "asset_id":"null"}
			, "special":{"fulltext":"null"}}'
	,''
	, ''
	);
	
