DROP TABLE IF EXISTS `#__zhosmmaps_maps`;

CREATE TABLE `#__zhosmmaps_maps` (
  `id` int(11) NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `width` int(5) NOT NULL default '0',
  `height` int(5) NOT NULL default '0',
  `latitude` varchar(20) NOT NULL default '',
  `longitude` varchar(20) NOT NULL default '',
  `zoom` int(3) NOT NULL default '0',
  `minzoom` int(3) NOT NULL default '0',
  `maxzoom` int(3) NOT NULL default '0',
  `draggable` tinyint(1) NOT NULL default '1',
  `doubleclickzoom` tinyint(1) NOT NULL default '0',
  `scrollwheelzoom` tinyint(1) NOT NULL default '0',
  `scalecontrol` tinyint(1) NOT NULL default '0',
  `zoomcontrol` tinyint(1) NOT NULL default '0',
  `maptype` tinyint(1) NOT NULL default '0',
  `maptypecontrol` tinyint(1) NOT NULL default '0',
  `balloon` tinyint(1) NOT NULL default '0',
  `openballoon` tinyint(1) NOT NULL default '0',
  `posmaptype` tinyint(1) NOT NULL default '0',
  `poszoom` tinyint(1) NOT NULL default '0',
  `posscale` tinyint(1) NOT NULL default '0',
  `scale_maxwidth` int(3) NOT NULL default '100',
  `scale_metric`  tinyint(1) NOT NULL default '1',
  `scale_imperial` tinyint(1) NOT NULL default '1',
  `scale_update_when_idle` tinyint(1) NOT NULL default '0',
  `description` text,
  `markermanager` tinyint(1) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `markercluster` tinyint(1) NOT NULL default '0',
  `markerclustergroup` tinyint(1) NOT NULL default '0',
  `clusterzoom` int(3) NOT NULL default '0',
  `kmllayer` text,
  `markergroupcontrol` tinyint(1) NOT NULL default '0',
  `markergrouptype` tinyint(1) NOT NULL default '0',
  `markergroupwidth` int(5) NOT NULL default '20',
  `markergroupshowicon` tinyint(1) NOT NULL default '0',
  `markergroupshowiconall` tinyint(1) NOT NULL default '100',
  `markergroupcss` int(5) NOT NULL default '0',
  `markergroupdesc1` text,
  `markergroupdesc2` text,
  `markergrouptitle` varchar(255),
  `markergroupsep1` tinyint(1) NOT NULL default '0',
  `markergroupsep2` tinyint(1) NOT NULL default '0',
  `markergrouporder` tinyint(1) NOT NULL default '0',
  `markergroupsearch` tinyint(1) NOT NULL default '0',
  `markerlist` tinyint(1) NOT NULL default '0',
  `markerlistpos` tinyint(1) NOT NULL default '0',
  `markerlistwidth` int(5) NOT NULL default '0',
  `markerlistheight` int(5) NOT NULL default '0',
  `markerlistbgcolor` text,
  `markerlistaction` tinyint(1) NOT NULL default '0',
  `markerlistcontent` tinyint(1) NOT NULL default '0',
  `markerlistbuttonpos` tinyint(1) NOT NULL default '3',
  `markerlistbuttontype` tinyint(1) NOT NULL default '0',
  `markerlistsearch` tinyint(1) NOT NULL default '0',
  `markerlistsync` tinyint(1) NOT NULL default '0',
  `headerhtml` text,
  `footerhtml` text,
  `headersep` tinyint(1) NOT NULL default '0',
  `footersep` tinyint(1) NOT NULL default '0',
  `openstreet` tinyint(1) NOT NULL default '1',
  `opentopomap` tinyint(1) NOT NULL default '0',
  `nztopomaps` tinyint(1) NOT NULL default '0',
  `usercontact` tinyint(1) NOT NULL default '0',
  `useruser` tinyint(1) NOT NULL default '0',
  `usermarkers` tinyint(1) NOT NULL default '0',
  `usermarkersfilter` tinyint(1) NOT NULL default '0',
  `usermarkerspublished` tinyint(1) NOT NULL default '0',
  `usermarkersicon` tinyint(1) NOT NULL default '1',
  `usercontactpublished` tinyint(1) NOT NULL default '0',
  `usermarkersinsert` tinyint(1) NOT NULL default '1',
  `usermarkersupdate` tinyint(1) NOT NULL default '1',
  `usermarkersdelete` tinyint(1) NOT NULL default '1',
  `routedraggable` tinyint(1) NOT NULL default '0',
  `routeshowpanel` tinyint(1) NOT NULL default '0',
  `autoposition` tinyint(1) NOT NULL default '0',
  `geolocationcontrol` tinyint(1) NOT NULL default '0',
  `geolocationpos` tinyint(1) NOT NULL default '2',
  `geolocationbutton` tinyint(1) NOT NULL default '1',
  `lang` varchar(20),
  `custommaptype` tinyint(1) NOT NULL default '0',
  `custommaptypelist` text,
  `usercontactattributes` text,
  `css2load` text,
  `js2load` text,
  `cssclassname` text,
  `mapbounds` varchar(100),
  `routedriving` tinyint(1) NOT NULL default '1',
  `routewalking` tinyint(1) NOT NULL default '1',
  `routebicycling` tinyint(1) NOT NULL default '1',
  `routetransit` tinyint(1) NOT NULL default '0',
  `routeavoidhighways` tinyint(1) NOT NULL default '0',
  `routeavoidtolls` tinyint(1) NOT NULL default '0',
  `routeunitsystem` tinyint(1) NOT NULL default '0',
  `useajax` tinyint(1) NOT NULL default '0',
  `useajaxobject` tinyint(1) NOT NULL default '0',
  `markergroupctlmarker` tinyint(1) NOT NULL default '1',
  `markergroupctlpath` tinyint(1) NOT NULL default '0',
  `placemark_rating` tinyint(1) NOT NULL default '0',
  `hovermarker` tinyint(1) NOT NULL default '0',
  `hoverinfobubble` int(11) NOT NULL default '0',
  `disableautopan` tinyint(1) NOT NULL default '0',
  `ajaxbufferplacemark` int(5) NOT NULL default '0',
  `ajaxbufferpath` int(5) NOT NULL default '0',
  `ajaxbufferroute` int(5) NOT NULL default '0',
  `ajaxgetplacemark` tinyint(1) NOT NULL default '0',
  `mapcentercontrol` tinyint(1) NOT NULL default '0',
  `mapcentercontrolpos` tinyint(1) NOT NULL default '2',
  `markerorder` tinyint(1) NOT NULL default '0',
  `markerspinner` tinyint(1) NOT NULL default '1',
  `showcreateinfo` tinyint(1) NOT NULL default '0',
  `override_id` int(11) NOT NULL default '0',
  `panelinfowin` tinyint(1) NOT NULL default '0',
  `panelwidth` int(3) NOT NULL default '300',
  `panelstate` tinyint(1) NOT NULL default '0',
  `overlayopacitycontrol` tinyint(1) NOT NULL default '0',
  `overlayopacitycontrolpos` tinyint(1) NOT NULL default '2',  
  `gogoogle` tinyint(1) NOT NULL default '0',
  `gogoogle_map` tinyint(1) NOT NULL default '0',
  `auto_center_zoom` tinyint(1) NOT NULL default '0',
  `clusterzoombounds` tinyint(1) NOT NULL default '1',
  `clustershowhover` tinyint(1) NOT NULL default '1',
  `hidesinglebaselayer` tinyint(1) NOT NULL default '1',
  `geocoder` tinyint(1) NOT NULL default '0',
  `geocoderpos` tinyint(1) NOT NULL default '3',
  `geocodercollapsed` tinyint(1) NOT NULL default '1',
  `geocoderprovider` tinyint(1) NOT NULL default '0',
  `closepopuponclick` tinyint(1) NOT NULL default '1',
  `fullscreencontrol` tinyint(1) NOT NULL default '1',
  `fullscreencontrolpos` tinyint(1) NOT NULL default '2',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_markers`;

CREATE TABLE `#__zhosmmaps_markers` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `latitude` varchar(20) NOT NULL default '',
  `longitude` varchar(20) NOT NULL default '',
  `addresstext` text,
  `mapid` int(11) NOT NULL default '0',
  `openbaloon` tinyint(1) NOT NULL default '0',
  `actionbyclick` tinyint(1) NOT NULL default '1',
  `zoombyclick` int(3) NOT NULL default '100',
  `baloon` tinyint(1) NOT NULL default '0',
  `icontype` varchar(250) NOT NULL default '',
  `iconofsetx` tinyint(1) NOT NULL default '0',
  `iconofsety` tinyint(1) NOT NULL default '0',
  `description` text,
  `descriptionhtml` text,
  `descriptionfullhtml` text,
  `hoverhtml` text,
  `published` tinyint(1) NOT NULL default '0',
  `hrefsite` text,
  `hrefimage` text,
  `hrefimagecss` text,
  `hrefimagethumbnail` text,
  `hrefsitename` text,
  `markergroup` int(11) NOT NULL default '0',
  `markercontent` tinyint(1) NOT NULL default '0',
  `contactid` int(11) NOT NULL default '0',
  `createdbyuser` int(11) NOT NULL default '0',
  `showcontact` tinyint(1) NOT NULL default '0',
  `showuser` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `createddate` DATETIME,
  `userprotection` tinyint(1) NOT NULL default '0',
  `params` text,
  `attribute1` text,
  `attribute2` text,
  `attribute3` text,
  `attribute4` text,
  `attribute5` text,
  `attribute6` text,
  `attribute7` text,
  `attribute8` text,
  `attribute9` text,
  `tabid` int(11) NOT NULL default '0',
  `tab1` text,
  `tab2` text,
  `tab3` text,
  `tab4` text,
  `tab5` text,
  `tab6` text,
  `tab7` text,
  `tab8` text,
  `tab9` text,
  `tab10` text,
  `tab11` text,
  `tab12` text,
  `tab13` text,
  `tab14` text,
  `tab15` text,
  `tab16` text,
  `tab17` text,
  `tab18` text,
  `tab19` text,
  `tab1title` varchar(250),
  `tab2title` varchar(250),
  `tab3title` varchar(250),
  `tab4title` varchar(250),
  `tab5title` varchar(250),
  `tab6title` varchar(250),
  `tab7title` varchar(250),
  `tab8title` varchar(250),
  `tab9title` varchar(250),
  `tab10title` varchar(250),
  `tab11title` varchar(250),
  `tab12title` varchar(250),
  `tab13title` varchar(250),
  `tab14title` varchar(250),
  `tab15title` varchar(250),
  `tab16title` varchar(250),
  `tab17title` varchar(250),
  `tab18title` varchar(250),
  `tab19title` varchar(250),
  `tab1image` text,
  `tab2image` text,
  `tab3image` text,
  `tab4image` text,
  `tab5image` text,
  `tab6image` text,
  `tab7image` text,
  `tab8image` text,
  `tab9image` text,
  `tab10image` text,
  `tab11image` text,
  `tab12image` text,
  `tab13image` text,
  `tab14image` text,
  `tab15image` text,
  `tab16image` text,
  `tab17image` text,
  `tab18image` text,
  `tab19image` text,
  `tab_info` tinyint(1) NOT NULL default '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rating_value` FLOAT NOT NULL DEFAULT '0',
  `rating_count` int(11) NOT NULL DEFAULT '0',
  `labelanchorx` int(5) NOT NULL default '0',
  `labelanchory` int(5) NOT NULL default '0',
  `labelclass` varchar(250),
  `labelcontent` text,
  `labelstyle` text,
  `includeinlist` tinyint(1) NOT NULL default '1',
  `access` int(11) NOT NULL DEFAULT '1',
  `alias` varchar(255),
  `hrefcontact` text,
  `hrefarticle` text,
  `hrefdetail` text,
  `toolbarcontact` tinyint(1) NOT NULL default '0',
  `toolbararticle` tinyint(1) NOT NULL default '0',
  `toolbardetail` tinyint(1) NOT NULL default '0',
  `articleid` int(11) NOT NULL default '0',
  `attributesdetail` text,
  `userorder` int(11) NOT NULL default '0',
  `showgps` tinyint(1) NOT NULL default '0',
  `iframearticleclass` varchar(250),
  `gogoogle` tinyint(1) NOT NULL default '0',
  `preparecontent` tinyint(1) NOT NULL default '0',
  `tag_show` tinyint(1) NOT NULL default '0',
  `tag_style` tinyint(1) NOT NULL default '0',
  `data_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_routers`;

CREATE TABLE `#__zhosmmaps_routers` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `providealt` tinyint(1) NOT NULL default '0',
  `optimizewaypoints` tinyint(1) NOT NULL default '0',
  `avoidhighways` tinyint(1) NOT NULL default '0',
  `avoidtolls` tinyint(1) NOT NULL default '0',
  `travelmode` tinyint(1) NOT NULL default '0',
  `unitsystem` tinyint(1) NOT NULL default '0',
  `route` text,
  `routebymarker` text,
  `mapid` int(11) NOT NULL default '0',
  `description` text,
  `descriptionhtml` text,
  `published` tinyint(1) NOT NULL default '0',
  `showtype` tinyint(1) NOT NULL default '0',
  `draggable` tinyint(1) NOT NULL default '0',
  `showpanel` tinyint(1) NOT NULL default '0',
  `showpaneltotal` tinyint(1) NOT NULL default '1',
  `showdescription` tinyint(1) NOT NULL default '0',  
  `suppressmarkers` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `weight` tinyint(1) NOT NULL default '5',
  `color` varchar(250) NOT NULL default '#4FA4FF',
  `opacity` varchar(20) NOT NULL default '0.7',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_paths`;

CREATE TABLE `#__zhosmmaps_paths` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `weight` tinyint(1) NOT NULL default '0',
  `color` varchar(250),
  `hover_color` varchar(250),
  `opacity` varchar(20),
  `path` text,
  `data_id` int(11) NOT NULL default '0',
  `kmllayer` text,
  `kmllayertype` tinyint(1) NOT NULL default '0',
  `mapid` int(11) NOT NULL default '0',
  `description` text,
  `descriptionhtml` text,
  `published` tinyint(1) NOT NULL default '0',
  `showtype` tinyint(1) NOT NULL default '0',
  `suppressinfowindows` tinyint(1) NOT NULL default '0',
  `geodesic` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `infowincontent` tinyint(1) NOT NULL default '0',
  `actionbyclick` tinyint(1) NOT NULL default '0',
  `objecttype` tinyint(1) NOT NULL default '0',
  `fillcolor` varchar(250),
  `fillopacity` varchar(20),
  `hover_fillcolor` varchar(250),
  `radius` varchar(250),
  `markergroup` int(11) NOT NULL default '0',
  `hoverhtml` text,
  `hrefsite` text,
  `hrefsitename` text, 
  `imgurl` text,
  `imgclickable` tinyint(1) NOT NULL default '0',  
  `imgbounds` varchar(100),
  `imgopacity` varchar(20),
  `imgopacitymanage` tinyint(1) NOT NULL default '1',
  `gridtilefunc` text,
  `gridopacity` varchar(20),
  `popup_placemark` tinyint(1) NOT NULL default '2',
  `popup_polyline` tinyint(1) NOT NULL default '2',
  `popup_polygon` tinyint(1) NOT NULL default '2',
  `tooltip_polyline` tinyint(1) NOT NULL default '1',
  `tooltip_polygon` tinyint(1) NOT NULL default '1',
  `tooltip_placemark` tinyint(1) NOT NULL default '0',
  `override_placemarks` tinyint(1) NOT NULL default '0',
  `override_paths` tinyint(1) NOT NULL default '0',
  `labelanchorx` int(5) NOT NULL default '0',
  `labelanchory` int(5) NOT NULL default '0',
  `labelclass` varchar(250),
  `labelcontent` text,
  `labelstyle` text,
  `labelpublished` tinyint(1) NOT NULL default '0',
  `dasharray` varchar(250),
  `dashoffset` varchar(250),
  `linecap` tinyint(1) NOT NULL default '0',
  `linejoin` tinyint(1) NOT NULL default '0',
  `elevation` tinyint(1) NOT NULL default '0',
  `elevation_width` varchar(10),
  `elevation_height` varchar(10),
  `y_min_value` varchar(20),
  `y_max_value` varchar(20),
  `elevation_theme` tinyint(1) NOT NULL default '0',
  `y_gridline_count` varchar(5),
  `x_gridline_count` varchar(5),
  `elevation_summary` tinyint(1) NOT NULL default '0',
  `elevation_follow` tinyint(1) NOT NULL default '0',
  `elevation_unitsystem` tinyint(1) NOT NULL default '1',
  `override_styles` tinyint(1) NOT NULL default '1',
  `show_time` tinyint(1) NOT NULL default '1',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_markergroups`;

CREATE TABLE `#__zhosmmaps_markergroups` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `icontype` varchar(250),
  `iconofsetx` tinyint(1) NOT NULL default '0',
  `iconofsety` tinyint(1) NOT NULL default '0',
  `overridegroupicon` tinyint(1) NOT NULL default '0',
  `overridemarkericon` tinyint(1) NOT NULL default '0',
  `markermanagerminzoom` int(3) NOT NULL default '0',
  `markermanagermaxzoom` int(3) NOT NULL default '18',
  `activeincluster` tinyint(1) NOT NULL default '0',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `userorder` int(11) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_maptypes`;

CREATE TABLE `#__zhosmmaps_maptypes` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `url_template` text,
  `license` text,
  `gettileurl` text,
  `tilewidth` int(5) NOT NULL default '256',
  `tileheight` int(5) NOT NULL default '256',
  `ispng` tinyint(1) NOT NULL default '1',
  `minzoom` int(3) NOT NULL default '0',
  `maxzoom` int(3) NOT NULL default '18',
  `opacity` varchar(20),
  `opacitymanage` tinyint(1) NOT NULL default '1',
  `layertype` tinyint(1) NOT NULL default '1',
  `projectionglobal` text,
  `projectiondefinition` text,
  `fromlatlngtopoint` text,
  `frompointtolatlng` text,
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_infobubbles`;

CREATE TABLE `#__zhosmmaps_infobubbles` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `minwidth` varchar(50),
  `maxwidth` varchar(50),
  `minheight` varchar(50),
  `maxheight` varchar(50),
  `disableautopan` tinyint(1) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `offsetx` tinyint(1) NOT NULL default '0',
  `offsety` tinyint(1) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;


DROP TABLE IF EXISTS `#__zhosmmaps_marker_rates`;

CREATE TABLE `#__zhosmmaps_marker_rates` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `markerid` int(11) NOT NULL default '0',
  `rating_value` FLOAT NOT NULL DEFAULT '0',
  `rating_date` DATETIME,
  `ip` text NOT NULL,
  `hostname` text NOT NULL,
  `createdbyuser` int(11) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_text_overrides`;

CREATE TABLE `#__zhosmmaps_text_overrides` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `placemark_list_title` text,
  `placemark_list_button_title` text,
  `placemark_list_button_hint` text,
  `panelcontrol_hint` text,
  `panel_detail_title` text,
  `panel_placemarklist_title` text,
  `panel_route_title` text,
  `panel_group_title` text,
  `group_list_title` text,
  `gogoogle_text` text,
  `placemark_list_search` tinyint(1) NOT NULL default '0',
  `placemark_list_mapping_type` tinyint(1) NOT NULL default '0',
  `placemark_list_accent` text,
  `placemark_list_mapping` text,
  `placemark_list_accent_side` tinyint(1) NOT NULL default '3',
  `group_list_search` tinyint(1) NOT NULL default '0',
  `group_list_mapping_type` tinyint(1) NOT NULL default '0',
  `group_list_accent` text,
  `group_list_mapping` text,
  `group_list_accent_side` tinyint(1) NOT NULL default '3',
  `tabid` int(11) NOT NULL default '0',
  `geocoder_placeholder` text,
  `geocoder_not_found` text,
  `invalidatediv` text,
  `invalidatetype` tinyint(1) NOT NULL default '0',
  `invalidateindex` text,
  `placemark_date_fmt` text,
  `markerspinner_list_template` text,
  `load_delay` int(5) NOT NULL default '0',
  `category_hierarchy` tinyint(1) NOT NULL default '0',
  `category_expand` tinyint(1) NOT NULL default '0',
  `geocoderzoom` int(3) NOT NULL default '100',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_marker_content`;

CREATE TABLE `#__zhosmmaps_marker_content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_log`;

CREATE TABLE `#__zhosmmaps_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `extension` varchar(250),
  `kind` varchar(250),
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `remarks` text,
  `id_target` int(11) NOT NULL default '0',
  `id_source` int(11) NOT NULL default '0',
  `id_find` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_marker_buffer`;

CREATE TABLE `#__zhosmmaps_marker_buffer` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `latitude` varchar(20) NOT NULL default '',
  `longitude` varchar(20) NOT NULL default '',
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `addresstext` text,
  `icontype` varchar(250),
  `iconofsetx` tinyint(1) NOT NULL default '0',
  `iconofsety` tinyint(1) NOT NULL default '0',
  `description` text,
  `descriptionhtml` text,
  `hrefimage` text,
  `markergroup` int(11) NOT NULL default '0',
  `createdbyuser` int(11) NOT NULL default '0',
  `showuser` tinyint(1) NOT NULL default '0',
  `createddate` DATETIME,
  `showgps` tinyint(1) NOT NULL default '0',
  `preparecontent` tinyint(1) NOT NULL default '0',
  `markercontent` tinyint(1) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_data_sqls`;

CREATE TABLE `#__zhosmmaps_data_sqls` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `sql_text_clause` text NOT NULL,
  `query_type` tinyint(1) NOT NULL default '0',
  `struct_id` int(11) NOT NULL default '0',
  `server_id` int(11) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_visual_structs`;

CREATE TABLE `#__zhosmmaps_visual_structs` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `latitude` varchar(50),
  `longitude` varchar(50),
  `lat_lng` varchar(50),
  `lat_lng_order` tinyint(1) NOT NULL default '0',
  `lat_lng_sep` varchar(10) NOT NULL default ',',
  `lat_lng_array` varchar(50),
  `lat_lng_array_sep` varchar(10) NOT NULL default ';',
  `result_object_type` tinyint(1) NOT NULL default '0',
  `createddate` varchar(50),
  `start_title` varchar(250),
  `start_description` text,
  `start_baloon` tinyint(1) NOT NULL default '0',
  `start_icontype` varchar(250),
  `start_iconofsetx` tinyint(1) NOT NULL default '0',
  `start_iconofsety` tinyint(1) NOT NULL default '0',
  `start_descriptionhtml` text,
  `end_title` varchar(250),
  `end_description` text,
  `end_baloon` tinyint(1) NOT NULL default '0',
  `end_icontype` varchar(250),
  `end_iconofsetx` tinyint(1) NOT NULL default '0',
  `end_iconofsety` tinyint(1) NOT NULL default '0',
  `end_descriptionhtml` text,  
  `title_column` varchar(50),
  `description_column` varchar(50),
  `descriptionhtml_column` varchar(50),
  `icontype_column` varchar(50),
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;

DROP TABLE IF EXISTS `#__zhosmmaps_data_servers`;

CREATE TABLE `#__zhosmmaps_data_servers` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `description` text,
  `published` tinyint(1) NOT NULL default '0',
  `publish_up` DATETIME,
  `publish_down` DATETIME,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `srv_driver` text,
  `srv_host` text,
  `srv_user` text,
  `srv_password` text,
  `srv_database` text,
  `srv_prefix` text,
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM CHARACTER SET `utf8`;


ALTER TABLE `#__zhosmmaps_data_sqls` ADD INDEX `idx_server` (`server_id`);
ALTER TABLE `#__zhosmmaps_data_servers` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_data_sqls` ADD INDEX `idx_struct` (`struct_id`);
ALTER TABLE `#__zhosmmaps_data_sqls` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_visual_structs` ADD INDEX `idx_catid` (`catid`);

ALTER TABLE `#__zhosmmaps_marker_buffer` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_marker_buffer` ADD INDEX `idx_markergroup` (`markergroup`);
ALTER TABLE `#__zhosmmaps_marker_buffer` ADD INDEX `idx_createdbyuser` (`createdbyuser`);

ALTER TABLE `#__zhosmmaps_maps` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_maps` ADD INDEX `idx_override` (`override_id`);
ALTER TABLE `#__zhosmmaps_maps` ADD INDEX `idx_hoverinfobubble` (`hoverinfobubble`);

ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_mapid` (`mapid`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_markergroup` (`markergroup`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_createdbyuser` (`createdbyuser`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_access` (`access`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_alias` (`alias`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_tabid` (`tabid`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_articleid` (`articleid`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_contactid` (`contactid`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_userorder` (`userorder`);
ALTER TABLE `#__zhosmmaps_markers` ADD INDEX `idx_data` (`data_id`);

ALTER TABLE `#__zhosmmaps_routers` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_routers` ADD INDEX `idx_mapid` (`mapid`);

ALTER TABLE `#__zhosmmaps_paths` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_paths` ADD INDEX `idx_mapid` (`mapid`);
ALTER TABLE `#__zhosmmaps_paths` ADD INDEX `idx_markergroup` (`markergroup`);
ALTER TABLE `#__zhosmmaps_paths` ADD INDEX `idx_data` (`data_id`);

ALTER TABLE `#__zhosmmaps_markergroups` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_markergroups` ADD INDEX `idx_userorder` (`userorder`);

ALTER TABLE `#__zhosmmaps_maptypes` ADD INDEX `idx_catid` (`catid`);

ALTER TABLE `#__zhosmmaps_infobubbles` ADD INDEX `idx_catid` (`catid`);

ALTER TABLE `#__zhosmmaps_marker_rates` ADD INDEX `idx_markerid` (`markerid`);

ALTER TABLE `#__zhosmmaps_text_overrides` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_text_overrides` ADD INDEX `idx_tabid` (`tabid`);

ALTER TABLE `#__zhosmmaps_marker_content` ADD INDEX `idx_catid` (`catid`);

ALTER TABLE `#__zhosmmaps_log` ADD INDEX `idx_catid` (`catid`);
ALTER TABLE `#__zhosmmaps_log` ADD INDEX `idx_ext` (`extension`);


INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) 
VALUES (	
	'ZhOSMMap Category', 
	'com_zhosmmap.category', 
	'{"special":
		{"dbtable":"#__categories"
		,"key":"id"
		,"type":"CategoryTable"
		,"prefix":"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"Joomla\\\\CMS\\\\Table\\\\"
		,"config":"array()"}}'
	,''
	, '{"common": {
        "core_content_item_id": "id",
        "core_title": "title",
        "core_state": "published",
        "core_alias": "alias",
        "core_created_time": "created_time",
        "core_modified_time": "modified_time",
        "core_body": "description",
        "core_hits": "hits",
        "core_publish_up": "null",
        "core_publish_down": "null",
        "core_access": "access",
        "core_params": "params",
        "core_featured": "null",
        "core_metadata": "metadata",
        "core_language": "language",
        "core_images": "null",
        "core_urls": "null",
        "core_version": "version",
        "core_ordering": "null",
        "core_metakey": "metakey",
        "core_metadesc": "metadesc",
        "core_catid": "parent_id",
        "asset_id": "asset_id"
    },
    "special": {
        "parent_id": "parent_id",
        "lft": "lft",
        "rgt": "rgt",
        "level": "level",
        "path": "path",
        "extension": "extension",
        "note": "note"
    }}'
	,''
	, ''
	);
	


INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) 
VALUES (	
	'ZhOSMMap Marker', 
	'com_zhosmmap.mapmarker', 
	'{"special":
		{"dbtable":"#__zhosmmaps_markers"
		,"key":"id"
		,"type":"MapmarkerTable"
		,"prefix":"ZhukDL\\\\Component\\\\ZhOpenStreetMap\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"JTable"
		,"config":"array()"}}'
	,''
	, '{"common":
			{"core_content_item_id":"id"
			,"core_title":"title"
			,"core_state":"null"
			,"core_alias":"alias"
			,"core_created_time":"null"
			,"core_modified_time":"null"
			,"core_body":"null"
			, "core_hits":"null"
			,"core_publish_up":"publish_up"
			,"core_publish_down":"publish_down"
			,"core_access":"access"
			, "core_params":"null"
			, "core_featured":"null"
			, "core_metadata":"null"
			, "core_language":"null"
			, "core_images":"null"
			, "core_urls":"null"
			, "core_version":"null"
			, "core_ordering":"ordering"
			, "core_metakey":"null"
			, "core_metadesc":"null"
			, "core_catid":"catid"
			, "core_xreference":"null"
			, "asset_id":"null"}
			, "special":{"fulltext":"null"}}'
	,''
	, ''
	);
	
INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) 
VALUES (	
	'ZhOSMMap Path', 
	'com_zhosmmap.mappath', 
	'{"special":
		{"dbtable":"#__zhosmmaps_paths"
		,"key":"id"
		,"type":"MappathTable"
		,"prefix":"ZhukDL\\\\Component\\\\ZhOpenStreetMap\\\\Administrator\\\\Table\\\\"
		,"config":"array()"}
	 ,"common":
		{"dbtable":"#__ucm_content"
		,"key":"ucm_id"
		,"type":"Corecontent"
		,"prefix":"JTable"
		,"config":"array()"}}'
	,''
	, '{"common":
			{"core_content_item_id":"id"
			,"core_title":"title"
			,"core_state":"null"
			,"core_alias":"alias"
			,"core_created_time":"null"
			,"core_modified_time":"null"
			,"core_body":"null"
			, "core_hits":"null"
			,"core_publish_up":"publish_up"
			,"core_publish_down":"publish_down"
			,"core_access":"access"
			, "core_params":"null"
			, "core_featured":"null"
			, "core_metadata":"null"
			, "core_language":"null"
			, "core_images":"null"
			, "core_urls":"null"
			, "core_version":"null"
			, "core_ordering":"ordering"
			, "core_metakey":"null"
			, "core_metadesc":"null"
			, "core_catid":"catid"
			, "core_xreference":"null"
			, "asset_id":"null"}
			, "special":{"fulltext":"null"}}'
	,''
	, ''
	);
	
